description: "This profile defines a baseline that aligns to the \"Level 1 - Workstation\"\nconfiguration
    from the Center for Internet Security\xAE Red Hat Enterprise\nLinux 7 Benchmark\u2122,
    v4.0.0, released 2023-12-21.\n\nThis profile includes Center for Internet Security\xAE\nRed
    Hat Enterprise Linux 7 CIS Benchmarks\u2122 content."
extends: null
hidden: ''
metadata:
    version: 4.0.0
    SMEs:
    - vojtapolasek
    - yuumasato
reference: https://www.cisecurity.org/cis-benchmarks/#red_hat_linux
selections:
- file_groupowner_etc_passwd
- file_permissions_etc_issue
- mount_option_dev_shm_noexec
- service_systemd-journald_enabled
- accounts_password_pam_dictcheck
- service_rsyslog_enabled
- sysctl_net_ipv4_icmp_ignore_bogus_error_responses
- file_groupowner_efi_grub2_cfg
- file_cron_deny_not_exist
- mount_option_var_tmp_nodev
- account_disable_post_pw_expiration
- sysctl_net_ipv4_conf_all_rp_filter
- accounts_user_dot_user_ownership
- dconf_gnome_banner_enabled
- rsyslog_files_ownership
- dconf_gnome_screensaver_lock_delay
- sudo_custom_logfile
- package_squid_removed
- file_permissions_etc_issue_net
- package_nginx_removed
- file_permissions_etc_passwd
- accounts_root_gid_zero
- file_permissions_efi_user_cfg
- journald_compress
- file_groupowner_cron_weekly
- file_permissions_etc_group
- accounts_users_netrc_file_permissions
- partition_for_dev_shm
- iptables_rules_for_open_ports
- file_permissions_sshd_pub_key
- sysctl_net_ipv4_conf_default_rp_filter
- sysctl_net_ipv6_conf_all_accept_source_route
- grub2_password
- account_unique_id
- dconf_gnome_disable_autorun
- dconf_gnome_login_banner_text
- package_pam_pwquality_installed
- sysctl_net_ipv6_conf_default_accept_redirects
- account_unique_name
- file_permissions_etc_shadow
- no_password_auth_for_systemaccounts
- sshd_use_approved_ciphers
- package_ypbind_removed
- accounts_umask_etc_profile
- file_permissions_backup_etc_passwd
- chronyd_specify_remote_server
- accounts_password_warn_age_login_defs
- accounts_password_pam_minlen
- file_groupowner_cron_monthly
- file_owner_etc_shadow
- journald_forward_to_syslog
- package_chrony_installed
- selinux_confinement_of_daemons
- dconf_gnome_session_idle_user_locks
- set_firewalld_appropriate_zone
- sysctl_net_ipv4_ip_forward
- mount_option_dev_shm_nosuid
- mount_option_tmp_nosuid
- banner_etc_issue
- sshd_enable_pam
- file_groupowner_grub2_cfg
- sshd_set_loglevel_verbose
- sysctl_net_ipv4_conf_all_accept_source_route
- sysctl_net_ipv6_conf_default_accept_ra
- accounts_passwords_pam_faillock_deny
- file_owner_etc_motd
- set_password_hashing_algorithm_passwordauth
- file_owner_etc_gshadow
- file_owner_backup_etc_gshadow
- sysctl_net_ipv4_conf_all_log_martians
- package_telnet_removed
- gnome_gdm_disable_xdmcp
- file_groupowner_etc_issue_net
- kernel_module_cramfs_disabled
- sshd_set_maxstartups
- kernel_module_hfs_disabled
- accounts_password_pam_pwhistory_remember_password_auth
- has_nonlocal_mta
- rsyslog_filecreatemode
- package_bind_removed
- mount_option_dev_shm_nodev
- package_dnsmasq_removed
- no_forward_files
- package_dovecot_removed
- ensure_gpgcheck_globally_activated
- file_owner_crontab
- file_permissions_cron_d
- file_permissions_user_cfg
- postfix_network_listening_disabled
- accounts_password_set_warn_age_existing
- sysctl_net_ipv4_conf_all_send_redirects
- gid_passwd_group_same
- sysctl_net_ipv4_conf_all_accept_redirects
- package_ypserv_removed
- file_permissions_home_directories
- ip6tables_rules_for_open_ports
- file_groupownership_sshd_pub_key
- mount_option_tmp_nodev
- file_groupowner_backup_etc_gshadow
- partition_for_tmp
- sshd_set_max_sessions
- file_permissions_cron_allow
- file_owner_cron_daily
- kernel_module_hfsplus_disabled
- mount_option_home_nodev
- rsyslog_files_groupownership
- sshd_use_strong_macs
- mount_option_var_nodev
- mount_option_var_nosuid
- set_loopback_traffic
- file_owner_grub2_cfg
- disable_host_auth
- mount_option_var_log_audit_nodev
- file_cron_allow_exists
- file_owner_etc_passwd
- file_permissions_backup_etc_group
- group_unique_id
- mount_option_var_tmp_nosuid
- mount_option_home_nosuid
- no_shelllogin_for_systemaccounts
- sysctl_net_ipv6_conf_default_accept_source_route
- sshd_disable_empty_passwords
- accounts_password_last_change_is_in_past
- file_ownership_sshd_private_key
- package_vsftpd_removed
- socket_systemd-journal-remote_disabled
- accounts_password_pam_difok
- sysctl_net_ipv4_icmp_echo_ignore_broadcasts
- file_owner_backup_etc_group
- banner_etc_issue_net
- rsyslog_files_permissions
- sshd_do_not_permit_user_env
- package_net-snmp_removed
- accounts_user_interactive_home_directory_exists
- sysctl_net_ipv6_conf_all_forwarding
- accounts_maximum_age_login_defs
- file_groupowner_etc_motd
- sshd_disable_rhosts
- service_crond_enabled
- dir_perms_world_writable_sticky_bits
- file_permissions_cron_monthly
- file_owner_cron_allow
- sshd_disable_root_login
- file_owner_backup_etc_passwd
- file_permissions_sshd_config
- service_nfs_disabled
- file_owner_etc_issue_net
- sudo_require_reauthentication
- file_permissions_unauthorized_world_writable
- file_groupowner_crontab
- sysctl_net_ipv4_conf_default_accept_redirects
- file_groupowner_backup_etc_group
- mount_option_var_log_audit_nosuid
- no_empty_passwords
- sshd_enable_warning_banner_net
- file_groupowner_etc_shadow
- file_groupowner_etc_gshadow
- file_permissions_cron_weekly
- sshd_use_strong_kex
- file_permissions_backup_etc_shadow
- selinux_policytype
- file_ownership_home_directories
- file_at_deny_not_exist
- sysctl_net_ipv6_conf_all_accept_redirects
- sshd_set_idle_timeout
- package_tftp_removed
- sshd_set_keepalive
- chronyd_run_as_chrony_user
- file_groupowner_cron_daily
- dconf_gnome_screensaver_user_locks
- file_owner_cron_hourly
- file_owner_sshd_config
- group_unique_name
- mount_option_var_tmp_noexec
- set_password_hashing_algorithm_systemauth
- dconf_gnome_screensaver_idle_delay
- file_owner_efi_grub2_cfg
- rsyslog_nolisten
- sysctl_kernel_yama_ptrace_scope
- mount_option_tmp_noexec
- sshd_disable_gssapi_auth
- file_groupowner_backup_etc_shadow
- file_owner_efi_user_cfg
- set_ip6tables_default_rule
- accounts_password_pam_pwhistory_remember_system_auth
- aide_build_database
- file_groupowner_cron_hourly
- sudo_add_use_pty
- package_aide_installed
- sysctl_net_ipv4_conf_default_accept_source_route
- service_firewalld_enabled
- file_groupowner_backup_etc_passwd
- journald_storage
- accounts_tmout
- package_rsyslog_installed
- file_owner_cron_monthly
- file_permissions_cron_daily
- accounts_password_set_max_life_existing
- package_sudo_installed
- file_permissions_efi_grub2_cfg
- file_owner_cron_weekly
- accounts_set_post_pw_existing
- file_owner_etc_issue
- kernel_module_freevxfs_disabled
- file_groupowner_sshd_config
- file_groupownership_sshd_private_key
- package_mcstrans_removed
- file_groupowner_cron_d
- sshd_set_max_auth_tries
- sysctl_net_ipv4_conf_default_secure_redirects
- file_etc_security_opasswd
- package_httpd_removed
- file_owner_etc_group
- sysctl_net_ipv4_conf_default_send_redirects
- sysctl_net_ipv6_conf_all_accept_ra
- accounts_umask_etc_login_defs
- grub2_uefi_password
- mount_option_var_log_noexec
- accounts_password_all_shadowed
- file_groupowner_etc_group
- file_owner_etc_shells
- file_permissions_crontab
- file_permissions_grub2_cfg
- file_permissions_sshd_private_key
- require_emergency_target_auth
- set_password_hashing_algorithm_logindefs
- sysctl_kernel_randomize_va_space
- file_groupowner_etc_shells
- package_xinetd_removed
- accounts_password_pam_maxrepeat
- accounts_no_uid_except_zero
- file_permissions_etc_gshadow
- accounts_passwords_pam_faillock_unlock_time
- package_samba_removed
- mount_option_var_log_audit_noexec
- accounts_umask_etc_bashrc
- file_groupowner_etc_issue
- file_ownership_sshd_pub_key
- file_permissions_etc_motd
- file_groupowner_efi_user_cfg
- dconf_db_up_to_date
- no_empty_passwords_etc_shadow
- file_groupowner_cron_allow
- require_singleuser_auth
- ensure_pam_wheel_group_empty
- aide_periodic_cron_checking
- service_rpcbind_disabled
- sshd_limit_user_access
- grub2_enable_selinux
- package_firewalld_installed
- ensure_gpgcheck_never_disabled
- file_groupowner_user_cfg
- package_tftp-server_removed
- coredump_disable_backtraces
- file_owner_user_cfg
- file_permission_user_init_files
- mount_option_var_log_nodev
- package_iptables_installed
- mount_option_var_log_nosuid
- package_rsync_removed
- sysctl_net_ipv4_tcp_syncookies
- use_pam_wheel_group_for_su
- kernel_module_jffs2_disabled
- file_permissions_etc_shells
- coredump_disable_storage
- file_permissions_backup_etc_gshadow
- package_cyrus-imapd_removed
- sudo_require_authentication
- file_owner_cron_d
- file_permissions_ungroupowned
- package_libselinux_installed
- sysctl_net_ipv4_conf_default_log_martians
- accounts_root_path_dirs_no_write
- ensure_root_password_configured
- no_files_unowned_by_user
- no_rsh_trust_files
- package_dhcp_removed
- package_ftp_removed
- package_telnet-server_removed
- banner_etc_motd
- root_path_no_dot
- sshd_set_login_grace_time
- sysctl_net_ipv4_conf_all_secure_redirects
- accounts_user_dot_group_ownership
- dconf_gnome_disable_user_list
- set_password_hashing_algorithm_libuserconf
- file_permissions_cron_hourly
- file_owner_backup_etc_shadow
- accounts_password_pam_minclass
- selinux_not_disabled
- var_user_initialization_files_regex=all_dotfiles
- var_accounts_user_umask=027
- var_accounts_tmout=15_min
- var_account_disable_post_pw_expiration=30
- var_accounts_password_warn_age_login_defs=7
- var_accounts_maximum_age_login_defs=365
- var_password_hashing_algorithm=SHA512
- var_password_pam_remember_control_flag=requisite_or_required
- var_password_pam_remember=24
- var_password_pam_dictcheck=1
- var_password_pam_maxrepeat=3
- var_password_pam_minclass=4
- var_password_pam_minlen=14
- var_password_pam_difok=2
- var_accounts_passwords_pam_faillock_unlock_time=900
- var_accounts_passwords_pam_faillock_deny=5
- var_pam_wheel_group_for_su=cis
- var_sudo_timestamp_timeout=15_minutes
- var_sudo_logfile=var_log_sudo_log
- var_sshd_set_maxstartups=10:30:60
- var_sshd_max_sessions=10
- sshd_max_auth_tries_value=4
- sshd_strong_macs=cis_rhel7
- var_sshd_set_login_grace_time=60
- sshd_strong_kex=cis_rhel7
- sshd_idle_timeout_value=5_minutes
- var_sshd_set_keepalive=1
- sshd_approved_ciphers=cis_rhel7
- sysctl_net_ipv6_conf_all_accept_ra_value=disabled
- sysctl_net_ipv6_conf_default_accept_ra_value=disabled
- sysctl_net_ipv4_tcp_syncookies_value=enabled
- sysctl_net_ipv4_conf_all_log_martians_value=enabled
- sysctl_net_ipv4_conf_default_log_martians_value=enabled
- sysctl_net_ipv4_conf_all_accept_source_route_value=disabled
- sysctl_net_ipv4_conf_default_accept_source_route_value=disabled
- sysctl_net_ipv6_conf_all_accept_source_route_value=disabled
- sysctl_net_ipv6_conf_default_accept_source_route_value=disabled
- sysctl_net_ipv4_conf_all_rp_filter_value=enabled
- sysctl_net_ipv4_conf_default_rp_filter_value=enabled
- sysctl_net_ipv4_conf_all_secure_redirects_value=disabled
- sysctl_net_ipv4_conf_default_secure_redirects_value=disabled
- sysctl_net_ipv4_conf_all_accept_redirects_value=disabled
- sysctl_net_ipv4_conf_default_accept_redirects_value=disabled
- sysctl_net_ipv6_conf_all_accept_redirects_value=disabled
- sysctl_net_ipv6_conf_default_accept_redirects_value=disabled
- sysctl_net_ipv4_icmp_echo_ignore_broadcasts_value=enabled
- sysctl_net_ipv4_icmp_ignore_bogus_error_responses_value=enabled
- sysctl_net_ipv6_conf_all_forwarding_value=disabled
- var_postfix_inet_interfaces=loopback-only
- var_multiple_time_servers=rhel
- inactivity_timeout_value=15_minutes
- var_screensaver_lock_delay=5_seconds
- remote_login_banner_text=cis_banners
- login_banner_text=cis_banners
- motd_banner_text=cis_banners
- var_selinux_policy_name=targeted
unselected_groups: []
platforms: !!set {}
cpe_names: !!set {}
platform: null
filter_rules: ''
policies:
- cis_rhel7
title: CIS Red Hat Enterprise Linux 7 Benchmark for Level 1 - Workstation
definition_location: /home/jcerny/work/git/content/products/rhel7/profiles/cis_workstation_l1.profile
documentation_complete: true
