description: 'This profile contains configuration checks that align to the

    DISA STIG for Red Hat Enterprise Linux 8 V1R13.


    In addition to being applicable to Red Hat Enterprise Linux 8, DISA recognizes
    this

    configuration baseline as applicable to the operating system tier of

    Red Hat technologies that are based on Red Hat Enterprise Linux 8, such as:


    - Red Hat Enterprise Linux Server

    - Red Hat Enterprise Linux Workstation and Desktop

    - Red Hat Enterprise Linux for HPC

    - Red Hat Storage

    - Red Hat Containers with a Red Hat Enterprise Linux 8 image'
extends: null
hidden: ''
metadata:
    version: V1R13
    SMEs:
    - mab879
    - ggbecker
reference: https://public.cyber.mil/stigs/downloads/?_dl_facet_stigs=operating-systems%2Cunix-linux
selections:
- mount_option_var_tmp_nosuid
- accounts_maximum_age_login_defs
- configure_libreswan_crypto_policy
- accounts_users_home_files_permissions
- accounts_users_home_files_groupownership
- harden_sshd_ciphers_openssh_conf_crypto_policy
- kernel_module_cramfs_disabled
- accounts_user_interactive_home_directory_exists
- audit_rules_dac_modification_fchown
- file_permissions_ungroupowned
- enable_authselect
- coredump_disable_backtraces
- accounts_max_concurrent_login_sessions
- file_permissions_etc_audit_rulesd
- grub2_pti_argument
- kernel_module_bluetooth_disabled
- accounts_password_pam_minclass
- rsyslog_encrypt_offload_actionsendstreamdrivermode
- audit_rules_file_deletion_events_unlink
- encrypt_partitions
- sysctl_net_ipv6_conf_default_accept_ra
- package_libreport-plugin-rhtsupport_removed
- dconf_gnome_screensaver_lock_delay
- auditd_local_events
- configure_tmux_lock_keybinding
- accounts_password_pam_difok
- account_password_pam_faillock_system_auth
- sysctl_kernel_perf_event_paranoid
- audit_rules_immutable
- sysctl_net_ipv6_conf_all_accept_ra
- no_tmux_in_shells
- xwindows_runlevel_target
- mount_option_var_tmp_nodev
- sysctl_kernel_kptr_restrict
- account_password_selinux_faillock_dir
- audit_rules_file_deletion_events_rename
- sshd_do_not_permit_user_env
- service_fapolicyd_enabled
- accounts_umask_etc_login_defs
- accounts_password_pam_pwquality_system_auth
- package_rng-tools_installed
- dir_group_ownership_library_dirs
- accounts_passwords_pam_faillock_dir
- sysctl_kernel_randomize_va_space
- sysctl_net_ipv6_conf_default_accept_redirects
- grub2_uefi_password
- audit_rules_privileged_commands_passwd
- require_emergency_target_auth
- mount_option_tmp_nodev
- audit_rules_privileged_commands_ssh_agent
- service_kdump_disabled
- accounts_passwords_pam_faillock_deny
- package_telnet-server_removed
- file_groupownership_system_commands_dirs
- configure_openssl_tls_crypto_policy
- no_files_unowned_by_user
- mount_option_noexec_removable_partitions
- mount_option_tmp_noexec
- package_abrt-addon-kerneloops_removed
- wireless_disable_interfaces
- accounts_password_all_shadowed_sha512
- dconf_gnome_banner_enabled
- display_login_attempts
- audit_rules_privileged_commands_postqueue
- ensure_gpgcheck_globally_activated
- coredump_disable_storage
- ensure_gpgcheck_local_packages
- dconf_gnome_lock_screen_on_smartcard_removal
- audit_rules_execution_setsebool
- accounts_user_interactive_home_directory_defined
- root_permissions_syslibrary_files
- grub2_audit_backlog_limit_argument
- kernel_module_uvcvideo_disabled
- audit_rules_kernel_module_loading_delete
- dconf_gnome_session_idle_user_locks
- package_mcafeetp_installed
- configure_usbguard_auditbackend
- package_mailx_installed
- dir_permissions_library_dirs
- audit_rules_usergroup_modification_shadow
- mount_option_var_log_audit_nosuid
- aide_build_database
- set_password_hashing_algorithm_systemauth
- audit_rules_privileged_commands_postdrop
- disallow_bypass_password_sudo
- configure_tmux_lock_after_time
- configure_firewalld_ports
- configure_bind_crypto_policy
- dconf_gnome_disable_user_list
- accounts_password_pam_pwquality_password_auth
- auditd_log_format
- audit_rules_sudoers_d
- accounts_passwords_pam_faillock_deny_root
- ensure_gpgcheck_never_disabled
- file_permissions_sshd_pub_key
- kernel_module_tipc_disabled
- audit_rules_privileged_commands_pam_timestamp_check
- chronyd_or_ntpd_set_maxpoll
- account_temp_expire_date
- service_debug-shell_disabled
- mount_option_home_noexec
- accounts_password_pam_retry
- security_patches_up_to_date
- partition_for_home
- sshd_enable_warning_banner
- package_sendmail_removed
- install_smartcard_packages
- usbguard_generate_policy
- accounts_passwords_pam_faillock_unlock_time
- sysctl_fs_protected_hardlinks
- no_host_based_files
- chronyd_client_only
- audit_rules_kernel_module_loading_finit
- sshd_print_last_log
- no_empty_passwords
- partition_for_var_log
- kerberos_disable_no_keytab
- service_sshd_enabled
- accounts_password_pam_pwhistory_remember_system_auth
- sshd_disable_empty_passwords
- accounts_password_pam_ucredit
- chronyd_server_directive
- audit_rules_dac_modification_lsetxattr
- disable_ctrlaltdel_reboot
- grub2_vsyscall_argument
- audit_rules_dac_modification_fchmod
- file_audit_tools_permissions
- enable_dracut_fips_module
- package_tuned_removed
- configure_crypto_policy
- selinux_policytype
- audit_rules_dac_modification_fchmodat
- configure_bashrc_tmux
- package_aide_installed
- rsyslog_remote_loghost
- mount_option_noexec_remote_filesystems
- file_audit_tools_ownership
- audit_rules_media_export
- sysctl_net_ipv4_conf_all_forwarding
- audit_rules_execution_setfiles
- package_libreport-plugin-logger_removed
- audit_rules_unsuccessful_file_modification_open_by_handle_at
- sshd_disable_user_known_hosts
- audit_rules_dac_modification_chmod
- require_singleuser_auth
- sssd_enable_certmap
- audit_rules_dac_modification_fchownat
- audit_rules_privileged_commands_sudo
- disable_ctrlaltdel_burstaction
- package_opensc_installed
- logind_session_timeout
- ensure_redhat_gpgkey_installed
- mount_option_var_log_nosuid
- file_group_ownership_var_log_audit
- sshd_set_keepalive
- selinux_state
- audit_rules_dac_modification_lchown
- accounts_have_homedir_login_defs
- audit_rules_unsuccessful_file_modification_truncate
- sysctl_net_ipv4_conf_default_accept_source_route
- accounts_password_set_max_life_existing
- package_postfix_installed
- mount_option_var_log_audit_nodev
- package_openssh-server_installed
- package_rsyslog-gnutls_installed
- file_permissions_var_log_messages
- service_rsyslog_enabled
- package_usbguard_installed
- package_fapolicyd_installed
- sysctl_crypto_fips_enabled
- file_ownership_var_log_audit_stig
- file_permissions_sshd_private_key
- audit_rules_execution_semanage
- grub2_password
- audit_rules_dac_modification_fsetxattr
- audit_rules_login_events_faillock
- mount_option_dev_shm_nosuid
- dconf_gnome_screensaver_lock_enabled
- rsyslog_remote_access_monitoring
- package_abrt-plugin-sosreport_removed
- audit_rules_usergroup_modification_opasswd
- accounts_password_pam_lcredit
- sshd_disable_x11_forwarding
- package_krb5-server_removed
- mount_option_boot_nosuid
- accounts_minimum_age_login_defs
- enable_fips_mode
- sudo_remove_nopasswd
- auditd_data_retention_action_mail_acct
- audit_rules_privileged_commands_crontab
- firewalld-backend
- sysctl_net_ipv4_conf_default_accept_redirects
- network_sniffer_disabled
- grub2_slub_debug_argument
- audit_rules_unsuccessful_file_modification_open
- ssh_keys_passphrase_protected
- mount_option_nosuid_removable_partitions
- file_groupownership_home_directories
- package_audit_installed
- auditd_overflow_action
- sysctl_net_ipv4_conf_all_send_redirects
- package_abrt_removed
- mount_option_home_nosuid
- directory_group_ownership_var_log_audit
- mount_option_nosuid_remote_filesystems
- package_tmux_installed
- audit_rules_execution_chacl
- file_permissions_home_directories
- sudo_restrict_privilege_elevation_to_authorized
- accounts_password_pam_dictcheck
- configure_tmux_lock_command
- sysctl_fs_protected_symlinks
- accounts_passwords_pam_faillock_silent
- file_permission_user_init_files
- service_autofs_disabled
- sssd_has_trust_anchor
- rsyslog_encrypt_offload_defaultnetstreamdriver
- service_rngd_enabled
- accounts_authorized_local_users
- installed_OS_is_vendor_supported
- accounts_logon_fail_delay
- audit_rules_kernel_module_loading_init
- partition_for_var_log_audit
- audit_rules_suid_privilege_function
- file_owner_var_log
- set_password_hashing_min_rounds_logindefs
- audit_rules_sudoers
- file_permissions_library_dirs
- sysctl_net_ipv6_conf_all_accept_source_route
- service_auditd_enabled
- no_user_host_based_files
- accounts_password_pam_dcredit
- audit_rules_usergroup_modification_passwd
- selinux_user_login_roles
- file_audit_tools_group_ownership
- sudo_remove_no_authenticate
- package_rsh-server_removed
- auditd_data_retention_space_left_percentage
- mount_option_var_log_noexec
- sysctl_net_ipv4_conf_all_accept_source_route
- directory_ownership_var_log_audit
- agent_mfetpd_running
- package_iprutils_removed
- rsyslog_encrypt_offload_actionsendstreamdriverauthmode
- aide_verify_ext_attributes
- accounts_password_pam_maxclassrepeat
- accounts_no_uid_except_zero
- file_permissions_var_log
- sysctl_net_ipv4_conf_all_rp_filter
- audit_rules_privileged_commands_unix_chkpwd
- package_firewalld_installed
- sysctl_net_ipv6_conf_default_accept_source_route
- aide_verify_acls
- configure_kerberos_crypto_policy
- audit_rules_privileged_commands_unix_update
- sshd_set_idle_timeout
- audit_rules_login_events_lastlog
- network_configure_name_resolution
- kernel_module_can_disabled
- auditd_data_disk_error_action
- audit_rules_execution_chcon
- sysctl_net_core_bpf_jit_harden
- package_python3-abrt-addon_removed
- package_policycoreutils_installed
- grub2_uefi_admin_username
- sysctl_net_ipv4_icmp_echo_ignore_broadcasts
- sysctl_kernel_core_pattern
- kernel_module_firewire-core_disabled
- accounts_password_set_min_life_existing
- chronyd_no_chronyc_network
- dir_perms_world_writable_root_owned
- sysctl_net_ipv4_conf_default_send_redirects
- file_permissions_binary_dirs
- accounts_umask_etc_profile
- package_vsftpd_removed
- audit_rules_privileged_commands_su
- service_systemd-coredump_disabled
- grub2_page_poison_argument
- accounts_user_dot_no_world_writable_programs
- configure_ssh_crypto_policy
- audit_rules_privileged_commands_kmod
- accounts_passwords_pam_faillock_interval
- auditd_data_disk_full_action
- mount_option_var_tmp_noexec
- account_disable_post_pw_expiration
- sudo_require_reauthentication
- file_ownership_binary_dirs
- audit_rules_file_deletion_events_renameat
- audit_rules_privileged_commands_mount
- sshd_disable_gssapi_auth
- sssd_offline_cred_expiration
- partition_for_var
- aide_check_audit_tools
- accounts_password_pam_ocredit
- partition_for_tmp
- sysctl_kernel_yama_ptrace_scope
- audit_rules_file_deletion_events_rmdir
- file_groupowner_var_log_messages
- auditd_data_retention_space_left_action
- aide_scan_notification
- account_password_pam_faillock_password_auth
- dconf_gnome_disable_ctrlaltdel_reboot
- harden_sshd_macs_opensshserver_conf_crypto_policy
- mount_option_boot_efi_nosuid
- file_permissions_etc_audit_auditd
- audit_rules_unsuccessful_file_modification_creat
- mount_option_var_log_audit_noexec
- audit_rules_privileged_commands_gpasswd
- harden_sshd_macs_openssh_conf_crypto_policy
- file_ownership_library_dirs
- mount_option_nodev_nonroot_local_partitions
- banner_etc_issue
- sshd_use_strong_rng
- grub2_audit_argument
- account_unique_id
- package_abrt-cli_removed
- audit_rules_immutable_login_uids
- service_usbguard_enabled
- audit_rules_privileged_commands_usermod
- audit_rules_dac_modification_lremovexattr
- accounts_umask_interactive_users
- audit_rules_unsuccessful_file_modification_openat
- service_firewalld_enabled
- accounts_password_minlen_login_defs
- audit_rules_usergroup_modification_group
- disable_users_coredumps
- audit_rules_file_deletion_events_unlinkat
- set_password_hashing_algorithm_passwordauth
- accounts_user_home_paths_only
- postfix_client_configure_mail_alias_postmaster
- kernel_module_usb-storage_disabled
- sssd_certificate_verification
- kernel_module_sctp_disabled
- configure_openssl_crypto_policy
- dconf_gnome_screensaver_idle_delay
- mount_option_dev_shm_nodev
- audit_rules_privileged_commands_umount
- postfix_prevent_unrestricted_relay
- tftpd_uses_secure_mode
- accounts_umask_etc_csh_cshrc
- kernel_module_atm_disabled
- audit_rules_privileged_commands_ssh_keysign
- package_tftp-server_removed
- sysctl_net_ipv6_conf_all_accept_redirects
- accounts_passwords_pam_faillock_audit
- sudoers_validate_passwd
- auditd_name_format
- sshd_disable_root_login
- audit_rules_dac_modification_chown
- sudoers_default_includedir
- sssd_enable_smartcards
- accounts_password_pam_pwhistory_remember_password_auth
- package_rsyslog_installed
- sshd_rekey_limit
- sshd_use_approved_kex_ordered_stig
- accounts_umask_etc_bashrc
- audit_rules_dac_modification_removexattr
- sysctl_kernel_dmesg_restrict
- package_abrt-addon-ccpp_removed
- dconf_gnome_screensaver_lock_locked
- auditd_audispd_configure_sufficiently_large_partition
- sshd_x11_use_localhost
- set_password_hashing_algorithm_logindefs
- file_owner_var_log_messages
- dconf_gnome_screensaver_user_locks
- file_groupowner_var_log
- accounts_password_pam_maxrepeat
- audit_rules_unsuccessful_file_modification_ftruncate
- dir_ownership_library_dirs
- set_firewalld_default_zone
- dir_perms_world_writable_system_owned_group
- package_krb5-workstation_removed
- audit_rules_usergroup_modification_gshadow
- harden_sshd_ciphers_opensshserver_conf_crypto_policy
- audit_rules_dac_modification_fremovexattr
- dir_perms_world_writable_sticky_bits
- fapolicy_default_deny
- mount_option_var_log_nodev
- audit_rules_execution_setfacl
- accounts_password_pam_minlen
- no_empty_passwords_etc_shadow
- configure_gnutls_tls_crypto_policy
- sysctl_kernel_kexec_load_disabled
- audit_rules_dac_modification_setxattr
- clean_components_post_updating
- sysctl_net_ipv6_conf_all_forwarding
- rsyslog_cron_logging
- mount_option_nodev_removable_partitions
- audit_rules_privileged_commands_userhelper
- file_permissions_var_log_audit
- directory_permissions_var_log_audit
- configured_firewalld_default_deny
- sshd_enable_strictmodes
- sysctl_user_max_user_namespaces
- xwindows_remove_packages
- sshd_disable_kerb_auth
- package_gssproxy_removed
- gnome_gdm_disable_automatic_login
- audit_rules_privileged_commands_newgrp
- audit_rules_privileged_commands_chsh
- mount_option_nodev_remote_filesystems
- dconf_gnome_login_banner_text
- bios_enable_execution_restrictions
- mount_option_dev_shm_noexec
- audit_rules_privileged_commands_chage
- sysctl_net_ipv4_conf_all_accept_redirects
- partition_for_var_tmp
- grub2_admin_username
- sysctl_kernel_unprivileged_bpf_disabled
- mount_option_tmp_nosuid
- var_rekey_limit_size=1G
- var_rekey_limit_time=1hour
- var_accounts_user_umask=077
- var_password_pam_difok=8
- var_password_pam_maxrepeat=3
- var_password_hashing_algorithm=SHA512
- var_password_pam_maxclassrepeat=4
- var_password_pam_minclass=4
- var_accounts_minimum_age_login_defs=1
- var_accounts_max_concurrent_login_sessions=10
- var_password_pam_remember=5
- var_password_pam_remember_control_flag=requisite_or_required
- var_selinux_state=enforcing
- var_selinux_policy_name=targeted
- var_password_pam_unix_rounds=5000
- var_password_pam_minlen=15
- var_password_pam_ocredit=1
- var_password_pam_dcredit=1
- var_password_pam_dictcheck=1
- var_password_pam_ucredit=1
- var_password_pam_lcredit=1
- var_password_pam_retry=3
- var_sshd_set_keepalive=1
- sshd_approved_macs=stig_extended
- sshd_approved_ciphers=stig_extended
- sshd_idle_timeout_value=10_minutes
- var_accounts_authorized_local_users_regex=rhel8
- var_accounts_passwords_pam_faillock_deny=3
- var_accounts_passwords_pam_faillock_fail_interval=900
- var_accounts_passwords_pam_faillock_unlock_time=never
- var_ssh_client_rekey_limit_size=1G
- var_ssh_client_rekey_limit_time=1hour
- var_accounts_fail_delay=4
- var_account_disable_post_pw_expiration=35
- var_auditd_action_mail_acct=root
- var_time_service_set_maxpoll=18_hours
- var_accounts_maximum_age_login_defs=60
- var_auditd_space_left_percentage=25pc
- var_auditd_space_left_action=email
- var_auditd_disk_error_action=rhel8
- var_auditd_max_log_file_action=syslog
- var_auditd_disk_full_action=rhel8
- var_sssd_certificate_verification_digest_function=sha1
- login_banner_text=dod_banners
- var_authselect_profile=sssd
- var_system_crypto_policy=fips
- var_sudo_timestamp_timeout=always_prompt
- var_slub_debug_options=P
- var_screensaver_lock_delay=5_seconds
- var_logind_session_timeout=15_minutes
- var_auditd_name_format=stig
unselected_groups: []
platforms: !!set {}
cpe_names: !!set {}
platform: null
filter_rules: ''
policies: []
title: DISA STIG for Red Hat Enterprise Linux 8
documentation_complete: true
