/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PasswordExpiringControl
extends Control
implements DecodeableControl {
    @NotNull
    public static final String PASSWORD_EXPIRING_OID = "2.16.840.1.113730.3.4.5";
    @NotNull
    private static final String JSON_FIELD_SECONDS_UNTIL_EXPIRATION = "seconds-until-expiration";
    private static final long serialVersionUID = 1250220480854441338L;
    private final int secondsUntilExpiration;

    PasswordExpiringControl() {
        this.secondsUntilExpiration = -1;
    }

    public PasswordExpiringControl(int secondsUntilExpiration) {
        super(PASSWORD_EXPIRING_OID, false, new ASN1OctetString(String.valueOf(secondsUntilExpiration)));
        this.secondsUntilExpiration = secondsUntilExpiration;
    }

    public PasswordExpiringControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PW_EXPIRING_NO_VALUE.get());
        }
        try {
            this.secondsUntilExpiration = Integer.parseInt(value.stringValue());
        }
        catch (NumberFormatException nfe) {
            Debug.debugException(nfe);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PW_EXPIRING_VALUE_NOT_INTEGER.get(), nfe);
        }
    }

    @Override
    @NotNull
    public PasswordExpiringControl decodeControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        return new PasswordExpiringControl(oid, isCritical, value);
    }

    @Nullable
    public static PasswordExpiringControl get(@NotNull LDAPResult result) throws LDAPException {
        Control c = result.getResponseControl(PASSWORD_EXPIRING_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof PasswordExpiringControl) {
            return (PasswordExpiringControl)c;
        }
        return new PasswordExpiringControl(c.getOID(), c.isCritical(), c.getValue());
    }

    public int getSecondsUntilExpiration() {
        return this.secondsUntilExpiration;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_PW_EXPIRING.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        return new JSONObject(new JSONField("oid", PASSWORD_EXPIRING_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_PW_EXPIRING.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", new JSONObject(new JSONField(JSON_FIELD_SECONDS_UNTIL_EXPIRATION, this.secondsUntilExpiration))));
    }

    @NotNull
    public static PasswordExpiringControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new PasswordExpiringControl(jsonControl.getOID(), jsonControl.getCriticality(), rawValue);
        }
        JSONObject valueObject = jsonControl.getValueObject();
        Integer secondsUntilExpiration = valueObject.getFieldAsInteger(JSON_FIELD_SECONDS_UNTIL_EXPIRATION);
        if (secondsUntilExpiration == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PW_EXPIRING_JSON_MISSING_SECONDS_UNTIL_EXPIRATION.get(controlObject.toSingleLineString(), JSON_FIELD_SECONDS_UNTIL_EXPIRATION));
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_SECONDS_UNTIL_EXPIRATION)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PW_EXPIRING_JSON_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new PasswordExpiringControl(secondsUntilExpiration);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("PasswordExpiringControl(secondsUntilExpiration=");
        buffer.append(this.secondsUntilExpiration);
        buffer.append(", isCritical=");
        buffer.append(this.isCritical());
        buffer.append(')');
    }
}

