/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.jsonfilter;

import com.unboundid.ldap.sdk.unboundidds.jsonfilter.JSONObjectFilter;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONBoolean;
import com.unboundid.util.json.JSONException;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class ORJSONObjectFilter
extends JSONObjectFilter {
    @NotNull
    public static final String FILTER_TYPE = "or";
    @NotNull
    public static final String FIELD_OR_FILTERS = "orFilters";
    @NotNull
    public static final String FIELD_EXCLUSIVE = "exclusive";
    @NotNull
    private static final Set<String> REQUIRED_FIELD_NAMES = Collections.unmodifiableSet(new HashSet<String>(Collections.singletonList("orFilters")));
    @NotNull
    private static final Set<String> OPTIONAL_FIELD_NAMES = Collections.unmodifiableSet(new HashSet<String>(Collections.singletonList("exclusive")));
    private static final long serialVersionUID = -7821418213623654386L;
    private volatile boolean exclusive;
    @NotNull
    private volatile List<JSONObjectFilter> orFilters;

    public ORJSONObjectFilter(JSONObjectFilter ... orFilters) {
        this(StaticUtils.toList(orFilters));
    }

    public ORJSONObjectFilter(@Nullable Collection<JSONObjectFilter> orFilters) {
        this.setORFilters(orFilters);
        this.exclusive = false;
    }

    @NotNull
    public List<JSONObjectFilter> getORFilters() {
        return this.orFilters;
    }

    public void setORFilters(JSONObjectFilter ... orFilters) {
        this.setORFilters(StaticUtils.toList(orFilters));
    }

    public void setORFilters(@Nullable Collection<JSONObjectFilter> orFilters) {
        this.orFilters = orFilters == null || orFilters.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<JSONObjectFilter>(orFilters));
    }

    public boolean exclusive() {
        return this.exclusive;
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    @Override
    @NotNull
    public String getFilterType() {
        return FILTER_TYPE;
    }

    @Override
    @NotNull
    protected Set<String> getRequiredFieldNames() {
        return REQUIRED_FIELD_NAMES;
    }

    @Override
    @NotNull
    protected Set<String> getOptionalFieldNames() {
        return OPTIONAL_FIELD_NAMES;
    }

    @Override
    public boolean matchesJSONObject(@NotNull JSONObject o) {
        boolean matchFound = false;
        for (JSONObjectFilter f : this.orFilters) {
            if (!f.matchesJSONObject(o)) continue;
            if (this.exclusive) {
                if (matchFound) {
                    return false;
                }
                matchFound = true;
                continue;
            }
            return true;
        }
        return matchFound;
    }

    @Override
    @NotNull
    public JSONObject toJSONObject() {
        LinkedHashMap<String, JSONValue> fields = new LinkedHashMap<String, JSONValue>(StaticUtils.computeMapCapacity(3));
        fields.put("filterType", new JSONString(FILTER_TYPE));
        ArrayList<JSONObject> filterValues = new ArrayList<JSONObject>(this.orFilters.size());
        for (JSONObjectFilter f : this.orFilters) {
            filterValues.add(f.toJSONObject());
        }
        fields.put(FIELD_OR_FILTERS, new JSONArray(filterValues));
        if (this.exclusive) {
            fields.put(FIELD_EXCLUSIVE, JSONBoolean.TRUE);
        }
        return new JSONObject(fields);
    }

    @Override
    @NotNull
    protected ORJSONObjectFilter decodeFilter(@NotNull JSONObject filterObject) throws JSONException {
        ORJSONObjectFilter orFilter = new ORJSONObjectFilter(this.getFilters(filterObject, FIELD_OR_FILTERS));
        orFilter.exclusive = this.getBoolean(filterObject, FIELD_EXCLUSIVE, false);
        return orFilter;
    }
}

