# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=x86_64-unknown-unknown -mcpu=slm -instruction-tables < %s | FileCheck %s

crc32b      %al, %ecx
crc32b      (%rax), %ecx

crc32l      %eax, %ecx
crc32l      (%rax), %ecx

crc32w      %ax, %ecx
crc32w      (%rax), %ecx

crc32b      %al, %rcx
crc32b      (%rax), %rcx

crc32q      %rax, %rcx
crc32q      (%rax), %rcx

pcmpestri   $1, %xmm0, %xmm2
pcmpestri   $1, (%rax), %xmm2

pcmpestrm   $1, %xmm0, %xmm2
pcmpestrm   $1, (%rax), %xmm2

pcmpistri   $1, %xmm0, %xmm2
pcmpistri   $1, (%rax), %xmm2

pcmpistrm   $1, %xmm0, %xmm2
pcmpistrm   $1, (%rax), %xmm2

pcmpgtq     %xmm0, %xmm2
pcmpgtq     (%rax), %xmm2

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      3     1.00                        crc32b	%al, %ecx
# CHECK-NEXT:  1      6     1.00    *                   crc32b	(%rax), %ecx
# CHECK-NEXT:  1      3     1.00                        crc32l	%eax, %ecx
# CHECK-NEXT:  1      6     1.00    *                   crc32l	(%rax), %ecx
# CHECK-NEXT:  1      3     1.00                        crc32w	%ax, %ecx
# CHECK-NEXT:  1      6     1.00    *                   crc32w	(%rax), %ecx
# CHECK-NEXT:  1      3     1.00                        crc32b	%al, %rcx
# CHECK-NEXT:  1      6     1.00    *                   crc32b	(%rax), %rcx
# CHECK-NEXT:  1      3     1.00                        crc32q	%rax, %rcx
# CHECK-NEXT:  1      6     1.00    *                   crc32q	(%rax), %rcx
# CHECK-NEXT:  9      21    21.00                       pcmpestri	$1, %xmm0, %xmm2
# CHECK-NEXT:  10     24    21.00   *                   pcmpestri	$1, (%rax), %xmm2
# CHECK-NEXT:  8      17    17.00                       pcmpestrm	$1, %xmm0, %xmm2
# CHECK-NEXT:  9      20    17.00   *                   pcmpestrm	$1, (%rax), %xmm2
# CHECK-NEXT:  6      17    17.00                       pcmpistri	$1, %xmm0, %xmm2
# CHECK-NEXT:  7      20    17.00   *                   pcmpistri	$1, (%rax), %xmm2
# CHECK-NEXT:  5      13    13.00                       pcmpistrm	$1, %xmm0, %xmm2
# CHECK-NEXT:  6      16    13.00   *                   pcmpistrm	$1, (%rax), %xmm2
# CHECK-NEXT:  1      5     2.00                        pcmpgtq	%xmm0, %xmm2
# CHECK-NEXT:  2      8     2.00    *                   pcmpgtq	(%rax), %xmm2

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SLMDivider
# CHECK-NEXT: [1]   - SLMFPDivider
# CHECK-NEXT: [2]   - SLMFPMultiplier
# CHECK-NEXT: [3]   - SLM_FPC_RSV0
# CHECK-NEXT: [4]   - SLM_FPC_RSV1
# CHECK-NEXT: [5]   - SLM_IEC_RSV0
# CHECK-NEXT: [6]   - SLM_IEC_RSV1
# CHECK-NEXT: [7]   - SLM_MEC_RSV

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]
# CHECK-NEXT:  -      -      -     140.00  -      -     10.00  10.00

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    Instructions:
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     crc32b	%al, %ecx
# CHECK-NEXT:  -      -      -      -      -      -     1.00   1.00   crc32b	(%rax), %ecx
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     crc32l	%eax, %ecx
# CHECK-NEXT:  -      -      -      -      -      -     1.00   1.00   crc32l	(%rax), %ecx
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     crc32w	%ax, %ecx
# CHECK-NEXT:  -      -      -      -      -      -     1.00   1.00   crc32w	(%rax), %ecx
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     crc32b	%al, %rcx
# CHECK-NEXT:  -      -      -      -      -      -     1.00   1.00   crc32b	(%rax), %rcx
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     crc32q	%rax, %rcx
# CHECK-NEXT:  -      -      -      -      -      -     1.00   1.00   crc32q	(%rax), %rcx
# CHECK-NEXT:  -      -      -     21.00   -      -      -      -     pcmpestri	$1, %xmm0, %xmm2
# CHECK-NEXT:  -      -      -     21.00   -      -      -     1.00   pcmpestri	$1, (%rax), %xmm2
# CHECK-NEXT:  -      -      -     17.00   -      -      -      -     pcmpestrm	$1, %xmm0, %xmm2
# CHECK-NEXT:  -      -      -     17.00   -      -      -     1.00   pcmpestrm	$1, (%rax), %xmm2
# CHECK-NEXT:  -      -      -     17.00   -      -      -      -     pcmpistri	$1, %xmm0, %xmm2
# CHECK-NEXT:  -      -      -     17.00   -      -      -     1.00   pcmpistri	$1, (%rax), %xmm2
# CHECK-NEXT:  -      -      -     13.00   -      -      -      -     pcmpistrm	$1, %xmm0, %xmm2
# CHECK-NEXT:  -      -      -     13.00   -      -      -     1.00   pcmpistrm	$1, (%rax), %xmm2
# CHECK-NEXT:  -      -      -     2.00    -      -      -      -     pcmpgtq	%xmm0, %xmm2
# CHECK-NEXT:  -      -      -     2.00    -      -      -     1.00   pcmpgtq	(%rax), %xmm2
