; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt < %s -msan-check-access-address=0 -S -passes=msan 2>&1 | FileCheck %s

target datalayout = "e-m:e-i8:8:32-i16:16:32-i64:64-i128:128-n32:64-S128"
target triple = "aarch64-grtev4-linux-gnu"

%struct.IntInt = type { i32, i32 }
%struct.Int64Int64 = type { i64, i64 }
%struct.DoubleDouble = type { double, double }
%struct.Double4 = type { [4 x double] }
%struct.DoubleFloat = type { double, float }
%struct.LongDouble2 = type { [2 x fp128] }
%struct.LongDouble4 = type { [4 x fp128] }
%"struct.std::__va_list" = type { ptr, ptr, ptr, i32, i32 }

define linkonce_odr dso_local void @_Z4testIcEvT_(i8 noundef %arg) sanitize_memory {
; CHECK-LABEL: define linkonce_odr dso_local void @_Z4testIcEvT_(
; CHECK-SAME: i8 noundef [[ARG:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[ARG_ADDR:%.*]] = alloca i8, align 4
; CHECK-NEXT:    [[TMP1:%.*]] = ptrtoint ptr [[ARG_ADDR]] to i64
; CHECK-NEXT:    [[TMP2:%.*]] = xor i64 [[TMP1]], 193514046488576
; CHECK-NEXT:    [[TMP3:%.*]] = inttoptr i64 [[TMP2]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 4 [[TMP3]], i8 -1, i64 1, i1 false)
; CHECK-NEXT:    [[TMP4:%.*]] = ptrtoint ptr [[ARG_ADDR]] to i64
; CHECK-NEXT:    [[TMP5:%.*]] = xor i64 [[TMP4]], 193514046488576
; CHECK-NEXT:    [[TMP6:%.*]] = inttoptr i64 [[TMP5]] to ptr
; CHECK-NEXT:    store i8 [[TMP0]], ptr [[TMP6]], align 4
; CHECK-NEXT:    store i8 [[ARG]], ptr [[ARG_ADDR]], align 4
; CHECK-NEXT:    store i64 0, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @_Z3usePv(ptr noundef nonnull [[ARG_ADDR]])
; CHECK-NEXT:    [[TMP7:%.*]] = load i8, ptr [[ARG_ADDR]], align 4
; CHECK-NEXT:    [[TMP8:%.*]] = ptrtoint ptr [[ARG_ADDR]] to i64
; CHECK-NEXT:    [[TMP9:%.*]] = xor i64 [[TMP8]], 193514046488576
; CHECK-NEXT:    [[TMP10:%.*]] = inttoptr i64 [[TMP9]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load i8, ptr [[TMP10]], align 4
; CHECK-NEXT:    [[_MSPROP:%.*]] = zext i8 [[_MSLD]] to i32
; CHECK-NEXT:    [[CONV:%.*]] = zext i8 [[TMP7]] to i32
; CHECK-NEXT:    store i8 [[_MSLD]], ptr @__msan_param_tls, align 8
; CHECK-NEXT:    store i32 0, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 8) to ptr), align 8
; CHECK-NEXT:    store i32 [[_MSPROP]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    store i32 [[_MSPROP]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_va_arg_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    store i64 0, ptr @__msan_va_arg_overflow_size_tls, align 8
; CHECK-NEXT:    call void (i8, i32, ...) @_Z5test2IcEvT_iz(i8 noundef [[TMP7]], i32 noundef 1, i32 noundef [[CONV]])
; CHECK-NEXT:    ret void
;
entry:
  %arg.addr = alloca i8, align 4
  store i8 %arg, ptr %arg.addr, align 4
  call void @_Z3usePv(ptr noundef nonnull %arg.addr)
  %0 = load i8, ptr %arg.addr, align 4
  %conv = zext i8 %0 to i32
  call void (i8, i32, ...) @_Z5test2IcEvT_iz(i8 noundef %0, i32 noundef 1, i32 noundef %conv)
  ret void
}

define linkonce_odr dso_local void @_Z4testIiEvT_(i32 noundef %arg) sanitize_memory {
; CHECK-LABEL: define linkonce_odr dso_local void @_Z4testIiEvT_(
; CHECK-SAME: i32 noundef [[ARG:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[ARG_ADDR:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[TMP1:%.*]] = ptrtoint ptr [[ARG_ADDR]] to i64
; CHECK-NEXT:    [[TMP2:%.*]] = xor i64 [[TMP1]], 193514046488576
; CHECK-NEXT:    [[TMP3:%.*]] = inttoptr i64 [[TMP2]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 4 [[TMP3]], i8 -1, i64 4, i1 false)
; CHECK-NEXT:    [[TMP4:%.*]] = ptrtoint ptr [[ARG_ADDR]] to i64
; CHECK-NEXT:    [[TMP5:%.*]] = xor i64 [[TMP4]], 193514046488576
; CHECK-NEXT:    [[TMP6:%.*]] = inttoptr i64 [[TMP5]] to ptr
; CHECK-NEXT:    store i32 [[TMP0]], ptr [[TMP6]], align 4
; CHECK-NEXT:    store i32 [[ARG]], ptr [[ARG_ADDR]], align 4
; CHECK-NEXT:    store i64 0, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @_Z3usePv(ptr noundef nonnull [[ARG_ADDR]])
; CHECK-NEXT:    [[TMP7:%.*]] = load i32, ptr [[ARG_ADDR]], align 4
; CHECK-NEXT:    [[TMP8:%.*]] = ptrtoint ptr [[ARG_ADDR]] to i64
; CHECK-NEXT:    [[TMP9:%.*]] = xor i64 [[TMP8]], 193514046488576
; CHECK-NEXT:    [[TMP10:%.*]] = inttoptr i64 [[TMP9]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load i32, ptr [[TMP10]], align 4
; CHECK-NEXT:    store i32 [[_MSLD]], ptr @__msan_param_tls, align 8
; CHECK-NEXT:    store i32 0, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 8) to ptr), align 8
; CHECK-NEXT:    store i32 [[_MSLD]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    store i32 [[_MSLD]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_va_arg_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    store i64 0, ptr @__msan_va_arg_overflow_size_tls, align 8
; CHECK-NEXT:    call void (i32, i32, ...) @_Z5test2IiEvT_iz(i32 noundef [[TMP7]], i32 noundef 1, i32 noundef [[TMP7]])
; CHECK-NEXT:    ret void
;
entry:
  %arg.addr = alloca i32, align 4
  store i32 %arg, ptr %arg.addr, align 4
  call void @_Z3usePv(ptr noundef nonnull %arg.addr)
  %0 = load i32, ptr %arg.addr, align 4
  call void (i32, i32, ...) @_Z5test2IiEvT_iz(i32 noundef %0, i32 noundef 1, i32 noundef %0)
  ret void
}

define linkonce_odr dso_local void @_Z4testIfEvT_(float noundef %arg) sanitize_memory {
; CHECK-LABEL: define linkonce_odr dso_local void @_Z4testIfEvT_(
; CHECK-SAME: float noundef [[ARG:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[ARG_ADDR:%.*]] = alloca float, align 4
; CHECK-NEXT:    [[TMP1:%.*]] = ptrtoint ptr [[ARG_ADDR]] to i64
; CHECK-NEXT:    [[TMP2:%.*]] = xor i64 [[TMP1]], 193514046488576
; CHECK-NEXT:    [[TMP3:%.*]] = inttoptr i64 [[TMP2]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 4 [[TMP3]], i8 -1, i64 4, i1 false)
; CHECK-NEXT:    [[TMP4:%.*]] = ptrtoint ptr [[ARG_ADDR]] to i64
; CHECK-NEXT:    [[TMP5:%.*]] = xor i64 [[TMP4]], 193514046488576
; CHECK-NEXT:    [[TMP6:%.*]] = inttoptr i64 [[TMP5]] to ptr
; CHECK-NEXT:    store i32 [[TMP0]], ptr [[TMP6]], align 4
; CHECK-NEXT:    store float [[ARG]], ptr [[ARG_ADDR]], align 4
; CHECK-NEXT:    store i64 0, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @_Z3usePv(ptr noundef nonnull [[ARG_ADDR]])
; CHECK-NEXT:    [[TMP7:%.*]] = load float, ptr [[ARG_ADDR]], align 4
; CHECK-NEXT:    [[TMP8:%.*]] = ptrtoint ptr [[ARG_ADDR]] to i64
; CHECK-NEXT:    [[TMP9:%.*]] = xor i64 [[TMP8]], 193514046488576
; CHECK-NEXT:    [[TMP10:%.*]] = inttoptr i64 [[TMP9]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load i32, ptr [[TMP10]], align 4
; CHECK-NEXT:    [[TMP11:%.*]] = zext i32 [[_MSLD]] to i64
; CHECK-NEXT:    [[CONV:%.*]] = fpext float [[TMP7]] to double
; CHECK-NEXT:    store i32 [[_MSLD]], ptr @__msan_param_tls, align 8
; CHECK-NEXT:    store i32 0, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 8) to ptr), align 8
; CHECK-NEXT:    store i64 [[TMP11]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    store i64 [[TMP11]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_va_arg_tls to i64), i64 80) to ptr), align 8
; CHECK-NEXT:    store i64 0, ptr @__msan_va_arg_overflow_size_tls, align 8
; CHECK-NEXT:    call void (float, i32, ...) @_Z5test2IfEvT_iz(float noundef [[TMP7]], i32 noundef 1, double noundef [[CONV]])
; CHECK-NEXT:    ret void
;
entry:
  %arg.addr = alloca float, align 4
  store float %arg, ptr %arg.addr, align 4
  call void @_Z3usePv(ptr noundef nonnull %arg.addr)
  %0 = load float, ptr %arg.addr, align 4
  %conv = fpext float %0 to double
  call void (float, i32, ...) @_Z5test2IfEvT_iz(float noundef %0, i32 noundef 1, double noundef %conv)
  ret void
}

define linkonce_odr dso_local void @_Z4testIdEvT_(double noundef %arg) sanitize_memory {
; CHECK-LABEL: define linkonce_odr dso_local void @_Z4testIdEvT_(
; CHECK-SAME: double noundef [[ARG:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[ARG_ADDR:%.*]] = alloca double, align 8
; CHECK-NEXT:    [[TMP1:%.*]] = ptrtoint ptr [[ARG_ADDR]] to i64
; CHECK-NEXT:    [[TMP2:%.*]] = xor i64 [[TMP1]], 193514046488576
; CHECK-NEXT:    [[TMP3:%.*]] = inttoptr i64 [[TMP2]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP3]], i8 -1, i64 8, i1 false)
; CHECK-NEXT:    [[TMP4:%.*]] = ptrtoint ptr [[ARG_ADDR]] to i64
; CHECK-NEXT:    [[TMP5:%.*]] = xor i64 [[TMP4]], 193514046488576
; CHECK-NEXT:    [[TMP6:%.*]] = inttoptr i64 [[TMP5]] to ptr
; CHECK-NEXT:    store i64 [[TMP0]], ptr [[TMP6]], align 8
; CHECK-NEXT:    store double [[ARG]], ptr [[ARG_ADDR]], align 8
; CHECK-NEXT:    store i64 0, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @_Z3usePv(ptr noundef nonnull [[ARG_ADDR]])
; CHECK-NEXT:    [[TMP7:%.*]] = load double, ptr [[ARG_ADDR]], align 8
; CHECK-NEXT:    [[TMP8:%.*]] = ptrtoint ptr [[ARG_ADDR]] to i64
; CHECK-NEXT:    [[TMP9:%.*]] = xor i64 [[TMP8]], 193514046488576
; CHECK-NEXT:    [[TMP10:%.*]] = inttoptr i64 [[TMP9]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load i64, ptr [[TMP10]], align 8
; CHECK-NEXT:    store i64 [[_MSLD]], ptr @__msan_param_tls, align 8
; CHECK-NEXT:    store i32 0, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 8) to ptr), align 8
; CHECK-NEXT:    store i64 [[_MSLD]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    store i64 [[_MSLD]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_va_arg_tls to i64), i64 80) to ptr), align 8
; CHECK-NEXT:    store i64 0, ptr @__msan_va_arg_overflow_size_tls, align 8
; CHECK-NEXT:    call void (double, i32, ...) @_Z5test2IdEvT_iz(double noundef [[TMP7]], i32 noundef 1, double noundef [[TMP7]])
; CHECK-NEXT:    ret void
;
entry:
  %arg.addr = alloca double, align 8
  store double %arg, ptr %arg.addr, align 8
  call void @_Z3usePv(ptr noundef nonnull %arg.addr)
  %0 = load double, ptr %arg.addr, align 8
  call void (double, i32, ...) @_Z5test2IdEvT_iz(double noundef %0, i32 noundef 1, double noundef %0)
  ret void
}

define linkonce_odr dso_local void @_Z4testIeEvT_(fp128 noundef %arg) sanitize_memory {
; CHECK-LABEL: define linkonce_odr dso_local void @_Z4testIeEvT_(
; CHECK-SAME: fp128 noundef [[ARG:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[ARG_ADDR:%.*]] = alloca fp128, align 16
; CHECK-NEXT:    [[TMP1:%.*]] = ptrtoint ptr [[ARG_ADDR]] to i64
; CHECK-NEXT:    [[TMP2:%.*]] = xor i64 [[TMP1]], 193514046488576
; CHECK-NEXT:    [[TMP3:%.*]] = inttoptr i64 [[TMP2]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 16 [[TMP3]], i8 -1, i64 16, i1 false)
; CHECK-NEXT:    [[TMP4:%.*]] = ptrtoint ptr [[ARG_ADDR]] to i64
; CHECK-NEXT:    [[TMP5:%.*]] = xor i64 [[TMP4]], 193514046488576
; CHECK-NEXT:    [[TMP6:%.*]] = inttoptr i64 [[TMP5]] to ptr
; CHECK-NEXT:    store i128 [[TMP0]], ptr [[TMP6]], align 16
; CHECK-NEXT:    store fp128 [[ARG]], ptr [[ARG_ADDR]], align 16
; CHECK-NEXT:    store i64 0, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @_Z3usePv(ptr noundef nonnull [[ARG_ADDR]])
; CHECK-NEXT:    [[TMP7:%.*]] = load fp128, ptr [[ARG_ADDR]], align 16
; CHECK-NEXT:    [[TMP8:%.*]] = ptrtoint ptr [[ARG_ADDR]] to i64
; CHECK-NEXT:    [[TMP9:%.*]] = xor i64 [[TMP8]], 193514046488576
; CHECK-NEXT:    [[TMP10:%.*]] = inttoptr i64 [[TMP9]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load i128, ptr [[TMP10]], align 16
; CHECK-NEXT:    store i128 [[_MSLD]], ptr @__msan_param_tls, align 8
; CHECK-NEXT:    store i32 0, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    store i128 [[_MSLD]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 24) to ptr), align 8
; CHECK-NEXT:    store i128 [[_MSLD]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_va_arg_tls to i64), i64 80) to ptr), align 8
; CHECK-NEXT:    store i64 0, ptr @__msan_va_arg_overflow_size_tls, align 8
; CHECK-NEXT:    call void (fp128, i32, ...) @_Z5test2IeEvT_iz(fp128 noundef [[TMP7]], i32 noundef 1, fp128 noundef [[TMP7]])
; CHECK-NEXT:    ret void
;
entry:
  %arg.addr = alloca fp128, align 16
  store fp128 %arg, ptr %arg.addr, align 16
  call void @_Z3usePv(ptr noundef nonnull %arg.addr)
  %0 = load fp128, ptr %arg.addr, align 16
  call void (fp128, i32, ...) @_Z5test2IeEvT_iz(fp128 noundef %0, i32 noundef 1, fp128 noundef %0)
  ret void
}

define linkonce_odr dso_local void @_Z4testI6IntIntEvT_(i64 %arg.coerce) sanitize_memory {
; CHECK-LABEL: define linkonce_odr dso_local void @_Z4testI6IntIntEvT_(
; CHECK-SAME: i64 [[ARG_COERCE:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[ARG:%.*]] = alloca [[STRUCT_INTINT:%.*]], align 8
; CHECK-NEXT:    [[TMP1:%.*]] = ptrtoint ptr [[ARG]] to i64
; CHECK-NEXT:    [[TMP2:%.*]] = xor i64 [[TMP1]], 193514046488576
; CHECK-NEXT:    [[TMP3:%.*]] = inttoptr i64 [[TMP2]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP3]], i8 -1, i64 8, i1 false)
; CHECK-NEXT:    [[TMP4:%.*]] = ptrtoint ptr [[ARG]] to i64
; CHECK-NEXT:    [[TMP5:%.*]] = xor i64 [[TMP4]], 193514046488576
; CHECK-NEXT:    [[TMP6:%.*]] = inttoptr i64 [[TMP5]] to ptr
; CHECK-NEXT:    store i64 [[TMP0]], ptr [[TMP6]], align 8
; CHECK-NEXT:    store i64 [[ARG_COERCE]], ptr [[ARG]], align 8
; CHECK-NEXT:    store i64 0, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @_Z3usePv(ptr noundef nonnull [[ARG]])
; CHECK-NEXT:    [[AGG_TMP_SROA_0_0_COPYLOAD:%.*]] = load i64, ptr [[ARG]], align 8
; CHECK-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[ARG]] to i64
; CHECK-NEXT:    [[TMP8:%.*]] = xor i64 [[TMP7]], 193514046488576
; CHECK-NEXT:    [[TMP9:%.*]] = inttoptr i64 [[TMP8]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load i64, ptr [[TMP9]], align 8
; CHECK-NEXT:    store i64 [[_MSLD]], ptr @__msan_param_tls, align 8
; CHECK-NEXT:    store i32 0, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 8) to ptr), align 8
; CHECK-NEXT:    store i64 [[_MSLD]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    store i64 [[_MSLD]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_va_arg_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    store i64 0, ptr @__msan_va_arg_overflow_size_tls, align 8
; CHECK-NEXT:    call void (i64, i32, ...) @_Z5test2I6IntIntEvT_iz(i64 [[AGG_TMP_SROA_0_0_COPYLOAD]], i32 noundef 1, i64 [[AGG_TMP_SROA_0_0_COPYLOAD]])
; CHECK-NEXT:    ret void
;
entry:
  %arg = alloca %struct.IntInt, align 8
  store i64 %arg.coerce, ptr %arg, align 8
  call void @_Z3usePv(ptr noundef nonnull %arg)
  %agg.tmp.sroa.0.0.copyload = load i64, ptr %arg, align 8
  call void (i64, i32, ...) @_Z5test2I6IntIntEvT_iz(i64 %agg.tmp.sroa.0.0.copyload, i32 noundef 1, i64 %agg.tmp.sroa.0.0.copyload)
  ret void
}

define linkonce_odr dso_local void @_Z4testI10Int64Int64EvT_([2 x i64] %arg.coerce) sanitize_memory {
; CHECK-LABEL: define linkonce_odr dso_local void @_Z4testI10Int64Int64EvT_(
; CHECK-SAME: [2 x i64] [[ARG_COERCE:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load [2 x i64], ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[ARG:%.*]] = alloca [[STRUCT_INT64INT64:%.*]], align 8
; CHECK-NEXT:    [[TMP1:%.*]] = ptrtoint ptr [[ARG]] to i64
; CHECK-NEXT:    [[TMP2:%.*]] = xor i64 [[TMP1]], 193514046488576
; CHECK-NEXT:    [[TMP3:%.*]] = inttoptr i64 [[TMP2]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP3]], i8 -1, i64 16, i1 false)
; CHECK-NEXT:    [[TMP4:%.*]] = extractvalue [2 x i64] [[TMP0]], 0
; CHECK-NEXT:    [[ARG_COERCE_FCA_0_EXTRACT:%.*]] = extractvalue [2 x i64] [[ARG_COERCE]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = ptrtoint ptr [[ARG]] to i64
; CHECK-NEXT:    [[TMP6:%.*]] = xor i64 [[TMP5]], 193514046488576
; CHECK-NEXT:    [[TMP7:%.*]] = inttoptr i64 [[TMP6]] to ptr
; CHECK-NEXT:    store i64 [[TMP4]], ptr [[TMP7]], align 8
; CHECK-NEXT:    store i64 [[ARG_COERCE_FCA_0_EXTRACT]], ptr [[ARG]], align 8
; CHECK-NEXT:    [[TMP8:%.*]] = extractvalue [2 x i64] [[TMP0]], 1
; CHECK-NEXT:    [[ARG_COERCE_FCA_1_EXTRACT:%.*]] = extractvalue [2 x i64] [[ARG_COERCE]], 1
; CHECK-NEXT:    [[ARG_COERCE_FCA_1_GEP:%.*]] = getelementptr inbounds [2 x i64], ptr [[ARG]], i64 0, i64 1
; CHECK-NEXT:    [[TMP9:%.*]] = ptrtoint ptr [[ARG_COERCE_FCA_1_GEP]] to i64
; CHECK-NEXT:    [[TMP10:%.*]] = xor i64 [[TMP9]], 193514046488576
; CHECK-NEXT:    [[TMP11:%.*]] = inttoptr i64 [[TMP10]] to ptr
; CHECK-NEXT:    store i64 [[TMP8]], ptr [[TMP11]], align 8
; CHECK-NEXT:    store i64 [[ARG_COERCE_FCA_1_EXTRACT]], ptr [[ARG_COERCE_FCA_1_GEP]], align 8
; CHECK-NEXT:    store i64 0, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @_Z3usePv(ptr noundef nonnull [[ARG]])
; CHECK-NEXT:    [[AGG_TMP_SROA_0_0_COPYLOAD:%.*]] = load i64, ptr [[ARG]], align 8
; CHECK-NEXT:    [[TMP12:%.*]] = ptrtoint ptr [[ARG]] to i64
; CHECK-NEXT:    [[TMP13:%.*]] = xor i64 [[TMP12]], 193514046488576
; CHECK-NEXT:    [[TMP14:%.*]] = inttoptr i64 [[TMP13]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load i64, ptr [[TMP14]], align 8
; CHECK-NEXT:    [[AGG_TMP_SROA_2_0_COPYLOAD:%.*]] = load i64, ptr [[ARG_COERCE_FCA_1_GEP]], align 8
; CHECK-NEXT:    [[TMP15:%.*]] = ptrtoint ptr [[ARG_COERCE_FCA_1_GEP]] to i64
; CHECK-NEXT:    [[TMP16:%.*]] = xor i64 [[TMP15]], 193514046488576
; CHECK-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[TMP16]] to ptr
; CHECK-NEXT:    [[_MSLD1:%.*]] = load i64, ptr [[TMP17]], align 8
; CHECK-NEXT:    [[TMP18:%.*]] = insertvalue [2 x i64] [i64 -1, i64 -1], i64 [[_MSLD]], 0
; CHECK-NEXT:    [[DOTFCA_0_INSERT2:%.*]] = insertvalue [2 x i64] poison, i64 [[AGG_TMP_SROA_0_0_COPYLOAD]], 0
; CHECK-NEXT:    [[TMP19:%.*]] = insertvalue [2 x i64] [[TMP18]], i64 [[_MSLD1]], 1
; CHECK-NEXT:    [[DOTFCA_1_INSERT3:%.*]] = insertvalue [2 x i64] [[DOTFCA_0_INSERT2]], i64 [[AGG_TMP_SROA_2_0_COPYLOAD]], 1
; CHECK-NEXT:    store [2 x i64] [[TMP19]], ptr @__msan_param_tls, align 8
; CHECK-NEXT:    store i32 0, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    store [2 x i64] [[TMP19]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 24) to ptr), align 8
; CHECK-NEXT:    store [2 x i64] [[TMP19]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_va_arg_tls to i64), i64 24) to ptr), align 8
; CHECK-NEXT:    store i64 0, ptr @__msan_va_arg_overflow_size_tls, align 8
; CHECK-NEXT:    call void ([2 x i64], i32, ...) @_Z5test2I10Int64Int64EvT_iz([2 x i64] [[DOTFCA_1_INSERT3]], i32 noundef 1, [2 x i64] [[DOTFCA_1_INSERT3]])
; CHECK-NEXT:    ret void
;
entry:
  %arg = alloca %struct.Int64Int64, align 8
  %arg.coerce.fca.0.extract = extractvalue [2 x i64] %arg.coerce, 0
  store i64 %arg.coerce.fca.0.extract, ptr %arg, align 8
  %arg.coerce.fca.1.extract = extractvalue [2 x i64] %arg.coerce, 1
  %arg.coerce.fca.1.gep = getelementptr inbounds [2 x i64], ptr %arg, i64 0, i64 1
  store i64 %arg.coerce.fca.1.extract, ptr %arg.coerce.fca.1.gep, align 8
  call void @_Z3usePv(ptr noundef nonnull %arg)
  %agg.tmp.sroa.0.0.copyload = load i64, ptr %arg, align 8
  %agg.tmp.sroa.2.0.copyload = load i64, ptr %arg.coerce.fca.1.gep, align 8
  %.fca.0.insert2 = insertvalue [2 x i64] poison, i64 %agg.tmp.sroa.0.0.copyload, 0
  %.fca.1.insert3 = insertvalue [2 x i64] %.fca.0.insert2, i64 %agg.tmp.sroa.2.0.copyload, 1
  call void ([2 x i64], i32, ...) @_Z5test2I10Int64Int64EvT_iz([2 x i64] %.fca.1.insert3, i32 noundef 1, [2 x i64] %.fca.1.insert3)
  ret void
}

define linkonce_odr dso_local void @_Z4testI12DoubleDoubleEvT_([2 x double] alignstack(8) %arg.coerce) sanitize_memory {
; CHECK-LABEL: define linkonce_odr dso_local void @_Z4testI12DoubleDoubleEvT_(
; CHECK-SAME: [2 x double] alignstack(8) [[ARG_COERCE:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load [2 x i64], ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[ARG:%.*]] = alloca [[STRUCT_DOUBLEDOUBLE:%.*]], align 8
; CHECK-NEXT:    [[TMP1:%.*]] = ptrtoint ptr [[ARG]] to i64
; CHECK-NEXT:    [[TMP2:%.*]] = xor i64 [[TMP1]], 193514046488576
; CHECK-NEXT:    [[TMP3:%.*]] = inttoptr i64 [[TMP2]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP3]], i8 -1, i64 16, i1 false)
; CHECK-NEXT:    [[TMP4:%.*]] = extractvalue [2 x i64] [[TMP0]], 0
; CHECK-NEXT:    [[ARG_COERCE_FCA_0_EXTRACT:%.*]] = extractvalue [2 x double] [[ARG_COERCE]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = ptrtoint ptr [[ARG]] to i64
; CHECK-NEXT:    [[TMP6:%.*]] = xor i64 [[TMP5]], 193514046488576
; CHECK-NEXT:    [[TMP7:%.*]] = inttoptr i64 [[TMP6]] to ptr
; CHECK-NEXT:    store i64 [[TMP4]], ptr [[TMP7]], align 8
; CHECK-NEXT:    store double [[ARG_COERCE_FCA_0_EXTRACT]], ptr [[ARG]], align 8
; CHECK-NEXT:    [[TMP8:%.*]] = extractvalue [2 x i64] [[TMP0]], 1
; CHECK-NEXT:    [[ARG_COERCE_FCA_1_EXTRACT:%.*]] = extractvalue [2 x double] [[ARG_COERCE]], 1
; CHECK-NEXT:    [[ARG_COERCE_FCA_1_GEP:%.*]] = getelementptr inbounds [2 x double], ptr [[ARG]], i64 0, i64 1
; CHECK-NEXT:    [[TMP9:%.*]] = ptrtoint ptr [[ARG_COERCE_FCA_1_GEP]] to i64
; CHECK-NEXT:    [[TMP10:%.*]] = xor i64 [[TMP9]], 193514046488576
; CHECK-NEXT:    [[TMP11:%.*]] = inttoptr i64 [[TMP10]] to ptr
; CHECK-NEXT:    store i64 [[TMP8]], ptr [[TMP11]], align 8
; CHECK-NEXT:    store double [[ARG_COERCE_FCA_1_EXTRACT]], ptr [[ARG_COERCE_FCA_1_GEP]], align 8
; CHECK-NEXT:    store i64 0, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @_Z3usePv(ptr noundef nonnull [[ARG]])
; CHECK-NEXT:    [[AGG_TMP_SROA_0_0_COPYLOAD:%.*]] = load double, ptr [[ARG]], align 8
; CHECK-NEXT:    [[TMP12:%.*]] = ptrtoint ptr [[ARG]] to i64
; CHECK-NEXT:    [[TMP13:%.*]] = xor i64 [[TMP12]], 193514046488576
; CHECK-NEXT:    [[TMP14:%.*]] = inttoptr i64 [[TMP13]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load i64, ptr [[TMP14]], align 8
; CHECK-NEXT:    [[AGG_TMP_SROA_2_0_COPYLOAD:%.*]] = load double, ptr [[ARG_COERCE_FCA_1_GEP]], align 8
; CHECK-NEXT:    [[TMP15:%.*]] = ptrtoint ptr [[ARG_COERCE_FCA_1_GEP]] to i64
; CHECK-NEXT:    [[TMP16:%.*]] = xor i64 [[TMP15]], 193514046488576
; CHECK-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[TMP16]] to ptr
; CHECK-NEXT:    [[_MSLD1:%.*]] = load i64, ptr [[TMP17]], align 8
; CHECK-NEXT:    [[TMP18:%.*]] = insertvalue [2 x i64] [i64 -1, i64 -1], i64 [[_MSLD]], 0
; CHECK-NEXT:    [[DOTFCA_0_INSERT2:%.*]] = insertvalue [2 x double] poison, double [[AGG_TMP_SROA_0_0_COPYLOAD]], 0
; CHECK-NEXT:    [[TMP19:%.*]] = insertvalue [2 x i64] [[TMP18]], i64 [[_MSLD1]], 1
; CHECK-NEXT:    [[DOTFCA_1_INSERT3:%.*]] = insertvalue [2 x double] [[DOTFCA_0_INSERT2]], double [[AGG_TMP_SROA_2_0_COPYLOAD]], 1
; CHECK-NEXT:    store [2 x i64] [[TMP19]], ptr @__msan_param_tls, align 8
; CHECK-NEXT:    store i32 0, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    store [2 x i64] [[TMP19]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 24) to ptr), align 8
; CHECK-NEXT:    store [2 x i64] [[TMP19]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_va_arg_tls to i64), i64 96) to ptr), align 8
; CHECK-NEXT:    store i64 0, ptr @__msan_va_arg_overflow_size_tls, align 8
; CHECK-NEXT:    call void ([2 x double], i32, ...) @_Z5test2I12DoubleDoubleEvT_iz([2 x double] alignstack(8) [[DOTFCA_1_INSERT3]], i32 noundef 1, [2 x double] alignstack(8) [[DOTFCA_1_INSERT3]])
; CHECK-NEXT:    ret void
;
entry:
  %arg = alloca %struct.DoubleDouble, align 8
  %arg.coerce.fca.0.extract = extractvalue [2 x double] %arg.coerce, 0
  store double %arg.coerce.fca.0.extract, ptr %arg, align 8
  %arg.coerce.fca.1.extract = extractvalue [2 x double] %arg.coerce, 1
  %arg.coerce.fca.1.gep = getelementptr inbounds [2 x double], ptr %arg, i64 0, i64 1
  store double %arg.coerce.fca.1.extract, ptr %arg.coerce.fca.1.gep, align 8
  call void @_Z3usePv(ptr noundef nonnull %arg)
  %agg.tmp.sroa.0.0.copyload = load double, ptr %arg, align 8
  %agg.tmp.sroa.2.0.copyload = load double, ptr %arg.coerce.fca.1.gep, align 8
  %.fca.0.insert2 = insertvalue [2 x double] poison, double %agg.tmp.sroa.0.0.copyload, 0
  %.fca.1.insert3 = insertvalue [2 x double] %.fca.0.insert2, double %agg.tmp.sroa.2.0.copyload, 1
  call void ([2 x double], i32, ...) @_Z5test2I12DoubleDoubleEvT_iz([2 x double] alignstack(8) %.fca.1.insert3, i32 noundef 1, [2 x double] alignstack(8) %.fca.1.insert3)
  ret void
}

define linkonce_odr dso_local void @_Z4testI7Double4EvT_([4 x double] alignstack(8) %arg.coerce) sanitize_memory {
; CHECK-LABEL: define linkonce_odr dso_local void @_Z4testI7Double4EvT_(
; CHECK-SAME: [4 x double] alignstack(8) [[ARG_COERCE:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load [4 x i64], ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[ARG:%.*]] = alloca [[STRUCT_DOUBLE4:%.*]], align 8
; CHECK-NEXT:    [[TMP1:%.*]] = ptrtoint ptr [[ARG]] to i64
; CHECK-NEXT:    [[TMP2:%.*]] = xor i64 [[TMP1]], 193514046488576
; CHECK-NEXT:    [[TMP3:%.*]] = inttoptr i64 [[TMP2]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP3]], i8 -1, i64 32, i1 false)
; CHECK-NEXT:    [[TMP4:%.*]] = extractvalue [4 x i64] [[TMP0]], 0
; CHECK-NEXT:    [[ARG_COERCE_FCA_0_EXTRACT:%.*]] = extractvalue [4 x double] [[ARG_COERCE]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = ptrtoint ptr [[ARG]] to i64
; CHECK-NEXT:    [[TMP6:%.*]] = xor i64 [[TMP5]], 193514046488576
; CHECK-NEXT:    [[TMP7:%.*]] = inttoptr i64 [[TMP6]] to ptr
; CHECK-NEXT:    store i64 [[TMP4]], ptr [[TMP7]], align 8
; CHECK-NEXT:    store double [[ARG_COERCE_FCA_0_EXTRACT]], ptr [[ARG]], align 8
; CHECK-NEXT:    [[TMP8:%.*]] = extractvalue [4 x i64] [[TMP0]], 1
; CHECK-NEXT:    [[ARG_COERCE_FCA_1_EXTRACT:%.*]] = extractvalue [4 x double] [[ARG_COERCE]], 1
; CHECK-NEXT:    [[ARG_COERCE_FCA_1_GEP:%.*]] = getelementptr inbounds [4 x double], ptr [[ARG]], i64 0, i64 1
; CHECK-NEXT:    [[TMP9:%.*]] = ptrtoint ptr [[ARG_COERCE_FCA_1_GEP]] to i64
; CHECK-NEXT:    [[TMP10:%.*]] = xor i64 [[TMP9]], 193514046488576
; CHECK-NEXT:    [[TMP11:%.*]] = inttoptr i64 [[TMP10]] to ptr
; CHECK-NEXT:    store i64 [[TMP8]], ptr [[TMP11]], align 8
; CHECK-NEXT:    store double [[ARG_COERCE_FCA_1_EXTRACT]], ptr [[ARG_COERCE_FCA_1_GEP]], align 8
; CHECK-NEXT:    [[TMP12:%.*]] = extractvalue [4 x i64] [[TMP0]], 2
; CHECK-NEXT:    [[ARG_COERCE_FCA_2_EXTRACT:%.*]] = extractvalue [4 x double] [[ARG_COERCE]], 2
; CHECK-NEXT:    [[ARG_COERCE_FCA_2_GEP:%.*]] = getelementptr inbounds [4 x double], ptr [[ARG]], i64 0, i64 2
; CHECK-NEXT:    [[TMP13:%.*]] = ptrtoint ptr [[ARG_COERCE_FCA_2_GEP]] to i64
; CHECK-NEXT:    [[TMP14:%.*]] = xor i64 [[TMP13]], 193514046488576
; CHECK-NEXT:    [[TMP15:%.*]] = inttoptr i64 [[TMP14]] to ptr
; CHECK-NEXT:    store i64 [[TMP12]], ptr [[TMP15]], align 8
; CHECK-NEXT:    store double [[ARG_COERCE_FCA_2_EXTRACT]], ptr [[ARG_COERCE_FCA_2_GEP]], align 8
; CHECK-NEXT:    [[TMP16:%.*]] = extractvalue [4 x i64] [[TMP0]], 3
; CHECK-NEXT:    [[ARG_COERCE_FCA_3_EXTRACT:%.*]] = extractvalue [4 x double] [[ARG_COERCE]], 3
; CHECK-NEXT:    [[ARG_COERCE_FCA_3_GEP:%.*]] = getelementptr inbounds [4 x double], ptr [[ARG]], i64 0, i64 3
; CHECK-NEXT:    [[TMP17:%.*]] = ptrtoint ptr [[ARG_COERCE_FCA_3_GEP]] to i64
; CHECK-NEXT:    [[TMP18:%.*]] = xor i64 [[TMP17]], 193514046488576
; CHECK-NEXT:    [[TMP19:%.*]] = inttoptr i64 [[TMP18]] to ptr
; CHECK-NEXT:    store i64 [[TMP16]], ptr [[TMP19]], align 8
; CHECK-NEXT:    store double [[ARG_COERCE_FCA_3_EXTRACT]], ptr [[ARG_COERCE_FCA_3_GEP]], align 8
; CHECK-NEXT:    store i64 0, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @_Z3usePv(ptr noundef nonnull [[ARG]])
; CHECK-NEXT:    [[AGG_TMP_SROA_0_0_COPYLOAD:%.*]] = load double, ptr [[ARG]], align 8
; CHECK-NEXT:    [[TMP20:%.*]] = ptrtoint ptr [[ARG]] to i64
; CHECK-NEXT:    [[TMP21:%.*]] = xor i64 [[TMP20]], 193514046488576
; CHECK-NEXT:    [[TMP22:%.*]] = inttoptr i64 [[TMP21]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load i64, ptr [[TMP22]], align 8
; CHECK-NEXT:    [[AGG_TMP_SROA_2_0_COPYLOAD:%.*]] = load double, ptr [[ARG_COERCE_FCA_1_GEP]], align 8
; CHECK-NEXT:    [[TMP23:%.*]] = ptrtoint ptr [[ARG_COERCE_FCA_1_GEP]] to i64
; CHECK-NEXT:    [[TMP24:%.*]] = xor i64 [[TMP23]], 193514046488576
; CHECK-NEXT:    [[TMP25:%.*]] = inttoptr i64 [[TMP24]] to ptr
; CHECK-NEXT:    [[_MSLD1:%.*]] = load i64, ptr [[TMP25]], align 8
; CHECK-NEXT:    [[AGG_TMP_SROA_3_0_COPYLOAD:%.*]] = load double, ptr [[ARG_COERCE_FCA_2_GEP]], align 8
; CHECK-NEXT:    [[TMP26:%.*]] = ptrtoint ptr [[ARG_COERCE_FCA_2_GEP]] to i64
; CHECK-NEXT:    [[TMP27:%.*]] = xor i64 [[TMP26]], 193514046488576
; CHECK-NEXT:    [[TMP28:%.*]] = inttoptr i64 [[TMP27]] to ptr
; CHECK-NEXT:    [[_MSLD2:%.*]] = load i64, ptr [[TMP28]], align 8
; CHECK-NEXT:    [[AGG_TMP_SROA_4_0_COPYLOAD:%.*]] = load double, ptr [[ARG_COERCE_FCA_3_GEP]], align 8
; CHECK-NEXT:    [[TMP29:%.*]] = ptrtoint ptr [[ARG_COERCE_FCA_3_GEP]] to i64
; CHECK-NEXT:    [[TMP30:%.*]] = xor i64 [[TMP29]], 193514046488576
; CHECK-NEXT:    [[TMP31:%.*]] = inttoptr i64 [[TMP30]] to ptr
; CHECK-NEXT:    [[_MSLD3:%.*]] = load i64, ptr [[TMP31]], align 8
; CHECK-NEXT:    [[TMP32:%.*]] = insertvalue [4 x i64] [i64 -1, i64 -1, i64 -1, i64 -1], i64 [[_MSLD]], 0
; CHECK-NEXT:    [[DOTFCA_0_INSERT4:%.*]] = insertvalue [4 x double] poison, double [[AGG_TMP_SROA_0_0_COPYLOAD]], 0
; CHECK-NEXT:    [[TMP33:%.*]] = insertvalue [4 x i64] [[TMP32]], i64 [[_MSLD1]], 1
; CHECK-NEXT:    [[DOTFCA_1_INSERT5:%.*]] = insertvalue [4 x double] [[DOTFCA_0_INSERT4]], double [[AGG_TMP_SROA_2_0_COPYLOAD]], 1
; CHECK-NEXT:    [[TMP34:%.*]] = insertvalue [4 x i64] [[TMP33]], i64 [[_MSLD2]], 2
; CHECK-NEXT:    [[DOTFCA_2_INSERT6:%.*]] = insertvalue [4 x double] [[DOTFCA_1_INSERT5]], double [[AGG_TMP_SROA_3_0_COPYLOAD]], 2
; CHECK-NEXT:    [[TMP35:%.*]] = insertvalue [4 x i64] [[TMP34]], i64 [[_MSLD3]], 3
; CHECK-NEXT:    [[DOTFCA_3_INSERT7:%.*]] = insertvalue [4 x double] [[DOTFCA_2_INSERT6]], double [[AGG_TMP_SROA_4_0_COPYLOAD]], 3
; CHECK-NEXT:    store [4 x i64] [[TMP35]], ptr @__msan_param_tls, align 8
; CHECK-NEXT:    store i32 0, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    store [4 x i64] [[TMP35]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 40) to ptr), align 8
; CHECK-NEXT:    store [4 x i64] [[TMP35]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_va_arg_tls to i64), i64 128) to ptr), align 8
; CHECK-NEXT:    store i64 0, ptr @__msan_va_arg_overflow_size_tls, align 8
; CHECK-NEXT:    call void ([4 x double], i32, ...) @_Z5test2I7Double4EvT_iz([4 x double] alignstack(8) [[DOTFCA_3_INSERT7]], i32 noundef 1, [4 x double] alignstack(8) [[DOTFCA_3_INSERT7]])
; CHECK-NEXT:    ret void
;
entry:
  %arg = alloca %struct.Double4, align 8
  %arg.coerce.fca.0.extract = extractvalue [4 x double] %arg.coerce, 0
  store double %arg.coerce.fca.0.extract, ptr %arg, align 8
  %arg.coerce.fca.1.extract = extractvalue [4 x double] %arg.coerce, 1
  %arg.coerce.fca.1.gep = getelementptr inbounds [4 x double], ptr %arg, i64 0, i64 1
  store double %arg.coerce.fca.1.extract, ptr %arg.coerce.fca.1.gep, align 8
  %arg.coerce.fca.2.extract = extractvalue [4 x double] %arg.coerce, 2
  %arg.coerce.fca.2.gep = getelementptr inbounds [4 x double], ptr %arg, i64 0, i64 2
  store double %arg.coerce.fca.2.extract, ptr %arg.coerce.fca.2.gep, align 8
  %arg.coerce.fca.3.extract = extractvalue [4 x double] %arg.coerce, 3
  %arg.coerce.fca.3.gep = getelementptr inbounds [4 x double], ptr %arg, i64 0, i64 3
  store double %arg.coerce.fca.3.extract, ptr %arg.coerce.fca.3.gep, align 8
  call void @_Z3usePv(ptr noundef nonnull %arg)
  %agg.tmp.sroa.0.0.copyload = load double, ptr %arg, align 8
  %agg.tmp.sroa.2.0.copyload = load double, ptr %arg.coerce.fca.1.gep, align 8
  %agg.tmp.sroa.3.0.copyload = load double, ptr %arg.coerce.fca.2.gep, align 8
  %agg.tmp.sroa.4.0.copyload = load double, ptr %arg.coerce.fca.3.gep, align 8
  %.fca.0.insert4 = insertvalue [4 x double] poison, double %agg.tmp.sroa.0.0.copyload, 0
  %.fca.1.insert5 = insertvalue [4 x double] %.fca.0.insert4, double %agg.tmp.sroa.2.0.copyload, 1
  %.fca.2.insert6 = insertvalue [4 x double] %.fca.1.insert5, double %agg.tmp.sroa.3.0.copyload, 2
  %.fca.3.insert7 = insertvalue [4 x double] %.fca.2.insert6, double %agg.tmp.sroa.4.0.copyload, 3
  call void ([4 x double], i32, ...) @_Z5test2I7Double4EvT_iz([4 x double] alignstack(8) %.fca.3.insert7, i32 noundef 1, [4 x double] alignstack(8) %.fca.3.insert7)
  ret void
}

define linkonce_odr dso_local void @_Z4testI11DoubleFloatEvT_([2 x i64] %arg.coerce) sanitize_memory {
; CHECK-LABEL: define linkonce_odr dso_local void @_Z4testI11DoubleFloatEvT_(
; CHECK-SAME: [2 x i64] [[ARG_COERCE:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load [2 x i64], ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[ARG:%.*]] = alloca [[STRUCT_DOUBLEFLOAT:%.*]], align 8
; CHECK-NEXT:    [[TMP1:%.*]] = ptrtoint ptr [[ARG]] to i64
; CHECK-NEXT:    [[TMP2:%.*]] = xor i64 [[TMP1]], 193514046488576
; CHECK-NEXT:    [[TMP3:%.*]] = inttoptr i64 [[TMP2]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP3]], i8 -1, i64 16, i1 false)
; CHECK-NEXT:    [[TMP4:%.*]] = extractvalue [2 x i64] [[TMP0]], 0
; CHECK-NEXT:    [[ARG_COERCE_FCA_0_EXTRACT:%.*]] = extractvalue [2 x i64] [[ARG_COERCE]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = ptrtoint ptr [[ARG]] to i64
; CHECK-NEXT:    [[TMP6:%.*]] = xor i64 [[TMP5]], 193514046488576
; CHECK-NEXT:    [[TMP7:%.*]] = inttoptr i64 [[TMP6]] to ptr
; CHECK-NEXT:    store i64 [[TMP4]], ptr [[TMP7]], align 8
; CHECK-NEXT:    store i64 [[ARG_COERCE_FCA_0_EXTRACT]], ptr [[ARG]], align 8
; CHECK-NEXT:    [[TMP8:%.*]] = extractvalue [2 x i64] [[TMP0]], 1
; CHECK-NEXT:    [[ARG_COERCE_FCA_1_EXTRACT:%.*]] = extractvalue [2 x i64] [[ARG_COERCE]], 1
; CHECK-NEXT:    [[ARG_COERCE_FCA_1_GEP:%.*]] = getelementptr inbounds [2 x i64], ptr [[ARG]], i64 0, i64 1
; CHECK-NEXT:    [[TMP9:%.*]] = ptrtoint ptr [[ARG_COERCE_FCA_1_GEP]] to i64
; CHECK-NEXT:    [[TMP10:%.*]] = xor i64 [[TMP9]], 193514046488576
; CHECK-NEXT:    [[TMP11:%.*]] = inttoptr i64 [[TMP10]] to ptr
; CHECK-NEXT:    store i64 [[TMP8]], ptr [[TMP11]], align 8
; CHECK-NEXT:    store i64 [[ARG_COERCE_FCA_1_EXTRACT]], ptr [[ARG_COERCE_FCA_1_GEP]], align 8
; CHECK-NEXT:    store i64 0, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @_Z3usePv(ptr noundef nonnull [[ARG]])
; CHECK-NEXT:    [[AGG_TMP_SROA_0_0_COPYLOAD:%.*]] = load i64, ptr [[ARG]], align 8
; CHECK-NEXT:    [[TMP12:%.*]] = ptrtoint ptr [[ARG]] to i64
; CHECK-NEXT:    [[TMP13:%.*]] = xor i64 [[TMP12]], 193514046488576
; CHECK-NEXT:    [[TMP14:%.*]] = inttoptr i64 [[TMP13]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load i64, ptr [[TMP14]], align 8
; CHECK-NEXT:    [[AGG_TMP_SROA_2_0_COPYLOAD:%.*]] = load i64, ptr [[ARG_COERCE_FCA_1_GEP]], align 8
; CHECK-NEXT:    [[TMP15:%.*]] = ptrtoint ptr [[ARG_COERCE_FCA_1_GEP]] to i64
; CHECK-NEXT:    [[TMP16:%.*]] = xor i64 [[TMP15]], 193514046488576
; CHECK-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[TMP16]] to ptr
; CHECK-NEXT:    [[_MSLD1:%.*]] = load i64, ptr [[TMP17]], align 8
; CHECK-NEXT:    [[TMP18:%.*]] = insertvalue [2 x i64] [i64 -1, i64 -1], i64 [[_MSLD]], 0
; CHECK-NEXT:    [[DOTFCA_0_INSERT2:%.*]] = insertvalue [2 x i64] poison, i64 [[AGG_TMP_SROA_0_0_COPYLOAD]], 0
; CHECK-NEXT:    [[TMP19:%.*]] = insertvalue [2 x i64] [[TMP18]], i64 [[_MSLD1]], 1
; CHECK-NEXT:    [[DOTFCA_1_INSERT3:%.*]] = insertvalue [2 x i64] [[DOTFCA_0_INSERT2]], i64 [[AGG_TMP_SROA_2_0_COPYLOAD]], 1
; CHECK-NEXT:    store [2 x i64] [[TMP19]], ptr @__msan_param_tls, align 8
; CHECK-NEXT:    store i32 0, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    store [2 x i64] [[TMP19]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 24) to ptr), align 8
; CHECK-NEXT:    store [2 x i64] [[TMP19]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_va_arg_tls to i64), i64 24) to ptr), align 8
; CHECK-NEXT:    store i64 0, ptr @__msan_va_arg_overflow_size_tls, align 8
; CHECK-NEXT:    call void ([2 x i64], i32, ...) @_Z5test2I11DoubleFloatEvT_iz([2 x i64] [[DOTFCA_1_INSERT3]], i32 noundef 1, [2 x i64] [[DOTFCA_1_INSERT3]])
; CHECK-NEXT:    ret void
;
entry:
  %arg = alloca %struct.DoubleFloat, align 8
  %arg.coerce.fca.0.extract = extractvalue [2 x i64] %arg.coerce, 0
  store i64 %arg.coerce.fca.0.extract, ptr %arg, align 8
  %arg.coerce.fca.1.extract = extractvalue [2 x i64] %arg.coerce, 1
  %arg.coerce.fca.1.gep = getelementptr inbounds [2 x i64], ptr %arg, i64 0, i64 1
  store i64 %arg.coerce.fca.1.extract, ptr %arg.coerce.fca.1.gep, align 8
  call void @_Z3usePv(ptr noundef nonnull %arg)
  %agg.tmp.sroa.0.0.copyload = load i64, ptr %arg, align 8
  %agg.tmp.sroa.2.0.copyload = load i64, ptr %arg.coerce.fca.1.gep, align 8
  %.fca.0.insert2 = insertvalue [2 x i64] poison, i64 %agg.tmp.sroa.0.0.copyload, 0
  %.fca.1.insert3 = insertvalue [2 x i64] %.fca.0.insert2, i64 %agg.tmp.sroa.2.0.copyload, 1
  call void ([2 x i64], i32, ...) @_Z5test2I11DoubleFloatEvT_iz([2 x i64] %.fca.1.insert3, i32 noundef 1, [2 x i64] %.fca.1.insert3)
  ret void
}

define linkonce_odr dso_local void @_Z4testI11LongDouble2EvT_([2 x fp128] alignstack(16) %arg.coerce) sanitize_memory {
; CHECK-LABEL: define linkonce_odr dso_local void @_Z4testI11LongDouble2EvT_(
; CHECK-SAME: [2 x fp128] alignstack(16) [[ARG_COERCE:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load [2 x i128], ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[ARG:%.*]] = alloca [[STRUCT_LONGDOUBLE2:%.*]], align 16
; CHECK-NEXT:    [[TMP1:%.*]] = ptrtoint ptr [[ARG]] to i64
; CHECK-NEXT:    [[TMP2:%.*]] = xor i64 [[TMP1]], 193514046488576
; CHECK-NEXT:    [[TMP3:%.*]] = inttoptr i64 [[TMP2]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 16 [[TMP3]], i8 -1, i64 32, i1 false)
; CHECK-NEXT:    [[TMP4:%.*]] = extractvalue [2 x i128] [[TMP0]], 0
; CHECK-NEXT:    [[ARG_COERCE_FCA_0_EXTRACT:%.*]] = extractvalue [2 x fp128] [[ARG_COERCE]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = ptrtoint ptr [[ARG]] to i64
; CHECK-NEXT:    [[TMP6:%.*]] = xor i64 [[TMP5]], 193514046488576
; CHECK-NEXT:    [[TMP7:%.*]] = inttoptr i64 [[TMP6]] to ptr
; CHECK-NEXT:    store i128 [[TMP4]], ptr [[TMP7]], align 16
; CHECK-NEXT:    store fp128 [[ARG_COERCE_FCA_0_EXTRACT]], ptr [[ARG]], align 16
; CHECK-NEXT:    [[TMP8:%.*]] = extractvalue [2 x i128] [[TMP0]], 1
; CHECK-NEXT:    [[ARG_COERCE_FCA_1_EXTRACT:%.*]] = extractvalue [2 x fp128] [[ARG_COERCE]], 1
; CHECK-NEXT:    [[ARG_COERCE_FCA_1_GEP:%.*]] = getelementptr inbounds [2 x fp128], ptr [[ARG]], i64 0, i64 1
; CHECK-NEXT:    [[TMP9:%.*]] = ptrtoint ptr [[ARG_COERCE_FCA_1_GEP]] to i64
; CHECK-NEXT:    [[TMP10:%.*]] = xor i64 [[TMP9]], 193514046488576
; CHECK-NEXT:    [[TMP11:%.*]] = inttoptr i64 [[TMP10]] to ptr
; CHECK-NEXT:    store i128 [[TMP8]], ptr [[TMP11]], align 16
; CHECK-NEXT:    store fp128 [[ARG_COERCE_FCA_1_EXTRACT]], ptr [[ARG_COERCE_FCA_1_GEP]], align 16
; CHECK-NEXT:    store i64 0, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @_Z3usePv(ptr noundef nonnull [[ARG]])
; CHECK-NEXT:    [[AGG_TMP_SROA_0_0_COPYLOAD:%.*]] = load fp128, ptr [[ARG]], align 16
; CHECK-NEXT:    [[TMP12:%.*]] = ptrtoint ptr [[ARG]] to i64
; CHECK-NEXT:    [[TMP13:%.*]] = xor i64 [[TMP12]], 193514046488576
; CHECK-NEXT:    [[TMP14:%.*]] = inttoptr i64 [[TMP13]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load i128, ptr [[TMP14]], align 16
; CHECK-NEXT:    [[AGG_TMP_SROA_2_0_COPYLOAD:%.*]] = load fp128, ptr [[ARG_COERCE_FCA_1_GEP]], align 16
; CHECK-NEXT:    [[TMP15:%.*]] = ptrtoint ptr [[ARG_COERCE_FCA_1_GEP]] to i64
; CHECK-NEXT:    [[TMP16:%.*]] = xor i64 [[TMP15]], 193514046488576
; CHECK-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[TMP16]] to ptr
; CHECK-NEXT:    [[_MSLD1:%.*]] = load i128, ptr [[TMP17]], align 16
; CHECK-NEXT:    [[TMP18:%.*]] = insertvalue [2 x i128] [i128 -1, i128 -1], i128 [[_MSLD]], 0
; CHECK-NEXT:    [[DOTFCA_0_INSERT4:%.*]] = insertvalue [2 x fp128] poison, fp128 [[AGG_TMP_SROA_0_0_COPYLOAD]], 0
; CHECK-NEXT:    [[TMP19:%.*]] = insertvalue [2 x i128] [[TMP18]], i128 [[_MSLD1]], 1
; CHECK-NEXT:    [[DOTFCA_1_INSERT5:%.*]] = insertvalue [2 x fp128] [[DOTFCA_0_INSERT4]], fp128 [[AGG_TMP_SROA_2_0_COPYLOAD]], 1
; CHECK-NEXT:    store [2 x i128] [[TMP19]], ptr @__msan_param_tls, align 8
; CHECK-NEXT:    store i32 0, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    store [2 x i128] [[TMP19]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 40) to ptr), align 8
; CHECK-NEXT:    store [2 x i128] [[TMP19]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_va_arg_tls to i64), i64 96) to ptr), align 8
; CHECK-NEXT:    store i64 0, ptr @__msan_va_arg_overflow_size_tls, align 8
; CHECK-NEXT:    call void ([2 x fp128], i32, ...) @_Z5test2I11LongDouble2EvT_iz([2 x fp128] alignstack(16) [[DOTFCA_1_INSERT5]], i32 noundef 1, [2 x fp128] alignstack(16) [[DOTFCA_1_INSERT5]])
; CHECK-NEXT:    ret void
;
entry:
  %arg = alloca %struct.LongDouble2, align 16
  %arg.coerce.fca.0.extract = extractvalue [2 x fp128] %arg.coerce, 0
  store fp128 %arg.coerce.fca.0.extract, ptr %arg, align 16
  %arg.coerce.fca.1.extract = extractvalue [2 x fp128] %arg.coerce, 1
  %arg.coerce.fca.1.gep = getelementptr inbounds [2 x fp128], ptr %arg, i64 0, i64 1
  store fp128 %arg.coerce.fca.1.extract, ptr %arg.coerce.fca.1.gep, align 16
  call void @_Z3usePv(ptr noundef nonnull %arg)
  %agg.tmp.sroa.0.0.copyload = load fp128, ptr %arg, align 16
  %agg.tmp.sroa.2.0.copyload = load fp128, ptr %arg.coerce.fca.1.gep, align 16
  %.fca.0.insert4 = insertvalue [2 x fp128] poison, fp128 %agg.tmp.sroa.0.0.copyload, 0
  %.fca.1.insert5 = insertvalue [2 x fp128] %.fca.0.insert4, fp128 %agg.tmp.sroa.2.0.copyload, 1
  call void ([2 x fp128], i32, ...) @_Z5test2I11LongDouble2EvT_iz([2 x fp128] alignstack(16) %.fca.1.insert5, i32 noundef 1, [2 x fp128] alignstack(16) %.fca.1.insert5)
  ret void
}

define linkonce_odr dso_local void @_Z4testI11LongDouble4EvT_([4 x fp128] alignstack(16) %arg.coerce) sanitize_memory {
; CHECK-LABEL: define linkonce_odr dso_local void @_Z4testI11LongDouble4EvT_(
; CHECK-SAME: [4 x fp128] alignstack(16) [[ARG_COERCE:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load [4 x i128], ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[ARG:%.*]] = alloca [[STRUCT_LONGDOUBLE4:%.*]], align 16
; CHECK-NEXT:    [[TMP1:%.*]] = ptrtoint ptr [[ARG]] to i64
; CHECK-NEXT:    [[TMP2:%.*]] = xor i64 [[TMP1]], 193514046488576
; CHECK-NEXT:    [[TMP3:%.*]] = inttoptr i64 [[TMP2]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 16 [[TMP3]], i8 -1, i64 64, i1 false)
; CHECK-NEXT:    [[TMP4:%.*]] = extractvalue [4 x i128] [[TMP0]], 0
; CHECK-NEXT:    [[ARG_COERCE_FCA_0_EXTRACT:%.*]] = extractvalue [4 x fp128] [[ARG_COERCE]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = ptrtoint ptr [[ARG]] to i64
; CHECK-NEXT:    [[TMP6:%.*]] = xor i64 [[TMP5]], 193514046488576
; CHECK-NEXT:    [[TMP7:%.*]] = inttoptr i64 [[TMP6]] to ptr
; CHECK-NEXT:    store i128 [[TMP4]], ptr [[TMP7]], align 16
; CHECK-NEXT:    store fp128 [[ARG_COERCE_FCA_0_EXTRACT]], ptr [[ARG]], align 16
; CHECK-NEXT:    [[TMP8:%.*]] = extractvalue [4 x i128] [[TMP0]], 1
; CHECK-NEXT:    [[ARG_COERCE_FCA_1_EXTRACT:%.*]] = extractvalue [4 x fp128] [[ARG_COERCE]], 1
; CHECK-NEXT:    [[ARG_COERCE_FCA_1_GEP:%.*]] = getelementptr inbounds [4 x fp128], ptr [[ARG]], i64 0, i64 1
; CHECK-NEXT:    [[TMP9:%.*]] = ptrtoint ptr [[ARG_COERCE_FCA_1_GEP]] to i64
; CHECK-NEXT:    [[TMP10:%.*]] = xor i64 [[TMP9]], 193514046488576
; CHECK-NEXT:    [[TMP11:%.*]] = inttoptr i64 [[TMP10]] to ptr
; CHECK-NEXT:    store i128 [[TMP8]], ptr [[TMP11]], align 16
; CHECK-NEXT:    store fp128 [[ARG_COERCE_FCA_1_EXTRACT]], ptr [[ARG_COERCE_FCA_1_GEP]], align 16
; CHECK-NEXT:    [[TMP12:%.*]] = extractvalue [4 x i128] [[TMP0]], 2
; CHECK-NEXT:    [[ARG_COERCE_FCA_2_EXTRACT:%.*]] = extractvalue [4 x fp128] [[ARG_COERCE]], 2
; CHECK-NEXT:    [[ARG_COERCE_FCA_2_GEP:%.*]] = getelementptr inbounds [4 x fp128], ptr [[ARG]], i64 0, i64 2
; CHECK-NEXT:    [[TMP13:%.*]] = ptrtoint ptr [[ARG_COERCE_FCA_2_GEP]] to i64
; CHECK-NEXT:    [[TMP14:%.*]] = xor i64 [[TMP13]], 193514046488576
; CHECK-NEXT:    [[TMP15:%.*]] = inttoptr i64 [[TMP14]] to ptr
; CHECK-NEXT:    store i128 [[TMP12]], ptr [[TMP15]], align 16
; CHECK-NEXT:    store fp128 [[ARG_COERCE_FCA_2_EXTRACT]], ptr [[ARG_COERCE_FCA_2_GEP]], align 16
; CHECK-NEXT:    [[TMP16:%.*]] = extractvalue [4 x i128] [[TMP0]], 3
; CHECK-NEXT:    [[ARG_COERCE_FCA_3_EXTRACT:%.*]] = extractvalue [4 x fp128] [[ARG_COERCE]], 3
; CHECK-NEXT:    [[ARG_COERCE_FCA_3_GEP:%.*]] = getelementptr inbounds [4 x fp128], ptr [[ARG]], i64 0, i64 3
; CHECK-NEXT:    [[TMP17:%.*]] = ptrtoint ptr [[ARG_COERCE_FCA_3_GEP]] to i64
; CHECK-NEXT:    [[TMP18:%.*]] = xor i64 [[TMP17]], 193514046488576
; CHECK-NEXT:    [[TMP19:%.*]] = inttoptr i64 [[TMP18]] to ptr
; CHECK-NEXT:    store i128 [[TMP16]], ptr [[TMP19]], align 16
; CHECK-NEXT:    store fp128 [[ARG_COERCE_FCA_3_EXTRACT]], ptr [[ARG_COERCE_FCA_3_GEP]], align 16
; CHECK-NEXT:    store i64 0, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @_Z3usePv(ptr noundef nonnull [[ARG]])
; CHECK-NEXT:    [[AGG_TMP_SROA_0_0_COPYLOAD:%.*]] = load fp128, ptr [[ARG]], align 16
; CHECK-NEXT:    [[TMP20:%.*]] = ptrtoint ptr [[ARG]] to i64
; CHECK-NEXT:    [[TMP21:%.*]] = xor i64 [[TMP20]], 193514046488576
; CHECK-NEXT:    [[TMP22:%.*]] = inttoptr i64 [[TMP21]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load i128, ptr [[TMP22]], align 16
; CHECK-NEXT:    [[AGG_TMP_SROA_2_0_COPYLOAD:%.*]] = load fp128, ptr [[ARG_COERCE_FCA_1_GEP]], align 16
; CHECK-NEXT:    [[TMP23:%.*]] = ptrtoint ptr [[ARG_COERCE_FCA_1_GEP]] to i64
; CHECK-NEXT:    [[TMP24:%.*]] = xor i64 [[TMP23]], 193514046488576
; CHECK-NEXT:    [[TMP25:%.*]] = inttoptr i64 [[TMP24]] to ptr
; CHECK-NEXT:    [[_MSLD1:%.*]] = load i128, ptr [[TMP25]], align 16
; CHECK-NEXT:    [[AGG_TMP_SROA_3_0_COPYLOAD:%.*]] = load fp128, ptr [[ARG_COERCE_FCA_2_GEP]], align 16
; CHECK-NEXT:    [[TMP26:%.*]] = ptrtoint ptr [[ARG_COERCE_FCA_2_GEP]] to i64
; CHECK-NEXT:    [[TMP27:%.*]] = xor i64 [[TMP26]], 193514046488576
; CHECK-NEXT:    [[TMP28:%.*]] = inttoptr i64 [[TMP27]] to ptr
; CHECK-NEXT:    [[_MSLD2:%.*]] = load i128, ptr [[TMP28]], align 16
; CHECK-NEXT:    [[AGG_TMP_SROA_4_0_COPYLOAD:%.*]] = load fp128, ptr [[ARG_COERCE_FCA_3_GEP]], align 16
; CHECK-NEXT:    [[TMP29:%.*]] = ptrtoint ptr [[ARG_COERCE_FCA_3_GEP]] to i64
; CHECK-NEXT:    [[TMP30:%.*]] = xor i64 [[TMP29]], 193514046488576
; CHECK-NEXT:    [[TMP31:%.*]] = inttoptr i64 [[TMP30]] to ptr
; CHECK-NEXT:    [[_MSLD3:%.*]] = load i128, ptr [[TMP31]], align 16
; CHECK-NEXT:    [[TMP32:%.*]] = insertvalue [4 x i128] [i128 -1, i128 -1, i128 -1, i128 -1], i128 [[_MSLD]], 0
; CHECK-NEXT:    [[DOTFCA_0_INSERT4:%.*]] = insertvalue [4 x fp128] poison, fp128 [[AGG_TMP_SROA_0_0_COPYLOAD]], 0
; CHECK-NEXT:    [[TMP33:%.*]] = insertvalue [4 x i128] [[TMP32]], i128 [[_MSLD1]], 1
; CHECK-NEXT:    [[DOTFCA_1_INSERT5:%.*]] = insertvalue [4 x fp128] [[DOTFCA_0_INSERT4]], fp128 [[AGG_TMP_SROA_2_0_COPYLOAD]], 1
; CHECK-NEXT:    [[TMP34:%.*]] = insertvalue [4 x i128] [[TMP33]], i128 [[_MSLD2]], 2
; CHECK-NEXT:    [[DOTFCA_2_INSERT6:%.*]] = insertvalue [4 x fp128] [[DOTFCA_1_INSERT5]], fp128 [[AGG_TMP_SROA_3_0_COPYLOAD]], 2
; CHECK-NEXT:    [[TMP35:%.*]] = insertvalue [4 x i128] [[TMP34]], i128 [[_MSLD3]], 3
; CHECK-NEXT:    [[DOTFCA_3_INSERT7:%.*]] = insertvalue [4 x fp128] [[DOTFCA_2_INSERT6]], fp128 [[AGG_TMP_SROA_4_0_COPYLOAD]], 3
; CHECK-NEXT:    store [4 x i128] [[TMP35]], ptr @__msan_param_tls, align 8
; CHECK-NEXT:    store i32 0, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 64) to ptr), align 8
; CHECK-NEXT:    store [4 x i128] [[TMP35]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 72) to ptr), align 8
; CHECK-NEXT:    store [4 x i128] [[TMP35]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_va_arg_tls to i64), i64 128) to ptr), align 8
; CHECK-NEXT:    store i64 0, ptr @__msan_va_arg_overflow_size_tls, align 8
; CHECK-NEXT:    call void ([4 x fp128], i32, ...) @_Z5test2I11LongDouble4EvT_iz([4 x fp128] alignstack(16) [[DOTFCA_3_INSERT7]], i32 noundef 1, [4 x fp128] alignstack(16) [[DOTFCA_3_INSERT7]])
; CHECK-NEXT:    ret void
;
entry:
  %arg = alloca %struct.LongDouble4, align 16
  %arg.coerce.fca.0.extract = extractvalue [4 x fp128] %arg.coerce, 0
  store fp128 %arg.coerce.fca.0.extract, ptr %arg, align 16
  %arg.coerce.fca.1.extract = extractvalue [4 x fp128] %arg.coerce, 1
  %arg.coerce.fca.1.gep = getelementptr inbounds [4 x fp128], ptr %arg, i64 0, i64 1
  store fp128 %arg.coerce.fca.1.extract, ptr %arg.coerce.fca.1.gep, align 16
  %arg.coerce.fca.2.extract = extractvalue [4 x fp128] %arg.coerce, 2
  %arg.coerce.fca.2.gep = getelementptr inbounds [4 x fp128], ptr %arg, i64 0, i64 2
  store fp128 %arg.coerce.fca.2.extract, ptr %arg.coerce.fca.2.gep, align 16
  %arg.coerce.fca.3.extract = extractvalue [4 x fp128] %arg.coerce, 3
  %arg.coerce.fca.3.gep = getelementptr inbounds [4 x fp128], ptr %arg, i64 0, i64 3
  store fp128 %arg.coerce.fca.3.extract, ptr %arg.coerce.fca.3.gep, align 16
  call void @_Z3usePv(ptr noundef nonnull %arg)
  %agg.tmp.sroa.0.0.copyload = load fp128, ptr %arg, align 16
  %agg.tmp.sroa.2.0.copyload = load fp128, ptr %arg.coerce.fca.1.gep, align 16
  %agg.tmp.sroa.3.0.copyload = load fp128, ptr %arg.coerce.fca.2.gep, align 16
  %agg.tmp.sroa.4.0.copyload = load fp128, ptr %arg.coerce.fca.3.gep, align 16
  %.fca.0.insert4 = insertvalue [4 x fp128] poison, fp128 %agg.tmp.sroa.0.0.copyload, 0
  %.fca.1.insert5 = insertvalue [4 x fp128] %.fca.0.insert4, fp128 %agg.tmp.sroa.2.0.copyload, 1
  %.fca.2.insert6 = insertvalue [4 x fp128] %.fca.1.insert5, fp128 %agg.tmp.sroa.3.0.copyload, 2
  %.fca.3.insert7 = insertvalue [4 x fp128] %.fca.2.insert6, fp128 %agg.tmp.sroa.4.0.copyload, 3
  call void ([4 x fp128], i32, ...) @_Z5test2I11LongDouble4EvT_iz([4 x fp128] alignstack(16) %.fca.3.insert7, i32 noundef 1, [4 x fp128] alignstack(16) %.fca.3.insert7)
  ret void
}

declare void @_Z3usePv(ptr noundef) local_unnamed_addr #2

define linkonce_odr dso_local void @_Z5test2IcEvT_iz(i8 noundef %t, i32 noundef %n, ...) sanitize_memory {
; CHECK-LABEL: define linkonce_odr dso_local void @_Z5test2IcEvT_iz(
; CHECK-SAME: i8 noundef [[T:%.*]], i32 noundef [[N:%.*]], ...) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr @__msan_va_arg_overflow_size_tls, align 8
; CHECK-NEXT:    [[TMP1:%.*]] = add i64 192, [[TMP0]]
; CHECK-NEXT:    [[TMP2:%.*]] = alloca i8, i64 [[TMP1]], align 8
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP2]], i8 0, i64 [[TMP1]], i1 false)
; CHECK-NEXT:    [[TMP3:%.*]] = call i64 @llvm.umin.i64(i64 [[TMP1]], i64 800)
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP2]], ptr align 8 @__msan_va_arg_tls, i64 [[TMP3]], i1 false)
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[ARGS:%.*]] = alloca %"struct.std::__va_list", align 8
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 32, ptr nonnull [[ARGS]])
; CHECK-NEXT:    [[TMP4:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP5:%.*]] = xor i64 [[TMP4]], 193514046488576
; CHECK-NEXT:    [[TMP6:%.*]] = inttoptr i64 [[TMP5]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP6]], i8 -1, i64 32, i1 false)
; CHECK-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP8:%.*]] = xor i64 [[TMP7]], 193514046488576
; CHECK-NEXT:    [[TMP9:%.*]] = inttoptr i64 [[TMP8]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP9]], i8 0, i64 32, i1 false)
; CHECK-NEXT:    call void @llvm.va_start(ptr nonnull [[ARGS]])
; CHECK-NEXT:    [[TMP10:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP11:%.*]] = add i64 [[TMP10]], 0
; CHECK-NEXT:    [[TMP12:%.*]] = inttoptr i64 [[TMP11]] to ptr
; CHECK-NEXT:    [[TMP13:%.*]] = load i64, ptr [[TMP12]], align 8
; CHECK-NEXT:    [[TMP14:%.*]] = inttoptr i64 [[TMP13]] to ptr
; CHECK-NEXT:    [[TMP15:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP16:%.*]] = add i64 [[TMP15]], 8
; CHECK-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[TMP16]] to ptr
; CHECK-NEXT:    [[TMP18:%.*]] = load i64, ptr [[TMP17]], align 8
; CHECK-NEXT:    [[TMP19:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP20:%.*]] = add i64 [[TMP19]], 24
; CHECK-NEXT:    [[TMP21:%.*]] = inttoptr i64 [[TMP20]] to ptr
; CHECK-NEXT:    [[TMP22:%.*]] = load i32, ptr [[TMP21]], align 4
; CHECK-NEXT:    [[TMP23:%.*]] = sext i32 [[TMP22]] to i64
; CHECK-NEXT:    [[TMP24:%.*]] = add i64 [[TMP18]], [[TMP23]]
; CHECK-NEXT:    [[TMP25:%.*]] = inttoptr i64 [[TMP24]] to ptr
; CHECK-NEXT:    [[TMP26:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP27:%.*]] = add i64 [[TMP26]], 16
; CHECK-NEXT:    [[TMP28:%.*]] = inttoptr i64 [[TMP27]] to ptr
; CHECK-NEXT:    [[TMP29:%.*]] = load i64, ptr [[TMP28]], align 8
; CHECK-NEXT:    [[TMP30:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP31:%.*]] = add i64 [[TMP30]], 28
; CHECK-NEXT:    [[TMP32:%.*]] = inttoptr i64 [[TMP31]] to ptr
; CHECK-NEXT:    [[TMP33:%.*]] = load i32, ptr [[TMP32]], align 4
; CHECK-NEXT:    [[TMP34:%.*]] = sext i32 [[TMP33]] to i64
; CHECK-NEXT:    [[TMP35:%.*]] = add i64 [[TMP29]], [[TMP34]]
; CHECK-NEXT:    [[TMP36:%.*]] = inttoptr i64 [[TMP35]] to ptr
; CHECK-NEXT:    [[TMP37:%.*]] = add i64 64, [[TMP23]]
; CHECK-NEXT:    [[TMP38:%.*]] = ptrtoint ptr [[TMP25]] to i64
; CHECK-NEXT:    [[TMP39:%.*]] = xor i64 [[TMP38]], 193514046488576
; CHECK-NEXT:    [[TMP40:%.*]] = inttoptr i64 [[TMP39]] to ptr
; CHECK-NEXT:    [[TMP41:%.*]] = getelementptr inbounds i8, ptr [[TMP2]], i64 [[TMP37]]
; CHECK-NEXT:    [[TMP42:%.*]] = sub i64 64, [[TMP37]]
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP40]], ptr align 8 [[TMP41]], i64 [[TMP42]], i1 false)
; CHECK-NEXT:    [[TMP43:%.*]] = add i64 128, [[TMP34]]
; CHECK-NEXT:    [[TMP44:%.*]] = ptrtoint ptr [[TMP36]] to i64
; CHECK-NEXT:    [[TMP45:%.*]] = xor i64 [[TMP44]], 193514046488576
; CHECK-NEXT:    [[TMP46:%.*]] = inttoptr i64 [[TMP45]] to ptr
; CHECK-NEXT:    [[TMP47:%.*]] = getelementptr inbounds i8, ptr [[TMP2]], i32 64
; CHECK-NEXT:    [[TMP48:%.*]] = getelementptr inbounds i8, ptr [[TMP47]], i64 [[TMP43]]
; CHECK-NEXT:    [[TMP49:%.*]] = sub i64 128, [[TMP43]]
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP46]], ptr align 8 [[TMP48]], i64 [[TMP49]], i1 false)
; CHECK-NEXT:    [[TMP50:%.*]] = ptrtoint ptr [[TMP14]] to i64
; CHECK-NEXT:    [[TMP51:%.*]] = xor i64 [[TMP50]], 193514046488576
; CHECK-NEXT:    [[TMP52:%.*]] = inttoptr i64 [[TMP51]] to ptr
; CHECK-NEXT:    [[TMP53:%.*]] = getelementptr inbounds i8, ptr [[TMP2]], i32 192
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 16 [[TMP52]], ptr align 16 [[TMP53]], i64 [[TMP0]], i1 false)
; CHECK-NEXT:    store i64 0, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @_Z3usePv(ptr noundef nonnull [[ARGS]])
; CHECK-NEXT:    call void @llvm.va_end(ptr nonnull [[ARGS]])
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 32, ptr nonnull [[ARGS]])
; CHECK-NEXT:    ret void
;
entry:
  %args = alloca %"struct.std::__va_list", align 8
  call void @llvm.lifetime.start.p0(i64 32, ptr nonnull %args) #5
  call void @llvm.va_start(ptr nonnull %args)
  call void @_Z3usePv(ptr noundef nonnull %args)
  call void @llvm.va_end(ptr nonnull %args)
  call void @llvm.lifetime.end.p0(i64 32, ptr nonnull %args) #5
  ret void
}

declare void @llvm.lifetime.start.p0(i64 immarg, ptr nocapture) #3

declare void @llvm.va_start(ptr) #4

declare void @llvm.va_end(ptr) #4

declare void @llvm.lifetime.end.p0(i64 immarg, ptr nocapture) #3

define linkonce_odr dso_local void @_Z5test2IiEvT_iz(i32 noundef %t, i32 noundef %n, ...) sanitize_memory {
; CHECK-LABEL: define linkonce_odr dso_local void @_Z5test2IiEvT_iz(
; CHECK-SAME: i32 noundef [[T:%.*]], i32 noundef [[N:%.*]], ...) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr @__msan_va_arg_overflow_size_tls, align 8
; CHECK-NEXT:    [[TMP1:%.*]] = add i64 192, [[TMP0]]
; CHECK-NEXT:    [[TMP2:%.*]] = alloca i8, i64 [[TMP1]], align 8
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP2]], i8 0, i64 [[TMP1]], i1 false)
; CHECK-NEXT:    [[TMP3:%.*]] = call i64 @llvm.umin.i64(i64 [[TMP1]], i64 800)
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP2]], ptr align 8 @__msan_va_arg_tls, i64 [[TMP3]], i1 false)
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[ARGS:%.*]] = alloca %"struct.std::__va_list", align 8
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 32, ptr nonnull [[ARGS]])
; CHECK-NEXT:    [[TMP4:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP5:%.*]] = xor i64 [[TMP4]], 193514046488576
; CHECK-NEXT:    [[TMP6:%.*]] = inttoptr i64 [[TMP5]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP6]], i8 -1, i64 32, i1 false)
; CHECK-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP8:%.*]] = xor i64 [[TMP7]], 193514046488576
; CHECK-NEXT:    [[TMP9:%.*]] = inttoptr i64 [[TMP8]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP9]], i8 0, i64 32, i1 false)
; CHECK-NEXT:    call void @llvm.va_start(ptr nonnull [[ARGS]])
; CHECK-NEXT:    [[TMP10:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP11:%.*]] = add i64 [[TMP10]], 0
; CHECK-NEXT:    [[TMP12:%.*]] = inttoptr i64 [[TMP11]] to ptr
; CHECK-NEXT:    [[TMP13:%.*]] = load i64, ptr [[TMP12]], align 8
; CHECK-NEXT:    [[TMP14:%.*]] = inttoptr i64 [[TMP13]] to ptr
; CHECK-NEXT:    [[TMP15:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP16:%.*]] = add i64 [[TMP15]], 8
; CHECK-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[TMP16]] to ptr
; CHECK-NEXT:    [[TMP18:%.*]] = load i64, ptr [[TMP17]], align 8
; CHECK-NEXT:    [[TMP19:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP20:%.*]] = add i64 [[TMP19]], 24
; CHECK-NEXT:    [[TMP21:%.*]] = inttoptr i64 [[TMP20]] to ptr
; CHECK-NEXT:    [[TMP22:%.*]] = load i32, ptr [[TMP21]], align 4
; CHECK-NEXT:    [[TMP23:%.*]] = sext i32 [[TMP22]] to i64
; CHECK-NEXT:    [[TMP24:%.*]] = add i64 [[TMP18]], [[TMP23]]
; CHECK-NEXT:    [[TMP25:%.*]] = inttoptr i64 [[TMP24]] to ptr
; CHECK-NEXT:    [[TMP26:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP27:%.*]] = add i64 [[TMP26]], 16
; CHECK-NEXT:    [[TMP28:%.*]] = inttoptr i64 [[TMP27]] to ptr
; CHECK-NEXT:    [[TMP29:%.*]] = load i64, ptr [[TMP28]], align 8
; CHECK-NEXT:    [[TMP30:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP31:%.*]] = add i64 [[TMP30]], 28
; CHECK-NEXT:    [[TMP32:%.*]] = inttoptr i64 [[TMP31]] to ptr
; CHECK-NEXT:    [[TMP33:%.*]] = load i32, ptr [[TMP32]], align 4
; CHECK-NEXT:    [[TMP34:%.*]] = sext i32 [[TMP33]] to i64
; CHECK-NEXT:    [[TMP35:%.*]] = add i64 [[TMP29]], [[TMP34]]
; CHECK-NEXT:    [[TMP36:%.*]] = inttoptr i64 [[TMP35]] to ptr
; CHECK-NEXT:    [[TMP37:%.*]] = add i64 64, [[TMP23]]
; CHECK-NEXT:    [[TMP38:%.*]] = ptrtoint ptr [[TMP25]] to i64
; CHECK-NEXT:    [[TMP39:%.*]] = xor i64 [[TMP38]], 193514046488576
; CHECK-NEXT:    [[TMP40:%.*]] = inttoptr i64 [[TMP39]] to ptr
; CHECK-NEXT:    [[TMP41:%.*]] = getelementptr inbounds i8, ptr [[TMP2]], i64 [[TMP37]]
; CHECK-NEXT:    [[TMP42:%.*]] = sub i64 64, [[TMP37]]
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP40]], ptr align 8 [[TMP41]], i64 [[TMP42]], i1 false)
; CHECK-NEXT:    [[TMP43:%.*]] = add i64 128, [[TMP34]]
; CHECK-NEXT:    [[TMP44:%.*]] = ptrtoint ptr [[TMP36]] to i64
; CHECK-NEXT:    [[TMP45:%.*]] = xor i64 [[TMP44]], 193514046488576
; CHECK-NEXT:    [[TMP46:%.*]] = inttoptr i64 [[TMP45]] to ptr
; CHECK-NEXT:    [[TMP47:%.*]] = getelementptr inbounds i8, ptr [[TMP2]], i32 64
; CHECK-NEXT:    [[TMP48:%.*]] = getelementptr inbounds i8, ptr [[TMP47]], i64 [[TMP43]]
; CHECK-NEXT:    [[TMP49:%.*]] = sub i64 128, [[TMP43]]
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP46]], ptr align 8 [[TMP48]], i64 [[TMP49]], i1 false)
; CHECK-NEXT:    [[TMP50:%.*]] = ptrtoint ptr [[TMP14]] to i64
; CHECK-NEXT:    [[TMP51:%.*]] = xor i64 [[TMP50]], 193514046488576
; CHECK-NEXT:    [[TMP52:%.*]] = inttoptr i64 [[TMP51]] to ptr
; CHECK-NEXT:    [[TMP53:%.*]] = getelementptr inbounds i8, ptr [[TMP2]], i32 192
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 16 [[TMP52]], ptr align 16 [[TMP53]], i64 [[TMP0]], i1 false)
; CHECK-NEXT:    store i64 0, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @_Z3usePv(ptr noundef nonnull [[ARGS]])
; CHECK-NEXT:    call void @llvm.va_end(ptr nonnull [[ARGS]])
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 32, ptr nonnull [[ARGS]])
; CHECK-NEXT:    ret void
;
entry:
  %args = alloca %"struct.std::__va_list", align 8
  call void @llvm.lifetime.start.p0(i64 32, ptr nonnull %args) #5
  call void @llvm.va_start(ptr nonnull %args)
  call void @_Z3usePv(ptr noundef nonnull %args)
  call void @llvm.va_end(ptr nonnull %args)
  call void @llvm.lifetime.end.p0(i64 32, ptr nonnull %args) #5
  ret void
}

define linkonce_odr dso_local void @_Z5test2IfEvT_iz(float noundef %t, i32 noundef %n, ...) sanitize_memory {
; CHECK-LABEL: define linkonce_odr dso_local void @_Z5test2IfEvT_iz(
; CHECK-SAME: float noundef [[T:%.*]], i32 noundef [[N:%.*]], ...) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr @__msan_va_arg_overflow_size_tls, align 8
; CHECK-NEXT:    [[TMP1:%.*]] = add i64 192, [[TMP0]]
; CHECK-NEXT:    [[TMP2:%.*]] = alloca i8, i64 [[TMP1]], align 8
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP2]], i8 0, i64 [[TMP1]], i1 false)
; CHECK-NEXT:    [[TMP3:%.*]] = call i64 @llvm.umin.i64(i64 [[TMP1]], i64 800)
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP2]], ptr align 8 @__msan_va_arg_tls, i64 [[TMP3]], i1 false)
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[ARGS:%.*]] = alloca %"struct.std::__va_list", align 8
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 32, ptr nonnull [[ARGS]])
; CHECK-NEXT:    [[TMP4:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP5:%.*]] = xor i64 [[TMP4]], 193514046488576
; CHECK-NEXT:    [[TMP6:%.*]] = inttoptr i64 [[TMP5]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP6]], i8 -1, i64 32, i1 false)
; CHECK-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP8:%.*]] = xor i64 [[TMP7]], 193514046488576
; CHECK-NEXT:    [[TMP9:%.*]] = inttoptr i64 [[TMP8]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP9]], i8 0, i64 32, i1 false)
; CHECK-NEXT:    call void @llvm.va_start(ptr nonnull [[ARGS]])
; CHECK-NEXT:    [[TMP10:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP11:%.*]] = add i64 [[TMP10]], 0
; CHECK-NEXT:    [[TMP12:%.*]] = inttoptr i64 [[TMP11]] to ptr
; CHECK-NEXT:    [[TMP13:%.*]] = load i64, ptr [[TMP12]], align 8
; CHECK-NEXT:    [[TMP14:%.*]] = inttoptr i64 [[TMP13]] to ptr
; CHECK-NEXT:    [[TMP15:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP16:%.*]] = add i64 [[TMP15]], 8
; CHECK-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[TMP16]] to ptr
; CHECK-NEXT:    [[TMP18:%.*]] = load i64, ptr [[TMP17]], align 8
; CHECK-NEXT:    [[TMP19:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP20:%.*]] = add i64 [[TMP19]], 24
; CHECK-NEXT:    [[TMP21:%.*]] = inttoptr i64 [[TMP20]] to ptr
; CHECK-NEXT:    [[TMP22:%.*]] = load i32, ptr [[TMP21]], align 4
; CHECK-NEXT:    [[TMP23:%.*]] = sext i32 [[TMP22]] to i64
; CHECK-NEXT:    [[TMP24:%.*]] = add i64 [[TMP18]], [[TMP23]]
; CHECK-NEXT:    [[TMP25:%.*]] = inttoptr i64 [[TMP24]] to ptr
; CHECK-NEXT:    [[TMP26:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP27:%.*]] = add i64 [[TMP26]], 16
; CHECK-NEXT:    [[TMP28:%.*]] = inttoptr i64 [[TMP27]] to ptr
; CHECK-NEXT:    [[TMP29:%.*]] = load i64, ptr [[TMP28]], align 8
; CHECK-NEXT:    [[TMP30:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP31:%.*]] = add i64 [[TMP30]], 28
; CHECK-NEXT:    [[TMP32:%.*]] = inttoptr i64 [[TMP31]] to ptr
; CHECK-NEXT:    [[TMP33:%.*]] = load i32, ptr [[TMP32]], align 4
; CHECK-NEXT:    [[TMP34:%.*]] = sext i32 [[TMP33]] to i64
; CHECK-NEXT:    [[TMP35:%.*]] = add i64 [[TMP29]], [[TMP34]]
; CHECK-NEXT:    [[TMP36:%.*]] = inttoptr i64 [[TMP35]] to ptr
; CHECK-NEXT:    [[TMP37:%.*]] = add i64 64, [[TMP23]]
; CHECK-NEXT:    [[TMP38:%.*]] = ptrtoint ptr [[TMP25]] to i64
; CHECK-NEXT:    [[TMP39:%.*]] = xor i64 [[TMP38]], 193514046488576
; CHECK-NEXT:    [[TMP40:%.*]] = inttoptr i64 [[TMP39]] to ptr
; CHECK-NEXT:    [[TMP41:%.*]] = getelementptr inbounds i8, ptr [[TMP2]], i64 [[TMP37]]
; CHECK-NEXT:    [[TMP42:%.*]] = sub i64 64, [[TMP37]]
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP40]], ptr align 8 [[TMP41]], i64 [[TMP42]], i1 false)
; CHECK-NEXT:    [[TMP43:%.*]] = add i64 128, [[TMP34]]
; CHECK-NEXT:    [[TMP44:%.*]] = ptrtoint ptr [[TMP36]] to i64
; CHECK-NEXT:    [[TMP45:%.*]] = xor i64 [[TMP44]], 193514046488576
; CHECK-NEXT:    [[TMP46:%.*]] = inttoptr i64 [[TMP45]] to ptr
; CHECK-NEXT:    [[TMP47:%.*]] = getelementptr inbounds i8, ptr [[TMP2]], i32 64
; CHECK-NEXT:    [[TMP48:%.*]] = getelementptr inbounds i8, ptr [[TMP47]], i64 [[TMP43]]
; CHECK-NEXT:    [[TMP49:%.*]] = sub i64 128, [[TMP43]]
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP46]], ptr align 8 [[TMP48]], i64 [[TMP49]], i1 false)
; CHECK-NEXT:    [[TMP50:%.*]] = ptrtoint ptr [[TMP14]] to i64
; CHECK-NEXT:    [[TMP51:%.*]] = xor i64 [[TMP50]], 193514046488576
; CHECK-NEXT:    [[TMP52:%.*]] = inttoptr i64 [[TMP51]] to ptr
; CHECK-NEXT:    [[TMP53:%.*]] = getelementptr inbounds i8, ptr [[TMP2]], i32 192
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 16 [[TMP52]], ptr align 16 [[TMP53]], i64 [[TMP0]], i1 false)
; CHECK-NEXT:    store i64 0, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @_Z3usePv(ptr noundef nonnull [[ARGS]])
; CHECK-NEXT:    call void @llvm.va_end(ptr nonnull [[ARGS]])
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 32, ptr nonnull [[ARGS]])
; CHECK-NEXT:    ret void
;
entry:
  %args = alloca %"struct.std::__va_list", align 8
  call void @llvm.lifetime.start.p0(i64 32, ptr nonnull %args) #5
  call void @llvm.va_start(ptr nonnull %args)
  call void @_Z3usePv(ptr noundef nonnull %args)
  call void @llvm.va_end(ptr nonnull %args)
  call void @llvm.lifetime.end.p0(i64 32, ptr nonnull %args) #5
  ret void
}

define linkonce_odr dso_local void @_Z5test2IdEvT_iz(double noundef %t, i32 noundef %n, ...) sanitize_memory {
; CHECK-LABEL: define linkonce_odr dso_local void @_Z5test2IdEvT_iz(
; CHECK-SAME: double noundef [[T:%.*]], i32 noundef [[N:%.*]], ...) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr @__msan_va_arg_overflow_size_tls, align 8
; CHECK-NEXT:    [[TMP1:%.*]] = add i64 192, [[TMP0]]
; CHECK-NEXT:    [[TMP2:%.*]] = alloca i8, i64 [[TMP1]], align 8
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP2]], i8 0, i64 [[TMP1]], i1 false)
; CHECK-NEXT:    [[TMP3:%.*]] = call i64 @llvm.umin.i64(i64 [[TMP1]], i64 800)
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP2]], ptr align 8 @__msan_va_arg_tls, i64 [[TMP3]], i1 false)
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[ARGS:%.*]] = alloca %"struct.std::__va_list", align 8
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 32, ptr nonnull [[ARGS]])
; CHECK-NEXT:    [[TMP4:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP5:%.*]] = xor i64 [[TMP4]], 193514046488576
; CHECK-NEXT:    [[TMP6:%.*]] = inttoptr i64 [[TMP5]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP6]], i8 -1, i64 32, i1 false)
; CHECK-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP8:%.*]] = xor i64 [[TMP7]], 193514046488576
; CHECK-NEXT:    [[TMP9:%.*]] = inttoptr i64 [[TMP8]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP9]], i8 0, i64 32, i1 false)
; CHECK-NEXT:    call void @llvm.va_start(ptr nonnull [[ARGS]])
; CHECK-NEXT:    [[TMP10:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP11:%.*]] = add i64 [[TMP10]], 0
; CHECK-NEXT:    [[TMP12:%.*]] = inttoptr i64 [[TMP11]] to ptr
; CHECK-NEXT:    [[TMP13:%.*]] = load i64, ptr [[TMP12]], align 8
; CHECK-NEXT:    [[TMP14:%.*]] = inttoptr i64 [[TMP13]] to ptr
; CHECK-NEXT:    [[TMP15:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP16:%.*]] = add i64 [[TMP15]], 8
; CHECK-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[TMP16]] to ptr
; CHECK-NEXT:    [[TMP18:%.*]] = load i64, ptr [[TMP17]], align 8
; CHECK-NEXT:    [[TMP19:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP20:%.*]] = add i64 [[TMP19]], 24
; CHECK-NEXT:    [[TMP21:%.*]] = inttoptr i64 [[TMP20]] to ptr
; CHECK-NEXT:    [[TMP22:%.*]] = load i32, ptr [[TMP21]], align 4
; CHECK-NEXT:    [[TMP23:%.*]] = sext i32 [[TMP22]] to i64
; CHECK-NEXT:    [[TMP24:%.*]] = add i64 [[TMP18]], [[TMP23]]
; CHECK-NEXT:    [[TMP25:%.*]] = inttoptr i64 [[TMP24]] to ptr
; CHECK-NEXT:    [[TMP26:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP27:%.*]] = add i64 [[TMP26]], 16
; CHECK-NEXT:    [[TMP28:%.*]] = inttoptr i64 [[TMP27]] to ptr
; CHECK-NEXT:    [[TMP29:%.*]] = load i64, ptr [[TMP28]], align 8
; CHECK-NEXT:    [[TMP30:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP31:%.*]] = add i64 [[TMP30]], 28
; CHECK-NEXT:    [[TMP32:%.*]] = inttoptr i64 [[TMP31]] to ptr
; CHECK-NEXT:    [[TMP33:%.*]] = load i32, ptr [[TMP32]], align 4
; CHECK-NEXT:    [[TMP34:%.*]] = sext i32 [[TMP33]] to i64
; CHECK-NEXT:    [[TMP35:%.*]] = add i64 [[TMP29]], [[TMP34]]
; CHECK-NEXT:    [[TMP36:%.*]] = inttoptr i64 [[TMP35]] to ptr
; CHECK-NEXT:    [[TMP37:%.*]] = add i64 64, [[TMP23]]
; CHECK-NEXT:    [[TMP38:%.*]] = ptrtoint ptr [[TMP25]] to i64
; CHECK-NEXT:    [[TMP39:%.*]] = xor i64 [[TMP38]], 193514046488576
; CHECK-NEXT:    [[TMP40:%.*]] = inttoptr i64 [[TMP39]] to ptr
; CHECK-NEXT:    [[TMP41:%.*]] = getelementptr inbounds i8, ptr [[TMP2]], i64 [[TMP37]]
; CHECK-NEXT:    [[TMP42:%.*]] = sub i64 64, [[TMP37]]
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP40]], ptr align 8 [[TMP41]], i64 [[TMP42]], i1 false)
; CHECK-NEXT:    [[TMP43:%.*]] = add i64 128, [[TMP34]]
; CHECK-NEXT:    [[TMP44:%.*]] = ptrtoint ptr [[TMP36]] to i64
; CHECK-NEXT:    [[TMP45:%.*]] = xor i64 [[TMP44]], 193514046488576
; CHECK-NEXT:    [[TMP46:%.*]] = inttoptr i64 [[TMP45]] to ptr
; CHECK-NEXT:    [[TMP47:%.*]] = getelementptr inbounds i8, ptr [[TMP2]], i32 64
; CHECK-NEXT:    [[TMP48:%.*]] = getelementptr inbounds i8, ptr [[TMP47]], i64 [[TMP43]]
; CHECK-NEXT:    [[TMP49:%.*]] = sub i64 128, [[TMP43]]
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP46]], ptr align 8 [[TMP48]], i64 [[TMP49]], i1 false)
; CHECK-NEXT:    [[TMP50:%.*]] = ptrtoint ptr [[TMP14]] to i64
; CHECK-NEXT:    [[TMP51:%.*]] = xor i64 [[TMP50]], 193514046488576
; CHECK-NEXT:    [[TMP52:%.*]] = inttoptr i64 [[TMP51]] to ptr
; CHECK-NEXT:    [[TMP53:%.*]] = getelementptr inbounds i8, ptr [[TMP2]], i32 192
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 16 [[TMP52]], ptr align 16 [[TMP53]], i64 [[TMP0]], i1 false)
; CHECK-NEXT:    store i64 0, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @_Z3usePv(ptr noundef nonnull [[ARGS]])
; CHECK-NEXT:    call void @llvm.va_end(ptr nonnull [[ARGS]])
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 32, ptr nonnull [[ARGS]])
; CHECK-NEXT:    ret void
;
entry:
  %args = alloca %"struct.std::__va_list", align 8
  call void @llvm.lifetime.start.p0(i64 32, ptr nonnull %args) #5
  call void @llvm.va_start(ptr nonnull %args)
  call void @_Z3usePv(ptr noundef nonnull %args)
  call void @llvm.va_end(ptr nonnull %args)
  call void @llvm.lifetime.end.p0(i64 32, ptr nonnull %args) #5
  ret void
}

define linkonce_odr dso_local void @_Z5test2IeEvT_iz(fp128 noundef %t, i32 noundef %n, ...) sanitize_memory {
; CHECK-LABEL: define linkonce_odr dso_local void @_Z5test2IeEvT_iz(
; CHECK-SAME: fp128 noundef [[T:%.*]], i32 noundef [[N:%.*]], ...) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr @__msan_va_arg_overflow_size_tls, align 8
; CHECK-NEXT:    [[TMP1:%.*]] = add i64 192, [[TMP0]]
; CHECK-NEXT:    [[TMP2:%.*]] = alloca i8, i64 [[TMP1]], align 8
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP2]], i8 0, i64 [[TMP1]], i1 false)
; CHECK-NEXT:    [[TMP3:%.*]] = call i64 @llvm.umin.i64(i64 [[TMP1]], i64 800)
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP2]], ptr align 8 @__msan_va_arg_tls, i64 [[TMP3]], i1 false)
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[ARGS:%.*]] = alloca %"struct.std::__va_list", align 8
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 32, ptr nonnull [[ARGS]])
; CHECK-NEXT:    [[TMP4:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP5:%.*]] = xor i64 [[TMP4]], 193514046488576
; CHECK-NEXT:    [[TMP6:%.*]] = inttoptr i64 [[TMP5]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP6]], i8 -1, i64 32, i1 false)
; CHECK-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP8:%.*]] = xor i64 [[TMP7]], 193514046488576
; CHECK-NEXT:    [[TMP9:%.*]] = inttoptr i64 [[TMP8]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP9]], i8 0, i64 32, i1 false)
; CHECK-NEXT:    call void @llvm.va_start(ptr nonnull [[ARGS]])
; CHECK-NEXT:    [[TMP10:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP11:%.*]] = add i64 [[TMP10]], 0
; CHECK-NEXT:    [[TMP12:%.*]] = inttoptr i64 [[TMP11]] to ptr
; CHECK-NEXT:    [[TMP13:%.*]] = load i64, ptr [[TMP12]], align 8
; CHECK-NEXT:    [[TMP14:%.*]] = inttoptr i64 [[TMP13]] to ptr
; CHECK-NEXT:    [[TMP15:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP16:%.*]] = add i64 [[TMP15]], 8
; CHECK-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[TMP16]] to ptr
; CHECK-NEXT:    [[TMP18:%.*]] = load i64, ptr [[TMP17]], align 8
; CHECK-NEXT:    [[TMP19:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP20:%.*]] = add i64 [[TMP19]], 24
; CHECK-NEXT:    [[TMP21:%.*]] = inttoptr i64 [[TMP20]] to ptr
; CHECK-NEXT:    [[TMP22:%.*]] = load i32, ptr [[TMP21]], align 4
; CHECK-NEXT:    [[TMP23:%.*]] = sext i32 [[TMP22]] to i64
; CHECK-NEXT:    [[TMP24:%.*]] = add i64 [[TMP18]], [[TMP23]]
; CHECK-NEXT:    [[TMP25:%.*]] = inttoptr i64 [[TMP24]] to ptr
; CHECK-NEXT:    [[TMP26:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP27:%.*]] = add i64 [[TMP26]], 16
; CHECK-NEXT:    [[TMP28:%.*]] = inttoptr i64 [[TMP27]] to ptr
; CHECK-NEXT:    [[TMP29:%.*]] = load i64, ptr [[TMP28]], align 8
; CHECK-NEXT:    [[TMP30:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP31:%.*]] = add i64 [[TMP30]], 28
; CHECK-NEXT:    [[TMP32:%.*]] = inttoptr i64 [[TMP31]] to ptr
; CHECK-NEXT:    [[TMP33:%.*]] = load i32, ptr [[TMP32]], align 4
; CHECK-NEXT:    [[TMP34:%.*]] = sext i32 [[TMP33]] to i64
; CHECK-NEXT:    [[TMP35:%.*]] = add i64 [[TMP29]], [[TMP34]]
; CHECK-NEXT:    [[TMP36:%.*]] = inttoptr i64 [[TMP35]] to ptr
; CHECK-NEXT:    [[TMP37:%.*]] = add i64 64, [[TMP23]]
; CHECK-NEXT:    [[TMP38:%.*]] = ptrtoint ptr [[TMP25]] to i64
; CHECK-NEXT:    [[TMP39:%.*]] = xor i64 [[TMP38]], 193514046488576
; CHECK-NEXT:    [[TMP40:%.*]] = inttoptr i64 [[TMP39]] to ptr
; CHECK-NEXT:    [[TMP41:%.*]] = getelementptr inbounds i8, ptr [[TMP2]], i64 [[TMP37]]
; CHECK-NEXT:    [[TMP42:%.*]] = sub i64 64, [[TMP37]]
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP40]], ptr align 8 [[TMP41]], i64 [[TMP42]], i1 false)
; CHECK-NEXT:    [[TMP43:%.*]] = add i64 128, [[TMP34]]
; CHECK-NEXT:    [[TMP44:%.*]] = ptrtoint ptr [[TMP36]] to i64
; CHECK-NEXT:    [[TMP45:%.*]] = xor i64 [[TMP44]], 193514046488576
; CHECK-NEXT:    [[TMP46:%.*]] = inttoptr i64 [[TMP45]] to ptr
; CHECK-NEXT:    [[TMP47:%.*]] = getelementptr inbounds i8, ptr [[TMP2]], i32 64
; CHECK-NEXT:    [[TMP48:%.*]] = getelementptr inbounds i8, ptr [[TMP47]], i64 [[TMP43]]
; CHECK-NEXT:    [[TMP49:%.*]] = sub i64 128, [[TMP43]]
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP46]], ptr align 8 [[TMP48]], i64 [[TMP49]], i1 false)
; CHECK-NEXT:    [[TMP50:%.*]] = ptrtoint ptr [[TMP14]] to i64
; CHECK-NEXT:    [[TMP51:%.*]] = xor i64 [[TMP50]], 193514046488576
; CHECK-NEXT:    [[TMP52:%.*]] = inttoptr i64 [[TMP51]] to ptr
; CHECK-NEXT:    [[TMP53:%.*]] = getelementptr inbounds i8, ptr [[TMP2]], i32 192
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 16 [[TMP52]], ptr align 16 [[TMP53]], i64 [[TMP0]], i1 false)
; CHECK-NEXT:    store i64 0, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @_Z3usePv(ptr noundef nonnull [[ARGS]])
; CHECK-NEXT:    call void @llvm.va_end(ptr nonnull [[ARGS]])
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 32, ptr nonnull [[ARGS]])
; CHECK-NEXT:    ret void
;
entry:
  %args = alloca %"struct.std::__va_list", align 8
  call void @llvm.lifetime.start.p0(i64 32, ptr nonnull %args) #5
  call void @llvm.va_start(ptr nonnull %args)
  call void @_Z3usePv(ptr noundef nonnull %args)
  call void @llvm.va_end(ptr nonnull %args)
  call void @llvm.lifetime.end.p0(i64 32, ptr nonnull %args) #5
  ret void
}

define linkonce_odr dso_local void @_Z5test2I6IntIntEvT_iz(i64 %t.coerce, i32 noundef %n, ...) sanitize_memory {
; CHECK-LABEL: define linkonce_odr dso_local void @_Z5test2I6IntIntEvT_iz(
; CHECK-SAME: i64 [[T_COERCE:%.*]], i32 noundef [[N:%.*]], ...) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr @__msan_va_arg_overflow_size_tls, align 8
; CHECK-NEXT:    [[TMP1:%.*]] = add i64 192, [[TMP0]]
; CHECK-NEXT:    [[TMP2:%.*]] = alloca i8, i64 [[TMP1]], align 8
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP2]], i8 0, i64 [[TMP1]], i1 false)
; CHECK-NEXT:    [[TMP3:%.*]] = call i64 @llvm.umin.i64(i64 [[TMP1]], i64 800)
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP2]], ptr align 8 @__msan_va_arg_tls, i64 [[TMP3]], i1 false)
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[ARGS:%.*]] = alloca %"struct.std::__va_list", align 8
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 32, ptr nonnull [[ARGS]])
; CHECK-NEXT:    [[TMP4:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP5:%.*]] = xor i64 [[TMP4]], 193514046488576
; CHECK-NEXT:    [[TMP6:%.*]] = inttoptr i64 [[TMP5]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP6]], i8 -1, i64 32, i1 false)
; CHECK-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP8:%.*]] = xor i64 [[TMP7]], 193514046488576
; CHECK-NEXT:    [[TMP9:%.*]] = inttoptr i64 [[TMP8]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP9]], i8 0, i64 32, i1 false)
; CHECK-NEXT:    call void @llvm.va_start(ptr nonnull [[ARGS]])
; CHECK-NEXT:    [[TMP10:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP11:%.*]] = add i64 [[TMP10]], 0
; CHECK-NEXT:    [[TMP12:%.*]] = inttoptr i64 [[TMP11]] to ptr
; CHECK-NEXT:    [[TMP13:%.*]] = load i64, ptr [[TMP12]], align 8
; CHECK-NEXT:    [[TMP14:%.*]] = inttoptr i64 [[TMP13]] to ptr
; CHECK-NEXT:    [[TMP15:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP16:%.*]] = add i64 [[TMP15]], 8
; CHECK-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[TMP16]] to ptr
; CHECK-NEXT:    [[TMP18:%.*]] = load i64, ptr [[TMP17]], align 8
; CHECK-NEXT:    [[TMP19:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP20:%.*]] = add i64 [[TMP19]], 24
; CHECK-NEXT:    [[TMP21:%.*]] = inttoptr i64 [[TMP20]] to ptr
; CHECK-NEXT:    [[TMP22:%.*]] = load i32, ptr [[TMP21]], align 4
; CHECK-NEXT:    [[TMP23:%.*]] = sext i32 [[TMP22]] to i64
; CHECK-NEXT:    [[TMP24:%.*]] = add i64 [[TMP18]], [[TMP23]]
; CHECK-NEXT:    [[TMP25:%.*]] = inttoptr i64 [[TMP24]] to ptr
; CHECK-NEXT:    [[TMP26:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP27:%.*]] = add i64 [[TMP26]], 16
; CHECK-NEXT:    [[TMP28:%.*]] = inttoptr i64 [[TMP27]] to ptr
; CHECK-NEXT:    [[TMP29:%.*]] = load i64, ptr [[TMP28]], align 8
; CHECK-NEXT:    [[TMP30:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP31:%.*]] = add i64 [[TMP30]], 28
; CHECK-NEXT:    [[TMP32:%.*]] = inttoptr i64 [[TMP31]] to ptr
; CHECK-NEXT:    [[TMP33:%.*]] = load i32, ptr [[TMP32]], align 4
; CHECK-NEXT:    [[TMP34:%.*]] = sext i32 [[TMP33]] to i64
; CHECK-NEXT:    [[TMP35:%.*]] = add i64 [[TMP29]], [[TMP34]]
; CHECK-NEXT:    [[TMP36:%.*]] = inttoptr i64 [[TMP35]] to ptr
; CHECK-NEXT:    [[TMP37:%.*]] = add i64 64, [[TMP23]]
; CHECK-NEXT:    [[TMP38:%.*]] = ptrtoint ptr [[TMP25]] to i64
; CHECK-NEXT:    [[TMP39:%.*]] = xor i64 [[TMP38]], 193514046488576
; CHECK-NEXT:    [[TMP40:%.*]] = inttoptr i64 [[TMP39]] to ptr
; CHECK-NEXT:    [[TMP41:%.*]] = getelementptr inbounds i8, ptr [[TMP2]], i64 [[TMP37]]
; CHECK-NEXT:    [[TMP42:%.*]] = sub i64 64, [[TMP37]]
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP40]], ptr align 8 [[TMP41]], i64 [[TMP42]], i1 false)
; CHECK-NEXT:    [[TMP43:%.*]] = add i64 128, [[TMP34]]
; CHECK-NEXT:    [[TMP44:%.*]] = ptrtoint ptr [[TMP36]] to i64
; CHECK-NEXT:    [[TMP45:%.*]] = xor i64 [[TMP44]], 193514046488576
; CHECK-NEXT:    [[TMP46:%.*]] = inttoptr i64 [[TMP45]] to ptr
; CHECK-NEXT:    [[TMP47:%.*]] = getelementptr inbounds i8, ptr [[TMP2]], i32 64
; CHECK-NEXT:    [[TMP48:%.*]] = getelementptr inbounds i8, ptr [[TMP47]], i64 [[TMP43]]
; CHECK-NEXT:    [[TMP49:%.*]] = sub i64 128, [[TMP43]]
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP46]], ptr align 8 [[TMP48]], i64 [[TMP49]], i1 false)
; CHECK-NEXT:    [[TMP50:%.*]] = ptrtoint ptr [[TMP14]] to i64
; CHECK-NEXT:    [[TMP51:%.*]] = xor i64 [[TMP50]], 193514046488576
; CHECK-NEXT:    [[TMP52:%.*]] = inttoptr i64 [[TMP51]] to ptr
; CHECK-NEXT:    [[TMP53:%.*]] = getelementptr inbounds i8, ptr [[TMP2]], i32 192
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 16 [[TMP52]], ptr align 16 [[TMP53]], i64 [[TMP0]], i1 false)
; CHECK-NEXT:    store i64 0, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @_Z3usePv(ptr noundef nonnull [[ARGS]])
; CHECK-NEXT:    call void @llvm.va_end(ptr nonnull [[ARGS]])
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 32, ptr nonnull [[ARGS]])
; CHECK-NEXT:    ret void
;
entry:
  %args = alloca %"struct.std::__va_list", align 8
  call void @llvm.lifetime.start.p0(i64 32, ptr nonnull %args) #5
  call void @llvm.va_start(ptr nonnull %args)
  call void @_Z3usePv(ptr noundef nonnull %args)
  call void @llvm.va_end(ptr nonnull %args)
  call void @llvm.lifetime.end.p0(i64 32, ptr nonnull %args) #5
  ret void
}

define linkonce_odr dso_local void @_Z5test2I10Int64Int64EvT_iz([2 x i64] %t.coerce, i32 noundef %n, ...) sanitize_memory {
; CHECK-LABEL: define linkonce_odr dso_local void @_Z5test2I10Int64Int64EvT_iz(
; CHECK-SAME: [2 x i64] [[T_COERCE:%.*]], i32 noundef [[N:%.*]], ...) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr @__msan_va_arg_overflow_size_tls, align 8
; CHECK-NEXT:    [[TMP1:%.*]] = add i64 192, [[TMP0]]
; CHECK-NEXT:    [[TMP2:%.*]] = alloca i8, i64 [[TMP1]], align 8
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP2]], i8 0, i64 [[TMP1]], i1 false)
; CHECK-NEXT:    [[TMP3:%.*]] = call i64 @llvm.umin.i64(i64 [[TMP1]], i64 800)
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP2]], ptr align 8 @__msan_va_arg_tls, i64 [[TMP3]], i1 false)
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[ARGS:%.*]] = alloca %"struct.std::__va_list", align 8
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 32, ptr nonnull [[ARGS]])
; CHECK-NEXT:    [[TMP4:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP5:%.*]] = xor i64 [[TMP4]], 193514046488576
; CHECK-NEXT:    [[TMP6:%.*]] = inttoptr i64 [[TMP5]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP6]], i8 -1, i64 32, i1 false)
; CHECK-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP8:%.*]] = xor i64 [[TMP7]], 193514046488576
; CHECK-NEXT:    [[TMP9:%.*]] = inttoptr i64 [[TMP8]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP9]], i8 0, i64 32, i1 false)
; CHECK-NEXT:    call void @llvm.va_start(ptr nonnull [[ARGS]])
; CHECK-NEXT:    [[TMP10:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP11:%.*]] = add i64 [[TMP10]], 0
; CHECK-NEXT:    [[TMP12:%.*]] = inttoptr i64 [[TMP11]] to ptr
; CHECK-NEXT:    [[TMP13:%.*]] = load i64, ptr [[TMP12]], align 8
; CHECK-NEXT:    [[TMP14:%.*]] = inttoptr i64 [[TMP13]] to ptr
; CHECK-NEXT:    [[TMP15:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP16:%.*]] = add i64 [[TMP15]], 8
; CHECK-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[TMP16]] to ptr
; CHECK-NEXT:    [[TMP18:%.*]] = load i64, ptr [[TMP17]], align 8
; CHECK-NEXT:    [[TMP19:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP20:%.*]] = add i64 [[TMP19]], 24
; CHECK-NEXT:    [[TMP21:%.*]] = inttoptr i64 [[TMP20]] to ptr
; CHECK-NEXT:    [[TMP22:%.*]] = load i32, ptr [[TMP21]], align 4
; CHECK-NEXT:    [[TMP23:%.*]] = sext i32 [[TMP22]] to i64
; CHECK-NEXT:    [[TMP24:%.*]] = add i64 [[TMP18]], [[TMP23]]
; CHECK-NEXT:    [[TMP25:%.*]] = inttoptr i64 [[TMP24]] to ptr
; CHECK-NEXT:    [[TMP26:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP27:%.*]] = add i64 [[TMP26]], 16
; CHECK-NEXT:    [[TMP28:%.*]] = inttoptr i64 [[TMP27]] to ptr
; CHECK-NEXT:    [[TMP29:%.*]] = load i64, ptr [[TMP28]], align 8
; CHECK-NEXT:    [[TMP30:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP31:%.*]] = add i64 [[TMP30]], 28
; CHECK-NEXT:    [[TMP32:%.*]] = inttoptr i64 [[TMP31]] to ptr
; CHECK-NEXT:    [[TMP33:%.*]] = load i32, ptr [[TMP32]], align 4
; CHECK-NEXT:    [[TMP34:%.*]] = sext i32 [[TMP33]] to i64
; CHECK-NEXT:    [[TMP35:%.*]] = add i64 [[TMP29]], [[TMP34]]
; CHECK-NEXT:    [[TMP36:%.*]] = inttoptr i64 [[TMP35]] to ptr
; CHECK-NEXT:    [[TMP37:%.*]] = add i64 64, [[TMP23]]
; CHECK-NEXT:    [[TMP38:%.*]] = ptrtoint ptr [[TMP25]] to i64
; CHECK-NEXT:    [[TMP39:%.*]] = xor i64 [[TMP38]], 193514046488576
; CHECK-NEXT:    [[TMP40:%.*]] = inttoptr i64 [[TMP39]] to ptr
; CHECK-NEXT:    [[TMP41:%.*]] = getelementptr inbounds i8, ptr [[TMP2]], i64 [[TMP37]]
; CHECK-NEXT:    [[TMP42:%.*]] = sub i64 64, [[TMP37]]
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP40]], ptr align 8 [[TMP41]], i64 [[TMP42]], i1 false)
; CHECK-NEXT:    [[TMP43:%.*]] = add i64 128, [[TMP34]]
; CHECK-NEXT:    [[TMP44:%.*]] = ptrtoint ptr [[TMP36]] to i64
; CHECK-NEXT:    [[TMP45:%.*]] = xor i64 [[TMP44]], 193514046488576
; CHECK-NEXT:    [[TMP46:%.*]] = inttoptr i64 [[TMP45]] to ptr
; CHECK-NEXT:    [[TMP47:%.*]] = getelementptr inbounds i8, ptr [[TMP2]], i32 64
; CHECK-NEXT:    [[TMP48:%.*]] = getelementptr inbounds i8, ptr [[TMP47]], i64 [[TMP43]]
; CHECK-NEXT:    [[TMP49:%.*]] = sub i64 128, [[TMP43]]
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP46]], ptr align 8 [[TMP48]], i64 [[TMP49]], i1 false)
; CHECK-NEXT:    [[TMP50:%.*]] = ptrtoint ptr [[TMP14]] to i64
; CHECK-NEXT:    [[TMP51:%.*]] = xor i64 [[TMP50]], 193514046488576
; CHECK-NEXT:    [[TMP52:%.*]] = inttoptr i64 [[TMP51]] to ptr
; CHECK-NEXT:    [[TMP53:%.*]] = getelementptr inbounds i8, ptr [[TMP2]], i32 192
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 16 [[TMP52]], ptr align 16 [[TMP53]], i64 [[TMP0]], i1 false)
; CHECK-NEXT:    store i64 0, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @_Z3usePv(ptr noundef nonnull [[ARGS]])
; CHECK-NEXT:    call void @llvm.va_end(ptr nonnull [[ARGS]])
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 32, ptr nonnull [[ARGS]])
; CHECK-NEXT:    ret void
;
entry:
  %args = alloca %"struct.std::__va_list", align 8
  call void @llvm.lifetime.start.p0(i64 32, ptr nonnull %args) #5
  call void @llvm.va_start(ptr nonnull %args)
  call void @_Z3usePv(ptr noundef nonnull %args)
  call void @llvm.va_end(ptr nonnull %args)
  call void @llvm.lifetime.end.p0(i64 32, ptr nonnull %args) #5
  ret void
}

define linkonce_odr dso_local void @_Z5test2I12DoubleDoubleEvT_iz([2 x double] alignstack(8) %t.coerce, i32 noundef %n, ...) sanitize_memory {
; CHECK-LABEL: define linkonce_odr dso_local void @_Z5test2I12DoubleDoubleEvT_iz(
; CHECK-SAME: [2 x double] alignstack(8) [[T_COERCE:%.*]], i32 noundef [[N:%.*]], ...) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr @__msan_va_arg_overflow_size_tls, align 8
; CHECK-NEXT:    [[TMP1:%.*]] = add i64 192, [[TMP0]]
; CHECK-NEXT:    [[TMP2:%.*]] = alloca i8, i64 [[TMP1]], align 8
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP2]], i8 0, i64 [[TMP1]], i1 false)
; CHECK-NEXT:    [[TMP3:%.*]] = call i64 @llvm.umin.i64(i64 [[TMP1]], i64 800)
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP2]], ptr align 8 @__msan_va_arg_tls, i64 [[TMP3]], i1 false)
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[ARGS:%.*]] = alloca %"struct.std::__va_list", align 8
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 32, ptr nonnull [[ARGS]])
; CHECK-NEXT:    [[TMP4:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP5:%.*]] = xor i64 [[TMP4]], 193514046488576
; CHECK-NEXT:    [[TMP6:%.*]] = inttoptr i64 [[TMP5]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP6]], i8 -1, i64 32, i1 false)
; CHECK-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP8:%.*]] = xor i64 [[TMP7]], 193514046488576
; CHECK-NEXT:    [[TMP9:%.*]] = inttoptr i64 [[TMP8]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP9]], i8 0, i64 32, i1 false)
; CHECK-NEXT:    call void @llvm.va_start(ptr nonnull [[ARGS]])
; CHECK-NEXT:    [[TMP10:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP11:%.*]] = add i64 [[TMP10]], 0
; CHECK-NEXT:    [[TMP12:%.*]] = inttoptr i64 [[TMP11]] to ptr
; CHECK-NEXT:    [[TMP13:%.*]] = load i64, ptr [[TMP12]], align 8
; CHECK-NEXT:    [[TMP14:%.*]] = inttoptr i64 [[TMP13]] to ptr
; CHECK-NEXT:    [[TMP15:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP16:%.*]] = add i64 [[TMP15]], 8
; CHECK-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[TMP16]] to ptr
; CHECK-NEXT:    [[TMP18:%.*]] = load i64, ptr [[TMP17]], align 8
; CHECK-NEXT:    [[TMP19:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP20:%.*]] = add i64 [[TMP19]], 24
; CHECK-NEXT:    [[TMP21:%.*]] = inttoptr i64 [[TMP20]] to ptr
; CHECK-NEXT:    [[TMP22:%.*]] = load i32, ptr [[TMP21]], align 4
; CHECK-NEXT:    [[TMP23:%.*]] = sext i32 [[TMP22]] to i64
; CHECK-NEXT:    [[TMP24:%.*]] = add i64 [[TMP18]], [[TMP23]]
; CHECK-NEXT:    [[TMP25:%.*]] = inttoptr i64 [[TMP24]] to ptr
; CHECK-NEXT:    [[TMP26:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP27:%.*]] = add i64 [[TMP26]], 16
; CHECK-NEXT:    [[TMP28:%.*]] = inttoptr i64 [[TMP27]] to ptr
; CHECK-NEXT:    [[TMP29:%.*]] = load i64, ptr [[TMP28]], align 8
; CHECK-NEXT:    [[TMP30:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP31:%.*]] = add i64 [[TMP30]], 28
; CHECK-NEXT:    [[TMP32:%.*]] = inttoptr i64 [[TMP31]] to ptr
; CHECK-NEXT:    [[TMP33:%.*]] = load i32, ptr [[TMP32]], align 4
; CHECK-NEXT:    [[TMP34:%.*]] = sext i32 [[TMP33]] to i64
; CHECK-NEXT:    [[TMP35:%.*]] = add i64 [[TMP29]], [[TMP34]]
; CHECK-NEXT:    [[TMP36:%.*]] = inttoptr i64 [[TMP35]] to ptr
; CHECK-NEXT:    [[TMP37:%.*]] = add i64 64, [[TMP23]]
; CHECK-NEXT:    [[TMP38:%.*]] = ptrtoint ptr [[TMP25]] to i64
; CHECK-NEXT:    [[TMP39:%.*]] = xor i64 [[TMP38]], 193514046488576
; CHECK-NEXT:    [[TMP40:%.*]] = inttoptr i64 [[TMP39]] to ptr
; CHECK-NEXT:    [[TMP41:%.*]] = getelementptr inbounds i8, ptr [[TMP2]], i64 [[TMP37]]
; CHECK-NEXT:    [[TMP42:%.*]] = sub i64 64, [[TMP37]]
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP40]], ptr align 8 [[TMP41]], i64 [[TMP42]], i1 false)
; CHECK-NEXT:    [[TMP43:%.*]] = add i64 128, [[TMP34]]
; CHECK-NEXT:    [[TMP44:%.*]] = ptrtoint ptr [[TMP36]] to i64
; CHECK-NEXT:    [[TMP45:%.*]] = xor i64 [[TMP44]], 193514046488576
; CHECK-NEXT:    [[TMP46:%.*]] = inttoptr i64 [[TMP45]] to ptr
; CHECK-NEXT:    [[TMP47:%.*]] = getelementptr inbounds i8, ptr [[TMP2]], i32 64
; CHECK-NEXT:    [[TMP48:%.*]] = getelementptr inbounds i8, ptr [[TMP47]], i64 [[TMP43]]
; CHECK-NEXT:    [[TMP49:%.*]] = sub i64 128, [[TMP43]]
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP46]], ptr align 8 [[TMP48]], i64 [[TMP49]], i1 false)
; CHECK-NEXT:    [[TMP50:%.*]] = ptrtoint ptr [[TMP14]] to i64
; CHECK-NEXT:    [[TMP51:%.*]] = xor i64 [[TMP50]], 193514046488576
; CHECK-NEXT:    [[TMP52:%.*]] = inttoptr i64 [[TMP51]] to ptr
; CHECK-NEXT:    [[TMP53:%.*]] = getelementptr inbounds i8, ptr [[TMP2]], i32 192
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 16 [[TMP52]], ptr align 16 [[TMP53]], i64 [[TMP0]], i1 false)
; CHECK-NEXT:    store i64 0, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @_Z3usePv(ptr noundef nonnull [[ARGS]])
; CHECK-NEXT:    call void @llvm.va_end(ptr nonnull [[ARGS]])
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 32, ptr nonnull [[ARGS]])
; CHECK-NEXT:    ret void
;
entry:
  %args = alloca %"struct.std::__va_list", align 8
  call void @llvm.lifetime.start.p0(i64 32, ptr nonnull %args) #5
  call void @llvm.va_start(ptr nonnull %args)
  call void @_Z3usePv(ptr noundef nonnull %args)
  call void @llvm.va_end(ptr nonnull %args)
  call void @llvm.lifetime.end.p0(i64 32, ptr nonnull %args) #5
  ret void
}

define linkonce_odr dso_local void @_Z5test2I7Double4EvT_iz([4 x double] alignstack(8) %t.coerce, i32 noundef %n, ...) sanitize_memory {
; CHECK-LABEL: define linkonce_odr dso_local void @_Z5test2I7Double4EvT_iz(
; CHECK-SAME: [4 x double] alignstack(8) [[T_COERCE:%.*]], i32 noundef [[N:%.*]], ...) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr @__msan_va_arg_overflow_size_tls, align 8
; CHECK-NEXT:    [[TMP1:%.*]] = add i64 192, [[TMP0]]
; CHECK-NEXT:    [[TMP2:%.*]] = alloca i8, i64 [[TMP1]], align 8
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP2]], i8 0, i64 [[TMP1]], i1 false)
; CHECK-NEXT:    [[TMP3:%.*]] = call i64 @llvm.umin.i64(i64 [[TMP1]], i64 800)
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP2]], ptr align 8 @__msan_va_arg_tls, i64 [[TMP3]], i1 false)
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[ARGS:%.*]] = alloca %"struct.std::__va_list", align 8
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 32, ptr nonnull [[ARGS]])
; CHECK-NEXT:    [[TMP4:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP5:%.*]] = xor i64 [[TMP4]], 193514046488576
; CHECK-NEXT:    [[TMP6:%.*]] = inttoptr i64 [[TMP5]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP6]], i8 -1, i64 32, i1 false)
; CHECK-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP8:%.*]] = xor i64 [[TMP7]], 193514046488576
; CHECK-NEXT:    [[TMP9:%.*]] = inttoptr i64 [[TMP8]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP9]], i8 0, i64 32, i1 false)
; CHECK-NEXT:    call void @llvm.va_start(ptr nonnull [[ARGS]])
; CHECK-NEXT:    [[TMP10:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP11:%.*]] = add i64 [[TMP10]], 0
; CHECK-NEXT:    [[TMP12:%.*]] = inttoptr i64 [[TMP11]] to ptr
; CHECK-NEXT:    [[TMP13:%.*]] = load i64, ptr [[TMP12]], align 8
; CHECK-NEXT:    [[TMP14:%.*]] = inttoptr i64 [[TMP13]] to ptr
; CHECK-NEXT:    [[TMP15:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP16:%.*]] = add i64 [[TMP15]], 8
; CHECK-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[TMP16]] to ptr
; CHECK-NEXT:    [[TMP18:%.*]] = load i64, ptr [[TMP17]], align 8
; CHECK-NEXT:    [[TMP19:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP20:%.*]] = add i64 [[TMP19]], 24
; CHECK-NEXT:    [[TMP21:%.*]] = inttoptr i64 [[TMP20]] to ptr
; CHECK-NEXT:    [[TMP22:%.*]] = load i32, ptr [[TMP21]], align 4
; CHECK-NEXT:    [[TMP23:%.*]] = sext i32 [[TMP22]] to i64
; CHECK-NEXT:    [[TMP24:%.*]] = add i64 [[TMP18]], [[TMP23]]
; CHECK-NEXT:    [[TMP25:%.*]] = inttoptr i64 [[TMP24]] to ptr
; CHECK-NEXT:    [[TMP26:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP27:%.*]] = add i64 [[TMP26]], 16
; CHECK-NEXT:    [[TMP28:%.*]] = inttoptr i64 [[TMP27]] to ptr
; CHECK-NEXT:    [[TMP29:%.*]] = load i64, ptr [[TMP28]], align 8
; CHECK-NEXT:    [[TMP30:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP31:%.*]] = add i64 [[TMP30]], 28
; CHECK-NEXT:    [[TMP32:%.*]] = inttoptr i64 [[TMP31]] to ptr
; CHECK-NEXT:    [[TMP33:%.*]] = load i32, ptr [[TMP32]], align 4
; CHECK-NEXT:    [[TMP34:%.*]] = sext i32 [[TMP33]] to i64
; CHECK-NEXT:    [[TMP35:%.*]] = add i64 [[TMP29]], [[TMP34]]
; CHECK-NEXT:    [[TMP36:%.*]] = inttoptr i64 [[TMP35]] to ptr
; CHECK-NEXT:    [[TMP37:%.*]] = add i64 64, [[TMP23]]
; CHECK-NEXT:    [[TMP38:%.*]] = ptrtoint ptr [[TMP25]] to i64
; CHECK-NEXT:    [[TMP39:%.*]] = xor i64 [[TMP38]], 193514046488576
; CHECK-NEXT:    [[TMP40:%.*]] = inttoptr i64 [[TMP39]] to ptr
; CHECK-NEXT:    [[TMP41:%.*]] = getelementptr inbounds i8, ptr [[TMP2]], i64 [[TMP37]]
; CHECK-NEXT:    [[TMP42:%.*]] = sub i64 64, [[TMP37]]
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP40]], ptr align 8 [[TMP41]], i64 [[TMP42]], i1 false)
; CHECK-NEXT:    [[TMP43:%.*]] = add i64 128, [[TMP34]]
; CHECK-NEXT:    [[TMP44:%.*]] = ptrtoint ptr [[TMP36]] to i64
; CHECK-NEXT:    [[TMP45:%.*]] = xor i64 [[TMP44]], 193514046488576
; CHECK-NEXT:    [[TMP46:%.*]] = inttoptr i64 [[TMP45]] to ptr
; CHECK-NEXT:    [[TMP47:%.*]] = getelementptr inbounds i8, ptr [[TMP2]], i32 64
; CHECK-NEXT:    [[TMP48:%.*]] = getelementptr inbounds i8, ptr [[TMP47]], i64 [[TMP43]]
; CHECK-NEXT:    [[TMP49:%.*]] = sub i64 128, [[TMP43]]
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP46]], ptr align 8 [[TMP48]], i64 [[TMP49]], i1 false)
; CHECK-NEXT:    [[TMP50:%.*]] = ptrtoint ptr [[TMP14]] to i64
; CHECK-NEXT:    [[TMP51:%.*]] = xor i64 [[TMP50]], 193514046488576
; CHECK-NEXT:    [[TMP52:%.*]] = inttoptr i64 [[TMP51]] to ptr
; CHECK-NEXT:    [[TMP53:%.*]] = getelementptr inbounds i8, ptr [[TMP2]], i32 192
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 16 [[TMP52]], ptr align 16 [[TMP53]], i64 [[TMP0]], i1 false)
; CHECK-NEXT:    store i64 0, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @_Z3usePv(ptr noundef nonnull [[ARGS]])
; CHECK-NEXT:    call void @llvm.va_end(ptr nonnull [[ARGS]])
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 32, ptr nonnull [[ARGS]])
; CHECK-NEXT:    ret void
;
entry:
  %args = alloca %"struct.std::__va_list", align 8
  call void @llvm.lifetime.start.p0(i64 32, ptr nonnull %args) #5
  call void @llvm.va_start(ptr nonnull %args)
  call void @_Z3usePv(ptr noundef nonnull %args)
  call void @llvm.va_end(ptr nonnull %args)
  call void @llvm.lifetime.end.p0(i64 32, ptr nonnull %args) #5
  ret void
}

define linkonce_odr dso_local void @_Z5test2I11DoubleFloatEvT_iz([2 x i64] %t.coerce, i32 noundef %n, ...) sanitize_memory {
; CHECK-LABEL: define linkonce_odr dso_local void @_Z5test2I11DoubleFloatEvT_iz(
; CHECK-SAME: [2 x i64] [[T_COERCE:%.*]], i32 noundef [[N:%.*]], ...) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr @__msan_va_arg_overflow_size_tls, align 8
; CHECK-NEXT:    [[TMP1:%.*]] = add i64 192, [[TMP0]]
; CHECK-NEXT:    [[TMP2:%.*]] = alloca i8, i64 [[TMP1]], align 8
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP2]], i8 0, i64 [[TMP1]], i1 false)
; CHECK-NEXT:    [[TMP3:%.*]] = call i64 @llvm.umin.i64(i64 [[TMP1]], i64 800)
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP2]], ptr align 8 @__msan_va_arg_tls, i64 [[TMP3]], i1 false)
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[ARGS:%.*]] = alloca %"struct.std::__va_list", align 8
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 32, ptr nonnull [[ARGS]])
; CHECK-NEXT:    [[TMP4:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP5:%.*]] = xor i64 [[TMP4]], 193514046488576
; CHECK-NEXT:    [[TMP6:%.*]] = inttoptr i64 [[TMP5]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP6]], i8 -1, i64 32, i1 false)
; CHECK-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP8:%.*]] = xor i64 [[TMP7]], 193514046488576
; CHECK-NEXT:    [[TMP9:%.*]] = inttoptr i64 [[TMP8]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP9]], i8 0, i64 32, i1 false)
; CHECK-NEXT:    call void @llvm.va_start(ptr nonnull [[ARGS]])
; CHECK-NEXT:    [[TMP10:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP11:%.*]] = add i64 [[TMP10]], 0
; CHECK-NEXT:    [[TMP12:%.*]] = inttoptr i64 [[TMP11]] to ptr
; CHECK-NEXT:    [[TMP13:%.*]] = load i64, ptr [[TMP12]], align 8
; CHECK-NEXT:    [[TMP14:%.*]] = inttoptr i64 [[TMP13]] to ptr
; CHECK-NEXT:    [[TMP15:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP16:%.*]] = add i64 [[TMP15]], 8
; CHECK-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[TMP16]] to ptr
; CHECK-NEXT:    [[TMP18:%.*]] = load i64, ptr [[TMP17]], align 8
; CHECK-NEXT:    [[TMP19:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP20:%.*]] = add i64 [[TMP19]], 24
; CHECK-NEXT:    [[TMP21:%.*]] = inttoptr i64 [[TMP20]] to ptr
; CHECK-NEXT:    [[TMP22:%.*]] = load i32, ptr [[TMP21]], align 4
; CHECK-NEXT:    [[TMP23:%.*]] = sext i32 [[TMP22]] to i64
; CHECK-NEXT:    [[TMP24:%.*]] = add i64 [[TMP18]], [[TMP23]]
; CHECK-NEXT:    [[TMP25:%.*]] = inttoptr i64 [[TMP24]] to ptr
; CHECK-NEXT:    [[TMP26:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP27:%.*]] = add i64 [[TMP26]], 16
; CHECK-NEXT:    [[TMP28:%.*]] = inttoptr i64 [[TMP27]] to ptr
; CHECK-NEXT:    [[TMP29:%.*]] = load i64, ptr [[TMP28]], align 8
; CHECK-NEXT:    [[TMP30:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP31:%.*]] = add i64 [[TMP30]], 28
; CHECK-NEXT:    [[TMP32:%.*]] = inttoptr i64 [[TMP31]] to ptr
; CHECK-NEXT:    [[TMP33:%.*]] = load i32, ptr [[TMP32]], align 4
; CHECK-NEXT:    [[TMP34:%.*]] = sext i32 [[TMP33]] to i64
; CHECK-NEXT:    [[TMP35:%.*]] = add i64 [[TMP29]], [[TMP34]]
; CHECK-NEXT:    [[TMP36:%.*]] = inttoptr i64 [[TMP35]] to ptr
; CHECK-NEXT:    [[TMP37:%.*]] = add i64 64, [[TMP23]]
; CHECK-NEXT:    [[TMP38:%.*]] = ptrtoint ptr [[TMP25]] to i64
; CHECK-NEXT:    [[TMP39:%.*]] = xor i64 [[TMP38]], 193514046488576
; CHECK-NEXT:    [[TMP40:%.*]] = inttoptr i64 [[TMP39]] to ptr
; CHECK-NEXT:    [[TMP41:%.*]] = getelementptr inbounds i8, ptr [[TMP2]], i64 [[TMP37]]
; CHECK-NEXT:    [[TMP42:%.*]] = sub i64 64, [[TMP37]]
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP40]], ptr align 8 [[TMP41]], i64 [[TMP42]], i1 false)
; CHECK-NEXT:    [[TMP43:%.*]] = add i64 128, [[TMP34]]
; CHECK-NEXT:    [[TMP44:%.*]] = ptrtoint ptr [[TMP36]] to i64
; CHECK-NEXT:    [[TMP45:%.*]] = xor i64 [[TMP44]], 193514046488576
; CHECK-NEXT:    [[TMP46:%.*]] = inttoptr i64 [[TMP45]] to ptr
; CHECK-NEXT:    [[TMP47:%.*]] = getelementptr inbounds i8, ptr [[TMP2]], i32 64
; CHECK-NEXT:    [[TMP48:%.*]] = getelementptr inbounds i8, ptr [[TMP47]], i64 [[TMP43]]
; CHECK-NEXT:    [[TMP49:%.*]] = sub i64 128, [[TMP43]]
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP46]], ptr align 8 [[TMP48]], i64 [[TMP49]], i1 false)
; CHECK-NEXT:    [[TMP50:%.*]] = ptrtoint ptr [[TMP14]] to i64
; CHECK-NEXT:    [[TMP51:%.*]] = xor i64 [[TMP50]], 193514046488576
; CHECK-NEXT:    [[TMP52:%.*]] = inttoptr i64 [[TMP51]] to ptr
; CHECK-NEXT:    [[TMP53:%.*]] = getelementptr inbounds i8, ptr [[TMP2]], i32 192
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 16 [[TMP52]], ptr align 16 [[TMP53]], i64 [[TMP0]], i1 false)
; CHECK-NEXT:    store i64 0, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @_Z3usePv(ptr noundef nonnull [[ARGS]])
; CHECK-NEXT:    call void @llvm.va_end(ptr nonnull [[ARGS]])
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 32, ptr nonnull [[ARGS]])
; CHECK-NEXT:    ret void
;
entry:
  %args = alloca %"struct.std::__va_list", align 8
  call void @llvm.lifetime.start.p0(i64 32, ptr nonnull %args) #5
  call void @llvm.va_start(ptr nonnull %args)
  call void @_Z3usePv(ptr noundef nonnull %args)
  call void @llvm.va_end(ptr nonnull %args)
  call void @llvm.lifetime.end.p0(i64 32, ptr nonnull %args) #5
  ret void
}

define linkonce_odr dso_local void @_Z5test2I11LongDouble2EvT_iz([2 x fp128] alignstack(16) %t.coerce, i32 noundef %n, ...) sanitize_memory {
; CHECK-LABEL: define linkonce_odr dso_local void @_Z5test2I11LongDouble2EvT_iz(
; CHECK-SAME: [2 x fp128] alignstack(16) [[T_COERCE:%.*]], i32 noundef [[N:%.*]], ...) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr @__msan_va_arg_overflow_size_tls, align 8
; CHECK-NEXT:    [[TMP1:%.*]] = add i64 192, [[TMP0]]
; CHECK-NEXT:    [[TMP2:%.*]] = alloca i8, i64 [[TMP1]], align 8
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP2]], i8 0, i64 [[TMP1]], i1 false)
; CHECK-NEXT:    [[TMP3:%.*]] = call i64 @llvm.umin.i64(i64 [[TMP1]], i64 800)
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP2]], ptr align 8 @__msan_va_arg_tls, i64 [[TMP3]], i1 false)
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[ARGS:%.*]] = alloca %"struct.std::__va_list", align 8
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 32, ptr nonnull [[ARGS]])
; CHECK-NEXT:    [[TMP4:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP5:%.*]] = xor i64 [[TMP4]], 193514046488576
; CHECK-NEXT:    [[TMP6:%.*]] = inttoptr i64 [[TMP5]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP6]], i8 -1, i64 32, i1 false)
; CHECK-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP8:%.*]] = xor i64 [[TMP7]], 193514046488576
; CHECK-NEXT:    [[TMP9:%.*]] = inttoptr i64 [[TMP8]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP9]], i8 0, i64 32, i1 false)
; CHECK-NEXT:    call void @llvm.va_start(ptr nonnull [[ARGS]])
; CHECK-NEXT:    [[TMP10:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP11:%.*]] = add i64 [[TMP10]], 0
; CHECK-NEXT:    [[TMP12:%.*]] = inttoptr i64 [[TMP11]] to ptr
; CHECK-NEXT:    [[TMP13:%.*]] = load i64, ptr [[TMP12]], align 8
; CHECK-NEXT:    [[TMP14:%.*]] = inttoptr i64 [[TMP13]] to ptr
; CHECK-NEXT:    [[TMP15:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP16:%.*]] = add i64 [[TMP15]], 8
; CHECK-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[TMP16]] to ptr
; CHECK-NEXT:    [[TMP18:%.*]] = load i64, ptr [[TMP17]], align 8
; CHECK-NEXT:    [[TMP19:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP20:%.*]] = add i64 [[TMP19]], 24
; CHECK-NEXT:    [[TMP21:%.*]] = inttoptr i64 [[TMP20]] to ptr
; CHECK-NEXT:    [[TMP22:%.*]] = load i32, ptr [[TMP21]], align 4
; CHECK-NEXT:    [[TMP23:%.*]] = sext i32 [[TMP22]] to i64
; CHECK-NEXT:    [[TMP24:%.*]] = add i64 [[TMP18]], [[TMP23]]
; CHECK-NEXT:    [[TMP25:%.*]] = inttoptr i64 [[TMP24]] to ptr
; CHECK-NEXT:    [[TMP26:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP27:%.*]] = add i64 [[TMP26]], 16
; CHECK-NEXT:    [[TMP28:%.*]] = inttoptr i64 [[TMP27]] to ptr
; CHECK-NEXT:    [[TMP29:%.*]] = load i64, ptr [[TMP28]], align 8
; CHECK-NEXT:    [[TMP30:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP31:%.*]] = add i64 [[TMP30]], 28
; CHECK-NEXT:    [[TMP32:%.*]] = inttoptr i64 [[TMP31]] to ptr
; CHECK-NEXT:    [[TMP33:%.*]] = load i32, ptr [[TMP32]], align 4
; CHECK-NEXT:    [[TMP34:%.*]] = sext i32 [[TMP33]] to i64
; CHECK-NEXT:    [[TMP35:%.*]] = add i64 [[TMP29]], [[TMP34]]
; CHECK-NEXT:    [[TMP36:%.*]] = inttoptr i64 [[TMP35]] to ptr
; CHECK-NEXT:    [[TMP37:%.*]] = add i64 64, [[TMP23]]
; CHECK-NEXT:    [[TMP38:%.*]] = ptrtoint ptr [[TMP25]] to i64
; CHECK-NEXT:    [[TMP39:%.*]] = xor i64 [[TMP38]], 193514046488576
; CHECK-NEXT:    [[TMP40:%.*]] = inttoptr i64 [[TMP39]] to ptr
; CHECK-NEXT:    [[TMP41:%.*]] = getelementptr inbounds i8, ptr [[TMP2]], i64 [[TMP37]]
; CHECK-NEXT:    [[TMP42:%.*]] = sub i64 64, [[TMP37]]
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP40]], ptr align 8 [[TMP41]], i64 [[TMP42]], i1 false)
; CHECK-NEXT:    [[TMP43:%.*]] = add i64 128, [[TMP34]]
; CHECK-NEXT:    [[TMP44:%.*]] = ptrtoint ptr [[TMP36]] to i64
; CHECK-NEXT:    [[TMP45:%.*]] = xor i64 [[TMP44]], 193514046488576
; CHECK-NEXT:    [[TMP46:%.*]] = inttoptr i64 [[TMP45]] to ptr
; CHECK-NEXT:    [[TMP47:%.*]] = getelementptr inbounds i8, ptr [[TMP2]], i32 64
; CHECK-NEXT:    [[TMP48:%.*]] = getelementptr inbounds i8, ptr [[TMP47]], i64 [[TMP43]]
; CHECK-NEXT:    [[TMP49:%.*]] = sub i64 128, [[TMP43]]
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP46]], ptr align 8 [[TMP48]], i64 [[TMP49]], i1 false)
; CHECK-NEXT:    [[TMP50:%.*]] = ptrtoint ptr [[TMP14]] to i64
; CHECK-NEXT:    [[TMP51:%.*]] = xor i64 [[TMP50]], 193514046488576
; CHECK-NEXT:    [[TMP52:%.*]] = inttoptr i64 [[TMP51]] to ptr
; CHECK-NEXT:    [[TMP53:%.*]] = getelementptr inbounds i8, ptr [[TMP2]], i32 192
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 16 [[TMP52]], ptr align 16 [[TMP53]], i64 [[TMP0]], i1 false)
; CHECK-NEXT:    store i64 0, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @_Z3usePv(ptr noundef nonnull [[ARGS]])
; CHECK-NEXT:    call void @llvm.va_end(ptr nonnull [[ARGS]])
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 32, ptr nonnull [[ARGS]])
; CHECK-NEXT:    ret void
;
entry:
  %args = alloca %"struct.std::__va_list", align 8
  call void @llvm.lifetime.start.p0(i64 32, ptr nonnull %args) #5
  call void @llvm.va_start(ptr nonnull %args)
  call void @_Z3usePv(ptr noundef nonnull %args)
  call void @llvm.va_end(ptr nonnull %args)
  call void @llvm.lifetime.end.p0(i64 32, ptr nonnull %args) #5
  ret void
}

define linkonce_odr dso_local void @_Z5test2I11LongDouble4EvT_iz([4 x fp128] alignstack(16) %t.coerce, i32 noundef %n, ...) sanitize_memory {
; CHECK-LABEL: define linkonce_odr dso_local void @_Z5test2I11LongDouble4EvT_iz(
; CHECK-SAME: [4 x fp128] alignstack(16) [[T_COERCE:%.*]], i32 noundef [[N:%.*]], ...) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr @__msan_va_arg_overflow_size_tls, align 8
; CHECK-NEXT:    [[TMP1:%.*]] = add i64 192, [[TMP0]]
; CHECK-NEXT:    [[TMP2:%.*]] = alloca i8, i64 [[TMP1]], align 8
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP2]], i8 0, i64 [[TMP1]], i1 false)
; CHECK-NEXT:    [[TMP3:%.*]] = call i64 @llvm.umin.i64(i64 [[TMP1]], i64 800)
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP2]], ptr align 8 @__msan_va_arg_tls, i64 [[TMP3]], i1 false)
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[ARGS:%.*]] = alloca %"struct.std::__va_list", align 8
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 32, ptr nonnull [[ARGS]])
; CHECK-NEXT:    [[TMP4:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP5:%.*]] = xor i64 [[TMP4]], 193514046488576
; CHECK-NEXT:    [[TMP6:%.*]] = inttoptr i64 [[TMP5]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP6]], i8 -1, i64 32, i1 false)
; CHECK-NEXT:    [[TMP7:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP8:%.*]] = xor i64 [[TMP7]], 193514046488576
; CHECK-NEXT:    [[TMP9:%.*]] = inttoptr i64 [[TMP8]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP9]], i8 0, i64 32, i1 false)
; CHECK-NEXT:    call void @llvm.va_start(ptr nonnull [[ARGS]])
; CHECK-NEXT:    [[TMP10:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP11:%.*]] = add i64 [[TMP10]], 0
; CHECK-NEXT:    [[TMP12:%.*]] = inttoptr i64 [[TMP11]] to ptr
; CHECK-NEXT:    [[TMP13:%.*]] = load i64, ptr [[TMP12]], align 8
; CHECK-NEXT:    [[TMP14:%.*]] = inttoptr i64 [[TMP13]] to ptr
; CHECK-NEXT:    [[TMP15:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP16:%.*]] = add i64 [[TMP15]], 8
; CHECK-NEXT:    [[TMP17:%.*]] = inttoptr i64 [[TMP16]] to ptr
; CHECK-NEXT:    [[TMP18:%.*]] = load i64, ptr [[TMP17]], align 8
; CHECK-NEXT:    [[TMP19:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP20:%.*]] = add i64 [[TMP19]], 24
; CHECK-NEXT:    [[TMP21:%.*]] = inttoptr i64 [[TMP20]] to ptr
; CHECK-NEXT:    [[TMP22:%.*]] = load i32, ptr [[TMP21]], align 4
; CHECK-NEXT:    [[TMP23:%.*]] = sext i32 [[TMP22]] to i64
; CHECK-NEXT:    [[TMP24:%.*]] = add i64 [[TMP18]], [[TMP23]]
; CHECK-NEXT:    [[TMP25:%.*]] = inttoptr i64 [[TMP24]] to ptr
; CHECK-NEXT:    [[TMP26:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP27:%.*]] = add i64 [[TMP26]], 16
; CHECK-NEXT:    [[TMP28:%.*]] = inttoptr i64 [[TMP27]] to ptr
; CHECK-NEXT:    [[TMP29:%.*]] = load i64, ptr [[TMP28]], align 8
; CHECK-NEXT:    [[TMP30:%.*]] = ptrtoint ptr [[ARGS]] to i64
; CHECK-NEXT:    [[TMP31:%.*]] = add i64 [[TMP30]], 28
; CHECK-NEXT:    [[TMP32:%.*]] = inttoptr i64 [[TMP31]] to ptr
; CHECK-NEXT:    [[TMP33:%.*]] = load i32, ptr [[TMP32]], align 4
; CHECK-NEXT:    [[TMP34:%.*]] = sext i32 [[TMP33]] to i64
; CHECK-NEXT:    [[TMP35:%.*]] = add i64 [[TMP29]], [[TMP34]]
; CHECK-NEXT:    [[TMP36:%.*]] = inttoptr i64 [[TMP35]] to ptr
; CHECK-NEXT:    [[TMP37:%.*]] = add i64 64, [[TMP23]]
; CHECK-NEXT:    [[TMP38:%.*]] = ptrtoint ptr [[TMP25]] to i64
; CHECK-NEXT:    [[TMP39:%.*]] = xor i64 [[TMP38]], 193514046488576
; CHECK-NEXT:    [[TMP40:%.*]] = inttoptr i64 [[TMP39]] to ptr
; CHECK-NEXT:    [[TMP41:%.*]] = getelementptr inbounds i8, ptr [[TMP2]], i64 [[TMP37]]
; CHECK-NEXT:    [[TMP42:%.*]] = sub i64 64, [[TMP37]]
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP40]], ptr align 8 [[TMP41]], i64 [[TMP42]], i1 false)
; CHECK-NEXT:    [[TMP43:%.*]] = add i64 128, [[TMP34]]
; CHECK-NEXT:    [[TMP44:%.*]] = ptrtoint ptr [[TMP36]] to i64
; CHECK-NEXT:    [[TMP45:%.*]] = xor i64 [[TMP44]], 193514046488576
; CHECK-NEXT:    [[TMP46:%.*]] = inttoptr i64 [[TMP45]] to ptr
; CHECK-NEXT:    [[TMP47:%.*]] = getelementptr inbounds i8, ptr [[TMP2]], i32 64
; CHECK-NEXT:    [[TMP48:%.*]] = getelementptr inbounds i8, ptr [[TMP47]], i64 [[TMP43]]
; CHECK-NEXT:    [[TMP49:%.*]] = sub i64 128, [[TMP43]]
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP46]], ptr align 8 [[TMP48]], i64 [[TMP49]], i1 false)
; CHECK-NEXT:    [[TMP50:%.*]] = ptrtoint ptr [[TMP14]] to i64
; CHECK-NEXT:    [[TMP51:%.*]] = xor i64 [[TMP50]], 193514046488576
; CHECK-NEXT:    [[TMP52:%.*]] = inttoptr i64 [[TMP51]] to ptr
; CHECK-NEXT:    [[TMP53:%.*]] = getelementptr inbounds i8, ptr [[TMP2]], i32 192
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 16 [[TMP52]], ptr align 16 [[TMP53]], i64 [[TMP0]], i1 false)
; CHECK-NEXT:    store i64 0, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @_Z3usePv(ptr noundef nonnull [[ARGS]])
; CHECK-NEXT:    call void @llvm.va_end(ptr nonnull [[ARGS]])
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 32, ptr nonnull [[ARGS]])
; CHECK-NEXT:    ret void
;
entry:
  %args = alloca %"struct.std::__va_list", align 8
  call void @llvm.lifetime.start.p0(i64 32, ptr nonnull %args) #5
  call void @llvm.va_start(ptr nonnull %args)
  call void @_Z3usePv(ptr noundef nonnull %args)
  call void @llvm.va_end(ptr nonnull %args)
  call void @llvm.lifetime.end.p0(i64 32, ptr nonnull %args) #5
  ret void
}

define linkonce_odr dso_local void @_Z4test2I11LongDouble4EvT_([4 x fp128] alignstack(16) %arg.coerce) sanitize_memory {
; CHECK-LABEL: define linkonce_odr dso_local void @_Z4test2I11LongDouble4EvT_(
; CHECK-SAME: [4 x fp128] alignstack(16) [[ARG_COERCE:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load [4 x i128], ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[ARG:%.*]] = alloca [[STRUCT_LONGDOUBLE4:%.*]], align 16
; CHECK-NEXT:    [[TMP1:%.*]] = ptrtoint ptr [[ARG]] to i64
; CHECK-NEXT:    [[TMP2:%.*]] = xor i64 [[TMP1]], 193514046488576
; CHECK-NEXT:    [[TMP3:%.*]] = inttoptr i64 [[TMP2]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 16 [[TMP3]], i8 -1, i64 64, i1 false)
; CHECK-NEXT:    [[TMP4:%.*]] = extractvalue [4 x i128] [[TMP0]], 0
; CHECK-NEXT:    [[ARG_COERCE_FCA_0_EXTRACT:%.*]] = extractvalue [4 x fp128] [[ARG_COERCE]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = ptrtoint ptr [[ARG]] to i64
; CHECK-NEXT:    [[TMP6:%.*]] = xor i64 [[TMP5]], 193514046488576
; CHECK-NEXT:    [[TMP7:%.*]] = inttoptr i64 [[TMP6]] to ptr
; CHECK-NEXT:    store i128 [[TMP4]], ptr [[TMP7]], align 16
; CHECK-NEXT:    store fp128 [[ARG_COERCE_FCA_0_EXTRACT]], ptr [[ARG]], align 16
; CHECK-NEXT:    [[TMP8:%.*]] = extractvalue [4 x i128] [[TMP0]], 1
; CHECK-NEXT:    [[ARG_COERCE_FCA_1_EXTRACT:%.*]] = extractvalue [4 x fp128] [[ARG_COERCE]], 1
; CHECK-NEXT:    [[ARG_COERCE_FCA_1_GEP:%.*]] = getelementptr inbounds [4 x fp128], ptr [[ARG]], i64 0, i64 1
; CHECK-NEXT:    [[TMP9:%.*]] = ptrtoint ptr [[ARG_COERCE_FCA_1_GEP]] to i64
; CHECK-NEXT:    [[TMP10:%.*]] = xor i64 [[TMP9]], 193514046488576
; CHECK-NEXT:    [[TMP11:%.*]] = inttoptr i64 [[TMP10]] to ptr
; CHECK-NEXT:    store i128 [[TMP8]], ptr [[TMP11]], align 16
; CHECK-NEXT:    store fp128 [[ARG_COERCE_FCA_1_EXTRACT]], ptr [[ARG_COERCE_FCA_1_GEP]], align 16
; CHECK-NEXT:    [[TMP12:%.*]] = extractvalue [4 x i128] [[TMP0]], 2
; CHECK-NEXT:    [[ARG_COERCE_FCA_2_EXTRACT:%.*]] = extractvalue [4 x fp128] [[ARG_COERCE]], 2
; CHECK-NEXT:    [[ARG_COERCE_FCA_2_GEP:%.*]] = getelementptr inbounds [4 x fp128], ptr [[ARG]], i64 0, i64 2
; CHECK-NEXT:    [[TMP13:%.*]] = ptrtoint ptr [[ARG_COERCE_FCA_2_GEP]] to i64
; CHECK-NEXT:    [[TMP14:%.*]] = xor i64 [[TMP13]], 193514046488576
; CHECK-NEXT:    [[TMP15:%.*]] = inttoptr i64 [[TMP14]] to ptr
; CHECK-NEXT:    store i128 [[TMP12]], ptr [[TMP15]], align 16
; CHECK-NEXT:    store fp128 [[ARG_COERCE_FCA_2_EXTRACT]], ptr [[ARG_COERCE_FCA_2_GEP]], align 16
; CHECK-NEXT:    [[TMP16:%.*]] = extractvalue [4 x i128] [[TMP0]], 3
; CHECK-NEXT:    [[ARG_COERCE_FCA_3_EXTRACT:%.*]] = extractvalue [4 x fp128] [[ARG_COERCE]], 3
; CHECK-NEXT:    [[ARG_COERCE_FCA_3_GEP:%.*]] = getelementptr inbounds [4 x fp128], ptr [[ARG]], i64 0, i64 3
; CHECK-NEXT:    [[TMP17:%.*]] = ptrtoint ptr [[ARG_COERCE_FCA_3_GEP]] to i64
; CHECK-NEXT:    [[TMP18:%.*]] = xor i64 [[TMP17]], 193514046488576
; CHECK-NEXT:    [[TMP19:%.*]] = inttoptr i64 [[TMP18]] to ptr
; CHECK-NEXT:    store i128 [[TMP16]], ptr [[TMP19]], align 16
; CHECK-NEXT:    store fp128 [[ARG_COERCE_FCA_3_EXTRACT]], ptr [[ARG_COERCE_FCA_3_GEP]], align 16
; CHECK-NEXT:    store i64 0, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @_Z3usePv(ptr noundef nonnull [[ARG]])
; CHECK-NEXT:    [[AGG_TMP_SROA_0_0_COPYLOAD:%.*]] = load fp128, ptr [[ARG]], align 16
; CHECK-NEXT:    [[TMP20:%.*]] = ptrtoint ptr [[ARG]] to i64
; CHECK-NEXT:    [[TMP21:%.*]] = xor i64 [[TMP20]], 193514046488576
; CHECK-NEXT:    [[TMP22:%.*]] = inttoptr i64 [[TMP21]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load i128, ptr [[TMP22]], align 16
; CHECK-NEXT:    [[AGG_TMP_SROA_2_0_COPYLOAD:%.*]] = load fp128, ptr [[ARG_COERCE_FCA_1_GEP]], align 16
; CHECK-NEXT:    [[TMP23:%.*]] = ptrtoint ptr [[ARG_COERCE_FCA_1_GEP]] to i64
; CHECK-NEXT:    [[TMP24:%.*]] = xor i64 [[TMP23]], 193514046488576
; CHECK-NEXT:    [[TMP25:%.*]] = inttoptr i64 [[TMP24]] to ptr
; CHECK-NEXT:    [[_MSLD1:%.*]] = load i128, ptr [[TMP25]], align 16
; CHECK-NEXT:    [[AGG_TMP_SROA_3_0_COPYLOAD:%.*]] = load fp128, ptr [[ARG_COERCE_FCA_2_GEP]], align 16
; CHECK-NEXT:    [[TMP26:%.*]] = ptrtoint ptr [[ARG_COERCE_FCA_2_GEP]] to i64
; CHECK-NEXT:    [[TMP27:%.*]] = xor i64 [[TMP26]], 193514046488576
; CHECK-NEXT:    [[TMP28:%.*]] = inttoptr i64 [[TMP27]] to ptr
; CHECK-NEXT:    [[_MSLD2:%.*]] = load i128, ptr [[TMP28]], align 16
; CHECK-NEXT:    [[AGG_TMP_SROA_4_0_COPYLOAD:%.*]] = load fp128, ptr [[ARG_COERCE_FCA_3_GEP]], align 16
; CHECK-NEXT:    [[TMP29:%.*]] = ptrtoint ptr [[ARG_COERCE_FCA_3_GEP]] to i64
; CHECK-NEXT:    [[TMP30:%.*]] = xor i64 [[TMP29]], 193514046488576
; CHECK-NEXT:    [[TMP31:%.*]] = inttoptr i64 [[TMP30]] to ptr
; CHECK-NEXT:    [[_MSLD3:%.*]] = load i128, ptr [[TMP31]], align 16
; CHECK-NEXT:    [[TMP32:%.*]] = insertvalue [4 x i128] [i128 -1, i128 -1, i128 -1, i128 -1], i128 [[_MSLD]], 0
; CHECK-NEXT:    [[DOTFCA_0_INSERT118:%.*]] = insertvalue [4 x fp128] poison, fp128 [[AGG_TMP_SROA_0_0_COPYLOAD]], 0
; CHECK-NEXT:    [[TMP33:%.*]] = insertvalue [4 x i128] [[TMP32]], i128 [[_MSLD1]], 1
; CHECK-NEXT:    [[DOTFCA_1_INSERT119:%.*]] = insertvalue [4 x fp128] [[DOTFCA_0_INSERT118]], fp128 [[AGG_TMP_SROA_2_0_COPYLOAD]], 1
; CHECK-NEXT:    [[TMP34:%.*]] = insertvalue [4 x i128] [[TMP33]], i128 [[_MSLD2]], 2
; CHECK-NEXT:    [[DOTFCA_2_INSERT120:%.*]] = insertvalue [4 x fp128] [[DOTFCA_1_INSERT119]], fp128 [[AGG_TMP_SROA_3_0_COPYLOAD]], 2
; CHECK-NEXT:    [[TMP35:%.*]] = insertvalue [4 x i128] [[TMP34]], i128 [[_MSLD3]], 3
; CHECK-NEXT:    [[DOTFCA_3_INSERT121:%.*]] = insertvalue [4 x fp128] [[DOTFCA_2_INSERT120]], fp128 [[AGG_TMP_SROA_4_0_COPYLOAD]], 3
; CHECK-NEXT:    store [4 x i128] [[TMP35]], ptr @__msan_param_tls, align 8
; CHECK-NEXT:    store i32 0, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 64) to ptr), align 8
; CHECK-NEXT:    store [4 x i128] [[TMP35]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 72) to ptr), align 8
; CHECK-NEXT:    store [4 x i128] [[TMP35]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 136) to ptr), align 8
; CHECK-NEXT:    store [4 x i128] [[TMP35]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 200) to ptr), align 8
; CHECK-NEXT:    store [4 x i128] [[TMP35]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 264) to ptr), align 8
; CHECK-NEXT:    store [4 x i128] [[TMP35]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 328) to ptr), align 8
; CHECK-NEXT:    store [4 x i128] [[TMP35]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 392) to ptr), align 8
; CHECK-NEXT:    store [4 x i128] [[TMP35]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 456) to ptr), align 8
; CHECK-NEXT:    store [4 x i128] [[TMP35]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 520) to ptr), align 8
; CHECK-NEXT:    store [4 x i128] [[TMP35]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 584) to ptr), align 8
; CHECK-NEXT:    store [4 x i128] [[TMP35]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 648) to ptr), align 8
; CHECK-NEXT:    store [4 x i128] [[TMP35]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 712) to ptr), align 8
; CHECK-NEXT:    store [4 x i128] [[TMP35]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_va_arg_tls to i64), i64 128) to ptr), align 8
; CHECK-NEXT:    store [4 x i128] [[TMP35]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_va_arg_tls to i64), i64 192) to ptr), align 8
; CHECK-NEXT:    store [4 x i128] [[TMP35]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_va_arg_tls to i64), i64 256) to ptr), align 8
; CHECK-NEXT:    store [4 x i128] [[TMP35]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_va_arg_tls to i64), i64 320) to ptr), align 8
; CHECK-NEXT:    store [4 x i128] [[TMP35]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_va_arg_tls to i64), i64 384) to ptr), align 8
; CHECK-NEXT:    store [4 x i128] [[TMP35]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_va_arg_tls to i64), i64 448) to ptr), align 8
; CHECK-NEXT:    store [4 x i128] [[TMP35]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_va_arg_tls to i64), i64 512) to ptr), align 8
; CHECK-NEXT:    store [4 x i128] [[TMP35]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_va_arg_tls to i64), i64 576) to ptr), align 8
; CHECK-NEXT:    store [4 x i128] [[TMP35]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_va_arg_tls to i64), i64 640) to ptr), align 8
; CHECK-NEXT:    store [4 x i128] [[TMP35]], ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_va_arg_tls to i64), i64 704) to ptr), align 8
; CHECK-NEXT:    call void @llvm.memset.p0.i32(ptr align 8 inttoptr (i64 add (i64 ptrtoint (ptr @__msan_va_arg_tls to i64), i64 768) to ptr), i8 0, i32 32, i1 false)
; CHECK-NEXT:    store i64 1216, ptr @__msan_va_arg_overflow_size_tls, align 8
; CHECK-NEXT:    call void ([4 x fp128], i32, ...) @_Z5test2I11LongDouble4EvT_iz([4 x fp128] alignstack(16) [[DOTFCA_3_INSERT121]], i32 noundef 20, [4 x fp128] alignstack(16) [[DOTFCA_3_INSERT121]], [4 x fp128] alignstack(16) [[DOTFCA_3_INSERT121]], [4 x fp128] alignstack(16) [[DOTFCA_3_INSERT121]], [4 x fp128] alignstack(16) [[DOTFCA_3_INSERT121]], [4 x fp128] alignstack(16) [[DOTFCA_3_INSERT121]], [4 x fp128] alignstack(16) [[DOTFCA_3_INSERT121]], [4 x fp128] alignstack(16) [[DOTFCA_3_INSERT121]], [4 x fp128] alignstack(16) [[DOTFCA_3_INSERT121]], [4 x fp128] alignstack(16) [[DOTFCA_3_INSERT121]], [4 x fp128] alignstack(16) [[DOTFCA_3_INSERT121]], [4 x fp128] alignstack(16) [[DOTFCA_3_INSERT121]], [4 x fp128] alignstack(16) [[DOTFCA_3_INSERT121]], [4 x fp128] alignstack(16) [[DOTFCA_3_INSERT121]], [4 x fp128] alignstack(16) [[DOTFCA_3_INSERT121]], [4 x fp128] alignstack(16) [[DOTFCA_3_INSERT121]], [4 x fp128] alignstack(16) [[DOTFCA_3_INSERT121]], [4 x fp128] alignstack(16) [[DOTFCA_3_INSERT121]], [4 x fp128] alignstack(16) [[DOTFCA_3_INSERT121]], [4 x fp128] alignstack(16) [[DOTFCA_3_INSERT121]], [4 x fp128] alignstack(16) [[DOTFCA_3_INSERT121]])
; CHECK-NEXT:    ret void
;
entry:
  %arg = alloca %struct.LongDouble4, align 16
  %arg.coerce.fca.0.extract = extractvalue [4 x fp128] %arg.coerce, 0
  store fp128 %arg.coerce.fca.0.extract, ptr %arg, align 16
  %arg.coerce.fca.1.extract = extractvalue [4 x fp128] %arg.coerce, 1
  %arg.coerce.fca.1.gep = getelementptr inbounds [4 x fp128], ptr %arg, i64 0, i64 1
  store fp128 %arg.coerce.fca.1.extract, ptr %arg.coerce.fca.1.gep, align 16
  %arg.coerce.fca.2.extract = extractvalue [4 x fp128] %arg.coerce, 2
  %arg.coerce.fca.2.gep = getelementptr inbounds [4 x fp128], ptr %arg, i64 0, i64 2
  store fp128 %arg.coerce.fca.2.extract, ptr %arg.coerce.fca.2.gep, align 16
  %arg.coerce.fca.3.extract = extractvalue [4 x fp128] %arg.coerce, 3
  %arg.coerce.fca.3.gep = getelementptr inbounds [4 x fp128], ptr %arg, i64 0, i64 3
  store fp128 %arg.coerce.fca.3.extract, ptr %arg.coerce.fca.3.gep, align 16
  call void @_Z3usePv(ptr noundef nonnull %arg)
  %agg.tmp.sroa.0.0.copyload = load fp128, ptr %arg, align 16
  %agg.tmp.sroa.2.0.copyload = load fp128, ptr %arg.coerce.fca.1.gep, align 16
  %agg.tmp.sroa.3.0.copyload = load fp128, ptr %arg.coerce.fca.2.gep, align 16
  %agg.tmp.sroa.4.0.copyload = load fp128, ptr %arg.coerce.fca.3.gep, align 16
  %.fca.0.insert118 = insertvalue [4 x fp128] poison, fp128 %agg.tmp.sroa.0.0.copyload, 0
  %.fca.1.insert119 = insertvalue [4 x fp128] %.fca.0.insert118, fp128 %agg.tmp.sroa.2.0.copyload, 1
  %.fca.2.insert120 = insertvalue [4 x fp128] %.fca.1.insert119, fp128 %agg.tmp.sroa.3.0.copyload, 2
  %.fca.3.insert121 = insertvalue [4 x fp128] %.fca.2.insert120, fp128 %agg.tmp.sroa.4.0.copyload, 3
  call void ([4 x fp128], i32, ...) @_Z5test2I11LongDouble4EvT_iz([4 x fp128] alignstack(16) %.fca.3.insert121, i32 noundef 20, [4 x fp128] alignstack(16) %.fca.3.insert121, [4 x fp128] alignstack(16) %.fca.3.insert121, [4 x fp128] alignstack(16) %.fca.3.insert121, [4 x fp128] alignstack(16) %.fca.3.insert121, [4 x fp128] alignstack(16) %.fca.3.insert121, [4 x fp128] alignstack(16) %.fca.3.insert121, [4 x fp128] alignstack(16) %.fca.3.insert121, [4 x fp128] alignstack(16) %.fca.3.insert121, [4 x fp128] alignstack(16) %.fca.3.insert121, [4 x fp128] alignstack(16) %.fca.3.insert121, [4 x fp128] alignstack(16) %.fca.3.insert121, [4 x fp128] alignstack(16) %.fca.3.insert121, [4 x fp128] alignstack(16) %.fca.3.insert121, [4 x fp128] alignstack(16) %.fca.3.insert121, [4 x fp128] alignstack(16) %.fca.3.insert121, [4 x fp128] alignstack(16) %.fca.3.insert121, [4 x fp128] alignstack(16) %.fca.3.insert121, [4 x fp128] alignstack(16) %.fca.3.insert121, [4 x fp128] alignstack(16) %.fca.3.insert121, [4 x fp128] alignstack(16) %.fca.3.insert121)
  ret void
}
