/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.kra;

import com.netscape.certsrv.base.Subsystem;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.base.ConfigStorage;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.KeyRequestRepository;
import com.netscape.kra.KeyRecoveryAuthority;
import org.dogtagpki.server.kra.KRAEngineConfig;

public class KRAEngine
extends CMSEngine {
    static KRAEngine instance;

    public KRAEngine() {
        super("KRA");
        instance = this;
    }

    public static KRAEngine getInstance() {
        return instance;
    }

    public KRAEngineConfig createConfig(ConfigStorage storage) throws Exception {
        return new KRAEngineConfig(storage);
    }

    public KRAEngineConfig getConfig() {
        return (KRAEngineConfig)this.mConfig;
    }

    public KeyRecoveryAuthority getKRA() {
        return (KeyRecoveryAuthority)this.getSubsystem("kra");
    }

    public KeyRequestRepository getKeyRequestRepository() {
        return (KeyRequestRepository)this.requestRepository;
    }

    public void initSubsystem(Subsystem subsystem, ConfigStore subsystemConfig) throws Exception {
        if (subsystem instanceof KeyRecoveryAuthority && this.isPreOpMode()) {
            return;
        }
        super.initSubsystem(subsystem, subsystemConfig);
    }

    public void startupSubsystems() throws Exception {
        super.startupSubsystems();
        KeyRecoveryAuthority kra = (KeyRecoveryAuthority)this.getSubsystem("kra");
        if (!this.isPreOpMode()) {
            logger.debug("KRAEngine: checking request serial number ranges for the KRA");
            this.requestRepository.checkRanges();
            logger.debug("KRAEngine: checking key serial number ranges");
            kra.getKeyRepository().checkRanges();
        }
    }
}

