/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.kra;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.MetaInfo;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.dbs.keydb.KeyId;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.SecurityDataArchivalProcessedEvent;
import com.netscape.certsrv.logging.event.SecurityDataArchivalRequestEvent;
import com.netscape.certsrv.logging.event.SecurityDataExportEvent;
import com.netscape.certsrv.logging.event.ServerSideKeyGenEvent;
import com.netscape.certsrv.logging.event.ServerSideKeyGenProcessedEvent;
import com.netscape.certsrv.request.IService;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.security.IStorageKeyUnit;
import com.netscape.cmscore.dbs.KeyRecord;
import com.netscape.cmscore.dbs.KeyRepository;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.security.JssSubsystem;
import com.netscape.cmsutil.crypto.CryptoUtil;
import com.netscape.kra.EncryptionUnit;
import com.netscape.kra.KeyRecoveryAuthority;
import com.netscape.kra.TransportKeyUnit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.SecureRandom;
import org.dogtagpki.server.kra.KRAEngine;
import org.dogtagpki.server.kra.KRAEngineConfig;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.netscape.security.provider.RSAPublicKey;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.util.WrappingParams;
import org.mozilla.jss.pkcs11.PK11SymKey;
import org.mozilla.jss.pkix.crmf.PKIArchiveOptions;
import org.mozilla.jss.util.Base64OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetkeyKeygenService
implements IService {
    public static Logger logger = LoggerFactory.getLogger(NetkeyKeygenService.class);
    public static final String ATTR_KEY_RECORD = "keyRecord";
    public static final String ATTR_PROOF_OF_ARCHIVAL = "proofOfArchival";
    private KeyRecoveryAuthority mKRA;
    private TransportKeyUnit mTransportUnit;
    private IStorageKeyUnit mStorageUnit = null;

    public NetkeyKeygenService(KeyRecoveryAuthority kra) {
        this.mKRA = kra;
        this.mTransportUnit = kra.getTransportKeyUnit();
        this.mStorageUnit = kra.getStorageKeyUnit();
    }

    public PKIArchiveOptions toPKIArchiveOptions(byte[] options) {
        ByteArrayInputStream bis = new ByteArrayInputStream(options);
        PKIArchiveOptions archOpts = null;
        try {
            archOpts = (PKIArchiveOptions)new PKIArchiveOptions.Template().decode((InputStream)bis);
        }
        catch (Exception e) {
            logger.warn("NetkeyKeygenService: getPKIArchiveOptions " + e.getMessage(), (Throwable)e);
        }
        return archOpts;
    }

    private static String base64Encode(byte[] bytes) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (Base64OutputStream b64 = new Base64OutputStream(new PrintStream(new FilterOutputStream(output)));){
            b64.write(bytes);
            b64.flush();
            String string = output.toString("8859_1");
            return string;
        }
    }

    public boolean serviceRequest(Request request) throws EBaseException {
        CryptoToken keygenToken;
        KRAEngine engine = KRAEngine.getInstance();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        byte[] iv = new byte[]{1, 1, 1, 1, 1, 1, 1, 1};
        String iv_s = "";
        try {
            SecureRandom random = jssSubsystem.getRandomNumberGenerator();
            random.nextBytes(iv);
        }
        catch (Exception e) {
            logger.error("NetkeyKeygenService.serviceRequest:  " + e.getMessage(), (Throwable)e);
            throw new EBaseException(e);
        }
        IVParameterSpec algParam = new IVParameterSpec(iv);
        KRAEngineConfig configStore = engine.getConfig();
        boolean allowEncDecrypt_archival = configStore.getBoolean("kra.allowEncDecrypt.archival", false);
        boolean useOAEPKeyWrap = configStore.getUseOAEPKeyWrap();
        byte[] wrapped_des_key = null;
        boolean archive = true;
        byte[] publicKeyData = null;
        String PubKey = "";
        String rArchive = request.getExtDataInString("archive");
        if (rArchive.equals("true")) {
            archive = true;
            logger.debug("NetkeyKeygenService: serviceRequest archival requested for serverSideKeyGen");
        } else {
            archive = false;
            logger.debug("NetkeyKeygenService: serviceRequest archival not requested for serverSideKeyGen");
        }
        String rCUID = request.getExtDataInString("CUID");
        String rUserid = request.getExtDataInString("USERID");
        String rKeytype = request.getExtDataInString("keytype");
        RequestId requestId = request.getRequestId();
        Auditor auditor = engine.getAuditor();
        String auditSubjectID = rCUID + ":" + rUserid;
        SessionContext sContext = SessionContext.getContext();
        String agentId = "";
        if (sContext != null) {
            agentId = (String)sContext.get((Object)"userid");
        }
        auditor.log((LogEvent)new ServerSideKeyGenEvent(agentId, "Success", auditSubjectID, requestId));
        String rWrappedDesKeyString = request.getExtDataInString("drm_trans_desKey");
        request.setExtData("delayLDAPCommit", "true");
        request.setExtData("drm_trans_desKey", "");
        wrapped_des_key = Utils.SpecialDecode((String)rWrappedDesKeyString);
        logger.debug("NetkeyKeygenService: wrapped_des_key specialDecoded");
        if (rKeytype == null || rKeytype.equals("")) {
            logger.debug("NetkeyKeygenService: serviceRequest: key type is null");
            rKeytype = "RSA";
        } else {
            logger.debug("NetkeyKeygenService: serviceRequest: key type = " + rKeytype);
        }
        String rKeysize = "2048";
        int keysize = 2048;
        String rKeycurve = "nistp256";
        if (rKeytype.equals("EC")) {
            rKeycurve = request.getExtDataInString("eckeycurve");
            if (rKeycurve == null || rKeycurve.equals("")) {
                rKeycurve = "nistp256";
            }
        } else {
            rKeysize = request.getExtDataInString("keysize");
            keysize = Integer.parseInt(rKeysize);
        }
        if ((keygenToken = this.mKRA.getKeygenToken()) == null) {
            logger.warn("NetkeyKeygenService: failed getting keygenToken");
            request.setExtData("Result", Integer.valueOf(10));
            return false;
        }
        logger.debug("NetkeyKeygenService: got keygenToken");
        if (wrapped_des_key != null && wrapped_des_key.length > 0) {
            PrivateKey privKey;
            KeyWrapAlgorithm wrapAlg = KeyWrapAlgorithm.RSA;
            if (useOAEPKeyWrap) {
                wrapAlg = KeyWrapAlgorithm.RSA_OAEP;
            }
            WrappingParams wrapParams = new WrappingParams(SymmetricKey.DES3, KeyGenAlgorithm.DES3, 0, wrapAlg, EncryptionAlgorithm.DES3_CBC_PAD, KeyWrapAlgorithm.DES3_CBC_PAD, EncryptionUnit.IV, EncryptionUnit.IV);
            KeyPair keypair = null;
            logger.debug("NetkeyKeygenService: about to generate key pair");
            keypair = this.mKRA.generateKeyPair(rKeytype, keysize, rKeycurve, null, null);
            if (keypair == null) {
                logger.warn("NetkeyKeygenService: failed generating key pair for " + rCUID + ":" + rUserid);
                request.setExtData("Result", Integer.valueOf(4));
                auditor.log((LogEvent)new ServerSideKeyGenProcessedEvent(agentId, "Failure", auditSubjectID, requestId, null));
                return false;
            }
            logger.debug("NetkeyKeygenService: finished generate key pair for " + rCUID + ":" + rUserid);
            try {
                publicKeyData = keypair.getPublic().getEncoded();
                if (publicKeyData == null) {
                    request.setExtData("Result", Integer.valueOf(4));
                    logger.warn("NetkeyKeygenService: failed getting publickey encoded");
                    return false;
                }
                if (rKeytype.equals("EC")) {
                    PubKey = Utils.SpecialEncode((byte[])publicKeyData);
                    logger.debug("NetkeyKeygenService: EC PubKey special encoded");
                } else {
                    PubKey = NetkeyKeygenService.base64Encode(publicKeyData);
                }
                request.setExtData("public_key", PubKey);
                auditor.log((LogEvent)new ServerSideKeyGenProcessedEvent(agentId, "Success", auditSubjectID, requestId, PubKey));
                privKey = keypair.getPrivate();
                if (privKey == null) {
                    request.setExtData("Result", Integer.valueOf(4));
                    logger.warn("NetkeyKeygenService: failed getting private key");
                    return false;
                }
                logger.debug("NetkeyKeygenService: got private key");
                PK11SymKey sk = null;
                try {
                    sk = (PK11SymKey)this.mTransportUnit.unwrap_sym(wrapped_des_key, wrapParams);
                    logger.debug("NetkeyKeygenService: received DES key");
                }
                catch (Exception e) {
                    logger.warn("NetkeyKeygenService: no DES key: " + e);
                    request.setExtData("Result", Integer.valueOf(4));
                    return false;
                }
                logger.debug("NetkeyKeygenService: wrapper token=" + keygenToken.getName());
                logger.debug("NetkeyKeygenService: key transport key is on slot: " + sk.getOwningToken().getName());
                byte[] wrapped = CryptoUtil.wrapUsingSymmetricKey((CryptoToken)keygenToken, (SymmetricKey)sk, (org.mozilla.jss.crypto.PrivateKey)((org.mozilla.jss.crypto.PrivateKey)privKey), (IVParameterSpec)algParam, (KeyWrapAlgorithm)KeyWrapAlgorithm.DES3_CBC_PAD);
                String wrappedPrivKeyString = Utils.SpecialEncode((byte[])wrapped);
                if (wrappedPrivKeyString == null) {
                    request.setExtData("Result", Integer.valueOf(4));
                    logger.warn("NetkeyKeygenService: failed generating wrapped private key");
                    auditor.log((LogEvent)new SecurityDataExportEvent(agentId, "Failure", auditSubjectID, null, "NetkeyKeygenService: failed generating wrapped private key", PubKey));
                    return false;
                }
                request.setExtData("wrappedUserPrivate", wrappedPrivKeyString);
                auditor.log((LogEvent)new SecurityDataExportEvent(agentId, "Success", auditSubjectID, null, null, PubKey));
                iv_s = Utils.SpecialEncode((byte[])iv);
                request.setExtData("iv_s", iv_s);
            }
            catch (Exception e) {
                logger.warn("NetkeyKeygenService: " + e.getMessage(), (Throwable)e);
                request.setExtData("Result", Integer.valueOf(4));
                return false;
            }
            try {
                if (archive) {
                    auditor.log((LogEvent)SecurityDataArchivalRequestEvent.createSuccessEvent((String)agentId, (String)auditSubjectID, (RequestId)request.getRequestId(), null));
                    logger.debug("KRA encrypts private key to put on internal ldap db");
                    byte[] privateKeyData = null;
                    WrappingParams params = null;
                    try {
                        params = this.mStorageUnit.getWrappingParams(allowEncDecrypt_archival);
                        params.setPayloadEncryptionIV(params.getPayloadWrappingIV());
                        logger.debug("NetKeyKeygenService: wrap params: " + params);
                        privateKeyData = this.mStorageUnit.wrap((org.mozilla.jss.crypto.PrivateKey)privKey, params);
                    }
                    catch (Exception e) {
                        request.setExtData("Result", Integer.valueOf(4));
                        throw new Exception("Unable to wrap private key with storage key", e);
                    }
                    logger.debug("NetkeyKeygenService: privatekey encryption by storage unit successful");
                    KeyRecord rec = new KeyRecord(null, publicKeyData, privateKeyData, rCUID + ":" + rUserid, keypair.getPublic().getAlgorithm(), agentId);
                    logger.debug("NetkeyKeygenService: got key record");
                    if (rKeytype.equals("RSA")) {
                        try {
                            RSAPublicKey rsaPublicKey = new RSAPublicKey(publicKeyData);
                            rec.setKeySize(Integer.valueOf(rsaPublicKey.getKeySize()));
                        }
                        catch (InvalidKeyException e) {
                            request.setExtData("Result", Integer.valueOf(11));
                            throw new Exception("Invalid RSA public key", e);
                        }
                    }
                    if (rKeytype.equals("EC")) {
                        logger.debug("NetkeyKeygenService: alg is EC");
                        String oidDescription = "UNDETERMINED";
                        MetaInfo metaInfo = new MetaInfo();
                        try {
                            byte[] curve = ASN1Util.getECCurveBytesByX509PublicKeyBytes((byte[])publicKeyData, (boolean)false);
                            if (curve.length != 0) {
                                oidDescription = ASN1Util.getOIDdescription((byte[])curve);
                            } else {
                                byte[] curveTS = ASN1Util.getECCurveBytesByX509PublicKeyBytes((byte[])publicKeyData, (boolean)true);
                                if (curveTS.length != 0) {
                                    oidDescription = Utils.base64encode((byte[])curveTS, (boolean)true);
                                }
                            }
                        }
                        catch (Exception e) {
                            logger.warn("NetkeyKeygenService: ASN1Util.getECCurveBytesByX509PublicKeyByte(): " + e.getMessage(), (Throwable)e);
                            logger.warn("NetkeyKeygenService: exception allowed. continue");
                        }
                        metaInfo.set("EllipticCurve", (Object)oidDescription);
                        rec.set("keyMetaInfo", (Object)metaInfo);
                        rec.setKeySize(Integer.valueOf(-1));
                    }
                    KeyRepository storage = this.mKRA.getKeyRepository();
                    BigInteger serialNo = storage.getNextSerialNumber();
                    if (serialNo == null) {
                        request.setExtData("Result", Integer.valueOf(11));
                        throw new Exception("Unable to generate next serial number");
                    }
                    rec.setWrappingParams(params, allowEncDecrypt_archival);
                    logger.debug("NetkeyKeygenService: before addKeyRecord");
                    rec.set("keySerialNumber", (Object)serialNo);
                    request.setExtData(ATTR_KEY_RECORD, serialNo);
                    storage.addKeyRecord(rec);
                    logger.debug("NetkeyKeygenService: key archived for " + rCUID + ":" + rUserid);
                    auditor.log((LogEvent)SecurityDataArchivalProcessedEvent.createSuccessEvent((String)agentId, (String)auditSubjectID, (RequestId)request.getRequestId(), null, (KeyId)new KeyId(serialNo), (String)PubKey));
                }
                request.setExtData("Result", Integer.valueOf(1));
            }
            catch (Exception e) {
                logger.warn("NetkeyKeygenService: " + e.getMessage(), (Throwable)e);
                auditor.log((LogEvent)SecurityDataArchivalProcessedEvent.createFailureEvent((String)agentId, (String)auditSubjectID, (RequestId)request.getRequestId(), null, null, (String)e.toString(), (String)PubKey));
                Integer result = request.getExtDataInInteger("Result");
                if (result == null) {
                    request.setExtData("Result", Integer.valueOf(4));
                }
                return false;
            }
        }
        request.setExtData("Result", Integer.valueOf(2));
        return true;
    }
}

