/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.kra;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.MetaInfo;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.dbs.keydb.KeyId;
import com.netscape.certsrv.kra.EKRAException;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.SecurityDataArchivalProcessedEvent;
import com.netscape.certsrv.request.IService;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.security.IStorageKeyUnit;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.crmf.CRMFParser;
import com.netscape.cmscore.crmf.PKIArchiveOptionsContainer;
import com.netscape.cmscore.dbs.KeyRecord;
import com.netscape.cmscore.dbs.KeyRepository;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.security.JssSubsystem;
import com.netscape.cmscore.util.StatsSubsystem;
import com.netscape.kra.ArchiveOptions;
import com.netscape.kra.KeyRecoveryAuthority;
import com.netscape.kra.TransportKeyUnit;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Vector;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.kra.KRAEngine;
import org.dogtagpki.server.kra.KRAEngineConfig;
import org.dogtagpki.server.kra.ProofOfArchival;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.provider.RSAPublicKey;
import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.util.WrappingParams;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.CertificateX509Key;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.mozilla.jss.pkix.crmf.CertReqMsg;
import org.mozilla.jss.pkix.crmf.CertRequest;
import org.mozilla.jss.pkix.crmf.PKIArchiveOptions;
import org.mozilla.jss.pkix.primitive.AVA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnrollmentService
implements IService {
    public static Logger logger = LoggerFactory.getLogger(EnrollmentService.class);
    public static final String CRMF_REQUEST = "CRMFRequest";
    public static final String ATTR_KEY_RECORD = "keyRecord";
    public static final String ATTR_PROOF_OF_ARCHIVAL = "proofOfArchival";
    private KeyRecoveryAuthority mKRA;
    private TransportKeyUnit mTransportUnit;
    private IStorageKeyUnit mStorageUnit = null;
    private static final OBJECT_IDENTIFIER PKIARCHIVEOPTIONS_OID = new OBJECT_IDENTIFIER(new long[]{1L, 3L, 6L, 1L, 5L, 5L, 7L, 5L, 1L, 4L});

    public EnrollmentService(KeyRecoveryAuthority kra) {
        this.mKRA = kra;
        this.mTransportUnit = kra.getTransportKeyUnit();
        this.mStorageUnit = kra.getStorageKeyUnit();
    }

    public PKIArchiveOptions toPKIArchiveOptions(byte[] options) {
        ByteArrayInputStream bis = new ByteArrayInputStream(options);
        PKIArchiveOptions archOpts = null;
        try {
            archOpts = (PKIArchiveOptions)new PKIArchiveOptions.Template().decode((InputStream)bis);
        }
        catch (Exception e) {
            logger.warn("EnrollProfile: getPKIArchiveOptions " + e.getMessage(), (Throwable)e);
        }
        return archOpts;
    }

    public boolean serviceRequest(Request request) throws EBaseException {
        KRAEngine engine = KRAEngine.getInstance();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        KRAEngineConfig config = null;
        Boolean allowEncDecrypt_archival = false;
        try {
            config = engine.getConfig();
            allowEncDecrypt_archival = config.getBoolean("kra.allowEncDecrypt.archival", false);
        }
        catch (Exception e) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_CERT_ERROR", (String[])new String[]{e.toString()}));
        }
        StatsSubsystem statsSub = (StatsSubsystem)engine.getSubsystem("stats");
        if (statsSub != null) {
            statsSub.startTiming("archival", true);
        }
        Auditor auditor = engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        String auditRequesterID = this.auditRequesterID();
        String auditPublicKey = "$Unidentified$";
        RequestId requestId = request.getRequestId();
        logger.debug("EnrollmentServlet: KRA services enrollment request");
        request.setExtData("delayLDAPCommit", "true");
        String transportCert = request.getExtDataInString("req_transport_cert");
        if (transportCert != null && transportCert.length() > 0) {
            logger.debug("EnrollmentService: serviceRequest: transportCert is in request");
            request.deleteExtData("req_transport_cert");
        } else {
            logger.warn("EnrollmentService: serviceRequest: Missing transport certificate");
        }
        X509Certificate tCert = this.mTransportUnit.verifyCertificate(transportCert);
        logger.debug("EnrollmentService: tCert=" + (String)(tCert != null ? tCert.getSerialNumber().toString() + ":" + tCert.getSubjectDN().toString() + ":" : "Invalid transport certificate"));
        SessionContext sContext = SessionContext.getContext();
        String agentId = (String)sContext.get((Object)"userid");
        AuthToken authToken = (AuthToken)sContext.get((Object)"AuthToken");
        logger.info("KRA services enrollment request");
        byte[] unwrapped = null;
        byte[] tmp_unwrapped = null;
        PKIArchiveOptionsContainer[] aOpts = null;
        String profileId = request.getExtDataInString("profileId");
        if (profileId == null || profileId.equals("")) {
            try {
                aOpts = CRMFParser.getPKIArchiveOptions((String)request.getExtDataInString("HTTP_PARAMS", CRMF_REQUEST));
            }
            catch (IOException e) {
                auditor.log((LogEvent)SecurityDataArchivalProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (RequestId)requestId, null, null, (String)e.toString(), null));
                logger.error("EnrollmentService: serviceRequest: CRMFParser.getPKIArchiveOptions() failed: " + e.toString());
                throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_INVALID_PRIVATE_KEY", (String[])new String[0]) + ": " + e, (Exception)e);
            }
        } else {
            PKIArchiveOptions options = this.toPKIArchiveOptions(request.getExtDataInByteArray("req_archive_options"));
            aOpts = new PKIArchiveOptionsContainer[]{new PKIArchiveOptionsContainer(options, 0)};
            request.setExtData("dbStatus", "NOT_UPDATED");
        }
        for (int i = 0; i < aOpts.length; ++i) {
            String owner;
            X509Key publicKey;
            byte[] publicKeyData;
            ArchiveOptions opts = new ArchiveOptions(aOpts[i].mAO);
            if (allowEncDecrypt_archival.booleanValue()) {
                if (tCert == null) {
                    logger.error("EnrollmentService: Invalid transport certificate: " + transportCert);
                    throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_INVALID_TRANSPORT_CERT", (String[])new String[0]));
                }
                if (statsSub != null) {
                    statsSub.startTiming("decrypt_user_key");
                }
                logger.info("KRA decrypts external private");
                logger.debug("EnrollmentService::about to decryptExternalPrivate");
                try {
                    tmp_unwrapped = this.mTransportUnit.decryptExternalPrivate(opts.getEncSymmKey(), opts.getSymmAlgOID(), opts.getSymmAlgParams(), opts.getEncValue(), tCert);
                }
                catch (Exception e) {
                    logger.error(CMS.getLogMessage((String)"CMSCORE_KRA_UNWRAP_USER_KEY", (Object[])new Object[0]), (Throwable)e);
                    auditor.log((LogEvent)SecurityDataArchivalProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (RequestId)requestId, null, null, (String)e.toString(), null));
                    logger.error("EnrollmentService: serviceRequest: mTransportUnit.decryptExternalPrivate() failed: " + e.toString());
                    throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_INVALID_PRIVATE_KEY", (String[])new String[0]) + ": " + e, e);
                }
                if (statsSub != null) {
                    statsSub.endTiming("decrypt_user_key");
                }
                logger.debug("EnrollmentService::finished decryptExternalPrivate");
                int first = 0;
                for (int j = 0; j < tmp_unwrapped.length && tmp_unwrapped[j] == 0; ++j) {
                    ++first;
                }
                unwrapped = Arrays.copyOfRange(tmp_unwrapped, first, tmp_unwrapped.length);
                jssSubsystem.obscureBytes(tmp_unwrapped);
            }
            if ((publicKeyData = (publicKey = this.getPublicKey(request, aOpts[i].mReqPos)).getEncoded()) == null) {
                String message = CMS.getLogMessage((String)"CMSCORE_KRA_PUBLIC_NOT_FOUND", (Object[])new Object[0]);
                logger.error(message);
                auditor.log((LogEvent)SecurityDataArchivalProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (RequestId)requestId, null, null, (String)message, null));
                throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_INVALID_PUBLIC_KEY", (String[])new String[0]) + ": " + message);
            }
            String keyAlg = publicKey.getAlgorithm();
            logger.debug("EnrollmentService: algorithm of key to archive is: " + keyAlg);
            PublicKey pubkey = null;
            PrivateKey entityPrivKey = null;
            if (!allowEncDecrypt_archival.booleanValue()) {
                if (tCert == null) {
                    logger.error("EnrollmentService: Invalid transport certificate: " + transportCert);
                    throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_INVALID_TRANSPORT_CERT", (String[])new String[0]));
                }
                try {
                    pubkey = X509Key.parsePublicKey((DerValue)new DerValue(publicKeyData));
                }
                catch (Exception e) {
                    logger.error("EnrollmentService: parsePublicKey:" + e.getMessage(), (Throwable)e);
                    throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_INVALID_PUBLIC_KEY", (String[])new String[0]), e);
                }
                try {
                    entityPrivKey = this.mTransportUnit.unwrap(opts.getEncSymmKey(), opts.getSymmAlgOID(), opts.getSymmAlgParams(), opts.getEncValue(), pubkey, tCert);
                }
                catch (Exception e) {
                    logger.error(CMS.getLogMessage((String)"CMSCORE_KRA_WRAP_USER_KEY", (Object[])new Object[0]), (Throwable)e);
                    auditor.log((LogEvent)SecurityDataArchivalProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (RequestId)requestId, null, null, (String)e.toString(), null));
                    logger.error("EnrollmentService: serviceRequest: mTransportUnit.unwrap() failed: " + e.toString());
                    throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_INVALID_PRIVATE_KEY", (String[])new String[0]) + ": " + e, e);
                }
            }
            if (keyAlg.equals("RSA") && allowEncDecrypt_archival.booleanValue()) {
                if (statsSub != null) {
                    statsSub.startTiming("verify_key");
                }
                try {
                    this.verifyKeyPair(publicKeyData, unwrapped);
                }
                catch (Exception e) {
                    logger.error("EnrollmentService: " + e.getMessage(), (Throwable)e);
                    jssSubsystem.obscureBytes(unwrapped);
                    auditor.log((LogEvent)SecurityDataArchivalProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (RequestId)requestId, null, null, (String)e.toString(), null));
                    throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_INVALID_PUBLIC_KEY", (String[])new String[0]) + ": " + e, e);
                }
                if (statsSub != null) {
                    statsSub.endTiming("verify_key");
                }
            }
            if ((owner = this.getOwnerName(request, aOpts[i].mReqPos)) == null) {
                String message = CMS.getLogMessage((String)"CMSCORE_KRA_OWNER_NAME_NOT_FOUND", (Object[])new Object[0]);
                logger.error(message);
                auditor.log((LogEvent)SecurityDataArchivalProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (RequestId)requestId, null, null, (String)message, null));
                throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_INVALID_KEYRECORD", (String[])new String[0]) + ": " + message);
            }
            logger.info("KRA encrypts internal private");
            if (statsSub != null) {
                statsSub.startTiming("encrypt_user_key");
            }
            byte[] privateKeyData = null;
            WrappingParams params = null;
            try {
                params = this.mStorageUnit.getWrappingParams(allowEncDecrypt_archival.booleanValue());
                privateKeyData = allowEncDecrypt_archival.booleanValue() ? this.mStorageUnit.encryptInternalPrivate(unwrapped, params) : this.mStorageUnit.wrap(entityPrivKey, params);
            }
            catch (Exception e) {
                logger.error(CMS.getLogMessage((String)"CMSCORE_KRA_WRAP_USER_KEY", (Object[])new Object[0]), (Throwable)e);
                auditor.log((LogEvent)SecurityDataArchivalProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (RequestId)requestId, null, null, (String)e.toString(), null));
                logger.error("EnrollmentService: serviceRequest: mStorageUnit encrypt or wrap call failed: " + e.toString());
                throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_INVALID_PRIVATE_KEY", (String[])new String[0]) + ": " + e, e);
            }
            finally {
                jssSubsystem.obscureBytes(unwrapped);
            }
            if (statsSub != null) {
                statsSub.endTiming("encrypt_user_key");
            }
            KeyRecord rec = new KeyRecord(null, publicKeyData, privateKeyData, owner, publicKey.getAlgorithmId().getOID().toString(), agentId);
            if (keyAlg.equals("RSA")) {
                try {
                    RSAPublicKey rsaPublicKey = new RSAPublicKey(publicKeyData);
                    rec.setKeySize(Integer.valueOf(rsaPublicKey.getKeySize()));
                }
                catch (InvalidKeyException e) {
                    auditor.log((LogEvent)SecurityDataArchivalProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (RequestId)requestId, null, null, (String)e.toString(), null));
                    throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_INVALID_KEYRECORD", (String[])new String[0]) + ": " + e, (Exception)e);
                }
            }
            if (keyAlg.equals("EC")) {
                String oidDescription = "UNDETERMINED";
                MetaInfo metaInfo = new MetaInfo();
                try {
                    byte[] curve = ASN1Util.getECCurveBytesByX509PublicKeyBytes((byte[])publicKeyData, (boolean)false);
                    if (curve.length != 0) {
                        oidDescription = ASN1Util.getOIDdescription((byte[])curve);
                    } else {
                        byte[] curveTS = ASN1Util.getECCurveBytesByX509PublicKeyBytes((byte[])publicKeyData, (boolean)true);
                        if (curveTS.length != 0) {
                            oidDescription = Utils.base64encode((byte[])curveTS, (boolean)true);
                        }
                    }
                }
                catch (Exception e) {
                    logger.warn("EnrollmentService: ASN1Util.getECCurveBytesByX509PublicKeyByte() throws exception: " + e.getMessage(), (Throwable)e);
                    logger.warn("EnrollmentService: exception alowed. continue");
                }
                metaInfo.set("EllipticCurve", (Object)oidDescription);
                rec.set("keyMetaInfo", (Object)metaInfo);
                rec.setKeySize(Integer.valueOf(-1));
            }
            if (rec.getSerialNumber() != null) {
                String message = CMS.getLogMessage((String)"CMSCORE_KRA_INVALID_SERIAL_NUMBER", (Object[])new Object[]{rec.getSerialNumber().toString()});
                logger.error(message);
                auditor.log((LogEvent)SecurityDataArchivalProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (RequestId)requestId, null, null, (String)message, null));
                throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_INVALID_STATE", (String[])new String[0]) + ": " + message);
            }
            String realm = request.getRealm();
            if (realm != null) {
                rec.set("realm", (Object)realm);
            }
            try {
                rec.setWrappingParams(params, allowEncDecrypt_archival.booleanValue());
            }
            catch (Exception e) {
                logger.error("Failed to store wrapping parameters", (Throwable)e);
                auditor.log((LogEvent)SecurityDataArchivalProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (RequestId)requestId, null, null, (String)e.toString(), null));
                throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_INVALID_STATE", (String[])new String[0]) + ": " + e, e);
            }
            KeyRepository storage = this.mKRA.getKeyRepository();
            BigInteger serialNo = storage.getNextSerialNumber();
            if (serialNo == null) {
                String message = CMS.getLogMessage((String)"CMSCORE_KRA_GET_NEXT_SERIAL", (Object[])new Object[0]);
                logger.error(message);
                auditor.log((LogEvent)SecurityDataArchivalProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (RequestId)requestId, null, null, (String)message, null));
                throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_INVALID_STATE", (String[])new String[0]) + ": " + message);
            }
            if (i == 0) {
                rec.set("keySerialNumber", (Object)serialNo);
                request.setExtData(ATTR_KEY_RECORD, serialNo);
            } else {
                rec.set("keySerialNumber" + i, (Object)serialNo);
                request.setExtData(ATTR_KEY_RECORD + i, serialNo);
            }
            logger.info("KRA adding key record " + serialNo);
            if (statsSub != null) {
                statsSub.startTiming("store_key");
            }
            storage.addKeyRecord(rec);
            if (statsSub != null) {
                statsSub.endTiming("store_key");
            }
            logger.debug("EnrollmentService: key record 0x" + serialNo.toString(16) + " (" + owner + ") archived");
            logger.info("key record 0x" + serialNo.toString(16) + " (" + owner + ") archived");
            String authMgr = "noAuthManager";
            if (authToken != null) {
                authMgr = authToken.getInString("authMgrInstName");
            }
            logger.info("{} reqID {} {} authenticated by {} is {} DN requested: {} {}", new Object[]{"archival", request.getRequestId(), "fromAgent agentID: " + agentId, authMgr, "completed", owner, "serial number: 0x" + serialNo.toString(16)});
            auditPublicKey = this.auditPublicKey(rec);
            auditor.log((LogEvent)SecurityDataArchivalProcessedEvent.createSuccessEvent((String)auditSubjectID, (String)auditRequesterID, (RequestId)requestId, null, (KeyId)new KeyId(rec.getSerialNumber()), (String)auditPublicKey));
            ProofOfArchival mProof = new ProofOfArchival(serialNo, owner, this.mKRA.getX500Name().toString(), rec.getCreateTime());
            DerOutputStream mProofOut = new DerOutputStream();
            mProof.encode(mProofOut);
            if (i == 0) {
                request.setExtData(ATTR_PROOF_OF_ARCHIVAL, mProofOut.toByteArray());
                continue;
            }
            request.setExtData(ATTR_PROOF_OF_ARCHIVAL + i, mProofOut.toByteArray());
        }
        request.setExtData("Result", Request.RES_SUCCESS);
        request.setExtData("cert_request", "");
        request.setExtData("req_archive_options", "");
        request.setExtData(ATTR_PROOF_OF_ARCHIVAL, "");
        request.setExtData("req_key", "");
        request.deleteExtData("cert_request");
        request.deleteExtData("req_archive_options");
        request.deleteExtData(ATTR_PROOF_OF_ARCHIVAL);
        request.deleteExtData("req_key");
        request.setExtData("delayLDAPCommit", "false");
        logger.info("KRA updating request");
        engine.getRequestRepository().updateRequest(request);
        if (statsSub != null) {
            statsSub.endTiming("archival");
        }
        return true;
    }

    public void verifyKeyPair(byte[] publicKeyData, byte[] privateKeyData) throws Exception {
        DerValue publicKeyVal = new DerValue(publicKeyData);
        DerInputStream publicKeyIn = publicKeyVal.data;
        publicKeyIn.getSequence(0);
        DerValue publicKeyDer = new DerValue(publicKeyIn.getBitString());
        DerInputStream publicKeyDerIn = publicKeyDer.data;
        BigInt publicKeyModulus = publicKeyDerIn.getInteger();
        BigInt publicKeyExponent = publicKeyDerIn.getInteger();
        DerValue privateKeyVal = new DerValue(privateKeyData);
        if (privateKeyVal.tag != 48) {
            throw new Exception("Invalid DER tag in private key data: " + privateKeyVal.tag);
        }
        DerInputStream privateKeyIn = privateKeyVal.data;
        privateKeyIn.getInteger();
        privateKeyIn.getSequence(0);
        DerValue privateKeyDer = new DerValue(privateKeyIn.getOctetString());
        DerInputStream privateKeyDerIn = privateKeyDer.data;
        BigInt privateKeyVersion = privateKeyDerIn.getInteger();
        BigInt privateKeyModulus = privateKeyDerIn.getInteger();
        BigInt privateKeyExponent = privateKeyDerIn.getInteger();
        if (!publicKeyModulus.equals(privateKeyModulus)) {
            logger.error("verifyKeyPair modulus mismatch publicKeyModulus=" + publicKeyModulus + " privateKeyModulus=" + privateKeyModulus);
            throw new Exception("Modulus mismatch");
        }
        if (!publicKeyExponent.equals(privateKeyExponent)) {
            logger.error("verifyKeyPair exponent mismatch publicKeyExponent=" + publicKeyExponent + " privateKeyExponent=" + privateKeyExponent);
            throw new Exception("Exponent mismatch");
        }
    }

    public static PKIArchiveOptionsContainer[] getPKIArchiveOptions(String crmfBlob) throws EBaseException {
        Vector<PKIArchiveOptionsContainer> options = new Vector<PKIArchiveOptionsContainer>();
        logger.debug("EnrollmentService::getPKIArchiveOptions> crmfBlob=" + crmfBlob);
        byte[] crmfBerBlob = null;
        crmfBerBlob = Utils.base64decode((String)crmfBlob);
        ByteArrayInputStream crmfBerBlobIn = new ByteArrayInputStream(crmfBerBlob);
        SEQUENCE crmfmsgs = null;
        try {
            crmfmsgs = (SEQUENCE)new SEQUENCE.OF_Template((ASN1Template)new CertReqMsg.Template()).decode((InputStream)crmfBerBlobIn);
        }
        catch (IOException e) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTRIBUTE", (String[])new String[]{"[crmf msgs]" + e.toString()}));
        }
        catch (InvalidBERException e) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTRIBUTE", (String[])new String[]{"[crmf msgs]" + e.toString()}));
        }
        for (int z = 0; z < crmfmsgs.size(); ++z) {
            CertReqMsg certReqMsg = (CertReqMsg)crmfmsgs.elementAt(z);
            CertRequest certReq = certReqMsg.getCertReq();
            AVA archAva = null;
            try {
                for (int i = 0; i < certReq.numControls(); ++i) {
                    AVA ava = certReq.controlAt(i);
                    OBJECT_IDENTIFIER oid = ava.getOID();
                    if (!oid.equals((Object)PKIARCHIVEOPTIONS_OID)) continue;
                    archAva = ava;
                    break;
                }
            }
            catch (Exception e) {
                throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTRIBUTE", (String[])new String[]{"no PKIArchiveOptions found " + e.toString()}));
            }
            if (archAva == null) continue;
            ANY archVal = archAva.getValue();
            ByteArrayInputStream bis = new ByteArrayInputStream(ASN1Util.encode((ASN1Value)archVal));
            PKIArchiveOptions archOpts = null;
            try {
                archOpts = (PKIArchiveOptions)new PKIArchiveOptions.Template().decode((InputStream)bis);
            }
            catch (IOException e) {
                throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTRIBUTE", (String[])new String[]{"[PKIArchiveOptions]" + e.toString()}));
            }
            catch (InvalidBERException e) {
                throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTRIBUTE", (String[])new String[]{"[PKIArchiveOptions]" + e.toString()}));
            }
            options.addElement(new PKIArchiveOptionsContainer(archOpts, z));
        }
        if (options.size() == 0) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTRIBUTE", (String[])new String[]{"PKIArchiveOptions found"}));
        }
        Object[] p = new PKIArchiveOptionsContainer[options.size()];
        options.copyInto(p);
        return p;
    }

    private X509Key getPublicKey(Request request, int i) throws EBaseException {
        String profileId = request.getExtDataInString("profileId");
        if (profileId != null && !profileId.equals("")) {
            byte[] certKeyData = request.getExtDataInByteArray("req_key");
            if (certKeyData != null) {
                try {
                    CertificateX509Key x509key = new CertificateX509Key((InputStream)new ByteArrayInputStream(certKeyData));
                    return (X509Key)x509key.get("value");
                }
                catch (Exception e1) {
                    logger.warn("EnrollService: (Archival) getPublicKey " + e1.getMessage(), (Throwable)e1);
                }
            }
            return null;
        }
        X509CertInfo[] certInfo = request.getExtDataInCertInfoArray("CERT_INFO");
        CertificateX509Key pX509Key = null;
        if (certInfo == null) {
            throw new EBaseException(CMS.getLogMessage((String)"CMS_BASE_CERT_NOT_FOUND", (Object[])new Object[0]));
        }
        try {
            pX509Key = (CertificateX509Key)certInfo[i].get("key");
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_KRA_GET_PUBLIC_KEY", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTRIBUTE", (String[])new String[]{"[key]" + e.toString()}), (Throwable)e);
        }
        catch (CertificateException e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_KRA_GET_PUBLIC_KEY", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTRIBUTE", (String[])new String[]{"[key]" + e.toString()}), (Throwable)e);
        }
        X509Key pKey = null;
        try {
            pKey = (X509Key)pX509Key.get("value");
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_KRA_GET_PUBLIC_KEY", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTRIBUTE", (String[])new String[]{"[value]" + e.toString()}), (Throwable)e);
        }
        return pKey;
    }

    private String getOwnerName(Request request, int i) throws EBaseException {
        CertificateSubjectName sub;
        String profileId = request.getExtDataInString("profileId");
        if (profileId != null && !profileId.equals("") && (sub = request.getExtDataInCertSubjectName("req_subject_name")) != null) {
            return sub.toString();
        }
        X509CertInfo[] certInfo = request.getExtDataInCertInfoArray("CERT_INFO");
        if (certInfo == null) {
            throw new EBaseException(CMS.getLogMessage((String)"CMS_BASE_CERT_NOT_FOUND", (Object[])new Object[0]));
        }
        CertificateSubjectName pSub = null;
        try {
            pSub = (CertificateSubjectName)certInfo[0].get("subject");
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_KRA_GET_OWNER_NAME", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTRIBUTE", (String[])new String[]{"[subject]" + e.toString()}), (Throwable)e);
        }
        catch (CertificateException e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_KRA_GET_OWNER_NAME", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTRIBUTE", (String[])new String[]{"[subject]" + e.toString()}), (Throwable)e);
        }
        String owner = pSub.toString();
        return owner;
    }

    private String auditPublicKey(KeyRecord rec) {
        String checkKey;
        if (rec == null) {
            return "<null>";
        }
        byte[] rawData = null;
        try {
            rawData = rec.getPublicKeyData();
        }
        catch (EBaseException e) {
            return "<null>";
        }
        String key = "";
        if (rawData != null) {
            String base64Data = null;
            base64Data = Utils.base64encode((byte[])rawData, (boolean)true).trim();
            key = base64Data.replace("\r", "").replace("\n", "");
        }
        return (checkKey = key.trim()).equals("") ? "<null>" : checkKey;
    }

    private String auditSubjectID() {
        String subjectID = null;
        SessionContext auditContext = SessionContext.getExistingContext();
        subjectID = auditContext != null ? ((subjectID = (String)auditContext.get((Object)"userid")) != null ? subjectID.trim() : "$NonRoleUser$") : "$Unidentified$";
        return subjectID;
    }

    private String auditRequesterID() {
        String requesterID = null;
        SessionContext auditContext = SessionContext.getExistingContext();
        requesterID = auditContext != null ? ((requesterID = (String)auditContext.get((Object)"requesterID")) != null ? requesterID.trim() : "$Unidentified$") : "$Unidentified$";
        return requesterID;
    }
}

