/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.key;

import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.authorization.EAuthzException;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.dbs.EDBRecordNotFoundException;
import com.netscape.certsrv.dbs.keydb.KeyId;
import com.netscape.certsrv.security.Credential;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.dbs.KeyRecord;
import com.netscape.cmscore.dbs.KeyRepository;
import com.netscape.kra.KeyRecoveryAuthority;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.kra.KRAEngine;
import org.dogtagpki.server.kra.KRAEngineConfig;
import org.mozilla.jss.netscape.security.util.Cert;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="kraKRARecoverBySerial", urlPatterns={"/agent/kra/recoverBySerial"}, initParams={@WebInitParam(name="GetClientCert", value="true"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authority", value="kra"), @WebInitParam(name="templatePath", value="/agent/kra/recoverBySerial.template"), @WebInitParam(name="ID", value="kraKRARecoverBySerial"), @WebInitParam(name="AuthMgr", value="certUserDBAuthMgr"), @WebInitParam(name="resourceID", value="certServer.kra.key")})
public class RecoverBySerial
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(RecoverBySerial.class);
    private static final long serialVersionUID = -4544485601409309840L;
    private static final String INFO = "recoverBySerial";
    private static final String TPL_FILE = "recoverBySerial.template";
    private static final String IN_SERIALNO = "serialNumber";
    private static final String IN_UID = "uid";
    private static final String IN_PWD = "pwd";
    private static final String IN_PASSWORD = "p12Password";
    private static final String IN_PASSWORD_AGAIN = "p12PasswordAgain";
    private static final String IN_DELIVERY = "p12Delivery";
    private static final String IN_CERT = "cert";
    private static final String IN_NICKNAME = "nickname";
    private static final String OUT_OP = "op";
    private static final String OUT_SERIALNO = "serialNumber";
    private static final String OUT_SERIALNO_IN_HEX = "serialNumberInHex";
    private static final String OUT_SERVICE_URL = "serviceURL";
    private static final String OUT_ERROR = "errorDetails";
    private static final String SCHEME = "scheme";
    private static final String HOST = "host";
    private static final String PORT = "port";
    private KeyRecoveryAuthority mService;
    private KeyRepository repo;
    private String mFormPath = null;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.mFormPath = "/kra/recoverBySerial.template";
        KRAEngine engine = KRAEngine.getInstance();
        this.mService = engine.getKRA();
        this.repo = this.mService.getKeyRepository();
        this.mTemplates.remove(CMSRequest.SUCCESS);
        if (this.mOutputTemplatePath != null) {
            this.mFormPath = this.mOutputTemplatePath;
        }
    }

    public String getServletInfo() {
        return INFO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse resp = cmsReq.getHttpResp();
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "recover");
        }
        catch (EAuthzAccessDenied e) {
            logger.warn("RecoverBySerial: " + CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (Exception e) {
            logger.warn("RecoverBySerial: " + CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        if (authzToken == null) {
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        try {
            form = this.getTemplate(this.mFormPath, req, locale);
        }
        catch (IOException e) {
            logger.error("RecoverBySerial: " + CMS.getLogMessage((String)"CMSGW_ERR_GET_TEMPLATE", (Object[])new Object[]{this.mFormPath, e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]));
        }
        cmsReq.setStatus(CMSRequest.SUCCESS);
        ArgBlock header = new ArgBlock();
        ArgBlock fixed = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, fixed);
        HttpServletRequest httpReq = cmsReq.getHttpReq();
        String host = httpReq.getServerName();
        int port = httpReq.getServerPort();
        String scheme = httpReq.getScheme();
        fixed.set(HOST, (Object)host);
        fixed.set(PORT, (Object)port);
        fixed.set(SCHEME, (Object)scheme);
        SessionContext ctx = null;
        try {
            String initAsyncRecovery = req.getParameter("initAsyncRecovery");
            KeyId keyId = new KeyId(req.getParameter("serialNumber"));
            KeyRecord rec = null;
            try {
                rec = this.repo.readKeyRecord(keyId.toBigInteger());
            }
            catch (EDBRecordNotFoundException e) {
                header.addStringValue(OUT_ERROR, "serialNumber not found");
                SessionContext.releaseContext();
                return;
            }
            String realm = rec.getRealm();
            try {
                this.mAuthz.checkRealm(realm, authToken, rec.getOwnerName(), this.mAuthzResourceName, "recover");
            }
            catch (EAuthzException e) {
                logger.warn("RecoverBySerial: " + CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
                cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
                SessionContext.releaseContext();
                return;
            }
            ctx = SessionContext.getContext();
            if (initAsyncRecovery != null && initAsyncRecovery.equalsIgnoreCase("ON")) {
                this.process(header, req.getParameter("serialNumber"), req.getParameter(IN_CERT), req, realm);
                int requiredNumber = this.mService.getNoOfRequiredAgents();
                header.addIntegerValue("noOfRequiredAgents", requiredNumber);
            } else {
                byte[] pkcs12;
                String recoveryID = req.getParameter("recoveryID");
                if (recoveryID != null && !recoveryID.equals("")) {
                    ctx.put((Object)"recoveryID", (Object)req.getParameter("recoveryID"));
                }
                if ((pkcs12 = this.process(header, req.getParameter("serialNumber"), req.getParameter("localAgents"), req.getParameter(IN_PASSWORD), req.getParameter(IN_PASSWORD_AGAIN), req.getParameter(IN_CERT), req.getParameter(IN_DELIVERY), req.getParameter(IN_NICKNAME), req, locale[0])) != null) {
                    resp.setContentType("application/x-pkcs12");
                    resp.getOutputStream().write(pkcs12);
                    this.mRenderResult = false;
                    return;
                }
            }
        }
        catch (NumberFormatException e) {
            header.addStringValue(OUT_ERROR, CMS.getUserMessage((Locale)locale[0], (String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{e.toString()}));
        }
        catch (IOException e) {
            header.addStringValue(OUT_ERROR, CMS.getUserMessage((Locale)locale[0], (String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{e.toString()}));
        }
        finally {
            SessionContext.releaseContext();
        }
        try {
            ServletOutputStream out = resp.getOutputStream();
            resp.setContentType("text/html");
            form.renderOutput((OutputStream)out, argSet);
        }
        catch (IOException e) {
            logger.error("RecoverBySerial: " + CMS.getLogMessage((String)"CMSGW_ERR_STREAM_TEMPLATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]));
        }
        cmsReq.setStatus(CMSRequest.SUCCESS);
    }

    private void process(ArgBlock header, String seq, String cert, HttpServletRequest req, String realm) {
        if (seq == null) {
            header.addStringValue(OUT_ERROR, "sequence number not found");
            return;
        }
        X509CertImpl x509cert = null;
        if (cert == null || cert.trim().length() == 0) {
            header.addStringValue(OUT_ERROR, "certificate not found");
            return;
        }
        try {
            x509cert = Cert.mapCert((String)cert);
        }
        catch (IOException e) {
            header.addStringValue(OUT_ERROR, e.toString());
        }
        if (x509cert == null) {
            header.addStringValue(OUT_ERROR, "invalid X.509 certificate");
            return;
        }
        SessionContext sContext = SessionContext.getContext();
        try {
            String reqID = this.mService.initAsyncKeyRecovery(new BigInteger(seq), x509cert, (String)sContext.get((Object)"userid"), realm);
            header.addStringValue("serialNumber", req.getParameter("serialNumber"));
            header.addStringValue(OUT_SERIALNO_IN_HEX, new BigInteger(req.getParameter("serialNumber")).toString(16));
            header.addStringValue("requestID", reqID);
        }
        catch (EBaseException e) {
            String error = "Failed to recover key for key id " + seq + ": " + e.getMessage();
            logger.warn("RecoverBySerial: " + error, (Throwable)e);
            try {
                this.mService.createError(seq, error);
            }
            catch (EBaseException eb) {
                logger.warn("RecoverBySerial: " + eb.getMessage(), (Throwable)e);
            }
        }
    }

    private byte[] process(ArgBlock header, String seq, String localAgents, String password, String passwordAgain, String cert, String delivery, String nickname, HttpServletRequest req, Locale locale) {
        if (seq == null) {
            header.addStringValue(OUT_ERROR, "sequence number not found");
            return null;
        }
        if (password == null || password.equals("")) {
            header.addStringValue(OUT_ERROR, "PKCS12 password not found");
            return null;
        }
        if (passwordAgain == null || !passwordAgain.equals(password)) {
            header.addStringValue(OUT_ERROR, "PKCS12 password not matched");
            return null;
        }
        X509CertImpl x509cert = null;
        if (cert == null || cert.trim().length() == 0) {
            header.addStringValue(OUT_ERROR, "certificate not found");
            return null;
        }
        try {
            x509cert = Cert.mapCert((String)cert);
        }
        catch (IOException e) {
            header.addStringValue(OUT_ERROR, e.toString());
        }
        if (x509cert == null) {
            header.addStringValue(OUT_ERROR, "invalid X.509 certificate");
            return null;
        }
        KRAEngine engine = KRAEngine.getInstance();
        KRAEngineConfig cs = engine.getConfig();
        try {
            Object[] creds = null;
            SessionContext sContext = SessionContext.getContext();
            String agent = null;
            if (sContext != null) {
                agent = (String)sContext.get((Object)"userid");
            }
            if (cs.getBoolean("kra.keySplitting")) {
                if (localAgents == null) {
                    String recoveryID = req.getParameter("recoveryID");
                    if (recoveryID == null || recoveryID.equals("")) {
                        header.addStringValue(OUT_ERROR, "No recovery ID specified");
                        return null;
                    }
                    Hashtable<String, Object> params = this.mService.createRecoveryParams(recoveryID);
                    params.put("keyID", req.getParameter("serialNumber"));
                    header.addStringValue("recoveryID", recoveryID);
                    params.put("agent", agent);
                    WaitApprovalThread waitThread = new WaitApprovalThread(recoveryID, seq, password, x509cert, delivery, nickname, SessionContext.getContext());
                    waitThread.start();
                    return null;
                }
                Vector<Credential> v = new Vector<Credential>();
                for (int i = 0; i < this.mService.getNoOfRequiredAgents(); ++i) {
                    String uid = req.getParameter(IN_UID + i);
                    String pwd = req.getParameter(IN_PWD + i);
                    if (uid == null || pwd == null || uid.equals("") || pwd.equals("")) {
                        header.addStringValue(OUT_ERROR, "Uid(s) or password(s) are not provided");
                        return null;
                    }
                    v.addElement(new Credential(uid, pwd));
                }
                if (v.size() != this.mService.getNoOfRequiredAgents()) {
                    header.addStringValue(OUT_ERROR, "Uid(s) or password(s) are not provided");
                    return null;
                }
                creds = new Credential[v.size()];
                v.copyInto(creds);
                header.addStringValue(OUT_OP, req.getParameter(OUT_OP));
                header.addBigIntegerValue("serialNumber", new BigInteger(seq), 10);
                header.addBigIntegerValue(OUT_SERIALNO_IN_HEX, new BigInteger(seq), 16);
                header.addStringValue(OUT_SERVICE_URL, req.getRequestURI());
                byte[] pkcs12 = this.mService.doKeyRecovery(new BigInteger(seq), (Credential[])creds, password, x509cert, delivery, nickname, agent);
                return pkcs12;
            }
            String recoveryID = req.getParameter("recoveryID");
            if (recoveryID == null || recoveryID.equals("")) {
                header.addStringValue(OUT_ERROR, "No recovery ID specified");
                return null;
            }
            Hashtable<String, Object> params = this.mService.createRecoveryParams(recoveryID);
            params.put("keyID", req.getParameter("serialNumber"));
            header.addStringValue("recoveryID", recoveryID);
            params.put("agent", agent);
            WaitApprovalThread waitThread = new WaitApprovalThread(recoveryID, seq, password, x509cert, delivery, nickname, SessionContext.getContext());
            waitThread.start();
            return null;
        }
        catch (EBaseException e) {
            header.addStringValue(OUT_ERROR, e.toString(locale));
        }
        catch (Exception e) {
            header.addStringValue(OUT_ERROR, e.toString());
        }
        return null;
    }

    final class WaitApprovalThread
    extends Thread {
        String theRecoveryID = null;
        String theSeq = null;
        String thePassword = null;
        X509CertImpl theCert = null;
        String theDelivery = null;
        String theNickname = null;
        SessionContext theSc = null;

        public WaitApprovalThread(String recoveryID, String seq, String password, X509CertImpl cert, String delivery, String nickname, SessionContext sc) {
            super.setName("waitApproval." + recoveryID + "-" + (Thread.activeCount() + 1));
            this.theRecoveryID = recoveryID;
            this.theSeq = seq;
            this.thePassword = password;
            this.theCert = cert;
            this.theDelivery = delivery;
            this.theNickname = nickname;
            this.theSc = sc;
        }

        @Override
        public void run() {
            SessionContext.setContext((SessionContext)this.theSc);
            Credential[] creds = null;
            try {
                creds = RecoverBySerial.this.mService.getDistributedCredentials(this.theRecoveryID);
            }
            catch (EBaseException e) {
                String error = "Failed to get required approvals for recovery id " + this.theRecoveryID + ": " + e.getMessage();
                logger.warn("WaitApprovalThread: " + error, (Throwable)e);
                try {
                    RecoverBySerial.this.mService.createError(this.theRecoveryID, error);
                }
                catch (EBaseException eb) {
                    logger.warn("WaitApprovalThread: " + eb.getMessage(), (Throwable)eb);
                }
                return;
            }
            SessionContext sContext = SessionContext.getContext();
            try {
                byte[] pkcs12 = RecoverBySerial.this.mService.doKeyRecovery(new BigInteger(this.theSeq), creds, this.thePassword, this.theCert, this.theDelivery, this.theNickname, (String)sContext.get((Object)"userid"));
                RecoverBySerial.this.mService.createPk12(this.theRecoveryID, pkcs12);
            }
            catch (EBaseException e) {
                String error = "Failed to recover key for recovery id " + this.theRecoveryID + ": " + e.getMessage();
                logger.warn("WaitApprovalThread: " + error, (Throwable)e);
                try {
                    RecoverBySerial.this.mService.createError(this.theRecoveryID, error);
                }
                catch (EBaseException eb) {
                    logger.warn("WaitApprovalThread: " + eb.getMessage(), (Throwable)eb);
                }
            }
        }
    }
}

