/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.user;

import com.netscape.certsrv.user.UserCertCollection;
import com.netscape.certsrv.user.UserCertData;
import com.netscape.certsrv.user.UserClient;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.user.UserCertCLI;
import java.util.Collection;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserCertFindCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(UserCertFindCLI.class);
    public UserCertCLI userCertCLI;

    public UserCertFindCLI(UserCertCLI userCertCLI) {
        super("find", "Find user certificates", (CLI)userCertCLI);
        this.userCertCLI = userCertCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <User ID> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "start", true, "Page start");
        option.setArgName("start");
        this.options.addOption(option);
        option = new Option(null, "size", true, "Page size");
        option.setArgName("size");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 1) {
            throw new Exception("No User ID specified.");
        }
        String userID = cmdArgs[0];
        String s = cmd.getOptionValue("start");
        Integer start = s == null ? null : Integer.valueOf(s);
        s = cmd.getOptionValue("size");
        Integer size = s == null ? null : Integer.valueOf(s);
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        UserClient userClient = this.userCertCLI.getUserClient();
        UserCertCollection response = userClient.findUserCerts(userID, start, size);
        MainCLI.printMessage(response.getTotal() + " entries matched");
        if (response.getTotal() == 0) {
            return;
        }
        Collection entries = response.getEntries();
        boolean first = true;
        for (UserCertData userCertData : entries) {
            if (first) {
                first = false;
            } else {
                System.out.println();
            }
            UserCertCLI.printCert(userCertData, false, false);
        }
        MainCLI.printMessage("Number of entries returned " + entries.size());
    }
}

