/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.user;

import com.netscape.certsrv.user.UserCertData;
import com.netscape.certsrv.user.UserClient;
import com.netscape.cmstools.user.UserCLI;
import com.netscape.cmstools.user.UserCertAddCLI;
import com.netscape.cmstools.user.UserCertFindCLI;
import com.netscape.cmstools.user.UserCertRemoveCLI;
import com.netscape.cmstools.user.UserCertShowCLI;
import org.dogtagpki.cli.CLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserCertCLI
extends CLI {
    public static Logger logger = LoggerFactory.getLogger(UserCertCLI.class);
    UserCLI parent;

    public UserCertCLI(UserCLI parent) {
        super("cert", "User certificate management commands", (CLI)parent);
        this.parent = parent;
        this.addModule((CLI)new UserCertFindCLI(this));
        this.addModule((CLI)new UserCertShowCLI(this));
        this.addModule((CLI)new UserCertAddCLI(this));
        this.addModule((CLI)new UserCertRemoveCLI(this));
    }

    public String getManPage() {
        return "pki-user-cert";
    }

    public UserClient getUserClient() throws Exception {
        return this.parent.getUserClient();
    }

    public static void printCert(UserCertData userCertData, boolean showPrettyPrint, boolean showEncoded) {
        System.out.println("  Cert ID: " + userCertData.getID());
        System.out.println("  Version: " + userCertData.getVersion());
        System.out.println("  Serial Number: " + userCertData.getSerialNumber().toHexString());
        System.out.println("  Issuer: " + userCertData.getIssuerDN());
        System.out.println("  Subject: " + userCertData.getSubjectDN());
        String prettyPrint = userCertData.getPrettyPrint();
        if (showPrettyPrint && prettyPrint != null) {
            System.out.println();
            System.out.println(prettyPrint);
        }
        String encoded = userCertData.getEncoded();
        if (showEncoded && encoded != null) {
            System.out.println();
            System.out.println(encoded);
        }
    }
}

