/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.tps.token;

import com.netscape.certsrv.tps.token.TokenClient;
import com.netscape.certsrv.tps.token.TokenCollection;
import com.netscape.certsrv.tps.token.TokenData;
import com.netscape.certsrv.tps.token.TokenStatus;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.tps.token.TokenCLI;
import java.util.Collection;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenFindCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(TokenFindCLI.class);
    public TokenCLI tokenCLI;

    public TokenFindCLI(TokenCLI tokenCLI) {
        super("find", "Find tokens", (CLI)tokenCLI);
        this.tokenCLI = tokenCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [FILTER] [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "token", true, "Token ID");
        option.setArgName("token ID");
        this.options.addOption(option);
        option = new Option(null, "user", true, "User ID");
        option.setArgName("user ID");
        this.options.addOption(option);
        option = new Option(null, "type", true, "Token type");
        option.setArgName("type");
        this.options.addOption(option);
        option = new Option(null, "status", true, "Token status");
        option.setArgName("status");
        this.options.addOption(option);
        option = new Option(null, "start", true, "Page start");
        option.setArgName("start");
        this.options.addOption(option);
        option = new Option(null, "size", true, "Page size");
        option.setArgName("size");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String s;
        String[] cmdArgs = cmd.getArgs();
        String filter = cmdArgs.length > 0 ? cmdArgs[0] : null;
        String tokenID = cmd.getOptionValue("token");
        String userID = cmd.getOptionValue("user");
        String type = cmd.getOptionValue("type");
        String statusStr = cmd.getOptionValue("status");
        TokenStatus status = null;
        if (statusStr != null) {
            status = TokenStatus.valueOf((String)statusStr);
        }
        Integer start = (s = cmd.getOptionValue("start")) == null ? null : Integer.valueOf(s);
        s = cmd.getOptionValue("size");
        Integer size = s == null ? null : Integer.valueOf(s);
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        TokenClient tokenClient = this.tokenCLI.getTokenClient();
        TokenCollection result = tokenClient.findTokens(filter, tokenID, userID, type, status, start, size);
        MainCLI.printMessage(result.getTotal() + " entries matched");
        if (result.getTotal() == 0) {
            return;
        }
        Collection tokens = result.getEntries();
        boolean first = true;
        for (TokenData tokenData : tokens) {
            if (first) {
                first = false;
            } else {
                System.out.println();
            }
            TokenCLI.printToken(tokenData);
        }
        MainCLI.printMessage("Number of entries returned " + tokens.size());
    }
}

