/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.tps.profile;

import com.netscape.certsrv.tps.profile.ProfileClient;
import com.netscape.certsrv.tps.profile.ProfileData;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.tps.profile.ProfileCLI;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileShowCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(ProfileShowCLI.class);
    public ProfileCLI profileCLI;

    public ProfileShowCLI(ProfileCLI profileCLI) {
        super("show", "Show profile", (CLI)profileCLI);
        this.profileCLI = profileCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <Profile ID> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "output", true, "Output file to store profile properties.");
        option.setArgName("file");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 1) {
            throw new Exception("No Profile ID specified.");
        }
        String profileID = cmdArgs[0];
        String output = cmd.getOptionValue("output");
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        ProfileClient profileClient = this.profileCLI.getProfileClient();
        ProfileData profileData = profileClient.getProfile(profileID);
        if (output == null) {
            MainCLI.printMessage("Profile \"" + profileID + "\"");
            ProfileCLI.printProfileData(profileData, true);
        } else {
            try (PrintWriter out = new PrintWriter(new FileWriter(output));){
                out.println(profileData);
            }
            MainCLI.printMessage("Stored profile \"" + profileID + "\" into " + output);
        }
    }
}

