/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.tps.authenticator;

import com.netscape.certsrv.tps.authenticator.AuthenticatorClient;
import com.netscape.certsrv.tps.authenticator.AuthenticatorCollection;
import com.netscape.certsrv.tps.authenticator.AuthenticatorData;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.tps.authenticator.AuthenticatorCLI;
import java.util.Collection;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticatorFindCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(AuthenticatorFindCLI.class);
    public AuthenticatorCLI authenticatorCLI;

    public AuthenticatorFindCLI(AuthenticatorCLI authenticatorCLI) {
        super("find", "Find authenticators", (CLI)authenticatorCLI);
        this.authenticatorCLI = authenticatorCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [FILTER] [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "start", true, "Page start");
        option.setArgName("start");
        this.options.addOption(option);
        option = new Option(null, "size", true, "Page size");
        option.setArgName("size");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        String filter = cmdArgs.length > 0 ? cmdArgs[0] : null;
        String s = cmd.getOptionValue("start");
        Integer start = s == null ? null : Integer.valueOf(s);
        s = cmd.getOptionValue("size");
        Integer size = s == null ? null : Integer.valueOf(s);
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        AuthenticatorClient authenticatorClient = this.authenticatorCLI.getAuthenticatorClient();
        AuthenticatorCollection result = authenticatorClient.findAuthenticators(filter, start, size);
        MainCLI.printMessage(result.getTotal() + " entries matched");
        if (result.getTotal() == 0) {
            return;
        }
        Collection authenticators = result.getEntries();
        boolean first = true;
        for (AuthenticatorData authenticatorData : authenticators) {
            if (first) {
                first = false;
            } else {
                System.out.println();
            }
            AuthenticatorCLI.printAuthenticatorData(authenticatorData, false);
        }
        MainCLI.printMessage("Number of entries returned " + authenticators.size());
    }
}

