/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.profile;

import com.netscape.certsrv.profile.ProfileClient;
import com.netscape.certsrv.profile.ProfileDataInfo;
import com.netscape.certsrv.profile.ProfileDataInfos;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.profile.ProfileCLI;
import java.util.Collection;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileFindCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(ProfileFindCLI.class);
    public ProfileCLI profileCLI;

    public ProfileFindCLI(ProfileCLI profileCLI) {
        super("find", "Find profiles", (CLI)profileCLI);
        this.profileCLI = profileCLI;
        this.createOptions();
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "start", true, "Page start");
        option.setArgName("start");
        this.options.addOption(option);
        option = new Option(null, "size", true, "Page size");
        option.setArgName("size");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 0) {
            throw new Exception("Too many arguments specified.");
        }
        String s = cmd.getOptionValue("start");
        Integer start = s == null ? null : Integer.valueOf(s);
        s = cmd.getOptionValue("size");
        Integer size = s == null ? null : Integer.valueOf(s);
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        ProfileClient profileClient = this.profileCLI.getProfileClient();
        ProfileDataInfos response = profileClient.listProfiles(start, size);
        MainCLI.printMessage(response.getTotal() + " entries matched");
        if (response.getTotal() == 0) {
            return;
        }
        Collection infos = response.getEntries();
        boolean first = true;
        for (ProfileDataInfo info : infos) {
            if (first) {
                first = false;
            } else {
                System.out.println();
            }
            ProfileCLI.printProfileDataInfo(info);
        }
        MainCLI.printMessage("Number of entries returned " + infos.size());
    }
}

