/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.pkcs12;

import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.pkcs12.PKCS12KeyCLI;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Collection;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.mozilla.jss.netscape.security.pkcs.PKCS12;
import org.mozilla.jss.netscape.security.pkcs.PKCS12KeyInfo;
import org.mozilla.jss.netscape.security.pkcs.PKCS12Util;
import org.mozilla.jss.util.Password;

public class PKCS12KeyFindCLI
extends CommandCLI {
    public PKCS12KeyCLI keyCLI;

    public PKCS12KeyFindCLI(PKCS12KeyCLI keyCLI) {
        super("find", "Find keys in PKCS #12 file", (CLI)keyCLI);
        this.keyCLI = keyCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "pkcs12-file", true, "PKCS #12 file");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "pkcs12-password", true, "PKCS #12 password");
        option.setArgName("password");
        this.options.addOption(option);
        option = new Option(null, "pkcs12-password-file", true, "PKCS #12 password file");
        option.setArgName("path");
        this.options.addOption(option);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CommandLine cmd) throws Exception {
        Collection keyInfos;
        String passwordFile;
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 0) {
            throw new Exception("Too many arguments specified.");
        }
        String filename = cmd.getOptionValue("pkcs12-file");
        if (filename == null) {
            throw new Exception("Missing PKCS #12 file.");
        }
        String passwordString = cmd.getOptionValue("pkcs12-password");
        if (passwordString == null && (passwordFile = cmd.getOptionValue("pkcs12-password-file")) != null) {
            try (BufferedReader in = new BufferedReader(new FileReader(passwordFile));){
                passwordString = in.readLine();
            }
        }
        if (passwordString == null) {
            throw new Exception("Missing PKCS #12 password.");
        }
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        Password password = new Password(passwordString.toCharArray());
        try {
            PKCS12Util util = new PKCS12Util();
            PKCS12 pkcs12 = util.loadFromFile(filename, password);
            keyInfos = pkcs12.getKeyInfos();
        }
        finally {
            password.clear();
        }
        MainCLI.printMessage(keyInfos.size() + " entries found");
        if (keyInfos.size() == 0) {
            return;
        }
        boolean first = true;
        for (PKCS12KeyInfo keyInfo : keyInfos) {
            if (first) {
                first = false;
            } else {
                System.out.println();
            }
            PKCS12KeyCLI.printKeyInfo(keyInfo);
        }
    }
}

