/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.pkcs12;

import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.pkcs12.PKCS12CertCLI;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Collection;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.mozilla.jss.netscape.security.pkcs.PKCS12;
import org.mozilla.jss.netscape.security.pkcs.PKCS12CertInfo;
import org.mozilla.jss.netscape.security.pkcs.PKCS12Util;
import org.mozilla.jss.util.Password;

public class PKCS12CertModCLI
extends CommandCLI {
    public PKCS12CertCLI certCLI;

    public PKCS12CertModCLI(PKCS12CertCLI certCLI) {
        super("mod", "Modify certificate in PKCS #12 file", (CLI)certCLI);
        this.certCLI = certCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <cert ID or nickname> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "pkcs12", true, "PKCS #12 file");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "pkcs12-file", true, "DEPRECATED: PKCS #12 file");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "password", true, "PKCS #12 password");
        option.setArgName("password");
        this.options.addOption(option);
        option = new Option(null, "pkcs12-password", true, "DEPRECATED: PKCS #12 password");
        option.setArgName("password");
        this.options.addOption(option);
        option = new Option(null, "password-file", true, "PKCS #12 password file");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "pkcs12-password-file", true, "DEPRECATED: PKCS #12 password file");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "friendly-name", true, "Certificate nickname");
        option.setArgName("nickname");
        this.options.addOption(option);
        option = new Option(null, "trust-flags", true, "Certificate trust flags");
        option.setArgName("flags");
        this.options.addOption(option);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CommandLine cmd) throws Exception {
        byte[] certID;
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length == 0) {
            throw new Exception("Missing certificate ID or nickname");
        }
        String nickname = cmdArgs[0];
        String filename = cmd.getOptionValue("pkcs12");
        if (filename == null) {
            filename = cmd.getOptionValue("pkcs12-file");
        }
        if (filename == null) {
            throw new Exception("Missing PKCS #12 file.");
        }
        String passwordString = cmd.getOptionValue("password");
        if (passwordString == null) {
            passwordString = cmd.getOptionValue("pkcs12-password");
        }
        if (passwordString == null) {
            String passwordFile = cmd.getOptionValue("password-file");
            if (passwordFile == null) {
                passwordFile = cmd.getOptionValue("pkcs12-password-file");
            }
            if (passwordFile != null) {
                try (BufferedReader in = new BufferedReader(new FileReader(passwordFile));){
                    passwordString = in.readLine();
                }
            }
        }
        if (passwordString == null) {
            throw new Exception("Missing PKCS #12 password.");
        }
        String friendlyName = cmd.getOptionValue("friendly-name");
        String trustFlags = cmd.getOptionValue("trust-flags");
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        Password password = new Password(passwordString.toCharArray());
        try {
            String id = nickname;
            if (id.startsWith("0x")) {
                id = id.substring(2);
            }
            certID = Hex.decodeHex((String)id);
        }
        catch (DecoderException e) {
            certID = null;
        }
        try {
            Collection certInfos;
            PKCS12Util util = new PKCS12Util();
            PKCS12 pkcs12 = util.loadFromFile(filename, password);
            PKCS12CertInfo certInfo = null;
            if (certID != null) {
                certInfo = pkcs12.getCertInfoByID(certID);
            }
            if (certInfo == null && !(certInfos = pkcs12.getCertInfosByFriendlyName(nickname)).isEmpty()) {
                certInfo = (PKCS12CertInfo)certInfos.iterator().next();
            }
            if (certInfo == null) {
                throw new Exception("Certificate " + nickname + " not found");
            }
            if (friendlyName != null) {
                certInfo.setFriendlyName(friendlyName);
            }
            if (trustFlags != null) {
                if (trustFlags.equals("")) {
                    certInfo.setTrustFlags(null);
                } else {
                    certInfo.setTrustFlags(trustFlags);
                }
            }
            util.storeIntoFile(pkcs12, filename, password);
        }
        finally {
            password.clear();
        }
        MainCLI.printMessage("Updated certificate \"" + nickname + "\"");
    }
}

