/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.pkcs11;

import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.cmstools.pkcs11.PKCS11CLI;
import com.netscape.cmstools.pkcs11.PKCS11CertExportCLI;
import com.netscape.cmstools.pkcs11.PKCS11CertFindCLI;
import com.netscape.cmstools.pkcs11.PKCS11CertRemoveCLI;
import com.netscape.cmstools.pkcs11.PKCS11CertShowCLI;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import org.dogtagpki.cli.CLI;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;

public class PKCS11CertCLI
extends CLI {
    public PKCS11CLI pkcs11CLI;

    public PKCS11CertCLI(PKCS11CLI pkcs11CLI) {
        super("cert", "PKCS #11 certificate management commands", (CLI)pkcs11CLI);
        this.pkcs11CLI = pkcs11CLI;
        this.addModule((CLI)new PKCS11CertExportCLI(this));
        this.addModule((CLI)new PKCS11CertFindCLI(this));
        this.addModule((CLI)new PKCS11CertShowCLI(this));
        this.addModule((CLI)new PKCS11CertRemoveCLI(this));
    }

    public static void printCertInfo(String alias, Certificate cert) throws CertificateEncodingException, CertificateException {
        System.out.println("  Cert ID: " + alias);
        System.out.println("  Type: " + cert.getType());
        X509CertImpl certImpl = new X509CertImpl(cert.getEncoded());
        CertId serialNumber = new CertId(certImpl.getSerialNumber());
        System.out.println("  Serial Number: " + serialNumber.toHexString());
        System.out.println("  Subject DN: " + certImpl.getSubjectName());
        System.out.println("  Issuer DN: " + certImpl.getIssuerName());
        System.out.println("  Not Valid Before: " + certImpl.getNotBefore());
        System.out.println("  Not Valid After: " + certImpl.getNotAfter());
    }
}

