/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.nss;

import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.nss.NSSCLI;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.apache.commons.cli.CommandLine;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.dogtagpki.nss.NSSDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSSRemoveCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(NSSRemoveCLI.class);
    public NSSCLI nssCLI;

    public NSSRemoveCLI(NSSCLI nssCLI) {
        super("remove", "Remove NSS database", (CLI)nssCLI);
        this.nssCLI = nssCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...]", this.options);
    }

    public void createOptions() {
        this.options.addOption(null, "force", false, "Force removal.");
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 0) {
            throw new Exception("Too many arguments specified");
        }
        MainCLI mainCLI = this.nssCLI.mainCLI;
        NSSDatabase nssdb = mainCLI.getNSSDatabase();
        if (!nssdb.exists()) {
            throw new Exception("There is no NSS database in " + nssdb.getPath());
        }
        boolean force = cmd.hasOption("force");
        if (!force) {
            System.out.println("Removing NSS database in " + nssdb.getPath() + ".");
            System.out.print("Are you sure (y/N)? ");
            System.out.flush();
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String line = reader.readLine().trim();
            if (line.equals("") || !line.substring(0, 1).equalsIgnoreCase("Y")) {
                return;
            }
        }
        nssdb.delete();
    }
}

