/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.kra;

import com.netscape.certsrv.base.RESTMessage;
import com.netscape.certsrv.key.KeyTemplate;
import com.netscape.certsrv.util.JSONSerializer;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.kra.KRAKeyCLI;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KRAKeyTemplateFindCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(KRAKeyTemplateFindCLI.class);
    public KRAKeyCLI keyCLI;
    public ArrayList<KeyTemplate> templates = new ArrayList();

    public KRAKeyTemplateFindCLI(KRAKeyCLI keyCLI) {
        super("template-find", "List request template IDs", (CLI)keyCLI);
        this.keyCLI = keyCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...]", this.options);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 0) {
            throw new Exception("Too many arguments specified.");
        }
        this.createTemplateList();
        MainCLI.printMessage(this.templates.size() + " entries matched");
        for (KeyTemplate template : this.templates) {
            template.printTemplateInfo();
        }
        System.out.println();
        MainCLI.printMessage("Number of entries returned " + this.templates.size());
    }

    public void createTemplateList() throws Exception {
        String[] templateFiles;
        String templateDir = "/usr/share/pki/key/templates/";
        File file = new File(templateDir);
        if (!file.exists()) {
            throw new Exception("Missing template files.");
        }
        KeyTemplate template = null;
        RESTMessage data = null;
        for (String templateName : templateFiles = file.list()) {
            if (templateName.indexOf(".json") == -1) continue;
            String id = templateName.substring(0, templateName.indexOf(".json"));
            String json = Files.readString(Path.of(templateDir + templateName, new String[0]));
            data = (RESTMessage)JSONSerializer.fromJSON((String)json, RESTMessage.class);
            template = new KeyTemplate(id, data.getAttribute("description"));
            this.templates.add(template);
        }
    }
}

