/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.group;

import com.netscape.certsrv.group.GroupClient;
import com.netscape.certsrv.group.GroupCollection;
import com.netscape.certsrv.group.GroupData;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.group.GroupCLI;
import java.util.Collection;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupFindCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(GroupFindCLI.class);
    public GroupCLI groupCLI;

    public GroupFindCLI(GroupCLI groupCLI) {
        super("find", "Find groups", (CLI)groupCLI);
        this.groupCLI = groupCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [FILTER] [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "start", true, "Page start");
        option.setArgName("start");
        this.options.addOption(option);
        option = new Option(null, "size", true, "Page size");
        option.setArgName("size");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        String filter = cmdArgs.length > 0 ? cmdArgs[0] : null;
        String s = cmd.getOptionValue("start");
        Integer start = s == null ? null : Integer.valueOf(s);
        s = cmd.getOptionValue("size");
        Integer size = s == null ? null : Integer.valueOf(s);
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        GroupClient groupClient = this.groupCLI.getGroupClient();
        GroupCollection response = groupClient.findGroups(filter, start, size);
        MainCLI.printMessage(response.getTotal() + " entries matched");
        if (response.getTotal() == 0) {
            return;
        }
        Collection entries = response.getEntries();
        boolean first = true;
        for (GroupData groupData : entries) {
            if (first) {
                first = false;
            } else {
                System.out.println();
            }
            GroupCLI.printGroup(groupData);
        }
        MainCLI.printMessage("Number of entries returned " + entries.size());
    }
}

