/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.ca;

import com.netscape.certsrv.ca.CACertClient;
import com.netscape.certsrv.cert.CertData;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.cmstools.ca.CACertCLI;
import com.netscape.cmstools.cli.MainCLI;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CACertShowCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(CACertShowCLI.class);
    public CACertCLI certCLI;

    public CACertShowCLI(CACertCLI certCLI) {
        super("show", "Show certificate", (CLI)certCLI);
        this.certCLI = certCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <Serial Number> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "output", true, "DEPRECATED: Output file");
        option.setArgName("file");
        this.options.addOption(option);
        this.options.addOption(null, "pretty", false, "Pretty print");
        this.options.addOption(null, "encoded", false, "DEPRECATED: Base-64 encoded");
    }

    public void execute(CommandLine cmd) throws Exception {
        String file;
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 1) {
            throw new Exception("Missing Serial Number.");
        }
        CertId certID = new CertId(cmdArgs[0]);
        boolean showPrettyPrint = cmd.hasOption("pretty");
        boolean showEncoded = cmd.hasOption("encoded");
        if (showEncoded) {
            logger.warn("The --encoded option has been deprecated. Use pki ca-cert-export instead.");
        }
        if ((file = cmd.getOptionValue("output")) != null) {
            logger.warn("The --output option has been deprecated. Use pki ca-cert-export instead.");
        }
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        CACertClient certClient = this.certCLI.getCertClient();
        CertData certData = certClient.getCert(certID);
        String encoded = certData.getEncoded();
        if (encoded != null && file != null) {
            try (PrintWriter out = new PrintWriter(new FileWriter(file));){
                out.print(encoded);
            }
        }
        CACertCLI.printCertData(certData, showPrettyPrint, showEncoded);
    }
}

