/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.ca;

import com.netscape.certsrv.ca.CACertClient;
import com.netscape.certsrv.cert.CertRequestInfo;
import com.netscape.certsrv.request.RequestId;
import com.netscape.cmstools.ca.CACertRequestCLI;
import com.netscape.cmstools.cli.MainCLI;
import org.apache.commons.cli.CommandLine;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CACertRequestShowCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(CACertRequestShowCLI.class);
    CACertRequestCLI certRequestCLI;

    public CACertRequestShowCLI(CACertRequestCLI certRequestCLI) {
        super("show", "Show certificate request", (CLI)certRequestCLI);
        this.certRequestCLI = certRequestCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <Request ID> [OPTIONS...]", this.options);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length < 1) {
            throw new Exception("Missing Certificate Request ID.");
        }
        RequestId requestId = null;
        try {
            requestId = new RequestId(cmdArgs[0]);
        }
        catch (NumberFormatException e) {
            throw new Exception("Invalid certificate request ID " + cmdArgs[0] + ".", e);
        }
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        CACertClient certClient = this.certRequestCLI.getCertClient();
        CertRequestInfo certRequest = certClient.getRequest(requestId);
        MainCLI.printMessage("Certificate request \"" + requestId.toHexString() + "\"");
        CACertRequestCLI.printCertRequestInfo(certRequest);
    }
}

