/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.ca;

import com.netscape.certsrv.ca.CACertClient;
import com.netscape.certsrv.cert.CertRequestInfo;
import com.netscape.certsrv.cert.CertRequestInfos;
import com.netscape.certsrv.cert.CertReviewResponse;
import com.netscape.certsrv.client.PKIClient;
import com.netscape.certsrv.profile.ProfileAttribute;
import com.netscape.certsrv.profile.ProfileInput;
import com.netscape.cmstools.ca.CACertRequestApproveCLI;
import com.netscape.cmstools.ca.CACertRequestAssignCLI;
import com.netscape.cmstools.ca.CACertRequestCancelCLI;
import com.netscape.cmstools.ca.CACertRequestFindCLI;
import com.netscape.cmstools.ca.CACertRequestProfileFindCLI;
import com.netscape.cmstools.ca.CACertRequestProfileShowCLI;
import com.netscape.cmstools.ca.CACertRequestRejectCLI;
import com.netscape.cmstools.ca.CACertRequestReviewCLI;
import com.netscape.cmstools.ca.CACertRequestShowCLI;
import com.netscape.cmstools.ca.CACertRequestSubmitCLI;
import com.netscape.cmstools.ca.CACertRequestUnassignCLI;
import com.netscape.cmstools.ca.CACertRequestUpdateCLI;
import com.netscape.cmstools.ca.CACertRequestValidateCLI;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.cli.SubsystemCLI;
import org.apache.commons.lang3.StringUtils;
import org.dogtagpki.cli.CLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CACertRequestCLI
extends CLI {
    public static Logger logger = LoggerFactory.getLogger(CACertRequestCLI.class);
    public CACertClient certClient;

    public CACertRequestCLI(CLI parent) {
        super("request", "Certificate request management commands", parent);
        this.addModule((CLI)new CACertRequestFindCLI(this));
        this.addModule((CLI)new CACertRequestShowCLI(this));
        this.addModule((CLI)new CACertRequestSubmitCLI(this));
        this.addModule((CLI)new CACertRequestReviewCLI(this));
        this.addModule((CLI)new CACertRequestApproveCLI(this));
        this.addModule((CLI)new CACertRequestRejectCLI(this));
        this.addModule((CLI)new CACertRequestCancelCLI(this));
        this.addModule((CLI)new CACertRequestUpdateCLI(this));
        this.addModule((CLI)new CACertRequestValidateCLI(this));
        this.addModule((CLI)new CACertRequestAssignCLI(this));
        this.addModule((CLI)new CACertRequestUnassignCLI(this));
        this.addModule((CLI)new CACertRequestProfileFindCLI(this));
        this.addModule((CLI)new CACertRequestProfileShowCLI(this));
    }

    public String getFullName() {
        return this.parent instanceof MainCLI ? this.name : this.parent.getFullName() + "-" + this.name;
    }

    public String getManPage() {
        return "pki-cert";
    }

    public CACertClient getCertClient() throws Exception {
        String subsystem;
        if (this.certClient != null) {
            return this.certClient;
        }
        PKIClient client = this.getClient();
        if (this.parent instanceof SubsystemCLI) {
            SubsystemCLI subsystemCLI = (SubsystemCLI)this.parent;
            subsystem = subsystemCLI.getName();
        } else {
            subsystem = "ca";
        }
        this.certClient = new CACertClient(client, subsystem);
        return this.certClient;
    }

    public static void printCertRequestInfos(CertRequestInfos infos) {
        boolean first = true;
        for (CertRequestInfo info : infos.getEntries()) {
            if (first) {
                first = false;
            } else {
                System.out.println();
            }
            CACertRequestCLI.printCertRequestInfo(info);
        }
    }

    public static void printCertRequestInfo(CertRequestInfo info) {
        System.out.println("  Request ID: " + info.getRequestID().toHexString());
        System.out.println("  Type: " + info.getRequestType());
        System.out.println("  Request Status: " + info.getRequestStatus());
        System.out.println("  Operation Result: " + info.getOperationResult());
        String error = info.getErrorMessage();
        if (error != null) {
            System.out.println("  Reason: " + error);
        }
        if (info.getCertId() != null) {
            System.out.println("  Certificate ID: " + info.getCertId().toHexString());
        }
        System.out.println("  Creation Time: " + info.getCreationTime());
        System.out.println("  Modification Time: " + info.getModificationTime());
    }

    public static void printCertReviewResponse(CertReviewResponse response) {
        System.out.println("  Request ID: " + response.getRequestId().toHexString());
        System.out.println("  Profile: " + response.getProfileName());
        System.out.println("  Type: " + response.getRequestType());
        System.out.println("  Status: " + response.getRequestStatus());
        for (ProfileInput input : response.getInputs()) {
            System.out.println();
            System.out.println("  " + input.getName() + ":");
            boolean inputProvided = false;
            for (ProfileAttribute attribute : input.getAttributes()) {
                String name = attribute.getName();
                String value = attribute.getValue().trim();
                if (StringUtils.isEmpty((CharSequence)value)) continue;
                System.out.println("    " + name + ": " + value);
                inputProvided = true;
            }
            if (inputProvided) continue;
            System.out.println("    none");
        }
    }
}

