/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.ca;

import com.netscape.certsrv.ca.CACertClient;
import com.netscape.certsrv.cert.CertRequestInfo;
import com.netscape.certsrv.cert.CertReviewResponse;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.util.JSONSerializer;
import com.netscape.cmstools.ca.CACertRequestCLI;
import com.netscape.cmstools.cli.MainCLI;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CACertRequestActionCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(CACertRequestActionCLI.class);
    CACertRequestCLI certRequestCLI;

    public CACertRequestActionCLI(String name, String description, CACertRequestCLI certRequestCLI) {
        super(name, description, (CLI)certRequestCLI);
        this.certRequestCLI = certRequestCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <Request ID> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "input-file", true, "Input file containing certificate request.");
        option.setArgName("filename");
        this.options.addOption(option);
        this.options.addOption(null, "force", false, "Force");
    }

    public void execute(CommandLine cmd) throws Exception {
        RequestId requestId;
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length < 1) {
            throw new Exception("Missing certificate request ID");
        }
        try {
            requestId = new RequestId(cmdArgs[0]);
        }
        catch (NumberFormatException e) {
            throw new Exception("Invalid certificate request ID: " + cmdArgs[0], e);
        }
        String filename = cmd.getOptionValue("input-file");
        boolean force = cmd.hasOption("force");
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        logger.info("Retrieving certificate request " + requestId.toHexString());
        CACertClient certClient = this.certRequestCLI.getCertClient();
        CertReviewResponse reviewInfo = certClient.reviewRequest(requestId);
        String nonce = reviewInfo.getNonce();
        logger.info("Nonce: " + nonce);
        if (filename == null) {
            if (!force) {
                CACertRequestCLI.printCertReviewResponse(reviewInfo);
                System.out.println();
                System.out.print("Are you sure (y/N)? ");
                System.out.flush();
                BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
                String confirmation = reader.readLine().trim();
                if (!confirmation.equalsIgnoreCase("y")) {
                    return;
                }
            }
        } else {
            logger.info("Loading certificate request from " + filename);
            String json = new String(Files.readAllBytes(Paths.get(filename, new String[0])));
            reviewInfo = (CertReviewResponse)JSONSerializer.fromJSON((String)json, CertReviewResponse.class);
            if (!requestId.equals((Object)reviewInfo.getRequestId())) {
                throw new Exception("Incorrect certificate request in " + filename);
            }
            reviewInfo.setNonce(nonce);
        }
        this.performAction(certClient, requestId, reviewInfo);
        CertRequestInfo certRequest = certClient.getRequest(requestId);
        CACertRequestCLI.printCertRequestInfo(certRequest);
    }

    public void performAction(CACertClient certClient, RequestId requestId, CertReviewResponse reviewInfo) throws Exception {
    }
}

