/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.util.Locale;
import org.mozilla.jss.netscape.security.util.CrlPrettyPrint;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.DeltaCRLIndicatorExtension;
import org.mozilla.jss.netscape.security.x509.HoldInstructionExtension;
import org.mozilla.jss.netscape.security.x509.InvalidityDateExtension;
import org.mozilla.jss.netscape.security.x509.IssuingDistributionPointExtension;
import org.mozilla.jss.netscape.security.x509.OIDMap;
import org.mozilla.jss.netscape.security.x509.X509CRLImpl;
import org.mozilla.jss.netscape.security.x509.X509ExtensionException;

public class PrettyPrintCrl {
    public static final int ARGC = 2;
    public static final String HEADER = "-----BEGIN";
    public static final String TRAILER = "-----END";

    public static void main(String[] argv) {
        BufferedReader inputCrl = null;
        String encodedBASE64CrlChunk = "";
        StringBuffer encodedBASE64Crl = new StringBuffer();
        byte[] decodedBASE64Crl = null;
        X509CRLImpl crl = null;
        Locale aLocale = null;
        CrlPrettyPrint CrlDetails = null;
        FileOutputStream outputCrl = null;
        if (argv.length < 1 || argv.length > 2) {
            System.out.println("Usage:  PrettyPrintCrl <input filename> [output filename]");
            return;
        }
        try {
            OIDMap.addAttribute((String)DeltaCRLIndicatorExtension.class.getName(), (String)"2.5.29.27", (String)"DeltaCRLIndicator");
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        try {
            OIDMap.addAttribute((String)HoldInstructionExtension.class.getName(), (String)"2.5.29.23", (String)"HoldInstruction");
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        try {
            OIDMap.addAttribute((String)InvalidityDateExtension.class.getName(), (String)"2.5.29.24", (String)"InvalidityDate");
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        try {
            OIDMap.addAttribute((String)IssuingDistributionPointExtension.class.getName(), (String)"2.5.29.28", (String)"IssuingDistributionPoint");
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        try {
            inputCrl = new BufferedReader(new InputStreamReader(new BufferedInputStream(new FileInputStream(argv[0]))));
        }
        catch (FileNotFoundException e) {
            System.out.println("PrettyPrintCrl():  can''t find file " + argv[0] + ":\n" + e);
            return;
        }
        try {
            while ((encodedBASE64CrlChunk = inputCrl.readLine()) != null) {
                if (encodedBASE64CrlChunk.startsWith(HEADER) || encodedBASE64CrlChunk.startsWith(TRAILER)) continue;
                encodedBASE64Crl.append(encodedBASE64CrlChunk.trim());
            }
        }
        catch (IOException e) {
            System.out.println("PrettyPrintCrl():  Unexpected BASE64 encoded error encountered in readLine():\n" + e);
        }
        try {
            inputCrl.close();
        }
        catch (IOException e) {
            System.out.println("PrettyPrintCrl():  Unexpected BASE64 encoded error encountered in close():\n" + e);
        }
        decodedBASE64Crl = Utils.base64decode((String)encodedBASE64Crl.toString());
        try {
            crl = new X509CRLImpl(decodedBASE64Crl);
        }
        catch (CRLException e) {
            System.out.println("PrettyPrintCrl():  Error encountered on parsing and initialization errors:\n" + e);
        }
        catch (X509ExtensionException e) {
            System.out.println("PrettyPrintCrl():  Error encountered on parsing and initialization errors:\n" + e);
        }
        aLocale = Locale.getDefault();
        CrlDetails = new CrlPrettyPrint(crl);
        String pp = CrlDetails.toString(aLocale);
        if (argv.length != 2) {
            System.out.println(pp);
        } else {
            try {
                outputCrl = new FileOutputStream(argv[1]);
            }
            catch (IOException e) {
                System.out.println("PrettyPrintCrl():  unable to open file " + argv[1] + " for writing:\n" + e);
                return;
            }
            try {
                outputCrl.write(pp.getBytes());
            }
            catch (IOException e) {
                System.out.println("PrettyPrintCrl():  I/O error encountered during write():\n" + e);
            }
            try {
                outputCrl.close();
            }
            catch (IOException e) {
                System.out.println("PrettyPrintCrl():  Unexpected error encountered while attempting to close() " + argv[1] + ":\n" + e);
            }
        }
    }
}

