/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.selftests;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.logging.LogEventListener;
import com.netscape.certsrv.selftests.EDuplicateSelfTestException;
import com.netscape.certsrv.selftests.EInvalidSelfTestException;
import com.netscape.certsrv.selftests.EMissingSelfTestException;
import com.netscape.certsrv.selftests.ESelfTestException;
import com.netscape.cms.selftests.SelfTest;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.selftests.SelfTestSubsystem;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Locale;
import org.dogtagpki.server.tps.TPSEngine;
import org.dogtagpki.server.tps.TPSSubsystem;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;

public class TPSValidity
extends SelfTest {
    public static final String PROP_TPS_SUB_ID = "TpsSubId";
    private String tpsSubId = null;

    public void initSelfTest(SelfTestSubsystem subsystem, String instanceName, ConfigStore parameters) throws EDuplicateSelfTestException, EInvalidSelfTestException, EMissingSelfTestException {
        super.initSelfTest(subsystem, instanceName, parameters);
        try {
            this.tpsSubId = this.mConfig.getString(PROP_TPS_SUB_ID);
            if (this.tpsSubId == null) {
                this.mSelfTestSubsystem.log(this.mSelfTestSubsystem.getSelfTestLogger(), CMS.getLogMessage((String)"SELFTESTS_MISSING_VALUES", (Object[])new Object[]{this.getSelfTestName(), this.mPrefix + ".TpsSubId"}));
                throw new EMissingSelfTestException(PROP_TPS_SUB_ID);
            }
            this.tpsSubId = this.tpsSubId.trim();
        }
        catch (EBaseException e) {
            this.mSelfTestSubsystem.log(this.mSelfTestSubsystem.getSelfTestLogger(), CMS.getLogMessage((String)"SELFTESTS_MISSING_NAME", (Object[])new Object[]{this.getSelfTestName(), this.mPrefix + ".TpsSubId"}));
            throw new EMissingSelfTestException(this.mPrefix, PROP_TPS_SUB_ID, null);
        }
    }

    public void startupSelfTest() throws ESelfTestException {
    }

    public void shutdownSelfTest() {
    }

    public String getSelfTestName() {
        return super.getSelfTestName();
    }

    public ConfigStore getSelfTestConfigStore() {
        return super.getSelfTestConfigStore();
    }

    public String getSelfTestDescription(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_SELFTESTS_TPS_VALIDITY_DESCRIPTION", (String[])new String[0]);
    }

    public void runSelfTest(LogEventListener logger) throws Exception {
        X509CertImpl tpsCert;
        TPSEngine engine = TPSEngine.getInstance();
        TPSSubsystem tps = (TPSSubsystem)engine.getSubsystem(this.tpsSubId);
        if (tps == null) {
            String logMessage = CMS.getLogMessage((String)"SELFTESTS_TPS_IS_NOT_PRESENT", (Object[])new Object[]{this.getSelfTestName()});
            this.mSelfTestSubsystem.log(logger, logMessage);
            throw new Exception(logMessage);
        }
        try {
            tpsCert = new X509CertImpl(tps.getSubsystemCert().getEncoded());
        }
        catch (Exception e) {
            String logMessage = CMS.getLogMessage((String)"SELFTESTS_TPS_IS_NOT_INITIALIZED", (Object[])new Object[]{this.getSelfTestName()});
            this.mSelfTestSubsystem.log(logger, logMessage);
            throw e;
        }
        try {
            tpsCert.checkValidity();
        }
        catch (CertificateNotYetValidException e) {
            String logMessage = CMS.getLogMessage((String)"SELFTESTS_TPS_IS_NOT_YET_VALID", (Object[])new Object[]{this.getSelfTestName()});
            this.mSelfTestSubsystem.log(logger, logMessage);
            throw e;
        }
        catch (CertificateExpiredException e) {
            String logMessage = CMS.getLogMessage((String)"SELFTESTS_TPS_IS_EXPIRED", (Object[])new Object[]{this.getSelfTestName()});
            this.mSelfTestSubsystem.log(logger, logMessage);
            throw e;
        }
        String logMessage = CMS.getLogMessage((String)"SELFTESTS_TPS_IS_VALID", (Object[])new Object[]{this.getSelfTestName()});
        this.mSelfTestSubsystem.log(logger, logMessage);
    }
}

