/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.rest;

import com.netscape.certsrv.base.BadRequestException;
import com.netscape.certsrv.base.ForbiddenException;
import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.tps.profile.ProfileMappingCollection;
import com.netscape.certsrv.tps.profile.ProfileMappingData;
import com.netscape.certsrv.tps.profile.ProfileMappingResource;
import com.netscape.cms.servlet.base.SubsystemService;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.logging.Auditor;
import java.net.URI;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.dogtagpki.server.tps.TPSEngine;
import org.dogtagpki.server.tps.TPSSubsystem;
import org.dogtagpki.server.tps.config.ProfileMappingDatabase;
import org.dogtagpki.server.tps.config.ProfileMappingRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileMappingService
extends SubsystemService
implements ProfileMappingResource {
    public static Logger logger = LoggerFactory.getLogger(ProfileMappingService.class);

    public ProfileMappingService() {
        logger.debug("ProfileMappingService.<init>()");
    }

    public ProfileMappingData createProfileMappingData(ProfileMappingRecord profileMappingRecord) {
        ProfileMappingData profileMappingData = new ProfileMappingData();
        profileMappingData.setID(profileMappingRecord.getID());
        profileMappingData.setProfileMappingID(profileMappingRecord.getID());
        profileMappingData.setStatus(profileMappingRecord.getStatus());
        profileMappingData.setProperties(profileMappingRecord.getProperties());
        return profileMappingData;
    }

    public ProfileMappingRecord createProfileMappingRecord(ProfileMappingData profileMappingData) {
        String id = profileMappingData.getID();
        ProfileMappingRecord profileMappingRecord = new ProfileMappingRecord();
        profileMappingRecord.setID(id == null ? profileMappingData.getProfileMappingID() : id);
        profileMappingRecord.setStatus(profileMappingData.getStatus());
        profileMappingRecord.setProperties(profileMappingData.getProperties());
        return profileMappingRecord;
    }

    public Response findProfileMappings(String filter, Integer start, Integer size) {
        logger.debug("ProfileMappingService.findProfileMappings()");
        if (filter != null && filter.length() < 3) {
            throw new BadRequestException("Filter is too short.");
        }
        start = start == null ? 0 : start;
        size = size == null ? 20 : size;
        TPSEngine engine = TPSEngine.getInstance();
        try {
            int i;
            TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
            ProfileMappingDatabase database = subsystem.getProfileMappingDatabase();
            Iterator<ProfileMappingRecord> profileMappings = database.findRecords(filter).iterator();
            ProfileMappingCollection response = new ProfileMappingCollection();
            for (i = 0; i < start && profileMappings.hasNext(); ++i) {
                profileMappings.next();
            }
            while (i < start + size && profileMappings.hasNext()) {
                response.addEntry((Object)this.createProfileMappingData(profileMappings.next()));
                ++i;
            }
            while (profileMappings.hasNext()) {
                profileMappings.next();
                ++i;
            }
            response.setTotal(i);
            return this.createOKResponse(response);
        }
        catch (PKIException e) {
            logger.error("ProfileMappingService: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("ProfileMappingService: " + e.getMessage(), (Throwable)e);
            throw new PKIException((Throwable)e);
        }
    }

    public Response getProfileMapping(String profileMappingID) {
        logger.debug("ProfileMappingService.getProfileMapping(\"" + profileMappingID + "\")");
        TPSEngine engine = TPSEngine.getInstance();
        try {
            TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
            ProfileMappingDatabase database = subsystem.getProfileMappingDatabase();
            return this.createOKResponse(this.createProfileMappingData(database.getRecord(profileMappingID)));
        }
        catch (PKIException e) {
            logger.error("ProfileMappingService: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("ProfileMappingService: " + e.getMessage(), (Throwable)e);
            throw new PKIException((Throwable)e);
        }
    }

    public Response addProfileMapping(ProfileMappingData profileMappingData) {
        String method = "ProfileMappingService.addProfileMapping";
        logger.debug("ProfileMappingService.addProfileMapping(\"" + profileMappingData.getProfileMappingID() + "\")");
        TPSEngine engine = TPSEngine.getInstance();
        ProfileMappingData pmd = null;
        try {
            TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
            ProfileMappingDatabase database = subsystem.getProfileMappingDatabase();
            String status = profileMappingData.getStatus();
            Principal principal = this.servletRequest.getUserPrincipal();
            if (StringUtils.isEmpty((CharSequence)status) || database.requiresApproval() && !database.canApprove(principal)) {
                profileMappingData.setStatus("Disabled");
            }
            String id = profileMappingData.getProfileMappingID();
            database.addRecord(id, this.createProfileMappingRecord(profileMappingData));
            pmd = this.createProfileMappingData(database.getRecord(id));
            this.auditMappingResolverChange("Success", method, pmd.getID(), profileMappingData.getProperties(), null);
            String profileMappingID = URLEncoder.encode(pmd.getID(), "UTF-8");
            URI uri = this.uriInfo.getBaseUriBuilder().path(ProfileMappingResource.class).path("{profileMappingID}").build(new Object[]{profileMappingID});
            return this.createCreatedResponse(pmd, uri);
        }
        catch (PKIException e) {
            logger.error("ProfileMappingService: " + e.getMessage(), (Throwable)e);
            this.auditMappingResolverChange("Failure", method, profileMappingData.getID(), profileMappingData.getProperties(), e.toString());
            throw e;
        }
        catch (Exception e) {
            logger.error("ProfileMappingService: " + e.getMessage(), (Throwable)e);
            this.auditMappingResolverChange("Failure", method, profileMappingData.getID(), profileMappingData.getProperties(), e.toString());
            throw new PKIException((Throwable)e);
        }
    }

    public Response updateProfileMapping(String profileMappingID, ProfileMappingData profileMappingData) {
        String method = "ProfileMappingService.updateProfileMapping";
        logger.debug("ProfileMappingService.updateProfileMapping(\"" + profileMappingID + "\")");
        TPSEngine engine = TPSEngine.getInstance();
        try {
            Map properties;
            TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
            ProfileMappingDatabase database = subsystem.getProfileMappingDatabase();
            ProfileMappingRecord record = database.getRecord(profileMappingID);
            if (!"Disabled".equals(record.getStatus())) {
                ForbiddenException e = new ForbiddenException("Unable to update profile mapping " + profileMappingID);
                this.auditMappingResolverChange("Failure", method, profileMappingData.getID(), profileMappingData.getProperties(), e.toString());
                throw e;
            }
            String status = profileMappingData.getStatus();
            boolean statusChanged = false;
            if (status != null && !"Disabled".equals(status)) {
                if (!"Enabled".equals(status)) {
                    ForbiddenException e = new ForbiddenException("Invalid profile mapping status: " + status);
                    this.auditMappingResolverChange("Failure", method, profileMappingData.getID(), profileMappingData.getProperties(), e.toString());
                    throw e;
                }
                Principal principal = this.servletRequest.getUserPrincipal();
                if (database.requiresApproval() && !database.canApprove(principal)) {
                    status = "Pending_Approval";
                }
                record.setStatus(status);
                statusChanged = true;
            }
            if ((properties = profileMappingData.getProperties()) != null) {
                record.setProperties(properties);
            }
            database.updateRecord(profileMappingID, record);
            profileMappingData = this.createProfileMappingData(database.getRecord(profileMappingID));
            if (statusChanged) {
                properties.put("Status", status);
            }
            this.auditMappingResolverChange("Success", method, profileMappingData.getID(), properties, null);
            return this.createOKResponse(profileMappingData);
        }
        catch (PKIException e) {
            logger.error("ProfileMappingService: " + e.getMessage(), (Throwable)e);
            this.auditMappingResolverChange("Failure", method, profileMappingData.getID(), profileMappingData.getProperties(), e.toString());
            throw e;
        }
        catch (Exception e) {
            logger.error("ProfileMappingService: " + e.getMessage(), (Throwable)e);
            this.auditMappingResolverChange("Failure", method, profileMappingData.getID(), profileMappingData.getProperties(), e.toString());
            throw new PKIException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response changeStatus(String profileMappingID, String action) {
        String method = "ProfileMappingService.changeStatus";
        HashMap<String, String> auditModParams = new HashMap<String, String>();
        if (profileMappingID == null) {
            this.auditConfigTokenGeneral("Failure", method, null, "Profile mapper ID is null.");
            throw new BadRequestException("Profile mapper ID is null.");
        }
        if (action == null) {
            this.auditConfigTokenGeneral("Failure", method, auditModParams, "action is null.");
            throw new BadRequestException("Action is null.");
        }
        auditModParams.put("Action", action);
        logger.debug("ProfileMappingService.changeStatus(\"" + profileMappingID + "\", \"" + action + "\")");
        TPSEngine engine = TPSEngine.getInstance();
        try {
            String status;
            boolean statusChanged;
            ProfileMappingRecord record;
            ProfileMappingDatabase database;
            block21: {
                boolean canApprove;
                block22: {
                    block23: {
                        TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
                        database = subsystem.getProfileMappingDatabase();
                        record = database.getRecord(profileMappingID);
                        statusChanged = false;
                        status = record.getStatus();
                        Principal principal = this.servletRequest.getUserPrincipal();
                        canApprove = database.canApprove(principal);
                        if (!"Disabled".equals(status)) break block22;
                        if (!database.requiresApproval()) break block23;
                        if ("submit".equals(action) && !canApprove) {
                            status = "Pending_Approval";
                            statusChanged = true;
                            break block21;
                        } else if ("enable".equals(action) && canApprove) {
                            status = "Enabled";
                            statusChanged = true;
                            break block21;
                        } else {
                            BadRequestException e = new BadRequestException("Invalid action: " + action);
                            this.auditMappingResolverChange("Failure", method, profileMappingID, auditModParams, e.toString());
                            throw e;
                        }
                    }
                    if (!"enable".equals(action)) {
                        BadRequestException e = new BadRequestException("Invalid action: " + action);
                        this.auditMappingResolverChange("Failure", method, profileMappingID, auditModParams, e.toString());
                        throw e;
                    }
                    status = "Enabled";
                    statusChanged = true;
                    break block21;
                }
                if ("Enabled".equals(status)) {
                    if (!"disable".equals(action)) {
                        BadRequestException e = new BadRequestException("Invalid action: " + action);
                        this.auditMappingResolverChange("Failure", method, profileMappingID, auditModParams, e.toString());
                        throw e;
                    }
                    status = "Disabled";
                    statusChanged = true;
                } else {
                    if (!"Pending_Approval".equals(status)) {
                        PKIException e = new PKIException("Invalid profile mapping status: " + status);
                        this.auditMappingResolverChange("Failure", method, profileMappingID, auditModParams, e.toString());
                        throw e;
                    }
                    if ("approve".equals(action) && canApprove) {
                        status = "Enabled";
                        statusChanged = true;
                    } else if ("reject".equals(action) && canApprove) {
                        status = "Disabled";
                        statusChanged = true;
                    } else if ("cancel".equals(action) && !canApprove) {
                        status = "Disabled";
                        statusChanged = true;
                    } else {
                        BadRequestException e = new BadRequestException("Invalid action: " + action);
                        this.auditMappingResolverChange("Failure", method, profileMappingID, auditModParams, e.toString());
                        throw e;
                    }
                }
            }
            record.setStatus(status);
            database.updateRecord(profileMappingID, record);
            ProfileMappingData profileMappingData = this.createProfileMappingData(database.getRecord(profileMappingID));
            if (statusChanged) {
                auditModParams.put("Status", status);
            }
            this.auditMappingResolverChange("Success", method, profileMappingData.getID(), auditModParams, null);
            return this.createOKResponse(profileMappingData);
        }
        catch (PKIException e) {
            logger.error("ProfileMappingService: " + e.getMessage(), (Throwable)e);
            this.auditMappingResolverChange("Failure", method, profileMappingID, auditModParams, e.toString());
            throw e;
        }
        catch (Exception e) {
            logger.error("ProfileMappingService: " + e.getMessage(), (Throwable)e);
            this.auditMappingResolverChange("Failure", method, profileMappingID, auditModParams, e.toString());
            throw new PKIException((Throwable)e);
        }
    }

    public Response removeProfileMapping(String profileMappingID) {
        String method = "ProfileMappingService.removeProfileMapping";
        HashMap<String, String> auditModParams = new HashMap<String, String>();
        logger.debug("ProfileMappingService.removeProfileMapping(\"" + profileMappingID + "\")");
        TPSEngine engine = TPSEngine.getInstance();
        try {
            TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
            ProfileMappingDatabase database = subsystem.getProfileMappingDatabase();
            ProfileMappingRecord record = database.getRecord(profileMappingID);
            String status = record.getStatus();
            if (!"Disabled".equals(status)) {
                ForbiddenException e = new ForbiddenException("Unable to delete profile mapping " + profileMappingID);
                this.auditMappingResolverChange("Failure", method, profileMappingID, auditModParams, e.toString());
                throw e;
            }
            database.removeRecord(profileMappingID);
            this.auditMappingResolverChange("Success", method, profileMappingID, null, null);
            return this.createNoContentResponse();
        }
        catch (PKIException e) {
            logger.error("ProfileMappingService: " + e.getMessage(), (Throwable)e);
            this.auditMappingResolverChange("Failure", method, profileMappingID, auditModParams, e.toString());
            throw e;
        }
        catch (Exception e) {
            logger.error("ProfileMappingService: " + e.getMessage(), (Throwable)e);
            this.auditMappingResolverChange("Failure", method, profileMappingID, auditModParams, e.toString());
            throw new PKIException((Throwable)e);
        }
    }

    public void auditMappingResolverChange(String status, String service, String resolverID, Map<String, String> params, String info) {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String msg = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_TOKEN_MAPPING_RESOLVER_6", (Object[])new Object[]{this.servletRequest.getUserPrincipal().getName(), status, service, resolverID, auditor.getParamString(params), info});
        auditor.log(msg);
    }
}

