/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.rest;

import com.netscape.certsrv.base.BadRequestException;
import com.netscape.certsrv.base.ForbiddenException;
import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.tps.connector.ConnectorCollection;
import com.netscape.certsrv.tps.connector.ConnectorData;
import com.netscape.certsrv.tps.connector.ConnectorResource;
import com.netscape.cms.servlet.base.SubsystemService;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.logging.Auditor;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.dogtagpki.server.tps.TPSEngine;
import org.dogtagpki.server.tps.TPSSubsystem;
import org.dogtagpki.server.tps.config.ConnectorDatabase;
import org.dogtagpki.server.tps.config.ConnectorRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorService
extends SubsystemService
implements ConnectorResource {
    public static Logger logger = LoggerFactory.getLogger(ConnectorService.class);

    public ConnectorService() {
        logger.debug("ConnectorService.<init>()");
    }

    public ConnectorData createConnectorData(ConnectorRecord connectionRecord) throws UnsupportedEncodingException {
        String connectorID = connectionRecord.getID();
        ConnectorData connectorData = new ConnectorData();
        connectorData.setID(connectorID);
        connectorData.setStatus(connectionRecord.getStatus());
        connectorData.setProperties(connectionRecord.getProperties());
        connectorID = URLEncoder.encode(connectorID, "UTF-8");
        return connectorData;
    }

    public ConnectorRecord createConnectorRecord(ConnectorData connectorData) {
        ConnectorRecord connectorRecord = new ConnectorRecord();
        connectorRecord.setID(connectorData.getID());
        connectorRecord.setStatus(connectorData.getStatus());
        connectorRecord.setProperties(connectorData.getProperties());
        return connectorRecord;
    }

    public Response findConnectors(String filter, Integer start, Integer size) {
        logger.info("ConnectorService: Finding connectors");
        if (filter != null && filter.length() < 3) {
            throw new BadRequestException("Filter is too short.");
        }
        start = start == null ? 0 : start;
        size = size == null ? 20 : size;
        TPSEngine engine = TPSEngine.getInstance();
        try {
            int i;
            TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
            ConnectorDatabase database = subsystem.getConnectorDatabase();
            logger.info("ConnectorService: Results:");
            Iterator<ConnectorRecord> connections = database.findRecords(filter).iterator();
            ConnectorCollection response = new ConnectorCollection();
            for (i = 0; i < start && connections.hasNext(); ++i) {
                connections.next();
            }
            while (i < start + size && connections.hasNext()) {
                ConnectorRecord record = connections.next();
                logger.info("ConnectorService: - " + record.getID());
                response.addEntry((Object)this.createConnectorData(record));
                ++i;
            }
            while (connections.hasNext()) {
                connections.next();
                ++i;
            }
            response.setTotal(i);
            return this.createOKResponse(response);
        }
        catch (PKIException e) {
            logger.error("ConnectorService: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("ConnectorService: " + e.getMessage(), (Throwable)e);
            throw new PKIException((Throwable)e);
        }
    }

    public Response getConnector(String connectorID) {
        logger.info("ConnectorService: Retrieving connector " + connectorID);
        if (connectorID == null) {
            throw new BadRequestException("Connector ID is null.");
        }
        TPSEngine engine = TPSEngine.getInstance();
        try {
            TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
            ConnectorDatabase database = subsystem.getConnectorDatabase();
            return this.createOKResponse(this.createConnectorData(database.getRecord(connectorID)));
        }
        catch (PKIException e) {
            logger.error("ConnectorService: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("ConnectorService: " + e.getMessage(), (Throwable)e);
            throw new PKIException((Throwable)e);
        }
    }

    public Response addConnector(ConnectorData connectorData) {
        String method = "ConnectorService.addConnector";
        if (connectorData == null) {
            this.auditConfigTokenGeneral("Failure", method, null, "Connector data is null.");
            throw new BadRequestException("Connector data is null.");
        }
        logger.info("ConnectorService: Adding connector " + connectorData.getID());
        TPSEngine engine = TPSEngine.getInstance();
        try {
            TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
            ConnectorDatabase database = subsystem.getConnectorDatabase();
            boolean requiresApproval = database.requiresApproval();
            logger.info("ConnectorService: - requires approval: " + requiresApproval);
            String status = connectorData.getStatus();
            Principal principal = this.servletRequest.getUserPrincipal();
            boolean canApprove = database.canApprove(principal);
            logger.info("ConnectorService: - can approve: " + canApprove);
            boolean statusChanged = false;
            if (StringUtils.isEmpty((CharSequence)status) || requiresApproval && !canApprove) {
                status = "Disabled";
                connectorData.setStatus(status);
                statusChanged = true;
            }
            logger.info("ConnectorService: - status: " + status);
            database.addRecord(connectorData.getID(), this.createConnectorRecord(connectorData));
            connectorData = this.createConnectorData(database.getRecord(connectorData.getID()));
            Map properties = connectorData.getProperties();
            if (statusChanged) {
                properties.put("Status", status);
            }
            this.auditTPSConnectorChange("Success", method, connectorData.getID(), properties, null);
            String connectorID = URLEncoder.encode(connectorData.getID(), "UTF-8");
            URI uri = this.uriInfo.getBaseUriBuilder().path(ConnectorResource.class).path("{connectorID}").build(new Object[]{connectorID});
            return this.createCreatedResponse(connectorData, uri);
        }
        catch (PKIException e) {
            logger.error("ConnectorService: " + e.getMessage(), (Throwable)e);
            this.auditTPSConnectorChange("Failure", method, connectorData.getID(), connectorData.getProperties(), e.toString());
            throw e;
        }
        catch (Exception e) {
            logger.error("ConnectorService: " + e.getMessage(), (Throwable)e);
            this.auditTPSConnectorChange("Failure", method, connectorData.getID(), connectorData.getProperties(), e.toString());
            throw new PKIException((Throwable)e);
        }
    }

    public Response updateConnector(String connectorID, ConnectorData connectorData) {
        logger.info("ConnectorService: Updating connector " + connectorID);
        String method = "ConnectorService.updateConnector";
        if (connectorID == null) {
            this.auditConfigTokenGeneral("Failure", method, null, "Connector id is null.");
            throw new BadRequestException("Connector ID is null.");
        }
        if (connectorData == null) {
            this.auditConfigTokenGeneral("Failure", method, null, "Connector data is null.");
            throw new BadRequestException("Connector data is null.");
        }
        TPSEngine engine = TPSEngine.getInstance();
        try {
            Map properties;
            TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
            ConnectorDatabase database = subsystem.getConnectorDatabase();
            ConnectorRecord record = database.getRecord(connectorID);
            String currentStatus = record.getStatus();
            logger.info("ConnectorService: - current status: " + currentStatus);
            if (!"Disabled".equals(currentStatus)) {
                ForbiddenException e = new ForbiddenException("Unable to update connector " + connectorID);
                this.auditTPSConnectorChange("Failure", method, connectorData.getID(), connectorData.getProperties(), e.toString());
                throw e;
            }
            String status = connectorData.getStatus();
            logger.info("ConnectorService: - new status: " + status);
            boolean statusChanged = false;
            if (status != null && !"Disabled".equals(status)) {
                if (!"Enabled".equals(status)) {
                    ForbiddenException e = new ForbiddenException("Invalid connector status: " + status);
                    this.auditTPSConnectorChange("Failure", method, connectorData.getID(), connectorData.getProperties(), e.toString());
                    throw e;
                }
                boolean requiresApproval = database.requiresApproval();
                logger.info("ConnectorService: - requires approve: " + requiresApproval);
                Principal principal = this.servletRequest.getUserPrincipal();
                boolean canApprove = database.canApprove(principal);
                logger.info("ConnectorService: - can approve: " + canApprove);
                if (requiresApproval && !canApprove) {
                    status = "Pending_Approval";
                }
                record.setStatus(status);
                statusChanged = true;
            }
            if ((properties = connectorData.getProperties()) != null) {
                record.setProperties(properties);
                if (statusChanged) {
                    properties.put("Status", status);
                }
            }
            database.updateRecord(connectorID, record);
            connectorData = this.createConnectorData(database.getRecord(connectorID));
            this.auditTPSConnectorChange("Success", method, connectorData.getID(), properties, null);
            return this.createOKResponse(connectorData);
        }
        catch (PKIException e) {
            logger.error("ConnectorService: " + e.getMessage(), (Throwable)e);
            this.auditTPSConnectorChange("Failure", method, connectorData.getID(), connectorData.getProperties(), e.toString());
            throw e;
        }
        catch (Exception e) {
            logger.error("ConnectorService: " + e.getMessage(), (Throwable)e);
            this.auditTPSConnectorChange("Failure", method, connectorData.getID(), connectorData.getProperties(), e.toString());
            throw new PKIException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response changeStatus(String connectorID, String action) {
        logger.info("ConnectorService: Changing connector " + connectorID + " status: " + action);
        String method = "ConnectorService.changeStatus";
        HashMap<String, String> auditModParams = new HashMap<String, String>();
        if (connectorID == null) {
            this.auditConfigTokenGeneral("Failure", method, null, "Connector id is null.");
            throw new BadRequestException("Connector ID is null.");
        }
        if (action == null) {
            this.auditConfigTokenGeneral("Failure", method, null, "Action is null.");
            throw new BadRequestException("Action is null.");
        }
        auditModParams.put("Action", action);
        TPSEngine engine = TPSEngine.getInstance();
        try {
            String status;
            ConnectorRecord record;
            ConnectorDatabase database;
            block20: {
                boolean canApprove;
                block21: {
                    block22: {
                        TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
                        database = subsystem.getConnectorDatabase();
                        record = database.getRecord(connectorID);
                        status = record.getStatus();
                        Principal principal = this.servletRequest.getUserPrincipal();
                        canApprove = database.canApprove(principal);
                        logger.info("ConnectorService: - can approve: " + canApprove);
                        logger.info("ConnectorService: - current status: " + status);
                        if (!"Disabled".equals(status)) break block21;
                        boolean requiresApproval = database.requiresApproval();
                        logger.info("ConnectorService: - requires approval: " + requiresApproval);
                        if (!requiresApproval) break block22;
                        if ("submit".equals(action) && !canApprove) {
                            status = "Pending_Approval";
                            break block20;
                        } else if ("enable".equals(action) && canApprove) {
                            status = "Enabled";
                            break block20;
                        } else {
                            BadRequestException e = new BadRequestException("Invalid action: " + action);
                            this.auditConfigTokenGeneral("Failure", method, auditModParams, e.toString());
                            this.auditTPSConnectorChange("Failure", method, connectorID, auditModParams, e.toString());
                            throw e;
                        }
                    }
                    if (!"enable".equals(action)) {
                        BadRequestException e = new BadRequestException("Invalid action: " + action);
                        this.auditTPSConnectorChange("Failure", method, connectorID, auditModParams, e.toString());
                        throw e;
                    }
                    status = "Enabled";
                    break block20;
                }
                if ("Enabled".equals(status)) {
                    if (!"disable".equals(action)) {
                        BadRequestException e = new BadRequestException("Invalid action: " + action);
                        this.auditTPSConnectorChange("Failure", method, connectorID, auditModParams, e.toString());
                        throw e;
                    }
                    status = "Disabled";
                } else {
                    if (!"Pending_Approval".equals(status)) {
                        BadRequestException e = new BadRequestException("Invalid connector status: " + status);
                        this.auditTPSConnectorChange("Failure", method, connectorID, auditModParams, e.toString());
                        throw e;
                    }
                    if ("approve".equals(action) && canApprove) {
                        status = "Enabled";
                    } else if ("reject".equals(action) && canApprove) {
                        status = "Disabled";
                    } else if ("cancel".equals(action) && !canApprove) {
                        status = "Disabled";
                    } else {
                        BadRequestException e = new BadRequestException("Invalid action: " + action);
                        this.auditTPSConnectorChange("Failure", method, connectorID, auditModParams, e.toString());
                        throw e;
                    }
                }
            }
            record.setStatus(status);
            database.updateRecord(connectorID, record);
            ConnectorData connectorData = this.createConnectorData(database.getRecord(connectorID));
            auditModParams.put("Status", status);
            this.auditTPSConnectorChange("Success", method, connectorData.getID(), auditModParams, null);
            return this.createOKResponse(connectorData);
        }
        catch (PKIException e) {
            logger.error("ConnectorService: " + e.getMessage(), (Throwable)e);
            this.auditTPSConnectorChange("Failure", method, connectorID, auditModParams, e.toString());
            throw e;
        }
        catch (Exception e) {
            logger.error("ConnectorService: " + e.getMessage(), (Throwable)e);
            this.auditTPSConnectorChange("Failure", method, connectorID, auditModParams, e.toString());
            throw new PKIException((Throwable)e);
        }
    }

    public Response removeConnector(String connectorID) {
        String method = "ConnectorService.removeConnector";
        HashMap<String, String> auditModParams = new HashMap<String, String>();
        if (connectorID == null) {
            this.auditConfigTokenGeneral("Failure", method, null, "Connector ID is null.");
            throw new BadRequestException("Connector ID is null.");
        }
        auditModParams.put("connectorID", connectorID);
        logger.debug("ConnectorService.removeConnector(\"" + connectorID + "\")");
        TPSEngine engine = TPSEngine.getInstance();
        try {
            TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
            ConnectorDatabase database = subsystem.getConnectorDatabase();
            ConnectorRecord record = database.getRecord(connectorID);
            String status = record.getStatus();
            if (!"Disabled".equals(status)) {
                ForbiddenException e = new ForbiddenException("Unable to delete connector " + connectorID + "; connector not disabled");
                this.auditTPSConnectorChange("Failure", method, connectorID, auditModParams, e.toString());
                throw e;
            }
            database.removeRecord(connectorID);
            this.auditTPSConnectorChange("Success", method, connectorID, null, null);
            return this.createNoContentResponse();
        }
        catch (PKIException e) {
            logger.error("ConnectorService: " + e.getMessage(), (Throwable)e);
            this.auditTPSConnectorChange("Failure", method, connectorID, auditModParams, e.toString());
            throw e;
        }
        catch (Exception e) {
            logger.error("ConnectorService: " + e.getMessage(), (Throwable)e);
            this.auditTPSConnectorChange("Failure", method, connectorID, auditModParams, e.toString());
            throw new PKIException((Throwable)e);
        }
    }

    public void auditTPSConnectorChange(String status, String service, String connectorID, Map<String, String> params, String info) {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String msg = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_TOKEN_CONNECTOR_6", (Object[])new Object[]{this.servletRequest.getUserPrincipal().getName(), status, service, connectorID, auditor.getParamString(params), info});
        auditor.log(msg);
    }
}

