/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.processor;

import com.netscape.certsrv.base.EBaseException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import org.dogtagpki.server.tps.dbs.TPSCertRecord;
import org.dogtagpki.server.tps.dbs.TokenCertStatus;
import org.dogtagpki.server.tps.main.PKCS11Obj;
import org.dogtagpki.server.tps.processor.CertEnrollInfo;
import org.dogtagpki.tps.main.TPSBuffer;
import org.dogtagpki.tps.main.Util;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnrolledCertsInfo {
    public static Logger logger = LoggerFactory.getLogger(EnrolledCertsInfo.class);
    private ArrayList<String> origins;
    private ArrayList<String> ktypes;
    private ArrayList<String> tokenTypes;
    private ArrayList<X509CertImpl> certificates = new ArrayList();
    private ArrayList<TokenCertStatus> certStatuses = new ArrayList();
    private ArrayList<CertEnrollInfo> externalRegRecoveryEnrollList;
    private TPSBuffer wrappedChallenge;
    private TPSBuffer plaintextChallenge;
    private TPSBuffer keyCheck;
    private int numCertsToEnroll;
    private int currentCertIndex;
    private int startProgress;
    private int endProgress;
    private PKCS11Obj pkcs11objx;

    EnrolledCertsInfo() {
        this.ktypes = new ArrayList();
        this.origins = new ArrayList();
        this.tokenTypes = new ArrayList();
        this.externalRegRecoveryEnrollList = new ArrayList();
    }

    EnrolledCertsInfo(PKCS11Obj obj, TPSBuffer wrappedChallenge, TPSBuffer plainChallenge, int keyTypeNum, int startProgress, int endProgress) {
        this();
        this.wrappedChallenge = wrappedChallenge;
        this.plaintextChallenge = plainChallenge;
        this.pkcs11objx = obj;
        this.numCertsToEnroll = keyTypeNum;
        this.startProgress = startProgress;
        this.endProgress = endProgress;
    }

    public int getCurrentCertIndex() {
        return this.currentCertIndex;
    }

    public ArrayList<CertEnrollInfo> getExternalRegRecoveryEnrollList() {
        return this.externalRegRecoveryEnrollList;
    }

    public void setCurrentCertIndex(int index) {
        this.currentCertIndex = index;
    }

    public void setNumCertsToEnroll(int num) {
        this.numCertsToEnroll = num;
    }

    public int getNumCertsToEnroll() {
        return this.numCertsToEnroll;
    }

    int getStartProgressValue() {
        return this.startProgress;
    }

    int getEndProgressValue() {
        return this.endProgress;
    }

    public void setKeyCheck(TPSBuffer keyCheck) {
        this.keyCheck = keyCheck;
    }

    public TPSBuffer getKeyCheck() {
        return this.keyCheck;
    }

    public void setWrappedChallenge(TPSBuffer wrappedChallenge) {
        this.wrappedChallenge = wrappedChallenge;
    }

    public TPSBuffer getWrappedChallenge() {
        return this.wrappedChallenge;
    }

    public void setPlaintextChallenge(TPSBuffer plaintextChallenge) {
        this.plaintextChallenge = plaintextChallenge;
    }

    public TPSBuffer getPlaintextChallenge() {
        return this.plaintextChallenge;
    }

    public void setPKCS11Obj(PKCS11Obj pkcs11obj) {
        this.pkcs11objx = pkcs11obj;
    }

    public PKCS11Obj getPKCS11Obj() {
        return this.pkcs11objx;
    }

    public void addOrigin(String origin) {
        logger.debug("EnrolledCertsInfo.addOrigin: " + origin);
        this.origins.add(origin);
    }

    public void addKType(String ktype) {
        this.ktypes.add(ktype);
    }

    public void addTokenType(String tokenType) {
        this.tokenTypes.add(tokenType);
    }

    public void addCertificate(X509CertImpl x509Cert) {
        this.certificates.add(x509Cert);
    }

    public void removeCertificate(X509CertImpl x509Cert) {
        this.certificates.remove(x509Cert);
    }

    public void addCertStatus(TokenCertStatus status) {
        this.certStatuses.add(status);
    }

    public void setCertStatus(int index, TokenCertStatus status) {
        this.certStatuses.set(index, status);
    }

    public void setStartProgress(int startP) {
        this.startProgress = startP;
    }

    public void setEndProgress(int endP) {
        this.endProgress = endP;
    }

    public ArrayList<TPSCertRecord> toTPSCertRecords(String cuid, String uid) {
        ArrayList<TPSCertRecord> certs = new ArrayList<TPSCertRecord>();
        logger.debug("EnrolledCertsInfo.toTPSCertRecords: starts");
        int index = 0;
        for (X509CertImpl cert : this.certificates) {
            TPSCertRecord certRecord = new TPSCertRecord();
            BigInteger serial_BigInt = cert.getSerialNumber();
            String hexSerial = serial_BigInt.toString(16);
            String serialNumber = "0x" + hexSerial;
            certRecord.setSerialNumber(serialNumber);
            String uniqueString = Util.getTimeStampString((boolean)false);
            String id = hexSerial + "." + uniqueString;
            certRecord.setId(id);
            logger.debug("EnrolledCertsInfo.toTPSCertRecords: converting cert:" + certRecord.getId());
            certRecord.setTokenID(cuid);
            logger.debug("EnrolledCertsInfo.toTPSCertRecords: cuid =" + cuid);
            if (!this.origins.isEmpty() && index < this.origins.size() && this.origins.get(index) != null) {
                certRecord.setOrigin(this.origins.get(index));
                logger.debug("EnrolledCertsInfo.toTPSCertRecords: origin =" + this.origins.get(index));
            } else {
                logger.warn("EnrolledCertsInfo.toTPSCertRecords: origin not found for index:" + index);
            }
            certRecord.setUserID(uid);
            logger.debug("EnrolledCertsInfo.toTPSCertRecords: uid =" + uid);
            if (!this.ktypes.isEmpty() && index < this.ktypes.size() && this.ktypes.get(index) != null) {
                certRecord.setKeyType(this.ktypes.get(index));
                logger.debug("EnrolledCertsInfo.toTPSCertRecords: keyType =" + this.ktypes.get(index));
            } else {
                logger.warn("EnrolledCertsInfo.toTPSCertRecords: keyType not found for index:" + index);
            }
            if (!this.tokenTypes.isEmpty() && index < this.tokenTypes.size() && this.tokenTypes.get(index) != null) {
                logger.debug("EnrolledCertsInfo.toTPSCertRecords: tokenType=" + this.tokenTypes.get(index));
                certRecord.setType(this.tokenTypes.get(index));
                logger.debug("EnrolledCertsInfo.toTPSCertRecords: tokenType set");
            } else {
                logger.warn("EnrolledCertsInfo.toTPSCertRecords: tokenType not found for index:" + index);
            }
            if (!this.certStatuses.isEmpty() && index < this.certStatuses.size() && this.certStatuses.get(index) != null) {
                logger.debug("EnrolledCertsInfo.toTPSCertRecords: cert status=" + (Object)((Object)this.certStatuses.get(index)));
                certRecord.setStatus(this.certStatuses.get(index).toString());
            } else {
                logger.warn("EnrolledCertsInfo.toTPSCertRecords: certStatus not found for index:" + index + "; set to default active");
                certRecord.setStatus(TokenCertStatus.ACTIVE.toString());
            }
            String issuedBy = cert.getIssuerName().toString();
            certRecord.setIssuedBy(issuedBy);
            logger.debug("EnrolledCertsInfo.toTPSCertRecords: issuer =" + issuedBy);
            String subject = cert.getSubjectName().toString();
            certRecord.setSubject(subject);
            logger.debug("EnrolledCertsInfo.toTPSCertRecords: subject =" + subject);
            certRecord.setValidNotBefore(cert.getNotBefore());
            logger.debug("EnrolledCertsInfo.toTPSCertRecords: notBefore =" + cert.getNotBefore().toString());
            certRecord.setValidNotAfter(cert.getNotAfter());
            logger.debug("EnrolledCertsInfo.toTPSCertRecords: notAfter =" + cert.getNotAfter().toString());
            try {
                String aki = Util.getCertAkiString((X509CertImpl)cert);
                certRecord.setCertificate(aki);
            }
            catch (EBaseException | IOException e) {
                logger.warn("EnrolledCertsInfo: " + e.getMessage(), e);
            }
            certs.add(certRecord);
            ++index;
        }
        logger.debug("EnrolledCertsInfo.toTPSCertRecords: ends");
        return certs;
    }
}

