/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.mapping;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.dogtagpki.tps.main.TPSException;
import org.dogtagpki.tps.msg.EndOpMsg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterMappingParams {
    public static Logger logger = LoggerFactory.getLogger(FilterMappingParams.class);
    public static final String FILTER_PARAM_MAJOR_VERSION = "fp_major_version";
    public static final String FILTER_PARAM_MINOR_VERSION = "fp_minor_version";
    public static final String FILTER_PARAM_CUID = "fp_cuid";
    public static final String FILTER_PARAM_MSN = "fp_msn";
    public static final String FILTER_PARAM_EXT_TOKEN_TYPE = "fp_ext_tokenType";
    public static final String FILTER_PARAM_EXT_TOKEN_ATR = "fp_ext_tokenATR";
    public static final String FILTER_PARAM_EXT_KEY_SET = "fp_ext_keySet";
    private HashMap<String, String> content = new HashMap();

    public String toString() {
        StringBuffer sb = new StringBuffer("[\n  Meta information:\n");
        for (Map.Entry<String, String> entry : this.content.entrySet()) {
            String key = entry.getKey();
            sb.append("  " + key + " : " + entry.getValue() + "\n");
        }
        sb.append("]\n");
        return sb.toString();
    }

    public String getString(String name) throws TPSException {
        String val = this.content.get(name);
        if (val == null) {
            logger.error("FilterMappingParams: Missing filter mapping parameter: " + name);
            throw new TPSException("Missing filter mapping parameter: " + name, EndOpMsg.TPSStatus.STATUS_ERROR_MAPPING_RESOLVER_PARAMS_NOT_FOUND);
        }
        return val;
    }

    public String getString(String name, String defaultValue) {
        String value = this.content.get(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public int getInt(String name) throws TPSException {
        String val = this.content.get(name);
        if (val == null) {
            logger.error("FilterMappingParams.getInt: param null: " + name);
            throw new TPSException("FilterMappingParams.getInt: param null:" + name, EndOpMsg.TPSStatus.STATUS_ERROR_MAPPING_RESOLVER_PARAMS_NOT_FOUND);
        }
        try {
            int intVal = Integer.parseInt(val);
            return intVal;
        }
        catch (NumberFormatException e) {
            logger.error("FilterMappingParams.getInt: param " + name + "=" + val + ": " + e.getMessage(), (Throwable)e);
            throw new TPSException("FilterMappingParams.getInt: param major_version:" + e, EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
    }

    public void set(String name, String val) {
        this.content.put(name, val);
    }

    public void delete(String name) {
        this.content.remove(name);
    }

    public Set<String> getElements() {
        return this.content.keySet();
    }
}

