/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.dbs;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.dbs.IDBObj;
import com.netscape.cmscore.dbs.DBSubsystem;
import com.netscape.cmscore.dbs.LDAPDatabase;
import com.netscape.cmsutil.ldap.LDAPUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.dogtagpki.server.tps.dbs.ActivityRecord;
import org.dogtagpki.tps.main.Util;

public class ActivityDatabase
extends LDAPDatabase<ActivityRecord> {
    public static final String OP_ADD = "add";
    public static final String OP_DELETE = "delete";
    public static final String OP_ENROLLMENT = "enrollment";
    public static final String OP_RECOVERY = "recovery";
    public static final String OP_RENEWAL = "renewal";
    public static final String OP_PIN_RESET = "pin_reset";
    public static final String OP_FORMAT = "format";
    public static final String OP_TOKEN_MODIFY = "token_modify";
    public static final String OP_TOKEN_STATUS_CHANGE = "token_status_change";
    public static final String OP_CERT_REVOCATION = "cert_revocation";
    public static final String OP_CERT_RESTORATION = "cert_restoration";
    public static final String OP_KEY_CHANGEOVER = "key_changeover";

    public ActivityDatabase(DBSubsystem dbSubsystem, String baseDN) throws EBaseException {
        super("Activity", dbSubsystem, baseDN, ActivityRecord.class);
    }

    public ActivityRecord log(String ip, String tokenID, String operation, String result, String message, String userID, String tokenType) throws Exception {
        Calendar c = Calendar.getInstance();
        String timeString = Util.getTimeStampString((boolean)true);
        long threadID = Thread.currentThread().getId();
        String threadIDS = String.format("%x", threadID);
        String id = timeString + "." + threadIDS;
        ActivityRecord activityRecord = new ActivityRecord();
        activityRecord.setId(id);
        activityRecord.setIP(ip);
        activityRecord.setTokenID(tokenID);
        activityRecord.setOperation(operation);
        activityRecord.setResult(result);
        activityRecord.setMessage(message);
        activityRecord.setUserID(userID);
        activityRecord.setType(tokenType);
        activityRecord.setDate(c.getTime());
        super.addRecord(id, (IDBObj)activityRecord);
        return activityRecord;
    }

    public void addRecord(String id, ActivityRecord activityRecord) throws Exception {
        activityRecord.setDate(new Date());
        super.addRecord(id, (IDBObj)activityRecord);
    }

    public String createDN(String id) {
        return "cn=" + id + "," + this.baseDN;
    }

    public String createFilter(String keyword, Map<String, String> attributes) {
        StringBuilder sb = new StringBuilder();
        if (keyword != null) {
            keyword = LDAPUtil.escapeFilter((Object)keyword);
            sb.append("(|(tokenID=*" + keyword + "*)(userID=*" + keyword + "*))");
        }
        this.createFilter(sb, attributes);
        if (sb.length() == 0) {
            sb.append("(objectClass=" + ActivityRecord.class.getName() + ")");
        }
        return sb.toString();
    }
}

