/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.config;

import com.netscape.certsrv.base.BadRequestException;
import com.netscape.certsrv.base.PKIException;
import com.netscape.cms.servlet.base.SubsystemService;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.dogtagpki.common.ConfigData;
import org.dogtagpki.common.ConfigResource;
import org.dogtagpki.server.tps.config.ConfigDatabase;
import org.dogtagpki.server.tps.config.ConfigRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigService
extends SubsystemService
implements ConfigResource {
    public static Logger logger = LoggerFactory.getLogger(ConfigService.class);

    public ConfigService() {
        logger.debug("ConfigService.<init>()");
    }

    public ConfigData createConfigData(Map<String, String> properties) throws UnsupportedEncodingException {
        ConfigData configData = new ConfigData();
        configData.setProperties(properties);
        return configData;
    }

    public Response getConfig() {
        logger.debug("ConfigService.getConfig()");
        try {
            ConfigDatabase configDatabase = new ConfigDatabase();
            ConfigRecord configRecord = configDatabase.getRecord("Generals");
            Map<String, String> properties = configDatabase.getProperties(configRecord, null);
            return this.createOKResponse(this.createConfigData(properties));
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PKIException(e.getMessage());
        }
    }

    public Response updateConfig(ConfigData configData) {
        String method = "ConfigService.updateConfig";
        HashMap<String, String> auditModParams = new HashMap<String, String>();
        if (configData == null) {
            BadRequestException e = new BadRequestException("Config data is null.");
            auditModParams.put("Info", e.toString());
            this.auditConfigTokenGeneral("Failure", method, auditModParams, e.toString());
            throw e;
        }
        logger.debug("ConfigService.updateConfig()");
        try {
            ConfigDatabase configDatabase = new ConfigDatabase();
            ConfigRecord configRecord = configDatabase.getRecord("Generals");
            Map newProperties = configData.getProperties();
            if (newProperties != null) {
                configDatabase.validateProperties(configRecord, null, newProperties);
                configDatabase.removeProperties(configRecord, null);
                configDatabase.addProperties(configRecord, null, newProperties);
            }
            configDatabase.commit();
            Map<String, String> properties = configDatabase.getProperties(configRecord, null);
            configData = this.createConfigData(properties);
            this.auditConfigTokenGeneral("Success", method, newProperties, null);
            return this.createOKResponse(configData);
        }
        catch (PKIException e) {
            logger.error(method + ": " + e.getMessage(), (Throwable)e);
            this.auditConfigTokenGeneral("Failure", method, auditModParams, e.toString());
            throw e;
        }
        catch (Exception e) {
            logger.error(method + ": " + e.getMessage(), (Throwable)e);
            this.auditConfigTokenGeneral("Failure", method, auditModParams, e.toString());
            throw new PKIException(e.getMessage());
        }
    }
}

