/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.config;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cmscore.dbs.CSCfgDatabase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.dogtagpki.server.tps.config.AuthenticatorRecord;
import org.dogtagpki.server.tps.config.ConfigDatabase;
import org.dogtagpki.server.tps.config.ConfigRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticatorDatabase
extends CSCfgDatabase<AuthenticatorRecord> {
    public static Logger logger = LoggerFactory.getLogger(AuthenticatorDatabase.class);

    public AuthenticatorDatabase() {
        super("Authenticator", "Authentication_Sources");
    }

    public AuthenticatorRecord createAuthenticatorRecord(ConfigDatabase configDatabase, ConfigRecord configRecord, String authenticatorID) throws EBaseException {
        AuthenticatorRecord authenticatorRecord = new AuthenticatorRecord();
        authenticatorRecord.setID(authenticatorID);
        String status = this.getRecordStatus(authenticatorID);
        authenticatorRecord.setStatus(status);
        Map<String, String> properties = configDatabase.getProperties(configRecord, authenticatorID);
        authenticatorRecord.setProperties(properties);
        return authenticatorRecord;
    }

    public Collection<AuthenticatorRecord> findRecords(String filter) throws Exception {
        ArrayList<AuthenticatorRecord> result = new ArrayList<AuthenticatorRecord>();
        ConfigDatabase configDatabase = new ConfigDatabase();
        ConfigRecord configRecord = configDatabase.getRecord(this.substoreName);
        for (String authenticatorID : configRecord.getKeys()) {
            if (filter != null && !authenticatorID.contains(filter)) continue;
            AuthenticatorRecord authenticatorRecord = this.createAuthenticatorRecord(configDatabase, configRecord, authenticatorID);
            result.add(authenticatorRecord);
        }
        return result;
    }

    public AuthenticatorRecord getRecord(String authenticatorID) throws Exception {
        ConfigDatabase configDatabase = new ConfigDatabase();
        ConfigRecord configRecord = configDatabase.getRecord(this.substoreName);
        return this.createAuthenticatorRecord(configDatabase, configRecord, authenticatorID);
    }

    public void addRecord(String authenticatorID, AuthenticatorRecord authenticatorRecord) throws Exception {
        logger.debug("AuthenticatorDatabase.addRecord(\"" + authenticatorID + "\")");
        ConfigDatabase configDatabase = new ConfigDatabase();
        ConfigRecord configRecord = configDatabase.getRecord(this.substoreName);
        Map properties = authenticatorRecord.getProperties();
        configDatabase.validateProperties(configRecord, authenticatorID, properties);
        configRecord.addKey(authenticatorID);
        configDatabase.updateRecord(this.substoreName, configRecord);
        configDatabase.addProperties(configRecord, authenticatorID, properties);
        this.setRecordStatus(authenticatorID, authenticatorRecord.getStatus());
        configDatabase.commit();
    }

    public void updateRecord(String authenticatorID, AuthenticatorRecord authenticatorRecord) throws Exception {
        logger.debug("AuthenticatorDatabase.updateRecord(\"" + authenticatorID + "\")");
        ConfigDatabase configDatabase = new ConfigDatabase();
        ConfigRecord configRecord = configDatabase.getRecord(this.substoreName);
        Map properties = authenticatorRecord.getProperties();
        configDatabase.validateProperties(configRecord, authenticatorID, properties);
        configDatabase.removeProperties(configRecord, authenticatorID);
        configDatabase.addProperties(configRecord, authenticatorID, properties);
        this.setRecordStatus(authenticatorID, authenticatorRecord.getStatus());
        configDatabase.commit();
    }

    public void removeRecord(String authenticatorID) throws Exception {
        logger.debug("AuthenticatorDatabase.removeRecord(\"" + authenticatorID + "\")");
        ConfigDatabase configDatabase = new ConfigDatabase();
        ConfigRecord configRecord = configDatabase.getRecord(this.substoreName);
        configDatabase.removeProperties(configRecord, authenticatorID);
        configRecord.removeKey(authenticatorID);
        configDatabase.updateRecord(this.substoreName, configRecord);
        this.removeRecordStatus(authenticatorID);
        configDatabase.commit();
    }
}

