/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.cms;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.connector.ConnectorConfig;
import com.netscape.certsrv.connector.ConnectorsConfig;
import com.netscape.cmscore.connector.HttpConnector;
import com.netscape.cmsutil.http.HttpResponse;
import java.util.Hashtable;
import org.dogtagpki.server.tps.TPSConfig;
import org.dogtagpki.server.tps.TPSEngine;
import org.dogtagpki.server.tps.TPSEngineConfig;
import org.dogtagpki.server.tps.TPSSubsystem;
import org.dogtagpki.server.tps.cms.RemoteRequestHandler;
import org.dogtagpki.server.tps.cms.TKSComputeRandomDataResponse;
import org.dogtagpki.server.tps.cms.TKSComputeSessionKeyResponse;
import org.dogtagpki.server.tps.cms.TKSCreateKeySetDataResponse;
import org.dogtagpki.server.tps.cms.TKSEncryptDataResponse;
import org.dogtagpki.tps.main.TPSBuffer;
import org.dogtagpki.tps.main.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TKSRemoteRequestHandler
extends RemoteRequestHandler {
    public static Logger logger = LoggerFactory.getLogger(TKSRemoteRequestHandler.class);
    private String keySet;

    public TKSRemoteRequestHandler(String connID) throws EBaseException {
        if (connID == null) {
            throw new EBaseException("TKSRemoteRequestHandler: TKSRemoteRequestHandler(): connID null.");
        }
        this.connid = connID;
    }

    public TKSRemoteRequestHandler(String connID, String inKeySet) throws EBaseException {
        if (connID == null) {
            throw new EBaseException("TKSRemoteRequestHandler: TKSRemoteRequestHandler(): connID null.");
        }
        this.connid = connID;
        this.keySet = inKeySet;
    }

    public TKSComputeSessionKeyResponse computeSessionKey(TPSBuffer kdd, TPSBuffer cuid, TPSBuffer keyInfo, TPSBuffer card_challenge, TPSBuffer card_cryptogram, TPSBuffer host_challenge, String tokenType) throws EBaseException {
        String[] keygenStrings;
        String method = "TKSRemoteRequestHandler: computeSessionKey(): ";
        logger.debug(method + " begins.");
        if (cuid == null || kdd == null || keyInfo == null || card_challenge == null || card_cryptogram == null || host_challenge == null) {
            throw new EBaseException("TKSRemoteRequestHandler: computeSessionKey(): input parameter null.");
        }
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig conf = engine.getConfig();
        TPSConfig tpsConfig = conf.getTPSConfig();
        ConnectorsConfig connectorsConfig = tpsConfig.getConnectorsConfig();
        ConnectorConfig connectorConfig = connectorsConfig.getConnectorConfig(this.connid);
        boolean serverKeygen = false;
        for (String keygenString : keygenStrings = new String[]{"identity", "signing", "encryption", "authentication", "auth"}) {
            boolean enabled = conf.getBoolean("op.enroll." + tokenType + ".keyGen." + keygenString + ".serverKeygen.enable", false);
            logger.debug(method + "config serverkegGen enabled for " + keygenString + " : " + enabled);
            if (!enabled) continue;
            serverKeygen = true;
            break;
        }
        logger.debug(method + " final serverkegGen enabled? " + serverKeygen);
        if (this.keySet == null) {
            this.keySet = connectorConfig.getString("keySet", "defKeySet");
        }
        TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
        HttpConnector conn = (HttpConnector)subsystem.getConnectionManager().getConnector(this.connid);
        String requestString = "serversideKeygen=" + serverKeygen + "&KDD=" + Util.specialURLEncode((TPSBuffer)kdd) + "&tokencuid=" + Util.specialURLEncode((TPSBuffer)cuid) + "&card_challenge=" + Util.specialURLEncode((TPSBuffer)card_challenge) + "&host_challenge=" + Util.specialURLEncode((TPSBuffer)host_challenge) + "&KeyInfo=" + Util.specialURLEncode((TPSBuffer)keyInfo) + "&card_cryptogram=" + Util.specialURLEncode((byte[])card_cryptogram.toBytesArray()) + "&keySet=" + this.keySet;
        logger.debug("TKSRemoteRequestHandler.computeSessionKey: sending request to TKS");
        HttpResponse resp = conn.send("computeSessionKey", requestString);
        String content = resp.getContent();
        if (content == null || content.equals("")) {
            logger.error("TKSRemoteRequestHandler: computeSessionKey(): no response content.");
            throw new EBaseException("TKSRemoteRequestHandler: computeSessionKey(): no response content.");
        }
        Hashtable<String, Object> response = this.parseResponse(content);
        Integer ist = -1;
        String value = (String)response.get("status");
        if (value == null) {
            logger.debug("TKSRemoteRequestHandler: computeSessionKey(): status not found.");
        } else {
            logger.debug("TKSRemoteRequestHandler: computeSessionKey(): got status = " + value);
            ist = Integer.parseInt(value);
        }
        response.put("status", ist);
        value = (String)response.get("sessionKey");
        if (value == null) {
            logger.debug("TKSRemoteRequestHandler: computeSessionKey(): response missing name-value pair for: sessionKey");
        } else {
            logger.debug("TKSRemoteRequestHandler: computeSessionKey(): got IRemoteRequest.TKS_RESPONSE_SessionKey");
            response.put("sessionKey", Util.specialDecode((String)value));
        }
        value = (String)response.get("encSessionKey");
        if (value == null) {
            logger.debug("TKSRemoteRequestHandler: computeSessionKey(): response missing name-value pair for: encSessionKey");
        } else {
            logger.debug("TKSRemoteRequestHandler: computeSessionKey(): got IRemoteRequest.TKS_RESPONSE_EncSessionKey");
            response.put("encSessionKey", Util.specialDecode((String)value));
        }
        value = (String)response.get("drm_trans_desKey");
        if (value == null) {
            logger.debug("TKSRemoteRequestHandler: computeSessionKey(): response missing name-value pair for: drm_trans_desKey");
        } else {
            logger.debug("TKSRemoteRequestHandler: computeSessionKey(): got IRemoteRequest.TKS_RESPONSE_DRM_Trans_DesKey");
            response.put("drm_trans_desKey", Util.specialDecode((String)value));
        }
        value = (String)response.get("kek_wrapped_desKey");
        if (value == null) {
            logger.debug("TKSRemoteRequestHandler: computeSessionKey(): response missing name-value pair for: kek_wrapped_desKey");
        } else {
            logger.debug("TKSRemoteRequestHandler: computeSessionKey(): got IRemoteRequest.TKS_RESPONSE_KEK_DesKey");
            response.put("kek_wrapped_desKey", Util.specialDecode((String)value));
        }
        value = (String)response.get("keycheck");
        if (value == null) {
            logger.debug("TKSRemoteRequestHandler: computeSessionKey(): response missing name-value pair for: keycheck");
        } else {
            logger.debug("TKSRemoteRequestHandler: computeSessionKey(): got IRemoteRequest.TKS_RESPONSE_KeyCheck");
            response.put("keycheck", Util.specialDecode((String)value));
        }
        value = (String)response.get("hostCryptogram");
        if (value == null) {
            logger.debug("TKSRemoteRequestHandler: computeSessionKey(): response missing name-value pair for: hostCryptogram");
        } else {
            logger.debug("TKSRemoteRequestHandler: computeSessionKey(): got IRemoteRequest.TKS_RESPONSE_HostCryptogram");
            response.put("hostCryptogram", Util.specialDecode((String)value));
        }
        logger.debug("TKSRemoteRequestHandler: computeSessionKey(): ends.");
        return new TKSComputeSessionKeyResponse(response);
    }

    public TKSComputeSessionKeyResponse computeSessionKeysSCP03(TPSBuffer kdd, TPSBuffer cuid, TPSBuffer keyInfo, TPSBuffer card_challenge, TPSBuffer card_cryptogram, TPSBuffer host_challenge, String tokenType) throws EBaseException {
        String requestString;
        TPSSubsystem subsystem;
        HttpConnector conn;
        HttpResponse resp;
        String content;
        String[] keygenStrings;
        String method = "TKSRemoteRequestHandler: computeSessionKeysSCP03()";
        logger.debug(method + " Entering: ");
        if (cuid == null || kdd == null || keyInfo == null || card_challenge == null || card_cryptogram == null || host_challenge == null || tokenType == null) {
            throw new EBaseException(method + " invalid input!");
        }
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig conf = engine.getConfig();
        TPSConfig tpsConfig = conf.getTPSConfig();
        ConnectorsConfig connectorsConfig = tpsConfig.getConnectorsConfig();
        ConnectorConfig connectorConfig = connectorsConfig.getConnectorConfig(this.connid);
        boolean serverKeygen = false;
        for (String keygenString : keygenStrings = new String[]{"identity", "signing", "encryption", "authentication", "auth"}) {
            boolean enabled = conf.getBoolean("op.enroll." + tokenType + ".keyGen." + keygenString + ".serverKeygen.enable", false);
            logger.debug(method + " serverkegGen enabled for " + keygenString + " : " + enabled);
            if (!enabled) continue;
            serverKeygen = true;
            break;
        }
        logger.debug(method + " final serverkegGen enabled? " + serverKeygen);
        if (this.keySet == null) {
            this.keySet = connectorConfig.getString("keySet", "defKeySet");
        }
        if ((content = (resp = (conn = (HttpConnector)(subsystem = (TPSSubsystem)engine.getSubsystem("tps")).getConnectionManager().getConnector(this.connid)).send("computeSessionKey", requestString = "serversideKeygen=" + serverKeygen + "&KDD=" + Util.specialURLEncode((TPSBuffer)kdd) + "&tokencuid=" + Util.specialURLEncode((TPSBuffer)cuid) + "&card_challenge=" + Util.specialURLEncode((TPSBuffer)card_challenge) + "&host_challenge=" + Util.specialURLEncode((TPSBuffer)host_challenge) + "&KeyInfo=" + Util.specialURLEncode((TPSBuffer)keyInfo) + "&protocol=3&card_cryptogram=" + Util.specialURLEncode((byte[])card_cryptogram.toBytesArray()) + "&keySet=" + this.keySet)).getContent()) == null || content.equals("")) {
            logger.error("TKSRemoteRequestHandler: computeSessionKeySCP02(): no response content.");
            throw new EBaseException("TKSRemoteRequestHandler: computeSessionKeySCP02(): no response content.");
        }
        Hashtable<String, Object> response = this.parseResponse(content);
        Integer ist = -1;
        String value = (String)response.get("status");
        if (value == null) {
            logger.debug(method + " status not found.");
        } else {
            logger.debug(method + " got status = " + value);
            ist = Integer.parseInt(value);
        }
        response.put("status", ist);
        value = (String)response.get("encSessionKey");
        if (value == null) {
            logger.debug(method + " response missing name-value pair for: encSessionKey");
        } else {
            logger.debug(method + "got IRemoteRequest.TKS_RESPONSE_EncSessionKey");
            response.put("encSessionKey", Util.specialDecode((String)value));
        }
        value = (String)response.get("drm_trans_desKey");
        if (value == null) {
            logger.debug(method + " response missing name-value pair for: drm_trans_desKey");
        } else {
            logger.debug(method + "got IRemoteRequest.TKS_RESPONSE_DRM_Trans_DesKey");
            response.put("drm_trans_desKey", Util.specialDecode((String)value));
        }
        value = (String)response.get("macSessionKey");
        if (value == null) {
            logger.debug(method + "response missing name-value pair for: macSessionKey");
        } else {
            logger.debug(method + " got IRemoteRequest.TKS_RESPONSE_MacSessionKey");
            response.put("macSessionKey", Util.specialDecode((String)value));
        }
        value = (String)response.get("kekSessionKey");
        if (value == null) {
            logger.debug(method + "response missing name-value pair for: kekSessionKey");
        } else {
            logger.debug(method + " got IRemoteRequest.TKS_RESPONSE_KekSessionKey");
            response.put("kekSessionKey", Util.specialDecode((String)value));
        }
        value = (String)response.get("kek_wrapped_desKey");
        if (value == null) {
            logger.debug(method + "response missing name-value pair for: kek_wrapped_desKey");
        } else {
            logger.debug(method + " got IRemoteRequest.TKS_RESPONSE_KEK_DesKey");
            response.put("kek_wrapped_desKey", Util.specialDecode((String)value));
        }
        value = (String)response.get("keycheck");
        if (value == null) {
            logger.debug(method + "response missing name-value pair for: keycheck");
        } else {
            logger.debug(method + " got IRemoteRequest.TKS_RESPONSE_KeyCheck");
            response.put("keycheck", Util.specialDecode((String)value));
        }
        value = (String)response.get("hostCryptogram");
        if (value == null) {
            logger.debug(method + " response missing name-value pair for: hostCryptogram");
        } else {
            logger.debug(method + " got hostCryptogram");
            response.put("hostCryptogram", Util.specialDecode((String)value));
        }
        logger.debug(method + " ends.");
        return new TKSComputeSessionKeyResponse(response);
    }

    public TKSComputeSessionKeyResponse computeSessionKeySCP02(TPSBuffer kdd, TPSBuffer cuid, TPSBuffer keyInfo, TPSBuffer sequenceCounter, TPSBuffer derivationConstant, String tokenType) throws EBaseException {
        String requestString;
        TPSSubsystem subsystem;
        HttpConnector conn;
        HttpResponse resp;
        String content;
        String[] keygenStrings;
        String method = "TKSRemoteRequestHandler: computeSessionKeySCP02(): ";
        logger.debug(method + " begins.");
        if (cuid == null || kdd == null || keyInfo == null || sequenceCounter == null || derivationConstant == null) {
            throw new EBaseException("TKSRemoteRequestHandler: computeSessionKeySCP02(): input parameter null.");
        }
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig conf = engine.getConfig();
        TPSConfig tpsConfig = conf.getTPSConfig();
        ConnectorsConfig connectorsConfig = tpsConfig.getConnectorsConfig();
        ConnectorConfig connectorConfig = connectorsConfig.getConnectorConfig(this.connid);
        boolean serverKeygen = false;
        for (String keygenString : keygenStrings = new String[]{"identity", "signing", "encryption", "authentication", "auth"}) {
            boolean enabled = conf.getBoolean("op.enroll." + tokenType + ".keyGen." + keygenString + ".serverKeygen.enable", false);
            logger.debug(method + " serverkegGen enabled for " + keygenString + " : " + enabled);
            if (!enabled) continue;
            serverKeygen = true;
            break;
        }
        if (this.keySet == null) {
            this.keySet = connectorConfig.getString("keySet", "defKeySet");
        }
        if ((content = (resp = (conn = (HttpConnector)(subsystem = (TPSSubsystem)engine.getSubsystem("tps")).getConnectionManager().getConnector(this.connid)).send("computeSessionKey", requestString = "serversideKeygen=" + serverKeygen + "&KDD=" + Util.specialURLEncode((TPSBuffer)kdd) + "&tokencuid=" + Util.specialURLEncode((TPSBuffer)cuid) + "&KeyInfo=" + Util.specialURLEncode((TPSBuffer)keyInfo) + "&keySet=" + this.keySet + "&protocol=2&sequenceCounter=" + Util.specialURLEncode((TPSBuffer)sequenceCounter) + "&derivationConstant=" + Util.specialURLEncode((TPSBuffer)derivationConstant))).getContent()) == null || content.equals("")) {
            logger.error("TKSRemoteRequestHandler: computeSessionKeySCP02(): no response content.");
            throw new EBaseException("TKSRemoteRequestHandler: computeSessionKeySCP02(): no response content.");
        }
        Hashtable<String, Object> response = this.parseResponse(content);
        Integer ist = -1;
        String value = (String)response.get("status");
        if (value == null) {
            logger.debug("TKSRemoteRequestHandler: computeSessionKeySCP02(): status not found.");
        } else {
            logger.debug("TKSRemoteRequestHandler: computeSessionKeySCP02(): got status = " + value);
            ist = Integer.parseInt(value);
        }
        response.put("status", ist);
        value = (String)response.get("sessionKey");
        if (value == null) {
            logger.debug("TKSRemoteRequestHandler: computeSessionKeySCP02(): response missing name-value pair for: sessionKey");
        } else {
            logger.debug("TKSRemoteRequestHandler: computeSessionKeySCP02(): got IRemoteRequest.TKS_RESPONSE_SessionKey");
            response.put("sessionKey", Util.specialDecode((String)value));
        }
        value = (String)response.get("drm_trans_desKey");
        if (value == null) {
            logger.debug("TKSRemoteRequestHandler: computeSessionKeySCP02(): response missing name-value pair for: drm_trans_desKey");
        } else {
            logger.debug("TKSRemoteRequestHandler: computeSessionKeySCP02(): got IRemoteRequest.TKS_RESPONSE_DRM_Trans_DesKey");
            response.put("drm_trans_desKey", Util.specialDecode((String)value));
        }
        value = (String)response.get("kek_wrapped_desKey");
        if (value == null) {
            logger.debug("TKSRemoteRequestHandler: computeSessionKeySCP02(): response missing name-value pair for: kek_wrapped_desKey");
        } else {
            logger.debug("TKSRemoteRequestHandler: computeSessionKeySCP02(): got IRemoteRequest.TKS_RESPONSE_KEK_DesKey");
            response.put("kek_wrapped_desKey", Util.specialDecode((String)value));
        }
        value = (String)response.get("keycheck");
        if (value == null) {
            logger.debug("TKSRemoteRequestHandler: computeSessionKeySCP02(): response missing name-value pair for: keycheck");
        } else {
            logger.debug("TKSRemoteRequestHandler: computeSessionKeySCP02(): got IRemoteRequest.TKS_RESPONSE_KeyCheck");
            response.put("keycheck", Util.specialDecode((String)value));
        }
        logger.debug("TKSRemoteRequestHandler: computeSessionKeySCP02(): ends.");
        return new TKSComputeSessionKeyResponse(response);
    }

    public TKSCreateKeySetDataResponse createKeySetData(TPSBuffer NewMasterVer, TPSBuffer version, TPSBuffer cuid, TPSBuffer kdd, int protocol, TPSBuffer wrappedDekSessionKey) throws EBaseException {
        HttpResponse resp;
        String content;
        logger.debug("TKSRemoteRequestHandler: createKeySetData(): begins.");
        if (cuid == null || NewMasterVer == null || version == null) {
            throw new EBaseException("TKSRemoteRequestHandler: createKeySetData(): input parameter null.");
        }
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig conf = engine.getConfig();
        TPSConfig tpsConfig = conf.getTPSConfig();
        ConnectorsConfig connectorsConfig = tpsConfig.getConnectorsConfig();
        ConnectorConfig connectorConfig = connectorsConfig.getConnectorConfig(this.connid);
        if (this.keySet == null) {
            this.keySet = connectorConfig.getString("keySet", "defKeySet");
        }
        TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
        HttpConnector conn = (HttpConnector)subsystem.getConnectionManager().getConnector(this.connid);
        logger.debug("TKSRemoteRequestHandler: createKeySetData(): sending request to tks.");
        String command = "newKeyInfo=" + Util.specialURLEncode((TPSBuffer)NewMasterVer) + "&KDD=" + Util.specialURLEncode((TPSBuffer)kdd) + "&tokencuid=" + Util.specialURLEncode((TPSBuffer)cuid) + "&KeyInfo=" + Util.specialURLEncode((TPSBuffer)version) + "&keySet=" + this.keySet + "&protocol=" + protocol;
        if (wrappedDekSessionKey != null) {
            command = command + "&wrappedDekKey=" + Util.specialURLEncode((TPSBuffer)wrappedDekSessionKey);
        }
        if ((content = (resp = conn.send("createKeySetData", command)).getContent()) == null || content.equals("")) {
            logger.error("TKSRemoteRequestHandler: createKeySetData(): no response content.");
            throw new EBaseException("TKSRemoteRequestHandler: createKeySetData(): no response content.");
        }
        Hashtable<String, Object> response = this.parseResponse(content);
        if (response == null) {
            logger.warn("TKSRemoteRequestHandler: createKeySetData(): parseResponse returned null.");
            return null;
        }
        Integer ist = -1;
        String value = (String)response.get("status");
        if (value == null) {
            logger.debug("TKSRemoteRequestHandler: createKeySetData(): status not found.");
        } else {
            logger.debug("TKSRemoteRequestHandler: createKeySetData(): got status = " + value);
            ist = Integer.parseInt(value);
        }
        response.put("status", ist);
        value = (String)response.get("keySetData");
        if (value == null) {
            logger.debug("TKSRemoteRequestHandler: createKeySetData(): response missing name-value pair for: keySetData");
        } else {
            logger.debug("TKSRemoteRequestHandler: createKeySetData(): got IRemoteRequest.TKS_RESPONSE_KeySetData");
            response.put("keySetData", Util.specialDecode((String)value));
        }
        logger.debug("TKSRemoteRequestHandler: createKeySetData(): ends.");
        return new TKSCreateKeySetDataResponse(response);
    }

    public TKSComputeRandomDataResponse computeRandomData(int dataSize) throws EBaseException {
        logger.debug("TKSRemoteRequestHandler: computeRandomData(): begins.");
        if (dataSize <= 0 || dataSize > 1024) {
            logger.error("TKSRemoteRequestHandler: computeRandomData(): invalid dataSize requested:" + dataSize);
            throw new EBaseException("TKSRemoteRequestHandler: computeRandomData(): invalid dataSize requested");
        }
        logger.debug("TKSRemoteRequestHandler: computeRandomData(): sending request to tks.");
        TPSEngine engine = TPSEngine.getInstance();
        TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
        HttpConnector conn = (HttpConnector)subsystem.getConnectionManager().getConnector(this.connid);
        HttpResponse resp = conn.send("computeRandomData", "dataNumBytes=" + dataSize);
        String content = resp.getContent();
        if (content == null || content.equals("")) {
            logger.error("TKSRemoteRequestHandler: computeRandomData(): no response content.");
            throw new EBaseException("TKSRemoteRequestHandler: computeRandomData(): no response content.");
        }
        Hashtable<String, Object> response = this.parseResponse(content);
        Integer ist = -1;
        String value = (String)response.get("status");
        if (value == null) {
            logger.debug("TKSRemoteRequestHandler: computeRandomData(): status not found.");
        } else {
            logger.debug("TKSRemoteRequestHandler: computeRandomData(): got status = " + value);
            ist = Integer.parseInt(value);
        }
        response.put("status", ist);
        value = (String)response.get("randomData");
        if (value == null) {
            logger.debug("TKSRemoteRequestHandler: computeRandomData(): response missing name-value pair for: randomData");
        } else {
            logger.debug("TKSRemoteRequestHandler: computeRandomData(): got IRemoteRequest.TKS_RESPONSE_RandomData");
            response.put("randomData", Util.uriDecodeFromHex((String)value));
        }
        logger.debug("TKSRemoteRequestHandler: computeRandomData(): ends.");
        return new TKSComputeRandomDataResponse(response);
    }

    public TKSEncryptDataResponse encryptData(TPSBuffer kdd, TPSBuffer cuid, TPSBuffer version, TPSBuffer inData, int protocol) throws EBaseException {
        logger.debug("TKSRemoteRequestHandler: encryptData(): begins.");
        if (cuid == null || kdd == null || version == null || inData == null) {
            throw new EBaseException("TKSRemoteRequestHandler: encryptData(): input parameter null.");
        }
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig conf = engine.getConfig();
        TPSConfig tpsConfig = conf.getTPSConfig();
        ConnectorsConfig connectorsConfig = tpsConfig.getConnectorsConfig();
        ConnectorConfig connectorConfig = connectorsConfig.getConnectorConfig(this.connid);
        if (this.keySet == null) {
            this.keySet = connectorConfig.getString("keySet", "defKeySet");
        }
        TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
        HttpConnector conn = (HttpConnector)subsystem.getConnectionManager().getConnector(this.connid);
        logger.debug("TKSRemoteRequestHandler: encryptData(): sending request to tks.");
        HttpResponse resp = conn.send("encryptData", "data=" + Util.specialURLEncode((TPSBuffer)inData) + "&tokencuid=" + Util.specialURLEncode((TPSBuffer)cuid) + "&KDD=" + Util.specialURLEncode((TPSBuffer)kdd) + "&KeyInfo=" + Util.specialURLEncode((TPSBuffer)version) + "&keySet=" + this.keySet + "&protocol=" + protocol);
        String content = resp.getContent();
        if (content == null || content.equals("")) {
            logger.error("TKSRemoteRequestHandler: encryptData(): no response content.");
            throw new EBaseException("TKSRemoteRequestHandler: encryptData(): no response content.");
        }
        Hashtable<String, Object> response = this.parseResponse(content);
        Integer ist = -1;
        String value = (String)response.get("status");
        if (value == null) {
            logger.debug("TKSRemoteRequestHandler: encryptData(): status not found.");
        } else {
            logger.debug("TKSRemoteRequestHandler: encryptData(): got status = " + value);
            ist = Integer.parseInt(value);
        }
        response.put("status", ist);
        value = (String)response.get("encryptedData");
        if (value == null) {
            logger.debug("TKSRemoteRequestHandler: encryptData(): response missing name-value pair for: encryptedData");
        } else {
            logger.debug("TKSRemoteRequestHandler: encryptData(): got IRemoteRequest.TKS_RESPONSE_EncryptedData");
            response.put("encryptedData", Util.specialDecode((String)value));
        }
        logger.debug("TKSRemoteRequestHandler: encryptData(): ends.");
        return new TKSEncryptDataResponse(response);
    }
}

