/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.cms;

import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Hashtable;
import org.dogtagpki.server.tps.cms.RemoteResponse;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CARetrieveCertResponse
extends RemoteResponse {
    public static Logger logger = LoggerFactory.getLogger(CARetrieveCertResponse.class);

    public CARetrieveCertResponse(Hashtable<String, Object> ht) {
        this.nameValTable = ht;
    }

    public CARetrieveCertResponse(String connid, Hashtable<String, Object> ht) {
        this.setConnID(connid);
        this.nameValTable = ht;
    }

    public String getCertB64() {
        return (String)this.nameValTable.get("certChainBase64");
    }

    public X509CertImpl getCert() {
        return (X509CertImpl)this.nameValTable.get("X509Certificate");
    }

    public String getRevocationReason() {
        return (String)this.nameValTable.get("revocationReason");
    }

    public boolean isCertRevoked() {
        String retRevocationReason = this.getRevocationReason();
        return retRevocationReason != null;
    }

    public boolean isCertValid() {
        X509CertImpl cert = this.getCert();
        try {
            cert.checkValidity();
            return true;
        }
        catch (CertificateExpiredException e) {
            logger.warn("CARetrieveCertResponse.isCertValid: " + e.getMessage(), (Throwable)e);
            return false;
        }
        catch (CertificateNotYetValidException e) {
            logger.warn("CARetrieveCertResponse.isCertValid: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

