/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.authentication;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cmscore.authentication.AuthSubsystem;
import java.util.HashMap;
import org.dogtagpki.server.authentication.AuthManager;
import org.dogtagpki.server.tps.TPSEngine;
import org.dogtagpki.server.tps.authentication.AuthUIParameter;

public class TPSAuthenticator {
    private String id;
    private HashMap<String, String> uiTitle;
    private HashMap<String, String> uiDescription;
    private HashMap<String, AuthUIParameter> uiParameters;
    private HashMap<String, String> credMap_login;
    private HashMap<String, String> credMap_extlogin;
    private int maxLoginRetries = 1;
    private String authCredName;

    public TPSAuthenticator(String authId) throws EBaseException {
        this.id = authId;
        this.uiTitle = new HashMap();
        this.uiDescription = new HashMap();
        this.uiParameters = new HashMap();
        this.credMap_login = new HashMap();
        this.credMap_extlogin = new HashMap();
    }

    public String getID() {
        return this.id;
    }

    public AuthManager getAuthManager() {
        TPSEngine engine = TPSEngine.getInstance();
        AuthSubsystem authSub = engine.getAuthSubsystem();
        return authSub.getAuthManager(this.id);
    }

    public void setUiTitle(String locale, String title) {
        this.uiTitle.put(locale, title);
    }

    public String getUiTitle(String locale) {
        return this.uiTitle.get(locale);
    }

    public void setUiDescription(String locale, String desc) {
        this.uiDescription.put(locale, desc);
    }

    public String getUiDescription(String locale) {
        return this.uiDescription.get(locale);
    }

    public void setUiParam(String id, AuthUIParameter up) {
        this.uiParameters.put(id, up);
    }

    public AuthUIParameter getUiParam(String id) {
        return this.uiParameters.get(id);
    }

    public HashMap<String, AuthUIParameter> getUiParamSet() {
        return this.uiParameters;
    }

    public void setCredMap(String authCred, String msgCred, boolean extLogin) {
        if (extLogin) {
            this.credMap_extlogin.put(authCred, msgCred);
        } else {
            this.credMap_login.put(authCred, msgCred);
        }
    }

    public String getCredMap(String authCred, boolean extLogin) {
        return extLogin ? this.credMap_extlogin.get(authCred) : this.credMap_login.get(authCred);
    }

    public int getNumOfRetries() {
        return this.maxLoginRetries;
    }

    public void setNumOfRetries(int num) {
        this.maxLoginRetries = num;
    }

    public String getAuthCredName() {
        return this.authCredName;
    }

    public void setAuthCredName(String authCredName) {
        this.authCredName = authCredName;
    }
}

