/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.EPropertyNotFound;
import org.dogtagpki.server.tps.TPSEngine;
import org.dogtagpki.server.tps.TPSEngineConfig;
import org.dogtagpki.server.tps.TPSSubsystem;
import org.dogtagpki.server.tps.TokenDBConfig;
import org.dogtagpki.server.tps.dbs.TokenRecord;
import org.dogtagpki.tps.main.TPSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPSTokenPolicy {
    public static Logger logger = LoggerFactory.getLogger(TPSTokenPolicy.class);
    private TPSSubsystem tps;
    private static final String DEFAULT_POLICY_SET_STRING = "RE_ENROLL=YES;RENEW=NO;FORCE_FORMAT=NO;PIN_RESET=NO;RESET_PIN_RESET_TO_NO=NO";
    private boolean re_enroll = true;
    private boolean renew = false;
    private boolean renew_keep_old_enc_certs = true;
    private boolean force_format = false;
    private boolean pin_reset = true;
    private boolean reset_pin_reset_to_no = false;
    private String cuid = null;

    public TPSTokenPolicy(TPSSubsystem tps, String cuid) throws TPSException {
        if (tps == null) {
            String msg = "TPSTokenPolicy.TPSTokenPolicy: tps cannnot be null";
            logger.error(msg);
            throw new TPSException(msg);
        }
        if (cuid == null) {
            String msg = "TPSTokenPolicy.TPSTokenPolicy: cuid cannnot be null";
            logger.error(msg);
            throw new TPSException(msg);
        }
        this.tps = tps;
        String policySetString = this.getDefaultPolicySetString();
        this.parsePolicySetString(policySetString);
        this.cuid = cuid;
        this.getUpdatedPolicy();
    }

    public String getDefaultPolicySetString() {
        String policySetString;
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        TokenDBConfig tdbConfig = configStore.getTokenDBConfig();
        try {
            policySetString = tdbConfig.getString("defaultPolicy");
        }
        catch (EPropertyNotFound e) {
            policySetString = DEFAULT_POLICY_SET_STRING;
        }
        catch (EBaseException e) {
            policySetString = DEFAULT_POLICY_SET_STRING;
        }
        return policySetString;
    }

    public void parsePolicySetString(String policySetString) {
        String[] policySet;
        if (policySetString == null) {
            return;
        }
        for (String policyString : policySet = policySetString.split(";")) {
            String[] policy = policyString.split("=");
            if (policy[0].equalsIgnoreCase("RE_ENROLL")) {
                this.re_enroll = this.getBool(policy[1], true);
                continue;
            }
            if (policy[0].equalsIgnoreCase("RENEW")) {
                this.renew = this.getBool(policy[1], false);
                continue;
            }
            if (policy[0].equalsIgnoreCase("FORCE_FORMAT")) {
                this.force_format = this.getBool(policy[1], false);
                continue;
            }
            if (policy[0].equalsIgnoreCase("PIN_RESET")) {
                this.pin_reset = this.getBool(policy[1], false);
                continue;
            }
            if (policy[0].equalsIgnoreCase("RESET_PIN_RESET_TO_NO")) {
                this.reset_pin_reset_to_no = this.getBool(policy[1], false);
                continue;
            }
            if (!policy[0].equalsIgnoreCase("RENEW_KEEP_OLD_ENC_CERTS")) continue;
            this.renew_keep_old_enc_certs = this.getBool(policy[1], true);
        }
    }

    public void updatePolicySet() throws TPSException {
        String method = "TPSTokenPolicy.updatePolicySet: ";
        String msg = method + "Can't update token policy string to database.";
        TokenRecord tokenRecord = null;
        try {
            tokenRecord = this.tps.tdb.tdbGetTokenEntry(this.cuid);
        }
        catch (Exception e) {
            throw new TPSException(e.toString() + " " + msg);
        }
        Object newPolicy = "";
        newPolicy = (String)newPolicy + "RE_ENROLL=" + this.getFromBool(this.re_enroll);
        newPolicy = (String)newPolicy + ";RENEW=" + this.getFromBool(this.renew);
        newPolicy = (String)newPolicy + ";FORCE_FORMAT=" + this.getFromBool(this.force_format);
        newPolicy = (String)newPolicy + ";PIN_RESET=" + this.getFromBool(this.pin_reset);
        newPolicy = (String)newPolicy + ";RESET_PIN_RESET_TO_NO=" + this.getFromBool(this.reset_pin_reset_to_no);
        newPolicy = (String)newPolicy + ";RENEW_KEEP_OLD_ENC_CERTS=" + this.getFromBool(this.renew_keep_old_enc_certs);
        logger.debug("{}newPolicy: {}", (Object)method, newPolicy);
        tokenRecord.setPolicy((String)newPolicy);
        try {
            this.tps.tdb.tdbUpdateTokenEntry(tokenRecord);
        }
        catch (Exception e) {
            throw new TPSException(e.toString() + " " + msg);
        }
    }

    private boolean getBool(String string, boolean defaultBool) {
        if (string == null) {
            return defaultBool;
        }
        if (string.equalsIgnoreCase("YES") || string.equalsIgnoreCase("true")) {
            return true;
        }
        if (string.equalsIgnoreCase("NO") || string.equalsIgnoreCase("false")) {
            return false;
        }
        return defaultBool;
    }

    private String getFromBool(boolean value) {
        return value ? "YES" : "NO";
    }

    private void getUpdatedPolicy() {
        TokenRecord tokenRecord = null;
        String policySetString = null;
        try {
            tokenRecord = this.tps.tdb.tdbGetTokenEntry(this.cuid);
        }
        catch (Exception e) {
            return;
        }
        policySetString = tokenRecord.getPolicy();
        this.parsePolicySetString(policySetString);
    }

    public boolean isAllowedTokenPinReset() {
        return this.reset_pin_reset_to_no;
    }

    public boolean isAllowedResetPinResetToNo() {
        return this.reset_pin_reset_to_no;
    }

    public boolean isAllowedPinReset() {
        return this.pin_reset;
    }

    public boolean isForceTokenFormat() {
        return this.force_format;
    }

    public boolean isAllowdTokenReenroll() {
        return this.re_enroll;
    }

    public boolean isAllowdRenewSaveOldEncCerts() {
        return this.renew_keep_old_enc_certs;
    }

    public boolean isAllowdTokenRenew() {
        return this.renew;
    }

    public void setAllowedTokenPinReset(boolean value) {
        this.reset_pin_reset_to_no = value;
    }

    public void setAllowedResetPinResetToNo(boolean value) {
        this.reset_pin_reset_to_no = value;
    }

    public void setAllowedPinReset(boolean value) {
        this.pin_reset = value;
    }

    public void setForceTokenFormat(boolean value) {
        this.force_format = value;
    }

    public void setAllowdTokenReenroll(boolean value) {
        this.re_enroll = value;
    }

    public void setAllowdRenewSaveOldEncCerts(boolean value) {
        this.renew_keep_old_enc_certs = value;
    }

    public void setAllowdTokenRenew(boolean value) {
        this.renew = value;
    }
}

