/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme.validator;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.dogtagpki.acme.ACMEAuthorization;
import org.dogtagpki.acme.ACMEChallenge;
import org.dogtagpki.acme.ACMEError;
import org.dogtagpki.acme.ACMEIdentifier;
import org.dogtagpki.acme.ValidationResult;
import org.dogtagpki.acme.validator.ACMEValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP01Validator
extends ACMEValidator {
    public static Logger logger = LoggerFactory.getLogger(HTTP01Validator.class);

    public HTTP01Validator() {
        super("HTTP-01", "http-01");
    }

    @Override
    public ValidationResult validateChallenge(ACMEAuthorization authorization, ACMEChallenge challenge) {
        URI validationURL;
        String accountID = authorization.getAccountID();
        String token = challenge.getToken();
        String keyAuthorization = token + "." + accountID;
        logger.info("Key authorization: " + keyAuthorization);
        ACMEIdentifier identifier = authorization.getIdentifier();
        String hostname = identifier.getValue();
        String validationPath = "/.well-known/acme-challenge/" + token;
        try {
            validationURL = new URI("http", hostname, validationPath, null);
        }
        catch (URISyntaxException e) {
            ACMEError error = new ACMEError();
            error.setType("urn:ietf:params:acme:error:serverInternal");
            error.setDetail("Failed to construct validation URI for hostname '" + hostname + "' and path '" + validationPath + "': " + e);
            return ValidationResult.fail((ACMEError)error);
        }
        String response = null;
        try {
            response = this.getResponse(validationURL);
        }
        catch (Exception e) {
            logger.info("Unable to validate HTTP-01 challenge: " + e.getMessage(), (Throwable)e);
            ACMEError error = new ACMEError();
            error.setType("urn:ietf:params:acme:error:connection");
            error.setDetail("Unable to validate HTTP-01 challenge at " + validationURL + "\nError: " + e.getMessage());
            return ValidationResult.fail((ACMEError)error);
        }
        if (response == null || !response.equals(keyAuthorization)) {
            logger.error("Invalid response: " + response);
            ACMEError error = new ACMEError();
            error.setType("urn:ietf:params:acme:error:incorrectResponse");
            error.setDetail("Unable to validate HTTP-01 challenge at " + validationURL + "\nIncorrect response: " + response);
            return ValidationResult.fail((ACMEError)error);
        }
        return ValidationResult.ok();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResponse(URI validationURL) throws Exception {
        String response;
        logger.info("Retrieving " + validationURL);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(validationURL);
        try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);){
            HttpEntity entity = httpResponse.getEntity();
            response = IOUtils.toString((InputStream)entity.getContent(), (String)"UTF-8").trim();
            EntityUtils.consume((HttpEntity)entity);
        }
        logger.info("Response: " + response);
        return response;
    }
}

