/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.rest;

import com.netscape.certsrv.base.BadRequestException;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.ForbiddenException;
import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.base.ResourceNotFoundException;
import com.netscape.certsrv.base.UserNotFoundException;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.certsrv.group.GroupMemberData;
import com.netscape.certsrv.logging.event.ConfigRoleEvent;
import com.netscape.certsrv.user.UserCertCollection;
import com.netscape.certsrv.user.UserCertData;
import com.netscape.certsrv.user.UserCollection;
import com.netscape.certsrv.user.UserData;
import com.netscape.certsrv.user.UserMembershipCollection;
import com.netscape.certsrv.user.UserMembershipData;
import com.netscape.certsrv.user.UserResource;
import com.netscape.certsrv.usrgrp.EUsrGrpException;
import com.netscape.cms.password.PasswordChecker;
import com.netscape.cms.servlet.admin.GroupMemberProcessor;
import com.netscape.cms.servlet.base.SubsystemService;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.usrgrp.Group;
import com.netscape.cmscore.usrgrp.UGSubsystem;
import com.netscape.cmscore.usrgrp.User;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.dogtag.util.cert.CertUtil;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.InternalCertificate;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.pkcs.PKCS7;
import org.mozilla.jss.netscape.security.util.Cert;
import org.mozilla.jss.netscape.security.util.CertPrettyPrint;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserService
extends SubsystemService
implements UserResource {
    public static Logger logger = LoggerFactory.getLogger(UserService.class);
    public static final String BACK_SLASH = "\\";
    public static final String SYSTEM_USER = "$System$";

    public UserData createUserData(User user) throws Exception {
        String fullName;
        UserData userData = new UserData();
        String userID = user.getUserID();
        if (!StringUtils.isEmpty((CharSequence)userID)) {
            userData.setID(userID);
            userData.setUserID(userID);
        }
        if (!StringUtils.isEmpty((CharSequence)(fullName = user.getFullName()))) {
            userData.setFullName(fullName);
        }
        return userData;
    }

    public Response findUsers(String filter, Integer start, Integer size) {
        if (filter != null && filter.length() < 3) {
            throw new BadRequestException("Filter is too short.");
        }
        start = start == null ? 0 : start;
        size = size == null ? 20 : size;
        UserCollection response = new UserCollection();
        try {
            int i;
            CMSEngine engine = this.getCMSEngine();
            UGSubsystem userGroupManager = engine.getUGSubsystem();
            Enumeration<User> users = userGroupManager.findUsersByKeyword(filter);
            for (i = 0; i < start && users.hasMoreElements(); ++i) {
                users.nextElement();
            }
            while (i < start + size && users.hasMoreElements()) {
                User user = users.nextElement();
                response.addEntry((Object)this.createUserData(user));
                ++i;
            }
            while (users.hasMoreElements()) {
                users.nextElement();
                ++i;
            }
            response.setTotal(i);
            return this.createOKResponse(response);
        }
        catch (EUsrGrpException e) {
            if (CMS.getUserMessage("CMS_USRGRP_USER_NOT_FOUND", new String[0]).equals(e.getMessage())) {
                logger.debug("UserService.findUsers(): " + e.getMessage());
                return this.createOKResponse(response);
            }
            logger.error("UserService: " + e.getMessage(), (Throwable)e);
            throw new PKIException((Throwable)e);
        }
        catch (Exception e) {
            logger.error("UserService: " + e.getMessage(), (Throwable)e);
            throw new PKIException((Throwable)e);
        }
    }

    public Response getUser(String userID) {
        return this.createOKResponse(this.getUserData(userID));
    }

    public UserData getUserData(String userID) {
        try {
            List<String> profiles;
            String csType;
            String type;
            String state;
            String phone;
            User user;
            if (userID == null) {
                logger.error(CMS.getLogMessage("ADMIN_SRVLT_NULL_RS_ID", new Object[0]));
                throw new BadRequestException(this.getUserMessage("CMS_ADMIN_SRVLT_NULL_RS_ID", this.headers, new String[0]));
            }
            CMSEngine engine = this.getCMSEngine();
            EngineConfig cs = engine.getConfig();
            UGSubsystem userGroupManager = engine.getUGSubsystem();
            try {
                user = userGroupManager.getUser(userID);
            }
            catch (Exception e) {
                throw new PKIException(this.getUserMessage("CMS_INTERNAL_ERROR", this.headers, new String[0]));
            }
            if (user == null) {
                logger.error(CMS.getLogMessage("USRGRP_SRVLT_USER_NOT_EXIST", new Object[0]));
                throw new UserNotFoundException(userID);
            }
            UserData userData = this.createUserData(user);
            String email = user.getEmail();
            if (!StringUtils.isEmpty((CharSequence)email)) {
                userData.setEmail(email);
            }
            if (!StringUtils.isEmpty((CharSequence)(phone = user.getPhone()))) {
                userData.setPhone(phone);
            }
            if (!StringUtils.isEmpty((CharSequence)(state = user.getState()))) {
                userData.setState(state);
            }
            if (!StringUtils.isEmpty((CharSequence)(type = user.getUserType()))) {
                userData.setType(type);
            }
            if ((csType = cs.getType()).equals("TPS") && (profiles = user.getTpsProfiles()) != null) {
                StringBuilder sb = new StringBuilder();
                String prefix = "";
                for (String profile : profiles) {
                    sb.append(prefix);
                    prefix = ",";
                    sb.append(profile);
                }
                userData.setAttribute("tpsProfiles", sb.toString());
            }
            return userData;
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public Response addUser(UserData userData) {
        logger.debug("UserService.addUser()");
        if (userData == null) {
            throw new BadRequestException("User data is null.");
        }
        String userID = userData.getUserID();
        logger.debug("User ID: " + userID);
        try {
            String csType;
            if (userID == null) {
                logger.error(CMS.getLogMessage("ADMIN_SRVLT_NULL_RS_ID", new Object[0]));
                throw new BadRequestException(this.getUserMessage("CMS_ADMIN_SRVLT_NULL_RS_ID", this.headers, new String[0]));
            }
            if (userID.indexOf(BACK_SLASH) != -1) {
                logger.error(CMS.getLogMessage("ADMIN_SRVLT_RS_ID_BS", new Object[0]));
                throw new BadRequestException(this.getUserMessage("CMS_ADMIN_SRVLT_RS_ID_BS", this.headers, new String[0]));
            }
            if (userID.equals(SYSTEM_USER)) {
                logger.error(CMS.getLogMessage("ADMIN_SRVLT_SPECIAL_ID", userID));
                throw new ForbiddenException(this.getUserMessage("CMS_ADMIN_SRVLT_SPECIAL_ID", this.headers, userID));
            }
            CMSEngine engine = this.getCMSEngine();
            EngineConfig cs = engine.getConfig();
            UGSubsystem userGroupManager = engine.getUGSubsystem();
            User user = userGroupManager.createUser(userID);
            String fname = userData.getFullName();
            logger.debug("Full name: " + fname);
            if (fname == null || fname.length() == 0) {
                String msg = this.getUserMessage("CMS_USRGRP_USER_ADD_FAILED_1", this.headers, "full name");
                logger.error(msg);
                throw new BadRequestException(msg);
            }
            user.setFullName(fname);
            String email = userData.getEmail();
            logger.debug("Email: " + email);
            if (email != null) {
                user.setEmail(email);
            } else {
                user.setEmail("");
            }
            String pword = userData.getPassword();
            logger.debug("Password: " + (pword == null ? null : "********"));
            if (pword != null && !pword.equals("")) {
                PasswordChecker passwdCheck = engine.getPasswordChecker();
                if (!passwdCheck.isGoodPassword(pword)) {
                    throw new EUsrGrpException(passwdCheck.getReason(pword));
                }
                user.setPassword(pword);
            } else {
                user.setPassword("");
            }
            String phone = userData.getPhone();
            logger.debug("Phone: " + phone);
            if (phone != null) {
                user.setPhone(phone);
            } else {
                user.setPhone("");
            }
            String type = userData.getType();
            logger.debug("Type: " + type);
            if (type != null) {
                user.setUserType(type);
            } else {
                user.setUserType("");
            }
            String state = userData.getState();
            logger.debug("State: " + state);
            if (state != null) {
                user.setState(state);
            }
            if ((csType = cs.getType()).equals("TPS")) {
                String tpsProfiles = userData.getAttribute("tpsProfiles");
                logger.debug("TPS profiles: " + tpsProfiles);
                if (tpsProfiles != null) {
                    String[] profiles = StringUtils.isEmpty((CharSequence)tpsProfiles) ? new String[]{} : tpsProfiles.split(",");
                    user.setTpsProfiles(Arrays.asList(profiles));
                }
            }
            userGroupManager.addUser(user);
            this.auditAddUser(userID, userData, "Success");
            userData = this.getUserData(userID);
            String encodedUserID = URLEncoder.encode(userID, "UTF-8");
            URI uri = this.uriInfo.getBaseUriBuilder().path(UserResource.class).path("{userID}").build(new Object[]{encodedUserID});
            return this.createCreatedResponse(userData, uri);
        }
        catch (PKIException e) {
            this.auditAddUser(userID, userData, "Failure");
            throw e;
        }
        catch (EBaseException | UnsupportedEncodingException e) {
            this.auditAddUser(userID, userData, "Failure");
            throw new PKIException(e.getMessage());
        }
    }

    public Response modifyUser(String userID, UserData userData) {
        logger.debug("UserService.modifyUser(" + userID + ")");
        if (userData == null) {
            throw new BadRequestException("User data is null.");
        }
        try {
            String csType;
            String pword;
            if (userID == null) {
                logger.error(CMS.getLogMessage("ADMIN_SRVLT_NULL_RS_ID", new Object[0]));
                throw new BadRequestException(this.getUserMessage("CMS_ADMIN_SRVLT_NULL_RS_ID", this.headers, new String[0]));
            }
            CMSEngine engine = this.getCMSEngine();
            EngineConfig cs = engine.getConfig();
            UGSubsystem userGroupManager = engine.getUGSubsystem();
            User user = userGroupManager.createUser(userID);
            String fullName = userData.getFullName();
            logger.debug("Full name: " + fullName);
            if (fullName != null) {
                user.setFullName(fullName);
            }
            String email = userData.getEmail();
            logger.debug("Email: " + email);
            if (email != null) {
                user.setEmail(email);
            }
            if ((pword = userData.getPassword()) != null && !pword.equals("")) {
                PasswordChecker passwdCheck = engine.getPasswordChecker();
                if (!passwdCheck.isGoodPassword(pword)) {
                    throw new EUsrGrpException(passwdCheck.getReason(pword));
                }
                user.setPassword(pword);
            }
            String phone = userData.getPhone();
            logger.debug("Phone: " + phone);
            if (phone != null) {
                user.setPhone(phone);
            }
            String state = userData.getState();
            logger.debug("State: " + state);
            if (state != null) {
                user.setState(state);
            }
            if ((csType = cs.getType()).equals("TPS")) {
                String tpsProfiles = userData.getAttribute("tpsProfiles");
                logger.debug("TPS Profiles: " + tpsProfiles);
                if (tpsProfiles != null) {
                    String[] profiles = StringUtils.isEmpty((CharSequence)tpsProfiles) ? new String[]{} : tpsProfiles.split(",");
                    user.setTpsProfiles(Arrays.asList(profiles));
                }
            }
            userGroupManager.modifyUser(user);
            this.auditModifyUser(userID, userData, "Success");
            userData = this.getUserData(userID);
            return this.createOKResponse(userData);
        }
        catch (PKIException e) {
            this.auditModifyUser(userID, userData, "Failure");
            throw e;
        }
        catch (EBaseException e) {
            this.auditModifyUser(userID, userData, "Failure");
            throw new PKIException(e.getMessage());
        }
    }

    public Response removeUser(String userID) {
        try {
            if (userID == null) {
                logger.error(CMS.getLogMessage("ADMIN_SRVLT_NULL_RS_ID", new Object[0]));
                throw new BadRequestException(this.getUserMessage("CMS_ADMIN_SRVLT_NULL_RS_ID", this.headers, new String[0]));
            }
            CMSEngine engine = this.getCMSEngine();
            UGSubsystem userGroupManager = engine.getUGSubsystem();
            Enumeration<Group> groups = userGroupManager.findGroups("*");
            while (groups.hasMoreElements()) {
                Group group = groups.nextElement();
                if (!group.isMember(userID)) continue;
                userGroupManager.removeUserFromGroup(group, userID);
            }
            userGroupManager.removeUser(userID);
            this.auditDeleteUser(userID, "Success");
            return this.createNoContentResponse();
        }
        catch (PKIException e) {
            this.auditDeleteUser(userID, "Failure");
            throw e;
        }
        catch (EBaseException e) {
            this.auditDeleteUser(userID, "Failure");
            throw new PKIException(e.getMessage());
        }
    }

    public UserCertData createUserCertData(String userID, java.security.cert.X509Certificate cert) throws Exception {
        UserCertData userCertData = new UserCertData();
        userCertData.setVersion(Integer.valueOf(cert.getVersion()));
        userCertData.setSerialNumber(new CertId(cert.getSerialNumber()));
        userCertData.setIssuerDN(cert.getIssuerDN().toString());
        userCertData.setSubjectDN(cert.getSubjectDN().toString());
        userID = URLEncoder.encode(userID, "UTF-8");
        return userCertData;
    }

    public Response findUserCerts(String userID, Integer start, Integer size) {
        try {
            int i;
            start = start == null ? 0 : start;
            size = size == null ? 20 : size;
            if (userID == null) {
                logger.error(CMS.getLogMessage("ADMIN_SRVLT_NULL_RS_ID", new Object[0]));
                throw new BadRequestException(this.getUserMessage("CMS_ADMIN_SRVLT_NULL_RS_ID", this.headers, new String[0]));
            }
            CMSEngine engine = this.getCMSEngine();
            UGSubsystem userGroupManager = engine.getUGSubsystem();
            User user = null;
            try {
                user = userGroupManager.getUser(userID);
            }
            catch (Exception e) {
                throw new PKIException(this.getUserMessage("CMS_USRGRP_SRVLT_USER_NOT_EXIST", this.headers, new String[0]));
            }
            if (user == null) {
                logger.error(CMS.getLogMessage("USRGRP_SRVLT_USER_NOT_EXIST", new Object[0]));
                throw new UserNotFoundException(userID);
            }
            java.security.cert.X509Certificate[] certs = user.getX509Certificates();
            if (certs == null) {
                certs = new java.security.cert.X509Certificate[]{};
            }
            Iterator<java.security.cert.X509Certificate> entries = Arrays.asList(certs).iterator();
            UserCertCollection response = new UserCertCollection();
            for (i = 0; i < start && entries.hasNext(); ++i) {
                entries.next();
            }
            while (i < start + size && entries.hasNext()) {
                response.addEntry((Object)this.createUserCertData(userID, entries.next()));
                ++i;
            }
            while (entries.hasNext()) {
                entries.next();
                ++i;
            }
            response.setTotal(i);
            return this.createOKResponse(response);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public Response getUserCert(String userID, String certID) {
        return this.createOKResponse(this.getUserCertData(userID, certID));
    }

    public UserCertData getUserCertData(String userID, String certID) {
        if (certID == null) {
            throw new BadRequestException("Certificate ID is null.");
        }
        try {
            if (userID == null) {
                logger.error(CMS.getLogMessage("ADMIN_SRVLT_NULL_RS_ID", new Object[0]));
                throw new BadRequestException(this.getUserMessage("CMS_ADMIN_SRVLT_NULL_RS_ID", this.headers, new String[0]));
            }
            CMSEngine engine = this.getCMSEngine();
            UGSubsystem userGroupManager = engine.getUGSubsystem();
            User user = null;
            try {
                user = userGroupManager.getUser(userID);
            }
            catch (Exception e) {
                throw new PKIException(this.getUserMessage("CMS_USRGRP_SRVLT_USER_NOT_EXIST", this.headers, new String[0]));
            }
            if (user == null) {
                logger.error(CMS.getLogMessage("USRGRP_SRVLT_USER_NOT_EXIST", new Object[0]));
                throw new UserNotFoundException(userID);
            }
            java.security.cert.X509Certificate[] certs = user.getX509Certificates();
            if (certs == null) {
                throw new ResourceNotFoundException("No certificates found for " + userID);
            }
            try {
                certID = URLDecoder.decode(certID, "UTF-8");
            }
            catch (Exception e) {
                throw new PKIException(e.getMessage());
            }
            for (java.security.cert.X509Certificate cert : certs) {
                UserCertData userCertData = this.createUserCertData(userID, cert);
                if (!userCertData.getID().equals(certID)) continue;
                CertPrettyPrint print = new CertPrettyPrint((Certificate)cert);
                userCertData.setPrettyPrint(print.toString(this.getLocale(this.headers)));
                String base64 = CertUtil.toPEM((java.security.cert.X509Certificate)cert);
                userCertData.setEncoded(base64);
                return userCertData;
            }
            throw new ResourceNotFoundException("No certificates found for " + userID);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public Response addUserCert(String userID, UserCertData userCertData) {
        if (userCertData == null) {
            throw new BadRequestException("Certificate data is null.");
        }
        try {
            if (userID == null) {
                logger.error(CMS.getLogMessage("ADMIN_SRVLT_NULL_RS_ID", new Object[0]));
                throw new BadRequestException(this.getUserMessage("CMS_ADMIN_SRVLT_NULL_RS_ID", this.headers, new String[0]));
            }
            CMSEngine engine = this.getCMSEngine();
            UGSubsystem userGroupManager = engine.getUGSubsystem();
            User user = userGroupManager.createUser(userID);
            String encoded = userCertData.getEncoded();
            if (encoded == null) {
                this.auditAddUserCert(userID, userCertData, "Success");
                return this.createOKResponse();
            }
            Object cert = null;
            byte[] binaryCert = Cert.parseCertificate((String)encoded);
            try {
                cert = new X509CertImpl(binaryCert);
            }
            catch (CertificateException e) {
                logger.warn("UserService: Submitted data is not an X.509 certificate: " + e.getMessage(), (Throwable)e);
            }
            if (cert == null) {
                boolean assending = true;
                logger.debug("UserService: " + CMS.getLogMessage("ADMIN_SRVLT_IS_PK_BLOB", new Object[0]));
                try {
                    CryptoManager manager = CryptoManager.getInstance();
                    PKCS7 pkcs7 = new PKCS7(binaryCert);
                    java.security.cert.X509Certificate[] p7certs = pkcs7.getCertificates();
                    if (p7certs.length == 0) {
                        logger.error("UserService: PKCS #7 data contains no certificates");
                        throw new BadRequestException("PKCS #7 data contains no certificates");
                    }
                    if (p7certs[0].getSubjectDN().toString().equals(p7certs[0].getIssuerDN().toString()) && p7certs.length == 1) {
                        cert = p7certs[0];
                        logger.debug("UserService: " + CMS.getLogMessage("ADMIN_SRVLT_SINGLE_CERT_IMPORT", new Object[0]));
                    } else if (p7certs[0].getIssuerDN().toString().equals(p7certs[1].getSubjectDN().toString())) {
                        cert = p7certs[0];
                        logger.debug("UserService: " + CMS.getLogMessage("ADMIN_SRVLT_CERT_CHAIN_ACEND_ORD", new Object[0]));
                    } else if (p7certs[1].getIssuerDN().toString().equals(p7certs[0].getSubjectDN().toString())) {
                        assending = false;
                        logger.debug("UserService: " + CMS.getLogMessage("ADMIN_SRVLT_CERT_CHAIN_DESC_ORD", new Object[0]));
                        cert = p7certs[p7certs.length - 1];
                    } else {
                        logger.error("UserService: " + CMS.getLogMessage("ADMIN_SRVLT_CERT_BAD_CHAIN", new Object[0]));
                        throw new BadRequestException(this.getUserMessage("CMS_USRGRP_SRVLT_CERT_ERROR", this.headers, new String[0]));
                    }
                    logger.debug("UserService: " + CMS.getLogMessage("ADMIN_SRVLT_CHAIN_STORED_DB", String.valueOf(p7certs.length)));
                    int j = 0;
                    int jBegin = 0;
                    int jEnd = 0;
                    if (assending) {
                        jBegin = 1;
                        jEnd = p7certs.length;
                    } else {
                        jBegin = 0;
                        jEnd = p7certs.length - 1;
                    }
                    for (j = jBegin; j < jEnd; ++j) {
                        logger.debug("UserService: " + CMS.getLogMessage("ADMIN_SRVLT_CERT_IN_CHAIN", String.valueOf(j), String.valueOf(p7certs[j].getSubjectDN())));
                        X509Certificate leafCert = manager.importCACertPackage(p7certs[j].getEncoded());
                        if (leafCert == null) {
                            logger.warn("UserService: missing leaf certificate");
                            logger.error(CMS.getLogMessage("ADMIN_SRVLT_LEAF_CERT_NULL", new Object[0]));
                        } else {
                            logger.debug("UserService: " + CMS.getLogMessage("ADMIN_SRVLT_LEAF_CERT_NON_NULL", new Object[0]));
                        }
                        if (leafCert instanceof InternalCertificate) {
                            ((InternalCertificate)leafCert).setSSLTrust(152);
                            continue;
                        }
                        logger.error(CMS.getLogMessage("ADMIN_SRVLT_NOT_INTERNAL_CERT", String.valueOf(p7certs[j].getSubjectDN())));
                    }
                }
                catch (PKIException e) {
                    logger.error("UserService: Unable to import user certificate from PKCS #7 data: " + e);
                    logger.error(CMS.getLogMessage("USRGRP_SRVLT_CERT_ERROR", e.toString()));
                    throw e;
                }
                catch (Exception e) {
                    logger.error("UserService: " + e.getMessage(), (Throwable)e);
                    logger.error(CMS.getLogMessage("USRGRP_SRVLT_CERT_ERROR", e.toString()));
                    throw new PKIException("Unable to import user certificate from PKCS #7 data: " + e.getMessage(), (Throwable)e);
                }
            }
            try {
                logger.debug("UserService: " + CMS.getLogMessage("ADMIN_SRVLT_BEFORE_VALIDITY", new Object[0]));
                ((java.security.cert.X509Certificate)cert).checkValidity();
                user.setX509Certificates(new java.security.cert.X509Certificate[]{cert});
                userGroupManager.addUserCert(userID, (java.security.cert.X509Certificate)cert);
                this.auditAddUserCert(userID, userCertData, "Success");
                userCertData.setVersion(Integer.valueOf(((java.security.cert.X509Certificate)cert).getVersion()));
                userCertData.setSerialNumber(new CertId(((java.security.cert.X509Certificate)cert).getSerialNumber()));
                userCertData.setIssuerDN(((java.security.cert.X509Certificate)cert).getIssuerDN().toString());
                userCertData.setSubjectDN(((java.security.cert.X509Certificate)cert).getSubjectDN().toString());
                String certID = userCertData.getID();
                String encodedCertID = URLEncoder.encode(certID, "UTF-8");
                userCertData = this.getUserCertData(userID, encodedCertID);
                String encodedUserID = URLEncoder.encode(userID, "UTF-8");
                URI uri = this.uriInfo.getBaseUriBuilder().path(UserResource.class).path("{userID}/certs/{certID}").build(new Object[]{encodedUserID, encodedCertID});
                return this.createCreatedResponse(userCertData, uri);
            }
            catch (CertificateExpiredException e) {
                logger.error("UserService: Certificate expired: " + e.getMessage(), (Throwable)e);
                logger.error(CMS.getLogMessage("ADMIN_SRVLT_ADD_CERT_EXPIRED", String.valueOf(((java.security.cert.X509Certificate)cert).getSubjectDN())));
                throw new BadRequestException("Certificate expired: " + e.getMessage(), (Throwable)e);
            }
            catch (CertificateNotYetValidException e) {
                logger.error("UserService: Certificate not yet valid: " + e.getMessage(), (Throwable)e);
                logger.error(CMS.getLogMessage("USRGRP_SRVLT_CERT_NOT_YET_VALID", String.valueOf(((java.security.cert.X509Certificate)cert).getSubjectDN())));
                throw new BadRequestException("Certificate not yet valid: " + e.getMessage(), (Throwable)e);
            }
        }
        catch (PKIException e) {
            logger.error("UserService: Unable to import user certificate: " + e.getMessage(), (Throwable)e);
            this.auditAddUserCert(userID, userCertData, "Failure");
            throw e;
        }
        catch (Exception e) {
            logger.error("UserService: " + e.getMessage(), (Throwable)e);
            this.auditAddUserCert(userID, userCertData, "Failure");
            throw new PKIException("Unable to import user certificate: " + e.getMessage(), (Throwable)e);
        }
    }

    public Response removeUserCert(String userID, String certID) {
        if (userID == null) {
            throw new BadRequestException("User ID is null.");
        }
        if (certID == null) {
            throw new BadRequestException("Certificate ID is null.");
        }
        try {
            certID = URLDecoder.decode(certID, "UTF-8");
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
        UserCertData userCertData = new UserCertData();
        userCertData.setID(certID);
        this.removeUserCert(userID, userCertData);
        return this.createNoContentResponse();
    }

    public void removeUserCert(String userID, UserCertData userCertData) {
        try {
            if (userID == null) {
                logger.error(CMS.getLogMessage("ADMIN_SRVLT_NULL_RS_ID", new Object[0]));
                throw new BadRequestException(this.getUserMessage("CMS_ADMIN_SRVLT_NULL_RS_ID", this.headers, new String[0]));
            }
            CMSEngine engine = this.getCMSEngine();
            UGSubsystem userGroupManager = engine.getUGSubsystem();
            String certID = userCertData.getID();
            if (certID == null) {
                this.auditDeleteUserCert(userID, userCertData, "Success");
                return;
            }
            userGroupManager.removeUserCert(userID, certID);
            this.auditDeleteUserCert(userID, userCertData, "Success");
        }
        catch (PKIException e) {
            this.auditDeleteUserCert(userID, userCertData, "Failure");
            throw e;
        }
        catch (Exception e) {
            logger.error("Error: " + e.getMessage(), (Throwable)e);
            this.auditDeleteUserCert(userID, userCertData, "Failure");
            throw new PKIException(this.getUserMessage("CMS_USRGRP_USER_MOD_FAILED", this.headers, new String[0]));
        }
    }

    public UserMembershipData createUserMembershipData(String userID, String groupID) {
        UserMembershipData userMembershipData = new UserMembershipData();
        userMembershipData.setID(groupID);
        userMembershipData.setUserID(userID);
        return userMembershipData;
    }

    public Response findUserMemberships(String userID, String filter, Integer start, Integer size) {
        logger.debug("UserService.findUserMemberships(" + userID + ", " + filter + ")");
        if (userID == null) {
            logger.error(CMS.getLogMessage("ADMIN_SRVLT_NULL_RS_ID", new Object[0]));
            throw new BadRequestException(this.getUserMessage("CMS_ADMIN_SRVLT_NULL_RS_ID", this.headers, new String[0]));
        }
        if (filter != null && filter.length() < 3) {
            throw new BadRequestException("Filter is too short.");
        }
        start = start == null ? 0 : start;
        size = size == null ? 20 : size;
        try {
            int i;
            CMSEngine engine = this.getCMSEngine();
            UGSubsystem userGroupManager = engine.getUGSubsystem();
            User user = userGroupManager.getUser(userID);
            if (user == null) {
                logger.error(CMS.getLogMessage("USRGRP_SRVLT_USER_NOT_EXIST", new Object[0]));
                throw new UserNotFoundException(userID);
            }
            Enumeration<Group> groups = userGroupManager.findGroupsByUser(user.getUserDN(), filter);
            UserMembershipCollection response = new UserMembershipCollection();
            for (i = 0; i < start && groups.hasMoreElements(); ++i) {
                groups.nextElement();
            }
            while (i < start + size && groups.hasMoreElements()) {
                Group group = groups.nextElement();
                response.addEntry((Object)this.createUserMembershipData(userID, group.getName()));
                ++i;
            }
            while (groups.hasMoreElements()) {
                groups.nextElement();
                ++i;
            }
            response.setTotal(i);
            return this.createOKResponse(response);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PKIException(e.getMessage(), (Throwable)e);
        }
    }

    public Response addUserMembership(String userID, String groupID) {
        if (userID == null) {
            throw new BadRequestException("User ID is null.");
        }
        if (groupID == null) {
            throw new BadRequestException("Group ID is null.");
        }
        CMSEngine engine = this.getCMSEngine();
        User user = null;
        try {
            UGSubsystem userGroupManager = engine.getUGSubsystem();
            user = userGroupManager.getUser(userID);
        }
        catch (Exception e) {
            throw new PKIException(this.getUserMessage("CMS_USRGRP_SRVLT_USER_NOT_EXIST", this.headers, new String[0]));
        }
        if (user == null) {
            logger.error(CMS.getLogMessage("USRGRP_SRVLT_USER_NOT_EXIST", new Object[0]));
            throw new UserNotFoundException(userID);
        }
        try {
            GroupMemberData groupMemberData = new GroupMemberData();
            groupMemberData.setID(userID);
            groupMemberData.setGroupID(groupID);
            GroupMemberProcessor processor = new GroupMemberProcessor(this.getLocale(this.headers));
            processor.setCMSEngine(engine);
            processor.init();
            processor.setUriInfo(this.uriInfo);
            processor.addGroupMember(groupMemberData);
            UserMembershipData userMembershipData = this.createUserMembershipData(userID, groupID);
            URI uri = this.uriInfo.getBaseUriBuilder().path(UserResource.class).path("{userID}/memberships/{groupID}").build(new Object[]{URLEncoder.encode(userID, "UTF-8"), URLEncoder.encode(groupID, "UTF-8")});
            return this.createCreatedResponse(userMembershipData, uri);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PKIException(e.getMessage(), (Throwable)e);
        }
    }

    public Response removeUserMembership(String userID, String groupID) {
        if (userID == null) {
            throw new BadRequestException("User ID is null.");
        }
        if (groupID == null) {
            throw new BadRequestException("Group ID is null.");
        }
        try {
            GroupMemberProcessor processor = new GroupMemberProcessor(this.getLocale(this.headers));
            processor.setCMSEngine(this.getCMSEngine());
            processor.init();
            processor.setUriInfo(this.uriInfo);
            processor.removeGroupMember(groupID, userID);
            return this.createNoContentResponse();
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PKIException(e.getMessage(), (Throwable)e);
        }
    }

    public void auditAddUser(String id, UserData userData, String status) {
        this.auditUser("OP_ADD", id, this.getParams(userData), status);
    }

    public void auditModifyUser(String id, UserData userData, String status) {
        this.auditUser("OP_MODIFY", id, this.getParams(userData), status);
    }

    public void auditDeleteUser(String id, String status) {
        this.auditUser("OP_DELETE", id, null, status);
    }

    public void auditAddUserCert(String id, UserCertData userCertData, String status) {
        this.auditUserCert("OP_ADD", id, this.getParams(userCertData), status);
    }

    public void auditDeleteUserCert(String id, UserCertData userCertData, String status) {
        this.auditUserCert("OP_DELETE", id, this.getParams(userCertData), status);
    }

    public void auditUser(String type, String id, Map<String, String> params, String status) {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        auditor.log(new ConfigRoleEvent(auditor.getSubjectID(), status, auditor.getParamString("users", type, id, params)));
    }

    public void auditUserCert(String type, String id, Map<String, String> params, String status) {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        auditor.log(new ConfigRoleEvent(auditor.getSubjectID(), status, auditor.getParamString("certs", type, id, params)));
    }
}

