/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.cli;

import com.netscape.certsrv.user.UserCertData;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.server.cli.SubsystemUserCertAddCLI;
import org.dogtagpki.server.cli.SubsystemUserCertFindCLI;
import org.dogtagpki.server.cli.SubsystemUserCertRemoveCLI;

public class SubsystemUserCertCLI
extends CLI {
    public SubsystemUserCertCLI(CLI parent) {
        super("cert", parent.name.toUpperCase() + " user cert management commands", parent);
        this.addModule((CLI)new SubsystemUserCertFindCLI(this));
        this.addModule((CLI)new SubsystemUserCertAddCLI(this));
        this.addModule((CLI)new SubsystemUserCertRemoveCLI(this));
    }

    public static void printCert(UserCertData userCertData, boolean showPrettyPrint, boolean showEncoded) {
        System.out.println("  Cert ID: " + userCertData.getID());
        System.out.println("  Version: " + userCertData.getVersion());
        System.out.println("  Serial Number: " + userCertData.getSerialNumber().toHexString());
        System.out.println("  Issuer: " + userCertData.getIssuerDN());
        System.out.println("  Subject: " + userCertData.getSubjectDN());
        String prettyPrint = userCertData.getPrettyPrint();
        if (showPrettyPrint && prettyPrint != null) {
            System.out.println();
            System.out.println(prettyPrint);
        }
        String encoded = userCertData.getEncoded();
        if (showEncoded && encoded != null) {
            System.out.println();
            System.out.println(encoded);
        }
    }
}

