/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.cli;

import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.usrgrp.UGSubsystem;
import com.netscape.cmscore.usrgrp.UGSubsystemConfig;
import com.netscape.cmsutil.password.PasswordStore;
import com.netscape.cmsutil.password.PasswordStoreConfig;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.cert.X509Certificate;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.io.IOUtils;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.server.cli.SubsystemCLI;
import org.mozilla.jss.netscape.security.util.Cert;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubsystemUserCertAddCLI
extends SubsystemCLI {
    public static Logger logger = LoggerFactory.getLogger(SubsystemUserCertAddCLI.class);

    public SubsystemUserCertAddCLI(CLI parent) {
        super("add", "Add " + parent.getParent().getParent().getName().toUpperCase() + " user cert", parent);
    }

    public void createOptions() {
        Option option = new Option(null, "cert", true, "Certificate to add");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "format", true, "Certificate format: PEM (default), DER");
        option.setArgName("format");
        this.options.addOption(option);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length < 1) {
            throw new Exception("Missing user ID");
        }
        String userID = cmdArgs[0];
        String filename = cmd.getOptionValue("cert");
        String format = cmd.getOptionValue("format");
        this.initializeTomcatJSS();
        byte[] bytes = filename == null ? IOUtils.toByteArray((InputStream)System.in) : Files.readAllBytes(Paths.get(filename, new String[0]));
        if (format == null || "PEM".equalsIgnoreCase(format)) {
            bytes = Cert.parseCertificate((String)new String(bytes));
        } else if (!"DER".equalsIgnoreCase(format)) {
            throw new Exception("Unsupported format: " + format);
        }
        X509CertImpl cert = new X509CertImpl(bytes);
        String subsystem = this.parent.getParent().getParent().getName();
        EngineConfig cs = this.getEngineConfig(subsystem);
        cs.load();
        UGSubsystemConfig ugConfig = cs.getUGSubsystemConfig();
        LDAPConfig ldapConfig = ugConfig.getLDAPConfig();
        ldapConfig.putInteger("minConns", 1);
        PKISocketConfig socketConfig = cs.getSocketConfig();
        PasswordStoreConfig psc = cs.getPasswordStoreConfig();
        PasswordStore passwordStore = PasswordStore.create((PasswordStoreConfig)psc);
        UGSubsystem ugSubsystem = new UGSubsystem();
        try {
            ugSubsystem.init(ldapConfig, socketConfig, passwordStore);
            ugSubsystem.addUserCert(userID, (X509Certificate)cert);
        }
        finally {
            ugSubsystem.shutdown();
        }
    }
}

