/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.cli;

import com.netscape.cms.servlet.csadmin.LDAPConfigurator;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.LDAPConnectionConfig;
import com.netscape.cmscore.ldapconn.LdapAuthInfo;
import com.netscape.cmscore.ldapconn.LdapBoundConnection;
import com.netscape.cmscore.ldapconn.LdapConnInfo;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.ldapconn.PKISocketFactory;
import com.netscape.cmsutil.password.PasswordStore;
import com.netscape.cmsutil.password.PasswordStoreConfig;
import netscape.ldap.LDAPSocketFactory;
import org.apache.commons.cli.CommandLine;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.server.cli.SubsystemCLI;
import org.dogtagpki.util.logging.PKILogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubsystemDBAccessGrantCLI
extends SubsystemCLI {
    public static Logger logger = LoggerFactory.getLogger(SubsystemDBAccessGrantCLI.class);

    public SubsystemDBAccessGrantCLI(CLI parent) {
        super("grant", "Grant " + parent.parent.parent.getName().toUpperCase() + " database access", parent);
    }

    public void createOptions() {
        this.options.addOption("v", "verbose", false, "Run in verbose mode.");
        this.options.addOption(null, "debug", false, "Run in debug mode.");
        this.options.addOption(null, "help", false, "Show help message.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CommandLine cmd) throws Exception {
        if (cmd.hasOption("debug")) {
            PKILogger.setLevel((PKILogger.LogLevel)PKILogger.LogLevel.DEBUG);
        } else if (cmd.hasOption("verbose")) {
            PKILogger.setLevel((PKILogger.LogLevel)PKILogger.LogLevel.INFO);
        }
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 1) {
            throw new Exception("Missing DN");
        }
        String dn = cmdArgs[0];
        this.initializeTomcatJSS();
        String subsystem = this.parent.parent.parent.getName();
        EngineConfig cs = this.getEngineConfig(subsystem);
        cs.load();
        LDAPConfig ldapConfig = cs.getInternalDBConfig();
        String database = ldapConfig.getDatabase();
        String baseDN = ldapConfig.getBaseDN();
        PasswordStoreConfig psc = cs.getPasswordStoreConfig();
        PasswordStore passwordStore = PasswordStore.create((PasswordStoreConfig)psc);
        LDAPConnectionConfig connConfig = ldapConfig.getConnectionConfig();
        LdapConnInfo connInfo = new LdapConnInfo(connConfig);
        LdapAuthInfo authInfo = this.getAuthInfo(passwordStore, connInfo, ldapConfig);
        PKISocketConfig socketConfig = cs.getSocketConfig();
        PKISocketFactory socketFactory = new PKISocketFactory();
        socketFactory.setSecure(connInfo.getSecure());
        if (authInfo.getAuthType() == 2) {
            socketFactory.setClientCertNickname(authInfo.getClientCertNickname());
        }
        socketFactory.init(socketConfig);
        LdapBoundConnection conn = new LdapBoundConnection((LDAPSocketFactory)socketFactory, connInfo, authInfo);
        LDAPConfigurator ldapConfigurator = new LDAPConfigurator(conn, ldapConfig);
        try {
            ldapConfigurator.grantDatabaseAccess(dn);
        }
        finally {
            conn.disconnect();
        }
    }
}

