/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.authentication;

import com.netscape.certsrv.usrgrp.Certificates;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import org.dogtagpki.server.authentication.AuthManager;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;

public class AuthToken {
    public static final String USER = "user";
    public static final String USER_DN = "userdn";
    public static final String USER_ID = "userid";
    public static final String UID = "uid";
    public static final String GROUP = "group";
    public static final String GROUPS = "groups";
    public static final String TOKEN_CERT_SUBJECT = "tokenCertSubject";
    public static final String TOKEN_AUTHENTICATED_CERT_SUBJECT = "tokenAuthenticatedCertSubject";
    public static final String TOKEN_SHARED_TOKEN_AUTHENTICATED_CERT_SUBJECT = "tokenSharedTokenAuthenticatedCertSubject";
    public static final String TOKEN_CERT_NOTBEFORE = "tokenCertNotBefore";
    public static final String TOKEN_CERT_NOTAFTER = "tokenCertNotAfter";
    public static final String TOKEN_CERT_EXTENSIONS = "tokenCertExts";
    public static final String TOKEN_CERT_SERIALNUM = "certSerial";
    public static final String TOKEN_CERT = "tokenCert";
    public static final String TOKEN_CERT_TO_REVOKE = "tokenCertToRevoke";
    public static final String TOKEN_AUTHMGR_INST_NAME = "authMgrInstName";
    public static final String TOKEN_AUTHTIME = "authTime";
    protected Hashtable<String, Object> mAttrs = null;

    public AuthToken() {
    }

    public AuthToken(AuthManager authMgr) {
        this.mAttrs = new Hashtable();
        if (authMgr != null) {
            this.set(TOKEN_AUTHMGR_INST_NAME, authMgr.getName());
        }
        this.set(TOKEN_AUTHTIME, new Date());
    }

    public Object get(String attrName) {
        return this.mAttrs.get(attrName);
    }

    public String getInString(String attrName) {
        return (String)this.mAttrs.get(attrName);
    }

    public boolean set(String attrName, String value) {
        if (value == null) {
            return false;
        }
        this.mAttrs.put(attrName, value);
        return true;
    }

    public void delete(String attrName) {
        this.mAttrs.remove(attrName);
    }

    public Enumeration<String> getElements() {
        return this.mAttrs.keys();
    }

    public byte[] getInByteArray(String name) {
        String value = this.getInString(name);
        if (value == null) {
            return null;
        }
        return Utils.base64decode((String)value);
    }

    public boolean set(String name, byte[] value) {
        if (value == null) {
            return false;
        }
        return this.set(name, Utils.base64encode((byte[])value, (boolean)true));
    }

    public Integer getInInteger(String name) {
        String strVal = this.getInString(name);
        if (strVal == null) {
            return null;
        }
        try {
            return Integer.valueOf(strVal);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public boolean set(String name, Integer value) {
        if (value == null) {
            return false;
        }
        return this.set(name, value.toString());
    }

    public BigInteger[] getInBigIntegerArray(String name) {
        String value = this.getInString(name);
        if (value == null) {
            return null;
        }
        String[] values = value.split(",");
        if (values.length == 0) {
            return null;
        }
        BigInteger[] result = new BigInteger[values.length];
        for (int i = 0; i < values.length; ++i) {
            try {
                result[i] = new BigInteger(values[i]);
                continue;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return result;
    }

    public boolean set(String name, BigInteger[] value) {
        if (value == null) {
            return false;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < value.length; ++i) {
            if (i != 0) {
                buffer.append(",");
            }
            buffer.append(value[i].toString());
        }
        return this.set(name, buffer.toString());
    }

    public Date getInDate(String name) {
        String value = this.getInString(name);
        if (value == null) {
            return null;
        }
        try {
            return new Date(Long.parseLong(value));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public boolean set(String name, Date value) {
        if (value == null) {
            return false;
        }
        return this.set(name, String.valueOf(value.getTime()));
    }

    public String[] getInStringArray(String name) {
        String[] stringValues;
        byte[] byteValue = this.getInByteArray(name);
        if (byteValue == null) {
            return null;
        }
        try {
            DerInputStream in = new DerInputStream(byteValue);
            DerValue[] derValues = in.getSequence(5);
            stringValues = new String[derValues.length];
            for (int i = 0; i < derValues.length; ++i) {
                stringValues[i] = derValues[i].getAsString();
            }
        }
        catch (IOException e) {
            return null;
        }
        return stringValues;
    }

    public boolean set(String name, String[] value) {
        boolean bl;
        if (value == null) {
            return false;
        }
        DerValue[] derValues = new DerValue[value.length];
        DerOutputStream out = new DerOutputStream();
        try {
            for (int i = 0; i < value.length; ++i) {
                derValues[i] = new DerValue(value[i]);
            }
            out.putSequence(derValues);
            bl = this.set(name, out.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        out.close();
        return bl;
    }

    public X509CertImpl getInCert(String name) {
        byte[] data = this.getInByteArray(name);
        if (data == null) {
            return null;
        }
        try {
            return new X509CertImpl(data);
        }
        catch (CertificateException e) {
            return null;
        }
    }

    public boolean set(String name, X509CertImpl value) {
        if (value == null) {
            return false;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            value.encode((OutputStream)out);
        }
        catch (CertificateEncodingException e) {
            return false;
        }
        return this.set(name, out.toByteArray());
    }

    public CertificateExtensions getInCertExts(String name) throws IOException {
        CertificateExtensions exts = null;
        byte[] data = this.getInByteArray(name);
        if (data != null) {
            exts = new CertificateExtensions();
            exts.decodeEx((InputStream)new ByteArrayInputStream(data));
        }
        return exts;
    }

    public boolean set(String name, CertificateExtensions value) {
        if (value == null) {
            return false;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            value.encode((OutputStream)out);
        }
        catch (IOException e) {
            return false;
        }
        catch (CertificateException e) {
            return false;
        }
        return this.set(name, out.toByteArray());
    }

    public Certificates getInCertificates(String name) throws IOException, CertificateException {
        byte[] byteValue = this.getInByteArray(name);
        if (byteValue == null) {
            return null;
        }
        DerInputStream in = new DerInputStream(byteValue);
        DerValue[] derValues = in.getSequence(5);
        X509CertImpl[] certArray = new X509CertImpl[derValues.length];
        for (int i = 0; i < derValues.length; ++i) {
            byte[] certData = derValues[i].toByteArray();
            certArray[i] = new X509CertImpl(certData);
        }
        return new Certificates((X509Certificate[])certArray);
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public boolean set(String name, Certificates value) {
        if (value == null) {
            return false;
        }
        X509Certificate[] certArray = value.getCertificates();
        DerValue[] derValues = new DerValue[certArray.length];
        try {
            Throwable throwable2;
            DerOutputStream derStream = new DerOutputStream();
            try {
                for (int i = 0; i < certArray.length; ++i) {
                    ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                    try {
                        X509CertImpl certImpl = (X509CertImpl)certArray[i];
                        certImpl.encode((OutputStream)byteStream);
                        derValues[i] = new DerValue(byteStream.toByteArray());
                        continue;
                    }
                    catch (CertificateEncodingException e) {
                        boolean bl = false;
                        derStream.close();
                        return bl;
                    }
                    catch (ClassCastException e) {
                        boolean bl = false;
                        derStream.close();
                        return bl;
                    }
                }
                derStream.putSequence(derValues);
                boolean bl = this.set(name, derStream.toByteArray());
                return bl;
                {
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                }
            }
            finally {
                try {
                    derStream.close();
                }
                catch (Throwable throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
            }
        }
        catch (IOException e) {
            return false;
        }
    }

    public byte[][] getInByteArrayArray(String name) throws IOException {
        byte[] byteValue = this.getInByteArray(name);
        if (byteValue == null) {
            return null;
        }
        DerInputStream in = new DerInputStream(byteValue);
        DerValue[] derValues = in.getSequence(5);
        byte[][] retval = new byte[derValues.length][];
        for (int i = 0; i < derValues.length; ++i) {
            retval[i] = derValues[i].getOctetString();
        }
        return retval;
    }

    public boolean set(String name, byte[][] value) {
        boolean bl;
        if (value == null) {
            return false;
        }
        DerValue[] derValues = new DerValue[value.length];
        DerOutputStream out = new DerOutputStream();
        try {
            for (int i = 0; i < value.length; ++i) {
                derValues[i] = new DerValue(4, value[i]);
            }
            out.putSequence(derValues);
            bl = this.set(name, out.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        out.close();
        return bl;
    }

    public Enumeration<Object> getVals() {
        return this.mAttrs.elements();
    }

    public String getAuthManagerInstName() {
        return (String)this.mAttrs.get(TOKEN_AUTHMGR_INST_NAME);
    }

    public Date getAuthTime() {
        return (Date)this.mAttrs.get(TOKEN_AUTHTIME);
    }
}

