/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.selftests;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.EPropertyNotFound;
import com.netscape.certsrv.base.Subsystem;
import com.netscape.certsrv.logging.AuditEvent;
import com.netscape.certsrv.logging.ELogException;
import com.netscape.certsrv.logging.ILogger;
import com.netscape.certsrv.logging.LogEventListener;
import com.netscape.certsrv.selftests.EDuplicateSelfTestException;
import com.netscape.certsrv.selftests.EInvalidSelfTestException;
import com.netscape.certsrv.selftests.EMissingSelfTestException;
import com.netscape.certsrv.selftests.ESelfTestException;
import com.netscape.cms.selftests.SelfTest;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.logging.LoggerConfig;
import com.netscape.cmscore.selftests.SelfTestOrderedInstance;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfTestSubsystem
extends Subsystem {
    public static Logger logger = LoggerFactory.getLogger(SelfTestSubsystem.class);
    public static final String ID = "selftests";
    public static final String PROP_CONTAINER = "container";
    public static final String PROP_INSTANCE = "instance";
    public static final String PROP_LOGGER = "logger";
    public static final String PROP_LOGGER_CLASS = "class";
    public static final String PROP_ORDER = "order";
    public static final String PROP_ON_DEMAND = "onDemand";
    public static final String PROP_STARTUP = "startup";
    private static LogEventListener mLogger;
    private ConfigStore mConfig;
    private String mRootPrefix = null;
    private String mPrefix = null;
    public Hashtable<String, SelfTest> mSelfTestInstances = new Hashtable();
    public Vector<SelfTestOrderedInstance> mOnDemandOrder = new Vector();
    public Vector<SelfTestOrderedInstance> mStartupOrder = new Vector();
    private static final String LIST_DELIMITER = ",";
    private static final String ELEMENT_DELIMITER = ":";
    private static final String CRITICAL = "critical";

    private String getFullName(String instancePrefix, String instanceName) {
        Object instanceFullName = null;
        if (instancePrefix != null) {
            instancePrefix = instancePrefix.trim();
        }
        if (instanceName != null) {
            instanceName = instanceName.trim();
        }
        if (instancePrefix != null && instancePrefix != "") {
            if (instanceName != null && instanceName != "") {
                instanceFullName = instancePrefix + "." + instanceName;
            }
        } else {
            instanceFullName = instanceName;
        }
        return instanceFullName;
    }

    private void checkInstance(SelfTestOrderedInstance element) throws EInvalidSelfTestException, EMissingSelfTestException {
        String instanceFullName = null;
        String instanceName = null;
        String instanceValue = null;
        String instancePath = "container.instance";
        ConfigStore instanceConfig = this.mConfig.getSubStore(instancePath, ConfigStore.class);
        instanceName = element.getSelfTestName();
        if (instanceName == null) {
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_NAME_IS_NULL", new Object[0]));
            throw new EMissingSelfTestException();
        }
        instanceName = instanceName.trim();
        instanceFullName = this.getFullName(this.mPrefix, instanceName);
        try {
            instanceValue = instanceConfig.getString(instanceName);
            if (instanceValue == null || instanceValue.equals("")) {
                this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_MISSING_VALUES", instanceFullName));
                throw new EMissingSelfTestException(instanceFullName, instanceValue);
            }
            instanceValue = instanceValue.trim();
        }
        catch (EPropertyNotFound e) {
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_MISSING_NAME", instanceFullName));
            throw new EMissingSelfTestException(instanceFullName);
        }
        catch (EBaseException e) {
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_THREW_EBASEEXCEPTION", instanceFullName, instanceValue));
            throw new EInvalidSelfTestException(instanceFullName, instanceValue);
        }
    }

    public Collection<String> getSelfTestNames() {
        return this.mSelfTestInstances.keySet();
    }

    public String[] listSelfTestsEnabledOnDemand() {
        int numElements = this.mOnDemandOrder.size();
        if (numElements == 0) {
            return null;
        }
        String[] mList = new String[numElements];
        Enumeration<SelfTestOrderedInstance> instances = this.mOnDemandOrder.elements();
        int i = 0;
        while (instances.hasMoreElements()) {
            SelfTestOrderedInstance instance = instances.nextElement();
            mList[i] = instance.getSelfTestName();
            if (mList[i] != null) {
                mList[i] = mList[i].trim();
            }
            ++i;
        }
        return mList;
    }

    public void enableSelfTestOnDemand(String instanceName, boolean isCritical) throws EInvalidSelfTestException, EMissingSelfTestException {
        if (instanceName == null) {
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_NAME_IS_NULL", new Object[0]));
            throw new EMissingSelfTestException();
        }
        instanceName = instanceName.trim();
        Enumeration<SelfTestOrderedInstance> instances = this.mOnDemandOrder.elements();
        while (instances.hasMoreElements()) {
            SelfTestOrderedInstance instance = instances.nextElement();
            if (!instanceName.equals(instance.getSelfTestName())) continue;
            instance.setSelfTestCriticalMode(isCritical);
            return;
        }
        Object elementName = null;
        elementName = isCritical ? instanceName + ":critical" : instanceName;
        SelfTestOrderedInstance element = new SelfTestOrderedInstance((String)elementName);
        this.checkInstance(element);
        this.mOnDemandOrder.add(element);
    }

    public void disableSelfTestOnDemand(String instanceName) throws EMissingSelfTestException {
        String instanceFullName = null;
        if (instanceName == null) {
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_NAME_IS_NULL", new Object[0]));
            throw new EMissingSelfTestException();
        }
        instanceName = instanceName.trim();
        instanceFullName = this.getFullName(this.mPrefix, instanceName);
        Enumeration<SelfTestOrderedInstance> instances = this.mOnDemandOrder.elements();
        while (instances.hasMoreElements()) {
            SelfTestOrderedInstance instance = instances.nextElement();
            if (!instanceName.equals(instance.getSelfTestName())) continue;
            this.mOnDemandOrder.remove(instance);
            return;
        }
        this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_MISSING_NAME", instanceFullName));
        throw new EMissingSelfTestException(instanceFullName);
    }

    public boolean isSelfTestEnabledOnDemand(String instanceName) throws EMissingSelfTestException {
        if (instanceName == null) {
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_NAME_IS_NULL", new Object[0]));
            throw new EMissingSelfTestException();
        }
        instanceName = instanceName.trim();
        Enumeration<SelfTestOrderedInstance> instances = this.mOnDemandOrder.elements();
        while (instances.hasMoreElements()) {
            SelfTestOrderedInstance instance = instances.nextElement();
            if (!instanceName.equals(instance.getSelfTestName())) continue;
            return true;
        }
        return false;
    }

    public boolean isSelfTestCriticalOnDemand(String instanceName) throws EMissingSelfTestException {
        String instanceFullName = null;
        if (instanceName == null) {
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_NAME_IS_NULL", new Object[0]));
            throw new EMissingSelfTestException();
        }
        instanceName = instanceName.trim();
        instanceFullName = this.getFullName(this.mPrefix, instanceName);
        Enumeration<SelfTestOrderedInstance> instances = this.mOnDemandOrder.elements();
        while (instances.hasMoreElements()) {
            SelfTestOrderedInstance instance = instances.nextElement();
            if (!instanceName.equals(instance.getSelfTestName())) continue;
            return instance.isSelfTestCritical();
        }
        throw new EMissingSelfTestException(instanceFullName);
    }

    public void runSelfTestsOnDemand() throws EMissingSelfTestException, ESelfTestException {
        logger.debug("SelfTestSubsystem: runSelfTestsOnDemand()");
        Enumeration<SelfTestOrderedInstance> instances = this.mOnDemandOrder.elements();
        while (instances.hasMoreElements()) {
            SelfTestOrderedInstance instance = instances.nextElement();
            String instanceName = instance.getSelfTestName();
            if (instanceName == null) {
                this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_NAME_IS_NULL", new Object[0]));
                throw new EMissingSelfTestException();
            }
            instanceName = instanceName.trim();
            String instanceFullName = this.getFullName(this.mPrefix, instanceName);
            if (!this.mSelfTestInstances.containsKey(instanceName)) {
                this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_MISSING_NAME", instanceFullName));
                throw new EMissingSelfTestException(instanceFullName);
            }
            try {
                this.runSelfTest(instanceName);
            }
            catch (Exception e) {
                if (this.isSelfTestCriticalOnDemand(instanceName)) {
                    this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_RUN_ON_DEMAND_FAILED", instanceFullName));
                    logger.error("SelfTestSubsystem: Disabling subsystem due to selftest failure: " + e.getMessage(), (Throwable)e);
                    this.engine.disableSubsystem();
                    throw new ESelfTestException("Selftest failed: " + e.getMessage(), (Throwable)e);
                }
                logger.warn("SelfTestSubsystem: Selftest failed: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void runSelfTest(String instanceName) throws Exception {
        logger.debug("SelfTestSubsystem: runSelfTest(" + instanceName + ")");
        SelfTest test = this.mSelfTestInstances.get(instanceName);
        if (test == null) {
            throw new EMissingSelfTestException(instanceName);
        }
        test.runSelfTest(mLogger);
    }

    public String[] listSelfTestsEnabledAtStartup() {
        int numElements = this.mStartupOrder.size();
        if (numElements == 0) {
            return null;
        }
        String[] mList = new String[numElements];
        Enumeration<SelfTestOrderedInstance> instances = this.mStartupOrder.elements();
        int i = 0;
        while (instances.hasMoreElements()) {
            SelfTestOrderedInstance instance = instances.nextElement();
            mList[i] = instance.getSelfTestName();
            if (mList[i] != null) {
                mList[i] = mList[i].trim();
            }
            ++i;
        }
        return mList;
    }

    public void enableSelfTestAtStartup(String instanceName, boolean isCritical) throws EInvalidSelfTestException, EMissingSelfTestException {
        if (instanceName == null) {
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_NAME_IS_NULL", new Object[0]));
            throw new EMissingSelfTestException();
        }
        instanceName = instanceName.trim();
        Enumeration<SelfTestOrderedInstance> instances = this.mStartupOrder.elements();
        while (instances.hasMoreElements()) {
            SelfTestOrderedInstance instance = instances.nextElement();
            if (!instanceName.equals(instance.getSelfTestName())) continue;
            instance.setSelfTestCriticalMode(isCritical);
            return;
        }
        Object elementName = null;
        elementName = isCritical ? instanceName + ":critical" : instanceName;
        SelfTestOrderedInstance element = new SelfTestOrderedInstance((String)elementName);
        this.checkInstance(element);
        this.mStartupOrder.add(element);
    }

    public void disableSelfTestAtStartup(String instanceName) throws EMissingSelfTestException {
        String instanceFullName = null;
        if (instanceName == null) {
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_NAME_IS_NULL", new Object[0]));
            throw new EMissingSelfTestException();
        }
        instanceName = instanceName.trim();
        instanceFullName = this.getFullName(this.mPrefix, instanceName);
        Enumeration<SelfTestOrderedInstance> instances = this.mStartupOrder.elements();
        while (instances.hasMoreElements()) {
            SelfTestOrderedInstance instance = instances.nextElement();
            if (!instanceName.equals(instance.getSelfTestName())) continue;
            this.mStartupOrder.remove(instance);
            return;
        }
        this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_MISSING_NAME", instanceFullName));
        throw new EMissingSelfTestException(instanceFullName);
    }

    public boolean isSelfTestEnabledAtStartup(String instanceName) throws EMissingSelfTestException {
        if (instanceName == null) {
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_NAME_IS_NULL", new Object[0]));
            throw new EMissingSelfTestException();
        }
        instanceName = instanceName.trim();
        Enumeration<SelfTestOrderedInstance> instances = this.mStartupOrder.elements();
        while (instances.hasMoreElements()) {
            SelfTestOrderedInstance instance = instances.nextElement();
            if (!instanceName.equals(instance.getSelfTestName())) continue;
            return true;
        }
        return false;
    }

    public boolean isSelfTestCriticalAtStartup(String instanceName) throws EMissingSelfTestException {
        String instanceFullName = null;
        if (instanceName == null) {
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_NAME_IS_NULL", new Object[0]));
            throw new EMissingSelfTestException();
        }
        instanceName = instanceName.trim();
        instanceFullName = this.getFullName(this.mPrefix, instanceName);
        Enumeration<SelfTestOrderedInstance> instances = this.mStartupOrder.elements();
        while (instances.hasMoreElements()) {
            SelfTestOrderedInstance instance = instances.nextElement();
            if (!instanceName.equals(instance.getSelfTestName())) continue;
            return instance.isSelfTestCritical();
        }
        throw new EMissingSelfTestException(instanceFullName);
    }

    public void runSelfTestsAtStartup() throws Exception {
        this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_RUN_AT_STARTUP", new Object[0]));
        Enumeration<SelfTestOrderedInstance> instances = this.mStartupOrder.elements();
        while (instances.hasMoreElements()) {
            SelfTestOrderedInstance instance = instances.nextElement();
            String instanceFullName = null;
            String instanceName = instance.getSelfTestName();
            if (instanceName == null) {
                this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_NAME_IS_NULL", new Object[0]));
                throw new EMissingSelfTestException();
            }
            instanceName = instanceName.trim();
            instanceFullName = this.getFullName(this.mPrefix, instanceName);
            if (!this.mSelfTestInstances.containsKey(instanceName)) {
                this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_MISSING_NAME", instanceFullName));
                throw new EMissingSelfTestException(instanceFullName);
            }
            SelfTest test = this.mSelfTestInstances.get(instanceName);
            try {
                logger.debug("SelfTestSubsystem: running " + test.getSelfTestName());
                test.runSelfTest(mLogger);
            }
            catch (Exception e) {
                if (!this.isSelfTestCriticalAtStartup(instanceName)) {
                    logger.warn("SelfTestSubsystem: selftest failed: " + e.getMessage(), (Throwable)e);
                    continue;
                }
                logger.error("SelfTestSubsystem: selftest failed: " + e.getMessage(), (Throwable)e);
                this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_RUN_AT_STARTUP_FAILED", instanceFullName));
                throw e;
            }
        }
        this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_RUN_AT_STARTUP_SUCCEEDED", new Object[0]));
    }

    public void log(int level, String msg) {
    }

    public SelfTest getSelfTest(String instanceName) {
        if (instanceName == null) {
            return null;
        }
        instanceName = instanceName.trim();
        Enumeration<SelfTest> instances = this.mSelfTestInstances.elements();
        while (instances.hasMoreElements()) {
            SelfTest instance = instances.nextElement();
            if (!instanceName.equals(instance.getSelfTestName())) continue;
            return instance;
        }
        return null;
    }

    public LogEventListener getSelfTestLogger() {
        return mLogger;
    }

    public void log(LogEventListener logger, String msg) {
        if (logger != null) {
            AuditEvent ev = new AuditEvent(msg);
            ev.setSource(ILogger.S_OTHER);
            ev.setLevel(1);
            try {
                logger.log(ev);
            }
            catch (ELogException le) {
                SelfTestSubsystem.logger.warn(msg + ": " + le.getMessage(), (Throwable)le);
            }
        } else {
            SelfTestSubsystem.logger.info(msg);
        }
    }

    public void registerSelfTestOnDemand(String instanceName, boolean isCritical, SelfTest instance) throws EDuplicateSelfTestException, EInvalidSelfTestException, EMissingSelfTestException {
        String instanceFullName = null;
        if (instanceName == null) {
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_NAME_IS_NULL", new Object[0]));
            throw new EMissingSelfTestException();
        }
        instanceName = instanceName.trim();
        instanceFullName = this.getFullName(this.mPrefix, instanceName);
        if (this.mSelfTestInstances.containsKey(instanceName)) {
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_DUPLICATE_NAME", instanceFullName));
            throw new EDuplicateSelfTestException(instanceFullName);
        }
        this.mSelfTestInstances.put(instanceName, instance);
        this.enableSelfTestOnDemand(instanceName, isCritical);
    }

    public void deregisterSelfTestOnDemand(String instanceName) throws EMissingSelfTestException {
        String instanceFullName = null;
        if (instanceName == null) {
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_NAME_IS_NULL", new Object[0]));
            throw new EMissingSelfTestException();
        }
        instanceName = instanceName.trim();
        instanceFullName = this.getFullName(this.mPrefix, instanceName);
        SelfTest test = this.getSelfTest(instanceName);
        if (test == null) {
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_MISSING_NAME", instanceFullName));
            throw new EMissingSelfTestException(instanceFullName);
        }
        this.mSelfTestInstances.remove(instanceName);
        this.disableSelfTestOnDemand(instanceName);
    }

    public void registerSelfTestAtStartup(String instanceName, boolean isCritical, SelfTest instance) throws EDuplicateSelfTestException, EInvalidSelfTestException, EMissingSelfTestException {
        String instanceFullName = null;
        if (instanceName == null) {
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_NAME_IS_NULL", new Object[0]));
            throw new EMissingSelfTestException();
        }
        instanceName = instanceName.trim();
        instanceFullName = this.getFullName(this.mPrefix, instanceName);
        if (this.mSelfTestInstances.containsKey(instanceName)) {
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_DUPLICATE_NAME", instanceFullName));
            throw new EDuplicateSelfTestException(instanceFullName);
        }
        this.mSelfTestInstances.put(instanceName, instance);
        this.enableSelfTestAtStartup(instanceName, isCritical);
    }

    public void deregisterSelfTestAtStartup(String instanceName) throws EMissingSelfTestException {
        String instanceFullName = null;
        if (instanceName == null) {
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_NAME_IS_NULL", new Object[0]));
            throw new EMissingSelfTestException();
        }
        instanceName = instanceName.trim();
        instanceFullName = this.getFullName(this.mPrefix, instanceName);
        SelfTest test = this.getSelfTest(instanceName);
        if (test == null) {
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_MISSING_NAME", instanceFullName));
            throw new EMissingSelfTestException(instanceFullName);
        }
        this.mSelfTestInstances.remove(instanceName);
        this.disableSelfTestAtStartup(instanceName);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void setId(String id) throws EBaseException {
        if (id == null) {
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_NAME_IS_NULL", new Object[0]));
            throw new EBaseException("id is null");
        }
    }

    @Override
    public void init(ConfigStore config) throws Exception {
        logger.debug("SelfTestSubsystem: init()");
        if (config == null) {
            logger.error("SelfTestSubsystem: Missing selftest configuration");
            throw new EBaseException("Missing selftest configuration");
        }
        this.mConfig = config;
        if (this.mConfig != null && this.mConfig.getName() != null && this.mConfig.getName() != "") {
            this.mRootPrefix = this.mConfig.getName().trim();
        }
        int loadStatus = 0;
        logger.debug("SelfTestSubsystem: loading selftest logger parameters");
        String loggerPrefix = null;
        String loggerFullName = null;
        String loggerName = PROP_LOGGER_CLASS;
        String loggerValue = null;
        String loggerPath = "container.logger";
        LoggerConfig loggerConfig = this.mConfig.getSubStore(loggerPath, LoggerConfig.class);
        if (loggerConfig == null || loggerConfig.getName() == null || loggerConfig.getName() == "") {
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_INITIALIZATION_NOTIFICATION", new Object[0]));
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_NAME_IS_NULL", new Object[0]));
            throw new EMissingSelfTestException();
        }
        loggerPrefix = loggerConfig.getName().trim();
        Enumeration<String> loggerInstances = loggerConfig.getPropertyNames();
        if (loggerInstances.hasMoreElements()) {
            ++loadStatus;
            try {
                loggerFullName = this.getFullName(loggerPrefix, loggerName);
                loggerValue = loggerConfig.getString(loggerName);
                if (loggerValue == null) {
                    this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_MISSING_VALUES", loggerFullName));
                    throw new EMissingSelfTestException(loggerFullName, loggerValue);
                }
                loggerValue = loggerValue.trim();
                Object o = Class.forName(loggerValue).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (!(o instanceof LogEventListener)) {
                    this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_INITIALIZATION_NOTIFICATION", new Object[0]));
                    this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_INVALID_INSTANCE", loggerFullName, loggerValue));
                    throw new EInvalidSelfTestException("The self test plugin named " + loggerFullName + " contains a value " + loggerValue + " which is not an instance of LogEventListener.");
                }
                mLogger = (LogEventListener)o;
                mLogger.setCMSEngine(this.engine);
                mLogger.init(this, loggerConfig);
            }
            catch (EInvalidSelfTestException | EMissingSelfTestException e) {
                throw e;
            }
            catch (EBaseException e) {
                this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_INITIALIZATION_NOTIFICATION", new Object[0]));
                this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_THREW_EBASEEXCEPTION", loggerFullName, loggerValue));
                throw e;
            }
            catch (Exception e) {
                this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_INITIALIZATION_NOTIFICATION", new Object[0]));
                this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_THREW_EXCEPTION", loggerFullName, loggerValue));
                logger.error("SelfTestSubsystem: Unable to initialize selftest logger: " + e.getMessage(), (Throwable)e);
                throw new EBaseException(e);
            }
        }
        if (loadStatus == 0) {
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_INITIALIZATION_NOTIFICATION", new Object[0]));
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_DONT_LOAD_LOGGER_PARAMETERS", new Object[0]));
        } else {
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_INITIALIZATION_NOTIFICATION", new Object[0]));
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_LOAD_LOGGER_PARAMETERS", new Object[0]));
        }
        logger.debug("SelfTestSubsystem: loading selftest plugins");
        String instancePath = "container.instance";
        ConfigStore instanceConfig = this.mConfig.getSubStore(instancePath, ConfigStore.class);
        if (instanceConfig == null || instanceConfig.getName() == null || instanceConfig.getName() == "") {
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_NAME_IS_NULL", new Object[0]));
            throw new EMissingSelfTestException();
        }
        this.mPrefix = instanceConfig.getName().trim();
        Enumeration<String> instances = instanceConfig.getPropertyNames();
        if (instances.hasMoreElements()) {
            ++loadStatus;
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_LOAD_PLUGINS", new Object[0]));
        } else {
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_DONT_LOAD_PLUGINS", new Object[0]));
        }
        String instanceFullName = null;
        String instanceName = null;
        String instanceValue = null;
        boolean first_time = true;
        while (instances.hasMoreElements()) {
            Object o;
            instanceName = instances.nextElement();
            if (instanceName == null) {
                this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_NAME_IS_NULL", new Object[0]));
                throw new EMissingSelfTestException();
            }
            instanceName = instanceName.trim();
            instanceFullName = this.getFullName(this.mPrefix, instanceName);
            if (this.mSelfTestInstances.containsKey(instanceName)) {
                this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_DUPLICATE_NAME", instanceFullName));
                throw new EDuplicateSelfTestException(instanceFullName);
            }
            try {
                instanceValue = instanceConfig.getString(instanceName);
                if (instanceValue == null) {
                    this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_MISSING_VALUES", instanceFullName));
                    throw new EMissingSelfTestException(instanceFullName, instanceValue);
                }
                instanceValue = instanceValue.trim();
            }
            catch (EMissingSelfTestException e) {
                throw e;
            }
            catch (EBaseException e) {
                this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_THREW_EBASEEXCEPTION", instanceFullName, instanceValue));
                throw e;
            }
            try {
                o = Class.forName(instanceValue).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (!(o instanceof SelfTest)) {
                    this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_INVALID_INSTANCE", instanceFullName, instanceValue));
                    throw new EInvalidSelfTestException(instanceFullName, instanceValue);
                }
            }
            catch (Exception e) {
                this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_THREW_EXCEPTION", instanceFullName, instanceValue));
                logger.error("SelfTestSubsystem: Unable to create selftest instance: " + e.getMessage(), (Throwable)e);
                throw new EInvalidSelfTestException(instanceFullName, instanceValue);
            }
            try {
                if (first_time) {
                    first_time = false;
                    logger.debug("SelfTestSubsystem: loading selftest plugin parameters");
                    this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_LOAD_PLUGIN_PARAMETERS", new Object[0]));
                }
                SelfTest test = (SelfTest)o;
                test.setCMSEngine(this.engine);
                test.initSelfTest(this, instanceName, this.mConfig);
                this.mSelfTestInstances.put(instanceName, test);
            }
            catch (EDuplicateSelfTestException e) {
                this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PLUGIN_DUPLICATE_PARAMETER", instanceFullName, e.getInstanceParameter()));
                throw e;
            }
            catch (EMissingSelfTestException e) {
                this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PLUGIN_MISSING_PARAMETER", instanceFullName, e.getInstanceParameter()));
                throw e;
            }
            catch (EInvalidSelfTestException e) {
                this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PLUGIN_INVALID_PARAMETER", instanceFullName, e.getInstanceParameter()));
                throw e;
            }
        }
        logger.debug("SelfTestSubsystem: loading on demand selftests");
        String onDemandOrderName = "container.order.onDemand";
        String onDemandOrderFullName = this.getFullName(this.mRootPrefix, onDemandOrderName);
        String onDemandOrderValues = null;
        try {
            onDemandOrderValues = this.mConfig.getString(onDemandOrderName);
            if (onDemandOrderValues != null) {
                onDemandOrderValues = onDemandOrderValues.trim();
            }
            ++loadStatus;
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_LOAD_PLUGINS_ON_DEMAND", new Object[0]));
            if (onDemandOrderValues == null || onDemandOrderValues.equals("")) {
                if (onDemandOrderFullName != null && !onDemandOrderFullName.equals("")) {
                    this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_MISSING_ON_DEMAND_VALUES", onDemandOrderFullName));
                }
                throw new EBaseException("onDemandOrderValues is null or empty");
            }
            StringTokenizer tokens = new StringTokenizer(onDemandOrderValues, LIST_DELIMITER);
            while (tokens.hasMoreTokens()) {
                SelfTestOrderedInstance element = new SelfTestOrderedInstance(tokens.nextToken().trim());
                this.checkInstance(element);
                this.mOnDemandOrder.add(element);
            }
        }
        catch (EPropertyNotFound e) {
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_DONT_LOAD_PLUGINS_ON_DEMAND", new Object[0]));
        }
        catch (EBaseException e) {
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_THREW_EBASEEXCEPTION", onDemandOrderFullName, onDemandOrderValues));
            throw new EInvalidSelfTestException(onDemandOrderFullName, onDemandOrderValues);
        }
        logger.debug("SelfTestSubsystem: loading startup selftests");
        String startupOrderName = "container.order.startup";
        String startupOrderFullName = this.getFullName(this.mRootPrefix, startupOrderName);
        String startupOrderValues = null;
        try {
            startupOrderValues = this.mConfig.getString(startupOrderName);
            if (startupOrderValues != null) {
                startupOrderValues = startupOrderValues.trim();
            }
            ++loadStatus;
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_LOAD_PLUGINS_AT_STARTUP", new Object[0]));
            if ((startupOrderValues == null || startupOrderValues.equals("")) && startupOrderFullName != null && !startupOrderFullName.equals("")) {
                this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_MISSING_STARTUP_VALUES", startupOrderFullName));
            }
            StringTokenizer tokens = new StringTokenizer(startupOrderValues, LIST_DELIMITER);
            while (tokens.hasMoreTokens()) {
                SelfTestOrderedInstance element = new SelfTestOrderedInstance(tokens.nextToken().trim());
                this.checkInstance(element);
                this.mStartupOrder.add(element);
            }
        }
        catch (EPropertyNotFound e) {
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_DONT_LOAD_PLUGINS_AT_STARTUP", new Object[0]));
        }
        catch (EBaseException e) {
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PROPERTY_THREW_EBASEEXCEPTION", startupOrderFullName, startupOrderValues));
            throw new EInvalidSelfTestException(startupOrderFullName, startupOrderValues);
        }
        if (loadStatus == 0) {
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PLUGINS_NONE_LOADED", new Object[0]));
        } else {
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_PLUGINS_LOADED", new Object[0]));
        }
    }

    @Override
    public void startup() throws EBaseException {
        Auditor auditor = this.engine.getAuditor();
        Enumeration<SelfTest> instances = this.mSelfTestInstances.elements();
        while (instances.hasMoreElements()) {
            SelfTest instance = instances.nextElement();
            instance.startupSelfTest();
        }
        if (this.engine.isPreOpMode()) {
            logger.debug("SelfTestSubsystem.startup(): Do not run selftests in pre-op mode");
            return;
        }
        Enumeration<SelfTestOrderedInstance> selftests = this.mStartupOrder.elements();
        if (!selftests.hasMoreElements()) {
            this.log(mLogger, CMS.getLogMessage("CMSCORE_SELFTESTS_NOT_RUN_AT_STARTUP", new Object[0]));
            return;
        }
        try {
            this.runSelfTestsAtStartup();
            String auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_SELFTESTS_EXECUTION_2", "$System$", "Success");
            auditor.log(auditMessage);
        }
        catch (EMissingSelfTestException e) {
            String auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_SELFTESTS_EXECUTION_2", "$System$", "Failure");
            auditor.log(auditMessage);
            throw e;
        }
        catch (Exception e) {
            String auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_SELFTESTS_EXECUTION_2", "$System$", "Failure");
            auditor.log(auditMessage);
            logger.error("SelfTestSubsystem: Disabling subsystem due to selftest failure: " + e.getMessage(), (Throwable)e);
            this.engine.disableSubsystem();
            throw new ESelfTestException("Selftest failed: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void shutdown() {
        Collection<SelfTest> collection = this.mSelfTestInstances.values();
        Vector<SelfTest> list = new Vector<SelfTest>(collection);
        Collections.reverse(list);
        ListIterator<SelfTest> instances = list.listIterator();
        while (instances.hasNext()) {
            SelfTest instance = instances.next();
            instance.shutdownSelfTest();
        }
        if (mLogger != null) {
            mLogger.shutdown();
        }
    }

    @Override
    public ConfigStore getConfigStore() {
        return this.mConfig;
    }
}

