/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.security;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.security.KeyCertData;
import com.netscape.cmscore.security.CertificateInfo;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import org.mozilla.jss.crypto.PQGParamGenException;
import org.mozilla.jss.crypto.PQGParams;
import org.mozilla.jss.netscape.security.x509.KeyUsageExtension;

public class OCSPSigningCert
extends CertificateInfo {
    public static final String SUBJECT_NAME = "CN=Certificate Authority, O=Netscape Communications, C=US";

    public OCSPSigningCert(KeyCertData properties) {
        this(properties, null);
    }

    public OCSPSigningCert(KeyCertData properties, KeyPair pair) {
        super(properties, pair);
    }

    @Override
    public String getSubjectName() {
        return (String)this.mProperties.get("subjectName");
    }

    public PQGParams getPQGParams() throws EBaseException, IOException, PQGParamGenException {
        byte[] p = this.mConfig.getByteArray("ca.dsaP", null);
        byte[] q = this.mConfig.getByteArray("ca.dsaQ", null);
        byte[] g = this.mConfig.getByteArray("ca.dsaG", null);
        byte[] seed = this.mConfig.getByteArray("ca.dsaSeed", null);
        byte[] H = this.mConfig.getByteArray("ca.dsaH", null);
        int counter = this.mConfig.getInteger("ca.dsaCounter", 0);
        if (p != null && q != null && g != null) {
            BigInteger P = new BigInteger(p);
            BigInteger Q = new BigInteger(q);
            BigInteger G = new BigInteger(g);
            BigInteger pqgSeed = new BigInteger(seed);
            BigInteger pqgH = new BigInteger(H);
            return new PQGParams(P, Q, G, pqgSeed, counter, pqgH);
        }
        return null;
    }

    @Override
    public String getNickname() {
        String name = (String)this.mProperties.get("nickname");
        String instanceName = (String)this.mProperties.get("instanceID");
        if (name != null) {
            return name;
        }
        return "ocspSigningCert " + instanceName;
    }

    @Override
    public String getKeyAlgorithm() {
        return (String)this.mProperties.get("keyType");
    }

    @Override
    protected KeyUsageExtension getKeyUsageExtension() throws IOException {
        KeyUsageExtension extension = new KeyUsageExtension();
        extension.set("digital_signature", (Object)true);
        extension.set("non_repudiation", (Object)true);
        extension.set("key_certsign", (Object)true);
        extension.set("crl_sign", (Object)true);
        return extension;
    }
}

