/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.security;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.security.KeyCertData;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.security.KeyCertUtil;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.util.Calendar;
import java.util.Date;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.crypto.PQGParamGenException;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.AuthorityKeyIdentifierExtension;
import org.mozilla.jss.netscape.security.x509.CertificateAlgorithmId;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateIssuerName;
import org.mozilla.jss.netscape.security.x509.CertificateSerialNumber;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.CertificateValidity;
import org.mozilla.jss.netscape.security.x509.CertificateVersion;
import org.mozilla.jss.netscape.security.x509.CertificateX509Key;
import org.mozilla.jss.netscape.security.x509.KeyIdentifier;
import org.mozilla.jss.netscape.security.x509.KeyUsageExtension;
import org.mozilla.jss.netscape.security.x509.SubjectKeyIdentifierExtension;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.netscape.security.x509.X509Key;

public abstract class CertificateInfo {
    protected KeyCertData mProperties;
    protected KeyPair mKeyPair;
    protected ConfigStore mConfig;

    public CertificateInfo(KeyCertData properties) {
        this(properties, null);
    }

    public CertificateInfo(KeyCertData properties, KeyPair pair) {
        this.mProperties = properties;
        this.mKeyPair = pair == null ? (KeyPair)properties.get("keypair") : pair;
        this.mConfig = (ConfigStore)this.mProperties.get("cmsFile");
    }

    public KeyCertData getProperties() {
        return this.mProperties;
    }

    protected abstract KeyUsageExtension getKeyUsageExtension() throws IOException;

    public abstract String getSubjectName();

    public abstract String getKeyAlgorithm();

    public abstract String getNickname();

    public CertificateValidity getCertificateValidity() throws EBaseException {
        Date notBeforeDate = null;
        Date notAfterDate = null;
        String notBeforeStr = (String)this.mProperties.get("notBeforeStr");
        String notAfterStr = (String)this.mProperties.get("notAfterStr");
        if (notBeforeStr != null && notAfterStr != null) {
            notBeforeDate = new Date(Long.parseLong(notBeforeStr));
            notAfterDate = new Date(Long.parseLong(notAfterStr));
        } else {
            int beginYear = Integer.parseInt(this.mProperties.getBeginYear()) - 1900;
            int afterYear = Integer.parseInt(this.mProperties.getAfterYear()) - 1900;
            int beginMonth = Integer.parseInt(this.mProperties.getBeginMonth());
            int afterMonth = Integer.parseInt(this.mProperties.getAfterMonth());
            int beginDate = Integer.parseInt(this.mProperties.getBeginDate());
            int afterDate = Integer.parseInt(this.mProperties.getAfterDate());
            int beginHour = Integer.parseInt(this.mProperties.getBeginHour());
            int afterHour = Integer.parseInt(this.mProperties.getAfterHour());
            int beginMin = Integer.parseInt(this.mProperties.getBeginMin());
            int afterMin = Integer.parseInt(this.mProperties.getAfterMin());
            int beginSec = Integer.parseInt(this.mProperties.getBeginSec());
            int afterSec = Integer.parseInt(this.mProperties.getAfterSec());
            Calendar calendar = Calendar.getInstance();
            calendar.set(beginYear, beginMonth, beginDate, beginHour, beginMin, beginSec);
            notBeforeDate = calendar.getTime();
            calendar.set(afterYear, afterMonth, afterDate, afterHour, afterMin, afterSec);
            notAfterDate = calendar.getTime();
        }
        return new CertificateValidity(notBeforeDate, notAfterDate);
    }

    public X509CertInfo getCertInfo() throws EBaseException, PQGParamGenException {
        X509CertInfo certInfo = new X509CertInfo();
        try {
            AlgorithmId sigAlgId;
            certInfo.set("version", (Object)new CertificateVersion(2));
            BigInteger serialNumber = this.mProperties.getSerialNumber();
            certInfo.set("serialNumber", (Object)new CertificateSerialNumber(serialNumber));
            certInfo.set("extensions", (Object)this.getExtensions());
            certInfo.set("validity", (Object)this.getCertificateValidity());
            String issuerName = this.mProperties.getIssuerName();
            if (issuerName == null) {
                issuerName = this.getSubjectName();
            }
            certInfo.set("issuer", (Object)new CertificateIssuerName(new X500Name(issuerName)));
            certInfo.set("subject", (Object)new CertificateSubjectName(new X500Name(this.getSubjectName())));
            certInfo.set("version", (Object)new CertificateVersion(2));
            PublicKey pubk = this.mKeyPair.getPublic();
            X509Key xKey = CryptoUtil.createX509Key((PublicKey)pubk);
            certInfo.set("key", (Object)new CertificateX509Key(xKey));
            SignatureAlgorithm algm = (SignatureAlgorithm)this.mProperties.get("signatureAlg");
            if (algm == null) {
                String hashtype = (String)this.mProperties.get("hashType");
                String key = this.getKeyAlgorithm();
                algm = KeyCertUtil.getSigningAlgorithm(key, hashtype);
                if (algm == null) {
                    throw new NoSuchAlgorithmException("Key : " + key + "/ Hashtype : " + hashtype);
                }
                this.mProperties.put("signatureAlg", algm);
            }
            if ((sigAlgId = this.getAlgorithmId()) == null) {
                byte[] encodedOID = ASN1Util.encode((ASN1Value)algm.toOID());
                sigAlgId = new AlgorithmId(new ObjectIdentifier(new DerInputStream(encodedOID)));
            }
            certInfo.set("algorithmID", (Object)new CertificateAlgorithmId(sigAlgId));
        }
        catch (InvalidKeyException e) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_KEY", new String[0]));
        }
        catch (CertificateException e) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_CERT", e.toString()));
        }
        catch (IOException e) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_CERT", e.toString()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_ALG_NOT_SUPPORTED", e.getMessage()));
        }
        return certInfo;
    }

    public CertificateExtensions getExtensions() throws IOException, CertificateException, InvalidKeyException, NoSuchAlgorithmException {
        boolean isKeyUsageEnabled;
        CertificateExtensions exts = new CertificateExtensions();
        KeyCertUtil.setExtendedKeyUsageExtension(exts, this.mProperties);
        KeyCertUtil.setDERExtension(exts, this.mProperties);
        KeyCertUtil.setBasicConstraintsExtension(exts, this.mProperties);
        KeyCertUtil.setSubjectKeyIdentifier(this.mKeyPair, exts, this.mProperties);
        KeyCertUtil.setOCSPNoCheck(this.mKeyPair, exts, this.mProperties);
        String aki = this.mProperties.getAKI();
        if (aki != null && aki.equals("true")) {
            CertificateExtensions caexts = null;
            caexts = this.getClass().getName().indexOf("CASigningCert") != -1 ? exts : this.mProperties.getCAExtensions();
            this.setAuthorityKeyIdExt(caexts, exts);
        }
        if (isKeyUsageEnabled = this.mProperties.getKeyUsageExtension()) {
            KeyCertUtil.setKeyUsageExtension(exts, this.getKeyUsageExtension());
        }
        return exts;
    }

    public AlgorithmId getAlgorithmId() {
        return (AlgorithmId)this.mProperties.get("algorithmId");
    }

    public void setAuthorityKeyIdExt(CertificateExtensions caexts, CertificateExtensions ext) throws IOException, CertificateException, CertificateEncodingException, CertificateParsingException {
        SubjectKeyIdentifierExtension subjKeyExt = null;
        try {
            subjKeyExt = (SubjectKeyIdentifierExtension)caexts.get("SubjectKeyIdentifier");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (subjKeyExt == null) {
            return;
        }
        KeyIdentifier keyId = (KeyIdentifier)subjKeyExt.get("key_id");
        AuthorityKeyIdentifierExtension authExt = new AuthorityKeyIdentifierExtension(false, keyId, null, null);
        ext.set("AuthorityKeyIdentifier", (Object)authExt);
    }
}

