/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.registry;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.registry.ERegistryException;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.base.FileConfigStorage;
import com.netscape.cmscore.registry.PluginInfo;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginRegistry {
    public static Logger logger = LoggerFactory.getLogger(PluginRegistry.class);
    public static final String ID = "registry";
    private static final String PROP_TYPES = "types";
    private static final String PROP_IDS = "ids";
    private static final String PROP_NAME = "name";
    private static final String PROP_DESC = "desc";
    private static final String PROP_CLASSPATH = "class";
    private static final String PROP_FILE = "file";
    private ConfigStore registryConfig;
    private Hashtable<String, Hashtable<String, PluginInfo>> mTypes = new Hashtable();

    public void init(ConfigStore config, String defaultRegistryFile) throws Exception {
        String registryFile = config.getString(PROP_FILE, defaultRegistryFile);
        logger.info("PluginRegistry: Loading plugin registry from " + registryFile);
        File f = new File(registryFile);
        f.createNewFile();
        FileConfigStorage storage = new FileConfigStorage(registryFile);
        this.registryConfig = new ConfigStore(storage);
        this.registryConfig.load();
        String types = this.registryConfig.getString(PROP_TYPES, null);
        if (types == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(types, ",");
        while (st.hasMoreTokens()) {
            String type = st.nextToken();
            logger.debug("PluginRegistry: " + type + ":");
            this.loadPlugins(type);
        }
    }

    public void loadPlugins(String type) throws EBaseException {
        String ids_str = this.registryConfig.getString(type + ".ids", null);
        if (ids_str == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(ids_str, ",");
        while (st.hasMoreTokens()) {
            String id = st.nextToken();
            logger.debug("PluginRegistry: - " + id);
            this.loadPlugin(type, id);
        }
    }

    public void loadPlugin(String type, String id) throws EBaseException {
        String name = this.registryConfig.getString(type + "." + id + ".name", null);
        String desc = this.registryConfig.getString(type + "." + id + ".desc", null);
        String classpath = this.registryConfig.getString(type + "." + id + ".class", null);
        PluginInfo info = new PluginInfo(name, desc, classpath);
        this.addPluginInfo(type, id, info, 0);
    }

    public void removePluginInfo(String type, String id) throws ERegistryException {
        Hashtable<String, PluginInfo> plugins = this.mTypes.get(type);
        if (plugins == null) {
            return;
        }
        plugins.remove(id);
        Locale locale = Locale.getDefault();
        this.rebuildConfigStore(locale);
    }

    public void addPluginInfo(String type, String id, PluginInfo info) throws ERegistryException {
        this.addPluginInfo(type, id, info, 1);
    }

    public void addPluginInfo(String type, String id, PluginInfo info, int saveConfig) throws ERegistryException {
        Hashtable<String, PluginInfo> plugins = this.mTypes.get(type);
        if (plugins == null) {
            plugins = new Hashtable();
            this.mTypes.put(type, plugins);
        }
        Locale locale = Locale.getDefault();
        logger.debug("PluginRegistry: Added plugin " + type + " " + id + " " + info.getName(locale) + " " + info.getDescription(locale) + " " + info.getClassName());
        plugins.put(id, info);
        if (saveConfig == 1) {
            this.rebuildConfigStore(locale);
        }
    }

    public void rebuildConfigStore(Locale locale) throws ERegistryException {
        Enumeration<String> types = this.mTypes.keys();
        StringBuffer typesBuf = new StringBuffer();
        while (types.hasMoreElements()) {
            String type = types.nextElement();
            typesBuf.append(type);
            if (types.hasMoreElements()) {
                typesBuf.append(",");
            }
            Hashtable<String, PluginInfo> mPlugins = this.mTypes.get(type);
            StringBuffer idsBuf = new StringBuffer();
            Enumeration<String> plugins = mPlugins.keys();
            while (plugins.hasMoreElements()) {
                String id = plugins.nextElement();
                idsBuf.append(id);
                if (plugins.hasMoreElements()) {
                    idsBuf.append(",");
                }
                PluginInfo plugin = mPlugins.get(id);
                this.registryConfig.putString(type + "." + id + ".class", plugin.getClassName());
                this.registryConfig.putString(type + "." + id + ".name", plugin.getName(locale));
                this.registryConfig.putString(type + "." + id + ".desc", plugin.getDescription(locale));
            }
            this.registryConfig.putString(type + ".ids", idsBuf.toString());
        }
        this.registryConfig.putString(PROP_TYPES, typesBuf.toString());
        File file = ((FileConfigStorage)this.registryConfig.getStorage()).getFile();
        try {
            logger.info("PluginRegistry: Updating " + file.getAbsolutePath());
            this.registryConfig.commit(false);
        }
        catch (Exception e) {
            logger.warn("Unable to update " + file.getAbsolutePath() + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public void startup() throws EBaseException {
        logger.debug("RegistrySubsystem: startup");
    }

    public void shutdown() {
        this.mTypes.clear();
    }

    public Enumeration<String> getTypeNames() {
        return this.mTypes.keys();
    }

    public Enumeration<String> getIds(String type) {
        Hashtable<String, PluginInfo> plugins = this.mTypes.get(type);
        if (plugins == null) {
            return null;
        }
        return plugins.keys();
    }

    public PluginInfo getPluginInfo(String type, String id) {
        Hashtable<String, PluginInfo> plugins = this.mTypes.get(type);
        if (plugins == null) {
            return null;
        }
        return plugins.get(id);
    }
}

