/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.ldapconn;

import com.netscape.certsrv.logging.event.ClientAccessSessionEstablishEvent;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSSLSocketFactoryExt;
import org.mozilla.jss.ssl.SSLClientCertificateSelectionCallback;
import org.mozilla.jss.ssl.SSLHandshakeCompletedEvent;
import org.mozilla.jss.ssl.SSLHandshakeCompletedListener;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.ssl.SSLSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKISocketFactory
implements LDAPSSLSocketFactoryExt {
    public static final Logger logger = LoggerFactory.getLogger(PKISocketFactory.class);
    private Auditor auditor;
    private boolean secure;
    private String clientCertNickname;
    private boolean mClientAuth = false;
    private boolean keepAlive = true;
    private String mClientCiphers = null;
    protected List<SSLSocketListener> socketListeners = new ArrayList<SSLSocketListener>();
    private static boolean external = false;

    public PKISocketFactory() {
    }

    public PKISocketFactory(boolean secure) {
        this.secure = secure;
    }

    public PKISocketFactory(String clientCertNickname) {
        this.secure = true;
        this.clientCertNickname = clientCertNickname;
    }

    public PKISocketFactory(String clientCertNickname, boolean external) {
        this.secure = true;
        this.clientCertNickname = clientCertNickname;
        PKISocketFactory.external = external;
        this.init();
    }

    public Auditor getAuditor() {
        return this.auditor;
    }

    public void setAuditor(Auditor engine) {
        this.auditor = engine;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String getClientCertNickname() {
        return this.clientCertNickname;
    }

    public void setClientCertNickname(String clientCertNickname) {
        this.clientCertNickname = clientCertNickname;
    }

    public void addSocketListener(SSLSocketListener socketListener) {
        this.socketListeners.add(socketListener);
    }

    public void removeSocketListener(SSLSocketListener socketListener) {
        this.socketListeners.remove(socketListener);
    }

    public void init() {
        this.init(null);
    }

    public void init(PKISocketConfig config) {
        logger.info("PKISocketFactory: Initializing PKISocketFactory");
        if (config == null) {
            return;
        }
        try {
            this.keepAlive = config.isKeepAlive();
            logger.debug("PKISocketFactory: - keep alive: " + this.keepAlive);
            this.mClientCiphers = config.getClientCiphers();
            logger.debug("PKISocketFactory: - client ciphers: " + this.mClientCiphers);
            if (this.mClientCiphers != null) {
                this.mClientCiphers = this.mClientCiphers.trim();
                if (!this.mClientCiphers.isEmpty()) {
                    CryptoUtil.setClientCiphers((String)this.mClientCiphers);
                }
            }
        }
        catch (Exception e) {
            String message = "Unable to initialize socket factory: " + e.getMessage();
            logger.error("PKISocketFactory: " + message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
    }

    public SSLSocket makeSSLSocket(String host, int port) throws UnknownHostException, IOException {
        SSLSocket s;
        logger.info("PKISocketFactory: Creating SSL socket for " + host + ":" + port);
        if (this.clientCertNickname == null) {
            s = new SSLSocket(host, port);
        } else {
            Socket js = new Socket(InetAddress.getByName(host), port);
            s = new SSLSocket(js, host, null, (SSLClientCertificateSelectionCallback)new SSLClientCertificateSelectionCB(this.clientCertNickname));
        }
        s.setUseClientMode(true);
        s.enableV2CompatibleHello(false);
        for (SSLSocketListener socketListener : this.socketListeners) {
            s.addSocketListener(socketListener);
        }
        ClientHandshakeCB listener = null;
        listener = new ClientHandshakeCB(this);
        s.addHandshakeCompletedListener((SSLHandshakeCompletedListener)listener);
        if (this.clientCertNickname != null) {
            logger.debug("PKISocketFactory: - client cert: " + this.clientCertNickname);
            this.mClientAuth = true;
        }
        s.forceHandshake();
        return s;
    }

    public Socket makeSocket(String host, int port) throws LDAPException {
        Object s = null;
        try {
            if (!this.secure) {
                logger.info("PKISocketFactory: Creating socket for " + host + ":" + port);
                s = new Socket(host, port);
            } else {
                s = this.makeSSLSocket(host, port);
            }
            ((Socket)s).setKeepAlive(this.keepAlive);
        }
        catch (Exception e) {
            if (this.auditor != null) {
                String localIP = "localhost";
                try {
                    localIP = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                ClientAccessSessionEstablishEvent auditEvent = ClientAccessSessionEstablishEvent.createFailureEvent(localIP, host, Integer.toString(port), "SYSTEM", "connect:" + e.toString());
                this.auditor.log(auditEvent);
            }
            String message = "Unable to create socket: " + e.getMessage();
            logger.error("PKISocketFactory: " + message, (Throwable)e);
            if (s != null) {
                try {
                    ((Socket)s).close();
                }
                catch (IOException e1) {
                    logger.error("PKISocketFactory: Unable to close socket: " + e1.getMessage(), (Throwable)e1);
                }
            }
            throw new LDAPException(message, 52);
        }
        return s;
    }

    public boolean isClientAuth() {
        return this.mClientAuth;
    }

    public Object getCipherSuites() {
        return null;
    }

    static class SSLClientCertificateSelectionCB
    implements SSLClientCertificateSelectionCallback {
        String desiredCertName = null;

        public SSLClientCertificateSelectionCB(String clientAuthCertNickname) {
            logger.debug("SSLClientCertificateSelectionCB: Setting desired cert nickname to: " + clientAuthCertNickname);
            this.desiredCertName = clientAuthCertNickname;
        }

        public String select(Vector<String> certs) {
            logger.debug("SSLClientCertificatSelectionCB: Entering!");
            if (this.desiredCertName == null) {
                return null;
            }
            Iterator<String> itr = certs.iterator();
            String selection = null;
            while (itr.hasNext()) {
                String candidate = itr.next();
                logger.debug("SSLClientCertificatSelectionCB: Candidate cert: " + candidate);
                if (!this.desiredCertName.equalsIgnoreCase(candidate)) continue;
                selection = candidate;
                logger.debug("SSLClientCertificateSelectionCB: desired cert found in list: " + this.desiredCertName);
                break;
            }
            logger.debug("SSLClientCertificateSelectionCB: returning: " + selection);
            return selection;
        }
    }

    static class ClientHandshakeCB
    implements SSLHandshakeCompletedListener {
        Object sc;

        public ClientHandshakeCB(Object sc) {
            this.sc = sc;
        }

        public void handshakeCompleted(SSLHandshakeCompletedEvent event) {
            logger.debug("ClientHandshakeCB: SSL handshake happened");
        }
    }
}

